//
// File        : PROFILE.H
// Description : Profiling macros (TSC and MSR's)
// Notes       :
//
//


// These macros are converted directly from the assembly versions. See those
// for an explaination of how they work
//

extern	unsigned long	TSC;
extern	unsigned long	prof0;
extern	unsigned long	prof1;
extern	unsigned long	profsub0;
extern	unsigned long	profsub1;
extern	unsigned long	profdsub0;
extern	unsigned long	profdsub1;


void StartProfile(unsigned long timer0,unsigned long timer1);
void EndProfile(void);

#define _StartProfile(timer0,timer1) \
  SetMSRTimers(timer0,timer1), \
  profsub0 = ReadMSRTimer0(),  \
  profsub1 = ReadMSRTimer1(),  \
  profsub0 = (ReadMSRTimer0()-profdsub0), \
  profsub1 = (ReadMSRTimer1()-profdsub1), \
  prof0 = ReadMSRTimer0(), \
  prof1 = ReadMSRTimer1();

#define _EndProfile() prof0 = (ReadMSRTimer0()-profsub0),\
		      prof1 = (ReadMSRTimer1()-profsub1);


//
// TSC macros
//

// Stores the TSC count in global variable "TSC".
//
void StartTSC(void);
#pragma aux StartTSC = \
  "pushad" \
  "popad" \
  "pushad"\
  "mov eax,TSC"\
  "imul TSC"\
   0xf 0x31 \
  "mov TSC,eax"\
  "popad";

void EndTSC(void);
#pragma aux EndTSC =\
  "pushad"\
  "imul edx"\
   0xf 0x31\
  "sub eax,27"\
  "sub eax,TSC"\
  "mov TSC,eax"\
  "popad";

//
// MSR macros
//

//
// General MSR timing macros
//
// Timer bits:
//  0-5  - Event
//  6    - Count system overhead (CPL 0-2)
//  7    - Count user code (CPL 3)
//  8    - 0 = Count events, 1 = count cycles
//  9    - 0 = show counter incs, 1 = show counter overflows

//#define	USER_CODE     0010000000b
//#define	SYS_CODE      0001000000b

//#define	COUNT_EVENTS  0000000000b
//#define	COUNT_CYCLES  0100000000b

//#define	PM0_INCS      0000000000b
//#define	PM0_OVERFLOWS 1000000000b

// Setup the MSR timers to count something.
//
// Trashes eax ecx edx
//
void SetMSRTimers(unsigned long TIMER0,unsigned long TIMER1);
#pragma aux SetMSRTimers =\
  "mov ecx,011h"\
  "xor edx,edx"\
  "or  ax,0001000000b"\
  "shl eax,16"\
  "mov ax,bx"\
  "or  ax,0001000000b"\
  0xf 0x30\
  parm [EBX] [EAX]\
  modify [EAX ECX EDX];

// These just trash ecx...
unsigned long ReadMSRTimer0(void);
#pragma aux ReadMSRTimer0 =\
  "mov ecx,012h"\
  0xf 0x32\
  modify [ECX EDX]\
  value [EAX];

unsigned long ReadMSRTimer1(void);
#pragma aux ReadMSRTimer1 =\
  "mov ecx,013h"\
  0xf 0x32\
  modify [ECX EDX]\
  value [EAX];




