//
// File        : PROFILE.C
// Description : Profiling stuff (TSC and MSR's)
// Notes       :
//
//

#include "profile.h"

//
// Profiling variables
//

unsigned long	TSC;		// TSC cycle count

unsigned long	prof0;		// Timer0 profile
unsigned long	prof1;		// Timer1 profile

unsigned long	profsub0;	// Overhead for timer0
unsigned long	profsub1;	// Overhead for timer1
unsigned long	profdsub0=0;	// dummy sub value for timing
unsigned long	profdsub1=0;	// the overhead.. must stay 0


//
// These turned out to be too big to be #pragma macros.
//
// Also available as #define macros as _StartProfile and _EndProfile
//
void StartProfile(unsigned long timer0,unsigned long timer1)
{
  SetMSRTimers(timer0,timer1);

  // Time overhead code
  profsub0 = ReadMSRTimer0();
  profsub1 = ReadMSRTimer1();

  profsub0 = ReadMSRTimer0() - profdsub0;
  profsub1 = ReadMSRTimer1() - profdsub1;

  // start timer for real
  prof0 = ReadMSRTimer0();
  prof1 = ReadMSRTimer1();
}

void EndProfile(void)
{
  prof0 = ReadMSRTimer0() - profsub0;
  prof1 = ReadMSRTimer1() - profsub1;
}

