
//Ŀ
//                                                                           
// SOCOM 1.0                                                                 
//                                                                           
// Module - Implementation                                                   
//                                                                           
// (c) 1995 P.Lindh                                                          
//                                                                           
//

#include <string.h>
#include <socom\module.h>
#include <socom\channel.h>
#include <socom\audio.h>

//Ŀ
//                                                                           
// Global variables                                                          
//                                                                           
//

extern int     mpCounter;
extern int     mpPatPos;
extern int     mpSpeed;
extern int     mpPatBreak;
extern int     mpPatDelayTime;
extern int     mpSongPos;
extern int     mpSongLen;
extern int     mpPatLoop;
extern int     mpNumChn;
extern int     mpNumSmp;
extern int     mpMasterVolume;
extern ubyte   mpOrders[128];
extern Channel mpChannels[32];
extern ubyte** mpPatterns;

//Ŀ
//                                                                           
// Constructor                                                               
//                                                                           
//

Module::Module( char* fileName )
{
   myPatterns = 0;
   myPlayFlag = false;

   memset( myOrders, 0, 128 );

   myFP = fopen( fileName, "rb" );
}

//Ŀ
//                                                                           
// Copy constructor                                                          
//                                                                           
//

Module::Module( const Module& aMod )
{
   Copy( aMod );
}

//Ŀ
//                                                                           
// Destructor                                                                
//                                                                           
//

Module::~Module( void )
{
   Clear();
}

//Ŀ
//                                                                           
// Assignment operator                                                       
//                                                                           
//

Module& Module::operator =( const Module& aMod )
{
   Clear();
   Copy( aMod );

   return *this;
}

//Ŀ
//                                                                           
// Allocate memory for patterns                                              
//                                                                           
//

int   Module::AllocPatterns( void )
{
   int   retValue;

   myPatterns = new ubyte* [myNumPat];             // alloc memory for array

   if ( myPatterns != 0 )
   {
      for ( int i = 0; i < myNumPat; i++ )
      {
         myPatterns[i] = new ubyte [myPatSize];    // alloc memory for pattern

         if ( myPatterns[i] == 0 )
         {
            retValue = SOC_NO_MEMORY;              // if allocation failed
            break;                                 // break for loop and exit
         }
      }

      retValue = SOC_OK;
   }
   else
   {
      retValue = SOC_NO_MEMORY;
   }

   return retValue;
}

//Ŀ
//                                                                           
// Calculate number of patterns in module                                    
//                                                                           
//

void  Module::CalcNumPats( void )
{
   myNumPat = 0;

   // the highest value in the order table is the highest pattern index

   for ( int i = 0; i < 128; i++ )
   {
      if ( myOrders[i] > myNumPat )
      {
         myNumPat = myOrders[i];
      }
   }

   myNumPat++;    // must increase to skip index 0
}

//Ŀ
//                                                                           
// Deallocate all memory used up by the module                               
//                                                                           
//

void  Module::Clear( void )
{
   // deallocate all memory used by module

   if ( myPatterns != 0 )
   {
      for ( int i = 0; i < myNumPat; i++ )
      {
         if ( myPatterns[i] != 0 )
         {
            delete [] myPatterns[i];
         }
      }

      delete [] myPatterns;

      myPatterns = 0;
   }

   if ( mySamples != 0 )
   {
      delete [] mySamples;

      mySamples = 0;
   }
}

//Ŀ
//                                                                           
// Copy an object                                                            
//                                                                           
//

void  Module::Copy( const Module& aMod )
{
   myPatSize = aMod.myPatSize;
   myPatNote = aMod.myPatNote;
   myNumPat  = aMod.myNumPat;
   myNumChn  = aMod.myNumChn;
   myNumSmp  = aMod.myNumSmp;
   mySongLen = aMod.mySongLen;
   myMasterVolume = aMod.myMasterVolume;
   myModType      = aMod.myModType;
   myPlayFlag     = aMod.myPlayFlag;

   memcpy( myOrders, aMod.myOrders, 128 );
   memcpy( myPanPos, aMod.myPanPos, 32 );

   mySamples = new Sample [myNumSmp];

   if ( mySamples != 0 )
   {
      memcpy( mySamples, aMod.mySamples, myNumSmp * sizeof( Sample ) );
   }

   myPatterns = new ubyte* [myNumPat];

   if ( myPatterns != 0 )
   {
      for ( int i = 0; i < myNumPat; i++ )
      {
         myPatterns[i] = new ubyte [myPatSize];

         if ( myPatterns[i] != 0 )
         {
            memcpy( myPatterns[i], aMod.myPatterns[i], myPatSize );
         }
      }
   }
}

//Ŀ
//                                                                           
// Get master volume                                                         
//                                                                           
//

int   Module::GetMasterVolume( void ) const
{
   return myMasterVolume;
}

//Ŀ
//                                                                           
// Set master volume                                                         
//                                                                           
//

void  Module::SetMasterVolume( int mVolume )
{
   if ( mVolume < 256 && mVolume >= 0 )   // make sure volume is within bounds
   {
      myMasterVolume = mVolume;

      if ( myPlayFlag )                   // if module is playing
      {                                   // set player master volume also
         mpMasterVolume = mVolume;
      }
   }
}

//Ŀ
//                                                                           
// Start playing module                                                      
//                                                                           
//

void  Module::StartPlay( void )
{
   // initialize player variables

   Channel::myBpm       = 125;
   Channel::mySamples   = mySamples;
   Channel::myBpmChange = false;
   Channel::myModType   = myModType;

   mpCounter      = 0;
   mpPatPos       = 0;
   mpSpeed        = 6;
   mpPatBreak     = 0;
   mpPatDelayTime = 0;
   mpSongPos      = 0;
   mpPatLoop      = 0;
   mpNumChn       = myNumChn;
   mpSongLen      = mySongLen;
   mpNumSmp       = myNumSmp;
   mpMasterVolume = myMasterVolume;
   mpPatterns     = myPatterns;

   memcpy( mpOrders, myOrders, 128 );        // copy song orders

   for ( int i = 0; i < myNumChn; i++ )
   {
      mpChannels[i].Clear();                 // clear channel

      mpChannels[i].myPanPos = myPanPos[i];  // initialize channel with pan pos
   }

   myPlayFlag = true;
}

//Ŀ
//                                                                           
// Stop playing module                                                       
//                                                                           
//

void  Module::StopPlay( void )
{
   myPlayFlag = false;
}

