
#ifndef  __AUDIODEVICE_H__
#define  __AUDIODEVICE_H__

//Ŀ
//                                                                           
// SOCOM 1.0                                                                 
//                                                                           
// AudioDevice - Header file                                                 
//                                                                           
// (c) 1995 P.Lindh                                                          
//                                                                           
//

#include <socom\tables.h>
#include <socom\sample.h>
#include <socom\module.h>

//Ŀ
//                                                                           
// Class specification                                                       
//                                                                           
//

class AudioDevice
{

 public:

   // Constructor
   AudioDevice( void );

   // Destructor
   virtual ~AudioDevice( void );

   // Free a voice used for digital playback
   void  FreeVoice( int voice );

   // Allocate a voice for digital voices
   int   AllocVoice( void );

   // Close and detach sound device
   virtual void   Close( void ) = 0;

   // Handle interrupts
   virtual void   Handler( void ) = 0;

   // Load a module into the AudioDevice
   virtual int    LoadModule( Module* aMod, int digVoices ) = 0;

   // Load a sample into device
   virtual int    LoadSample( Sample* smp ) = 0;

   // Open and initialize sound device
   virtual int    Open( int musVoices, int digVoices ) = 0;

   // Play a standalone sample
   virtual void   PlaySample( ubyte voice, ubyte panPos, Sample* smp ) = 0;

   // start module replayer
   virtual void   Play( Module* aMod ) = 0;

   // stop module replayer
   virtual void   Stop( Module* aMod ) = 0;

   // Stop a running sample
   virtual void   StopSample( int voice ) const = 0;

   // Unload a module from device driver
   virtual int    UnloadModule( Module* aMod ) = 0;

 protected:

   IRQLine* myILine;       // current IRQ line
   ulong    myUsedVoices;  // bit holder for voice allocator
   int      myBasePort;    // sound card base port
   int      myIRQ;         // sound card interrupt number
   int      myDMA;         // sound card DMA channel
   int      myNumVoices;   // number of voices used
   int      myDigVoices;   // number of digital voices used
   PVI      myOldIntVec;   // original interrupt vector

   // initialize voice allocation handler
   void  InitVoiceAlloc( void );

};


#endif   // __AUDIODEVICE_H__
