
//Ŀ
//                                                                           
// SOCOM 1.0                                                                 
//                                                                           
// AudioDevice - Implementation                                              
//                                                                           
// (c) 1995 P.Lindh                                                          
//                                                                           
//

#include <socom\audio.h>

static char* copyright = "SOCOM 1.00 is Copyright (c) 1995 P.Lindh";

//Ŀ
//                                                                           
// Constructor                                                               
//                                                                           
//

AudioDevice::AudioDevice( void )
{

}

//Ŀ
//                                                                           
// Destructor                                                                
//                                                                           
//

AudioDevice::~AudioDevice( void )
{

}

//Ŀ
//                                                                           
// Allocate a voice for digital playback                                     
//                                                                           
//

int   AudioDevice::AllocVoice( void )
{
   // scan through dword for zero bit
   for ( int i = 0; i < myNumVoices; i++ )
   {
      if (!( myUsedVoices & ( 1L << i ))) // is there a zero bit
      {
         myUsedVoices |= 1L << i;         // if so, set bit and return voice

         return i;
      }
   }

   return -1;                             // no available voice numbers
}

//Ŀ
//                                                                           
// Free a voice used for digital playback                                    
//                                                                           
//

void  AudioDevice::FreeVoice( int voice )
{
   myUsedVoices &= ~voice; // zero bit corresponding to voice number
}

//Ŀ
//                                                                           
// Initialize voice allocation handler                                       
//                                                                           
//

void  AudioDevice::InitVoiceAlloc( void )
{
   myUsedVoices = 0;

   // set bits for all music voices (they are reserved)
   for ( int i = 0; i < myNumVoices; i++ )
   {
      myUsedVoices |= 1L << i;
   }
}

