;
;  ASMFX.ASM  //  ARM 12/93
;

        Ideal
        Model TPascal
        P286
        Radix 10

; Constants:

INCLUDE "meshsize.inc"

        DATASEG

EXTRN   U      : DWord
EXTRN   CT     : Word

        CODESEG

PUBLIC SquareSplash   ; (X,Y,S,D : word);
PUBLIC BitLift        ; (P : Pointer; L : integer);
PUBLIC IntLift        ; (X,Y,L : word; P : Pointer); (P->SX,SY;[X,Y])

; // SquareSplash

        PROC SquareSplash NEAR
        ARG X : Word, Y : Word, S : Word, D : Word
          mov si, [word ptr U]
          test [CT], 1
          jz @@0
          add si, NX*NY*2
        @@0:                ; si -> U[CT]

          push ds
          mov ax, [word ptr U+2]
          mov ds, ax

          mov ax, NY*2
          mul [X]
          add si, ax        ; si -> U[CT,X]

          mov ax, [Y]
          shl ax,1
          add si, ax        ; si -> U[b,X,Y]

          mov ax, [D]       ; depth
          mov dx, [S]       ; size (S*S square)
          mov bx, [X]

          @@LX:
            push bx
            push si
            mov bx, [Y]
            mov cx, [S]
            @@LY:
              mov [si], ax
              add si,2
              inc bx
              cmp bx, NY-2
              jge @@1
              dec cx
            jnz @@LY
          @@1:
            pop si
            pop bx
            add si, NY*2
            inc bx
            cmp bx, NX-2
            jge @@2
            dec dx
          jnz @@LX
          @@2:

          pop ds
        ret
        ENDP


; // BitLift

        PROC BitLift NEAR
        ARG P : DWord, L : Word
P386
          mov si, [word ptr U]
          test [CT], 1
          jz @@0
          add si, NX*NY*2
        @@0:                ; si -> U[CT]

          push ds
          mov ax, [word ptr U+2]
          mov ds, ax

          les di, [P]
          mov ax, [L]
          mov cx, NX*NY
          xor dx, dx

        @@1:
          test dx,31
          jnz @@3
          mov ebx, [es:di]
          add di,4
        @@3:
          rcr ebx,1
          jnc @@2
          mov [si], ax
        @@2:
          inc dx
          add si, 2
          dec cx
          jnz @@1

P286
          pop ds
        ret
        ENDP


; // IntLift

        PROC IntLift NEAR
        ARG X : Word, Y : Word, L : Word, P : DWord
        LOCAL SX : Word, SY : Word
          mov si, [word ptr U]
          test [CT], 1
          jz @@0
          add si, NX*NY*2
        @@0:                ; si -> U[CT]

          push ds
          mov ax, [word ptr U+2]
          mov ds, ax

          mov ax, NY*2
          mul [X]
          add si, ax        ; si -> U[CT,X]

          mov ax, [Y]
          shl ax,1
          add si, ax        ; si -> U[CT,X,Y]

          les di, [P]
          mov ax, [es:di]
          mov [SX], ax   ; X size
          mov ax, [es:di+2]
          mov [SY], ax   ; Y size (SX*SY square)
          add di, 4

          mov dx, [SX]
          mov bx, [X]

          @@LX:
            push bx
            push si
            mov bx, [Y]
            mov cx, [SY]
            @@LY:
              mov ax, [es:di]   ; depth
              test ax,ax
              js @@hollow
              add ax, [L]
              mov [si], ax
          @@hollow:
              add di,2
              add si,2
              inc bx
              cmp bx, NY-2
              jge @@1
              dec cx
            jnz @@LY
          @@1:
            pop si
            pop bx
            add si, NY*2
            inc bx
            cmp bx, NX-2
            jge @@2
            dec dx
          jnz @@LX
          @@2:

          pop ds
        ret
        ENDP



       END

