;=============================== Triangle Mapped + Phong Shading
;=============================== (C) 1995, SM Karibou

;= Entre:
;=        DS:ESI     Pointeur sur la liste des sommet du polygone (termine par la couleur)
;=        DS:EDI     Pointeur sur la liste des points 2D
;=        DS:TexPts  Tableau des polygone texture (Coord X/Y) (Longueur maxi = 256)
;=        DS:TexPtsP Tableau des polygone texture PHONG
;=        DS:TexOfs  Tableau des offset des textures
;=        DS:LTable  Offset de la table de translation de couleurs
;=        DS:BufOfs  Pointeur sur le buffer recevant le zoli dessin
;=        DS:PTable  Tableau d'clairage phong ( intensit )
; PTable et LTable doit etre modulo 65536

; Constantes 

.386p
locals
.MODEL FLAT
.CODE

GLOBAL DrawTriMP:near
GLOBAL TexPts:DWORD
GLOBAL TexPtsP:DWORD
GLOBAL TexOfs:DWORD
GLOBAL BufOfs:DWORD
GLOBAL LTable:DWORD
GLOBAL PTable:DWORD
GLOBAL ClipMinX:DWord
GLOBAL ClipMaxX:DWord
GLOBAL ClipMinY:DWord
GLOBAL ClipMaxY:DWord
GLOBAL ScanLine:DWord
GLOBAL ScanMultiplier:DWord

;
.DATA?
align 4
Y1          dd  ?       ;==== Sommet le plus haut de l'ecran
Y2          dd  ?
Y3          dd  ?

NY1         dd  ?       ;==== Numero des sommet dans la face
NY2         dd  ?
NY3         dd  ?

X2mX1A      dd  ?       ;==== Bah c'est marke dessus
X2mX1B      dd  ?

Hauteur1    dd  ?       ;==== Hauteur
Hauteur2    dd  ?

Delta1      dd  ?       ;==== Delta des eux cots
Delta2      dd  ?

CX1         dd  ?       ;==== Current X  1=Gauche 2=droit
CX2         dd  ?

CurrentY    dd  ?       ;==== Ligne Courante

_o          dd  ?       ;==== Tampon

WhatRoutine dd  ?       ;==== Routine de remplissage courante

;==================== Mapping

Xt1          dd  ?       ;==== Coord de mapping courante sur les cots
Yt1          dd  ?
Xt2          dd  ?
Yt2          dd  ?

StepX1       dd  ?       ;==== Increment sur le cote
StepY1       dd  ?
StepX2       dd  ?
StepY2       dd  ?

_IncX        dd  ?       ;==== Increment interne
_IncY        dd  ?

_CurX        dd  ?       ;==== Tampon
_CurY        dd  ?

Xt2mXt1A     dd  ?
Yt2mYt1A     dd  ?
Xt2mXt1B     dd  ?
Yt2mYt1B     dd  ?

TexOfs2     dd ?            ; Gestion multitexture

;=============== PHONG

Xp1          dd  ?       ;==== Couleur courante sur les cots
Xp2          dd  ?
Yp1          dd  ?       ;==== Couleur courante sur les cots
Yp2          dd  ?

EdgeStepXp1 dd  ?       ;==== Increment sur le cote
EdgeStepXp2 dd  ?
EdgeStepYp1 dd  ?       ;==== Increment sur le cote
EdgeStepYp2 dd  ?

_IncXp      dd  ?       ;==== Increment interne
_IncYp      dd  ?       ;==== Increment interne

_CurXp      dd  ?       ;==== Tampon couleur de ligne
_CurYp      dd  ?       ;==== Tampon couleur de ligne

Xp2mXp1A      dd  ?
Yp2mYp1A      dd  ?
Xp2mXp1B      dd  ?
Yp2mYp1B      dd  ?

compteur        DD ?

.CODE
;
DrawPartC Proc Near;Macro
         push esi edi

@@DrawLoop:
         mov eax,CX1
         mov ecx,CX2
         mov ebx,Xt1
         mov edx,Yt1
         mov ebp,Xp1
         mov esi,Yp1
         sar eax,16
         sar ecx,16
         mov _CurX,ebx
         mov _CurY,edx
         mov _CurXp,ebp
         mov _CurYp,esi

         ;====================== Clipping Y
       	 mov edx,CLIPMAXY
	     mov ebx,CLIPMINY
	     cmp CurrentY,edx
         jg SlowExit
         cmp CurrentY,ebx
         jl @@Step

         ;== Full Clip X ?
         cmp eax,ClipMaxX
         jg @@Step
         cmp ecx,ClipMinX
         jl @@Step

         ;====== Clipping
         cmp ecx,ClipMaxX
         jle @@Noclipright
         mov ecx,ClipMaxX
@@NoclipRight:
         cmp eax,ClipMinX
         jge @@NoClipLeft
         mov ebx,ClipMinX         ;========== Clipping Gauche
         sub ebx,eax

         mov eax,_IncX
         cdq
         imul ebx
         add _CurX,eax

         mov eax,_IncY
         cdq
         imul ebx
         add _CurY,eax

         mov eax,_IncXp
         cdq
         imul ebx
         add _CurXp,eax

         mov eax,_IncYp
         cdq
         imul ebx
         add _CurYp,eax

         mov eax,ClipMinx
@@NoClipLeft:

         sub ecx,eax
         jng @@Step

         mov edi,bufOfs
         add edi,eax
         mov esi,TexOfs2

         mov eax,_IncX
         mov edx,_IncY
         mov ebp,_IncXp
         mov ebx,_IncYp

         mov dword ptr [@@Automodif+1],eax
         mov dword ptr [@@Automodif2+2],edx
         mov dword ptr [@@Automodif3+6],ebp
         mov dword ptr [@@Automodif4+6],ebx

         mov eax,_CurX
         mov edx,_CurY

         mov compteur,ecx
         mov ecx,LTable
         mov ebp,PTable
         xor ebx,ebx

@@HZLoop:

         mov bl,byte ptr [_CurXp+1]
         mov bh,byte ptr [_CurYp+1]

         mov cl,byte ptr [ebp+ebx]

         mov bl,ah
         mov bh,dh

@@Automodif:
         add eax,012345678h

         mov ch,byte ptr [esi+ebx]

@@AutoModif2:
         add edx,012345678h

         mov bh,byte ptr ds:[ecx]

@@AutoModif3:
         add _CurXp,012345678h
@@AutoModif4:
         add _CurYp,012345678h

         mov [edi],bh
         inc edi

         dec dword ptr compteur
         jnz @@HZLoop


@@Step:
         mov ecx,Delta1
         mov edx,Delta2
         add CX1,ecx
         add CX2,edx

         ;=================== Mapping + Phong
         mov eax,StepX1
         mov ebx,StepY1
         mov ecx,EdgeStepXp1
         mov edx,EdgeStepYp1
         add Xt1,eax
         add Yt1,ebx
         add Xp1,ecx
         add Yp1,edx

         mov edx,Scanline
         inc CurrentY
         add BufOfs,edx
         dec Hauteur1
         jnz @@DrawLoop

         pop edi esi
         ret
DrawPartC endp

DrawPartNC Proc Near;Macro
         push esi edi

@@DrawLoop:
         mov eax,CX1
         mov ecx,CX2
         mov ebp,Xp1
         mov esi,Yp1
         sar eax,16
         sar ecx,16
         mov _CurXp,ebp
         mov _CurYp,esi

         ;====================== Clipping Y
       	 mov edx,CLIPMAXY
	     mov ebx,CLIPMINY
	     cmp CurrentY,edx
         jg SlowExit
         cmp CurrentY,ebx
         jl @@Step

         sub ecx,eax
         jng @@Step

         mov edi,bufOfs
         add edi,eax
         mov esi,TexOfs2

         mov eax,_IncX
         mov edx,_IncY
         mov ebp,_IncXp
         mov ebx,_IncYp

         mov dword ptr [@@Automodif+1],eax
         mov dword ptr [@@Automodif2+2],edx
         mov dword ptr [@@Automodif3+6],ebp
         mov dword ptr [@@Automodif4+6],ebx

         mov eax,Xt1
         mov edx,Yt1

         mov compteur,ecx
         mov ecx,LTable
         mov ebp,PTable
         xor ebx,ebx

@@HZLoop:

         mov bl,byte ptr [_CurXp+1]
         mov bh,byte ptr [_CurYp+1]

         mov cl,byte ptr [ebp+ebx]

         mov bl,ah
         mov bh,dh

@@Automodif:
         add eax,012345678h

         mov ch,byte ptr [esi+ebx]

@@AutoModif2:
         add edx,012345678h

         mov bh,byte ptr ds:[ecx]

@@AutoModif3:
         add _CurXp,012345678h
@@AutoModif4:
         add _CurYp,012345678h

         mov [edi],bh
         inc edi

         dec dword ptr compteur
         jnz @@HZLoop


@@Step:
         mov ecx,Delta1
         mov edx,Delta2
         add CX1,ecx
         add CX2,edx

         ;=================== Mapping + Phong
         mov eax,StepX1
         mov ebx,StepY1
         mov ecx,EdgeStepXp1
         mov edx,EdgeStepYp1
         add Xt1,eax
         add Yt1,ebx
         add Xp1,ecx
         add Yp1,edx

         mov edx,Scanline
         inc CurrentY
         add BufOfs,edx
         dec Hauteur1
         jnz @@DrawLoop

         pop edi esi
         ret
DrawPartNC endp

;

GetCoord Macro
         mov _o,esi
         mov ebx,[esi+eax*4]

         mov esi,TexPts
         movsx eax,word ptr [edi+ebx*4+2]

         movzx edx,byte ptr [esi+ebx*2]
         movzx ebp,byte ptr [esi+ebx*2+1]
         mov esi,TexPtsP
         movzx ecx,byte ptr [esi+ebx*2]
         movzx ebx,byte ptr [esi+ebx*2+1]
         mov esi,_o         
endm

;

isClipped Macro
       local @@zob1,@@Zob2
       cmp eax,CLIPMAXX
           jng @@Zob1
           mov WhatRoutine,offset DrawPartC
           jmp @@Zob2
@@Zob1:
           cmp eax,CLIPMinX
           jnl @@Zob2
           mov WhatRoutine,offset DrawPartC
@@Zob2:
endm

;
CalcInc Macro
        local @@lm,@@noclac

         mov ebx,Delta1
         sub ebx,Delta2
         jnz @@noclac

         mov _IncX,0
         mov _IncY,0
         mov _IncXp,0
         mov _IncYp,0
         jmp @@lm
@@noclac:

         mov eax,StepX1
         sub eax,StepX2
         cdq
         shl eax,16
         idiv ebx

         mov _IncX,eax

         mov eax,StepY1
         sub eax,StepY2
         cdq
         shl eax,16
         idiv ebx

         mov _IncY,eax

         mov eax,EdgeStepXp1
         sub eax,EdgeStepXp2
         cdq
         shl eax,16
         idiv ebx

         mov _IncXp,eax

         mov eax,EdgeStepYp1
         sub eax,EdgeStepYp2
         cdq
         shl eax,16
         idiv ebx

         mov _IncYp,eax
@@lm:

endm

;

DrawTriMP  Proc Near

         mov whatroutine,offset DrawPartNC

         ;======================= Tri des Y
         mov Ny1,0
         mov Ny2,1
         mov Ny3,2

         mov ebx,[esi]
         movsx edx,word ptr [edi+ebx*4]

         mov ebx,[esi+4]
         movsx ecx,word ptr [edi+ebx*4]

         mov ebx,[esi+8]
         movsx ebp,word ptr [edi+ebx*4]

         cmp edx,ecx
         jl @@Ok1
         xchg edx,ecx
         mov eax,NY1
         xchg NY2,eax
         mov NY1,eax
@@Ok1:
         cmp edx,ebp
         jl @@Ok2
         xchg edx,ebp
         mov eax,NY1
         xchg NY3,eax
         mov NY1,eax

@@Ok2:
         cmp ecx,ebp
         jl @@Ok3
         xchg ecx,ebp
         mov eax,NY2
         xchg NY3,eax
         mov NY2,eax
@@Ok3:
         mov y1,edx             ;===== Y1 pt le plus haut sur l'ecran
         mov y2,ecx
         mov y3,ebp

         cmp edx,ebp
         jge @@FastExit

         ;================= Turbo Clip Y
         cmp ebp,CLIPMINY
         jl @@FastExit
         cmp edx,CLIPMAXY
         jg @@FastExit

         ;================= O dans le buffer ?
         mov CurrentY,edx
         Call ScanMultiplier
         add BufOfs,edx

         ;===================== Chargement Texture
         mov _o,esi
         mov ebx,[esi+12]

         mov esi,TexOfs
         mov eax,[esi+ebx*4]
         mov TexOfs2,eax
         mov esi,_o

         ;================ Calcul des Hauteur
         mov eax,y2
         sub eax,y1
         jz @@TriPlat     ;=== Tri Plat
         mov Hauteur1,eax

         mov eax,y3
         sub eax,y1
         jz @@FastExit    ;=== Tri merdik
         mov hauteur2,eax

         ;=============== Recupere donne X2
         mov eax,ny2
         GetCoord
         mov X2mX1A,eax
         mov Xt2mXt1A,edx
         mov Yt2mYt1A,ebp
         mov Xp2mXp1A,ecx
         mov Yp2mYp1A,ebx

         ISClipped

         ;=============== Recupere donne X1
         mov eax,ny1
         GetCoord
         sub X2mX1A,eax
         sub Xt2mXt1A,edx
         sub Yt2mYt1A,ebp
         sub Xp2mXp1A,ecx
         sub Yp2mYp1A,ebx

         ISClipped

         ;=============== Init
         shl eax,16
         mov CX1,eax
         mov CX2,eax
         shl edx,8
         shl ebp,8
         shl ecx,8
         shl ebx,8
         mov Xt1,edx
         mov Yt1,ebp
         mov Xp1,ecx
         mov Yp1,ebx

         ;=============== DeltaX  1 -> 2
         mov eax,X2mX1A
         cdq
         shl eax,16
         idiv Hauteur1
         mov Delta1,eax

         ;================ Recupere donne X3
         mov eax,ny3
         GetCoord
         mov X2mX1B,eax
         mov Xt2mXt1B,edx
         mov Yt2mYt1B,ebp
         mov Xp2mXp1B,ecx
         mov Yp2mYp1B,ebx

         ISClipped

         ;================ Recupere donne X1
         mov eax,ny1
         GetCoord
         sub X2mX1B,eax
         sub Xt2mXt1B,edx
         sub Yt2mYt1B,ebp
         sub Xp2mXp1B,ecx
         sub Yp2mYp1B,ebx

         ;=============== DeltaX 1 -> 3
         mov eax,X2mX1B
         cdq
         shl eax,16
         idiv Hauteur2
         mov Delta2,eax

         ;=============== Calcul de l'increment de couleur du triangle
         mov eax,Xt2mXt1A
         cdq
         shl eax,8
         idiv hauteur1
         mov StepX1,eax

         mov eax,Yt2mYt1A
         cdq
         shl eax,8
         idiv hauteur1
         mov StepY1,eax

         mov eax,Xt2mXt1B
         cdq
         shl eax,8
         idiv hauteur2
         mov StepX2,eax

         mov eax,Yt2mYt1B
         cdq
         shl eax,8
         idiv hauteur2
         mov StepY2,eax

         mov eax,Xp2mXp1A
         cdq
         shl eax,8
         idiv hauteur1
         mov EdgeStepXp1,eax

         mov eax,Xp2mXp1B
         cdq
         shl eax,8
         idiv hauteur2
         mov EdgeStepXp2,eax

         mov eax,Yp2mYp1A
         cdq
         shl eax,8
         idiv hauteur1
         mov EdgeStepYp1,eax

         mov eax,Yp2mYp1B
         cdq
         shl eax,8
         idiv hauteur2
         mov EdgeStepYp2,eax


         ;=============== Determination du sens du triangle
         mov eax,Delta2
         cmp Delta1,eax
         jl @@lom
         xchg Delta1,eax
         mov Delta2,eax

         mov eax,StepX1
         xchg eax,StepX2
         mov StepX1,eax
         mov eax,StepY1
         xchg eax,StepY2
         mov StepY1,eax
         mov eax,EdgeStepXp1
         xchg eax,EdgeStepXp2
         mov EdgeStepXp1,eax
         mov eax,EdgeStepYp1
         xchg eax,EdgeStepYp2
         mov EdgeStepYp1,eax

@@lom:
         ;============== Setting Hauteur
         mov eax,hauteur1       ;=== Hauteur1 est le cote le moins long
         cmp eax,hauteur2
         jl @@h
         xchg eax,hauteur2
         mov hauteur1,eax
@@h:
         ;============= Calcul de L'incrment Interne
         CalcInc

         ;====================== Premiere Partie du triangle
         Call WhatRoutine
@@Part2:
         ;===== Hauteur 2 -> 3
         mov eax,y3
         sub eax,y2
         jz @@FastExit     ;=== Tri Plat en bas
         mov Hauteur1,eax

         ;======== Recupere donne X3
         mov eax,ny3
         GetCoord
         mov X2mX1A,eax
         mov Xt2mXt1A,edx
         mov Yt2mYt1A,ebp
         mov Xp2mXp1A,ecx
         mov Yp2mYp1A,ebx

         ;======== Recupere donne X2
         mov eax,ny2
         GetCoord
         sub X2mX1A,eax
         sub Xt2mXt1A,edx
         sub Yt2mYt1A,ebp
         sub Xp2mXp1A,ecx
         sub Yp2mYp1A,ebx

         ;=============== DeltaX 2 -> 3
         mov eax,X2mX1A
         cdq
         shl eax,16
         idiv Hauteur1

         ;===== Ou met-je ce Delta ? + Calcul second Increment Gouraud eventuel
         cmp eax,Delta1
         jl @@lok
         mov Delta1,eax

         mov eax,Xt2mXt1A
         cdq
         shl eax,8
         idiv Hauteur1
         mov StepX1,eax

         mov eax,Yt2mYt1A
         cdq
         shl eax,8
         idiv Hauteur1
         mov StepY1,eax

         mov eax,Xp2mXp1A
         cdq
         shl eax,8
         idiv Hauteur1
         mov EdgeStepXp1,eax

         mov eax,Yp2mYp1A
         cdq
         shl eax,8
         idiv Hauteur1
         mov EdgeStepYp1,eax

         mov eax,CX1
         add eax,8000h
         xor ax,ax
         mov CX1,eax

         jmp @@lop
@@lok:
         mov Delta2,eax

         mov eax,CX2
         add eax,8000h
         xor ax,ax
         mov CX2,eax

@@lop:
         ;====================== Deuxieme Partie du triangle
         Call Whatroutine

@@FastExit:
         ret

SlowExit:
         pop edi esi
         pop eax
         ret

@@TriPlat:
         ;================ Calcul des Hauteur
         mov eax,y3
         sub eax,y1
         jz @@FastExit     ;=== Tri Bizarre
         mov Hauteur1,eax
         mov hauteur2,eax

         ;================ Recupere donne X3
         mov eax,ny3
         GetCoord
         mov X2mX1A,eax
         mov X2mX1B,eax
         mov Xt2mXt1A,edx
         mov Xt2mXt1B,edx
         mov Yt2mYt1A,ebp
         mov Yt2mYt1B,ebp
         mov Xp2mXp1A,ecx
         mov Xp2mXp1B,ecx
         mov Yp2mYp1A,ebx
         mov Yp2mYp1B,ebx

         ISClipped

         ;================ Recupere donne X1
         mov eax,ny1
         GetCoord
         sub X2mX1A,eax
         sub Xt2mXt1A,edx
         sub Yt2mYt1A,ebp
         sub Xp2mXp1A,ecx
         sub Yp2mYp1A,ebx

         ISClipped

         ;=============== Init
         shl eax,16
         mov CX1,eax
         shl edx,8
         shl ebp,8
         shl ecx,8
         shl ebx,8
         mov Xt1,edx
         mov Yt1,ebp
         mov Xp1,ecx
         mov Yp1,ebx

         ;================ DeltaX 1 -> 3
         mov eax,X2mX1A
         cdq
         shl eax,16
         idiv Hauteur1
         mov Delta1,eax

         ;================ Recupere donne X2
         mov eax,ny2
         GetCoord
         sub X2mX1B,eax
         sub Xt2mXt1B,edx
         sub Yt2mYt1B,ebp
         sub Xp2mXp1B,ecx
         sub Yp2mYp1B,ebx

         ISClipped

         ;================ Init
         shl eax,16
         mov CX2,eax
         shl edx,8
         shl ebp,8
         shl ecx,8
         shl ebx,8
         mov Xt2,edx
         mov Yt2,ebp
         mov Xp2,ecx
         mov Yp2,ebx

         ;================ DeltaX 2 -> 3
         mov eax,X2mX1B
         cdq
         shl eax,16
         idiv Hauteur1
         mov Delta2,eax

         ;=============== Calcul de l'increment de couleur du triangle
         mov eax,Xt2mXt1A
         cdq
         shl eax,8
         mov ebx,hauteur1
         idiv ebx
         mov StepX1,eax

         mov eax,Yt2mYt1A
         cdq
         shl eax,8
         idiv ebx
         mov StepY1,eax

         mov eax,Xt2mXt1B
         cdq
         shl eax,8
         idiv ebx
         mov StepX2,eax

         mov eax,Yt2mYt1B
         cdq
         shl eax,8
         idiv ebx
         mov StepY2,eax

         mov eax,Xp2mXp1A
         cdq
         shl eax,8
         idiv ebx
         mov EdgeStepXp1,eax

         mov eax,Xp2mXp1B
         cdq
         shl eax,8
         idiv ebx
         mov EdgeStepXp2,eax

         mov eax,Yp2mYp1A
         cdq
         shl eax,8
         idiv ebx
         mov EdgeStepYp1,eax

         mov eax,Yp2mYp1B
         cdq
         shl eax,8
         idiv ebx
         mov EdgeStepYp2,eax

         ;=============== Determination du sens du triangle
         mov eax,Delta2
         cmp Delta1,eax
         jnl @@lom2

         xchg Delta1,eax
         mov Delta2,eax

         mov eax,StepX1
         xchg eax,StepX2
         mov StepX1,eax
         mov eax,StepY1
         xchg eax,StepY2
         mov StepY1,eax

         mov eax,EdgeStepXp1
         xchg eax,EdgeStepXp2
         mov EdgeStepXp1,eax

         mov eax,EdgeStepYp1
         xchg eax,EdgeStepYp2
         mov EdgeStepYp1,eax
@@lom2:
         mov eax,CX2
         cmp eax,CX1
         jg @@hjk
         mov eax,CX1
         xchg CX2,eax
         mov CX1,eax

         mov eax,Xt2
         mov ebx,Yt2
         mov Xt1,eax
         mov Yt1,ebx
         mov eax,Xp2
         mov ebx,Yp2
         mov Xp1,eax
         mov Yp1,ebx
@@hjk:
         ;============= Calcul de L'incrment Interne
         CalcInc

         ;====================== Dessin
         Call WhatRoutine
         ret
DrawTriMP endp

;

end
