{ͻ
 Unit         : SEGMENT.PAS                                                 
 Author       : Sebastian Schuberth aka Saint (email: saint@freepage.de)    
 Description  : Provides DOS memory functions and segment management        
Ķ
 Created on   : 17.05.1998                                                  
 Last revised : 02.06.1998                                                  
}

Unit Segment;

Interface

Var
  SegBuffer:Word;  { Current buffer writes go to. }

Procedure SegAlloc(Var Segment:Word);
Procedure SegFree(Segment:Word);

Procedure SegPutPixel(x,y,Color:Byte);
Function SegGetPixel(x,y:Byte):Byte;

Procedure SegPlasma(FromColor,ToColor:Word);

Implementation

Function AllocDOSMem(Paragraphs:Word):Word; Assembler;
{ Allocate as many paragraphs (16 byte blocks) as given. }
Asm
  mov    ah,48h
  mov    bx,[Paragraphs]
  int    21h
End;

Procedure FreeDOSMem(Segment:Word); Assembler;
{ Free a previously allocated DOS memory block. }
Asm
  mov    ah,49h
  mov    es,[Segment]
  int    21h
End;

Procedure SegAlloc(Var Segment:Word);
{ Allocates a whole segment and redirects writes to it. }
Begin
  SegBuffer:=AllocDOSMem(4096);
  Segment:=SegBuffer;
End;

Procedure SegFree(Segment:Word);
{ Free a previously allocated segment. }
Begin
  FreeDOSMem(Segment);
End;

Procedure SegPutPixel(x,y,Color:Byte); Assembler;
{ Put a pixel value. Segment is treated as a 256x256 screen. }
Asm
  mov    es,[SegBuffer]
  mov    bh,[y]
  mov    bl,[x]
  mov    al,[Color]
  mov    es:[bx],al
End;

Function SegGetPixel(x,y:Byte):Byte; Assembler;
{ Get a pixel value. Segment is treated as a 256x256 screen. }
Asm
  mov    es,[SegBuffer]
  mov    bh,[y]
  mov    bl,[x]
  mov    al,es:[bx]
End;

Procedure SegPlasma(FromColor,ToColor:Word);
{ Generate a plasma with the common algorithm. Note: This one will generate }
{ a wrapable plasma. You can specify a color range all pixels are within.   }
Var
  Color:Byte;
  ColorRange:Word;

  Procedure SwapWord(Var a,b:Word);
  { Tricky swap method, isn't it? }
  Begin
    a:=a XOR b;
    b:=a XOR b;
    a:=a XOR b;
  End;

  Procedure NewColor(x0,y0,x,y,x1,y1:Word);
  Begin
    If SegGetPixel(x,y)<>0 Then Exit;

    Color:=(x1-x0)+(y1-y0);
    Color:=Random(Color SHL 1)-Color;
    Inc(Color,(SegGetPixel(x0,y0)+SegGetPixel(x1,y1)+1) SHR 1);

    If Color<FromColor Then Color:=FromColor
    Else If Color>ToColor Then Color:=ToColor;

    SegPutPixel(x,y,Color);
  End;

  Procedure SubDivide(x0,y0,x1,y1:Word);
  Var
    x,y:Word;
  Begin
    If ((x1-x0)<2) And ((y1-y0)<2) Then Exit;

    x:=(x0+x1+1) SHR 1;
    y:=(y0+y1+1) SHR 1;

    NewColor(x0,y0,x,y0,x1,y0);
    NewColor(x1,y0,x1,y,x1,y1);
    NewColor(x0,y1,x,y1,x1,y1);
    NewColor(x0,y0,x0,y,x0,y1);

    Color:=(SegGetPixel(x0,y0)+SegGetPixel(x1,y0)
           +SegGetPixel(x1,y1)+SegGetPixel(x0,y1)+2) SHR 2;
    SegPutPixel(x,y,Color);

    SubDivide(x0,y0,x,y);
    SubDivide(x,y0,x1,y);
    SubDivide(x,y,x1,y1);
    SubDivide(x0,y,x,y1);
  End;

Begin
  For Color:=0 To 255 Do  { Initialize the segment to zero. }
    FillChar(Mem[SegBuffer:Color SHL 8],256,0);

  { Adjust color range. }
  If FromColor>ToColor Then SwapWord(FromColor,ToColor);
  ColorRange:=ToColor-FromColor+1;

  { Because of the wrap-around ([0,0]=[256,256]=[0,256]=[256,0]) we need }
  { just one initial value.                                              }
  SegPutPixel(0,0,FromColor+Random(ColorRange));
  SubDivide(0,0,256,256);
End;

End.