{R-}
program equation_finder;     { (c) 1996 by Daniel Vollmer! }
uses crt;
{{$DEFINE showcalc}
const
     Ver='0.2';
     NumOfEq=100;
     EqLength=256;
     MaxEqEntries=EqLength div sizeof(word);
     MaxConstsIn1Eq=8;
     MaxResults=256;
     StackEntries=65535 div sizeof(real)-1;
{----N-A-M-E-S---------------------------------------------------------------}
     EndOfEq=0;   { Nothing follows }
     Command=1;   { 1 byte command follows }
     RealConst=2; { 1 byte pointer follows }
     Constant=3;  { 1 byte pointer follows }
     Number=4;    { 6 bytes real number follows }
{----C-O-M-M-A-N-D-S---------------------------------------------------------}
     Nop=0;
     Add=1;
     Sub=2;
     Mul=3;
     Divi=4;
     Squa=5;
     Root=6;
     NumCommands=6;
{----C-O-N-S-T-A-N-T-S-------------------------------------------------------}
     Pie=0;
     NumConsts=0;
type
    EquationType=array[0..EqLength] of byte;
    AllEquaType=array[1..NumOfEq] of EquationType;
    ConstType=record
                    Result:Real;
                    Consts:array[0..MaxConstsIn1Eq-1] of real;
              end;
    ConstArrType=array[1..MaxResults] of ConstType;
    StackType=array[0..StackEntries] of real;
    CompareType=array[1..MaxResults] of Real;
const
     Functions:array[0..NumCommands] of byte=( (0), {Nop}  {1. Params}
                                               (2), {Add}
                                               (2), {Sub}
                                               (2), {Mul}
                                               (2), {Divi}
                                               (1), {Sqr}
                                               (1)  {Root}
                                                  );
     FuncNames:array[0..NumCommands] of string[4]=(
                                                    ('NOP'),
                                                    ('ADD'),
                                                    ('SUB'),
                                                    ('MUL'),
                                                    ('DIV'),
                                                    ('POT'),
                                                    ('ROT')
                                                  );
     Consts:array[0..NumConsts] of real=(pi); {already defined in TPascal}
var
   Equations:^AllEquaType;
   Constants:^ConstArrType;
   Stack:^StackType;
   TempResults:^CompareType;
   OKResults:array[1..MaxResults] of boolean;
   SolveEquation:array[1..NumOfEq] of boolean;
   NumOfMeas:word;
   NumOfConsts:byte;
   Accuracy:real;
   c,c2:word;
   found:boolean;
   small,smallptr:word;

procedure setup;
begin
     getmem(Equations,sizeof(AllEquaType));
     getmem(Constants,sizeof(ConstArrType));
     getmem(Stack,sizeof(StackType));
     getmem(TempResults,sizeof(Comparetype));
     Randomize;
     TextMode(Co80+Font8x8);
     writeln('Free memory: ',MemAvail,' , biggest block: ',MaxAvail,'.');
     writeln('Maximum amount of space for numbers in equations: ',MaxEqEntries,'.');
     writeln('Free stack-entries: ',StackEntries,'.');
     writeln;
     writeln('Equation-Finder Version ',Ver,' by Daniel Vollmer.');
     writeln;
end;

procedure shutdown;
begin
     freemem(Equations,sizeof(AllEquaType));
     freemem(Constants,sizeof(ConstArrType));
     freemem(Stack,sizeof(StackType));
     freemem(TempResults,sizeof(Comparetype));
end;

procedure getinfos;

function getnumber:real;
var r:real;
    s:string;
    c:Integer;
begin
     repeat
           readln(s);
           val(s,r,c);
     until c=0;
     getnumber:=r;
end;

var c,c2:byte;i:word;t:real;
begin
     writeln('Enter the number of different measurements:');
     NumOfMeas:=Round(getnumber);
     if NumOfMeas>MaxResults then NumOfMeas:=MaxResults;
     writeln('Enter the number of known values for each equation:');
     NumOfConsts:=Round(getnumber);
     if NumOfConsts>MaxConstsIn1Eq then NumOfConsts:=MaxConstsIn1Eq;
     for c:=1 to NumOfMeas do begin
         writeln;
         for c2:=1 to NumOfConsts do begin
             writeln('Enter the ',c2,'. known value for measurement #',c,':');
             Constants^[c].Consts[c2-1]:=getnumber;
         end;
         writeln('Enter the result for measurement #',c,':');
         Constants^[c].Result:=getnumber;
     end;
     writeln;
     writeln('Please enter number of exact digits (0=exact values):');
     i:=Round(getnumber);
     if i<>0 then begin
        t:=10;
        for c:=1 to i-1 do t:=t*10;
        Accuracy:=1/t;
     end else Accuracy:=0;
     writeln;
end;

procedure CreateNewEquation(Num:Word;Entries:Word);
var VirStack:Word;
    EqPtr:Word;
    c:Word;
    t:byte;
begin
     Fillchar(Equations^[Num],sizeof(EquationType),0);
     VirStack:=0; {Empty Stack at the beginning...}
     EqPtr:=0;
     if Entries>MaxEqEntries then Entries:=MaxEqEntries;
     c:=1;
     repeat
         t:=Random(3)+1;
         Case t of
         Command:
          begin
              t:=Random(NumCommands)+1; {No NOPs}
              if Functions[t]<=VirStack then begin
                 if Functions[t]>0 then dec(VirStack,Functions[t]-1); {because it pushes a result}
                 Equations^[Num][EqPtr]:=Command;
                 Equations^[Num][EqPtr+1]:=t;
                 inc(EqPtr,2);
              end;
          end;
         RealConst:
          begin
              Equations^[Num][EqPtr]:=RealConst;
              Equations^[Num][EqPtr+1]:=Random(NumConsts+1);
              inc(EqPtr,2);
              inc(VirStack);
          end;
         Constant:
          begin
              Equations^[Num][EqPtr]:=Constant;
              Equations^[Num][EqPtr+1]:=Random(NumOfConsts);
              inc(EqPtr,2);
              inc(VirStack);
          end;
         end;
         inc(c);
     until (c>Entries);
end;

function ExecuteEquation(Num,MeasID:Word):real;
var
   StackPtr,
   EqPtr    :Word;
   b:byte;
   r,r2:real;

procedure push(r:real); {StackPtr always points to the next free entry!}
begin
     if StackPtr<=StackEntries then begin
        Stack^[StackPtr]:=r;
        inc(StackPtr);
     end else begin
         writeln('Stack Overflow!');
         shutdown;
         halt(1);
     end;
end;

function pop:real;
begin
     if StackPtr>0 then begin
        dec(StackPtr);
        pop:=Stack^[StackPtr];
     end else begin
         writeln('Stack Underflow!');
         readkey;
         shutdown;
         halt(1);
     end;
end;

begin
     StackPtr:=0;
     EqPtr:=0;
     repeat
           b:=Equations^[Num][EqPtr];
           Case b of
            Command:
             begin
                  b:=Equations^[Num][EqPtr+1];
                  Case b of
                   Nop:;
                   Add:
                    begin
                         r:=pop;
                         r2:=pop;
{$IFDEF showcalc}        writeln('+',r,' ',r2); {$ENDIF}
                         push(r+r2);
                    end;
                   Sub:
                    begin
                         r:=pop;
                         r2:=pop;
{$IFDEF showcalc}        writeln('-',r2,' ',r); {$ENDIF}
                         push(r2-r);
                    end;
                   Mul:
                    begin
                         r:=pop;
                         r2:=pop;
{$IFDEF showcalc}        writeln('*',r,' ',r2); {$ENDIF}
                         push(r*r2);
                    end;
                   Divi:
                    begin
                         r:=pop;
                         if r<>0 then begin
                            r2:=pop;
{$IFDEF showcalc}           writeln('/',r,' ',r2); {$ENDIF}
                            push(r2/r);
                         end else push(r);
                    end;
                   Squa:
                    begin
                         r:=pop;
{$IFDEF showcalc}        writeln('',r);        {$ENDIF}
                         push(sqr(r));
                    end;
                   Root:
                    begin
                         r:=pop;
{$IFDEF showcalc}        writeln('',r);        {$ENDIF}
                         push(sqrt(abs(r)));
                    end;
                  else writeln('Wrong Command encountered!');
                  end;
                  inc(EqPtr,2);
             end;
            RealConst:
             begin
                  b:=Equations^[Num][EqPtr+1];
                  push(Consts[b]);
                  inc(EqPtr,2);
             end;
            Constant:
             begin
                  b:=Equations^[Num][EqPtr+1];
                  push(Constants^[MeasID].Consts[b]);
                  inc(EqPtr,2);
             end;
            end;
     until (Equations^[Num][EqPtr]=EndOfEq);
     if StackPtr>1 then ExecuteEquation:=pop else ExecuteEquation:=0;
end;

procedure DisplayEquation(Num,MeasID:Word);
var c:word;b:byte;r:real;c2:byte;
begin
     c:=0;
     c2:=1;
     repeat
           b:=Equations^[Num][c];
           case b of
                EndOfEq:exit;
                Command:begin
                             write('Command: ');
                             b:=Equations^[Num][c+1];
                             writeln(FuncNames[b]);
                             inc(c,2);
                        end;
                RealConst:begin
                               write('RealConst: ');
                               b:=Equations^[Num][c+1];
                               writeln(Consts[b]);
                               inc(c,2);
                          end;
                Constant:begin
                               write('Constant: ');
                               b:=Equations^[Num][c+1];
                               writeln(Constants^[MeasID].Consts[b]);
                               inc(c,2);
                         end;
           end;
           inc(c2);
           if c2=30 then begin
              readkey;
              c2:=1;
           end;
     until Equations^[Num][c]=0;
end;

function getlength(Num:Word):word;
var c:word;
begin
     c:=0;
     repeat inc(c,2) until Equations^[Num][c]=0;
     getlength:=c div 2;
end;

procedure CutEquation(Num:Word);
var c,NumNeeded,Ende:word;b:byte;
begin
     Ende:=(getlength(Num)-1)*2;
     c:=Ende;
     NumNeeded:=0;
     if (Equations^[Num][c]=RealConst) or (Equations^[Num][c]=Constant) then begin
        move(Equations^[Num][c],Equations^[Num][0],2);
        fillchar(Equations^[Num][3],EqLength-2,0);
     end else begin
          while c>0 do begin
                b:=Equations^[Num][c];
                if b=Command then begin
                   b:=Equations^[Num][c+1];
                   inc(NumNeeded,Functions[b])
                end else begin
                     b:=Equations^[Num][c];
                     dec(NumNeeded);
                end;
                dec(c,2);
                if NumNeeded=0 then begin
                   move(Equations^[Num][c+2],Equations^[Num][0],Ende-c);
                   fillchar(Equations^[Num][(Ende-c)],EqLength-(Ende-c),0);
                   c:=0;
                end;
          end;
     end;
end;

procedure mutation(Num:Word);

function CheckEquation(Num:Word):boolean;
var
   StackPtr,
   EqPtr    :Word;
   b:byte;
   r,r2:real;

procedure push(r:real); {StackPtr always points to the next free entry!}
begin
     if StackPtr<=StackEntries then begin
        Stack^[StackPtr]:=r;
        inc(StackPtr);
     end else CheckEquation:=false;
end;

function pop:real;
begin
     if StackPtr>0 then begin
        dec(StackPtr);
        pop:=Stack^[StackPtr];
     end else CheckEquation:=false;
end;

begin
     CheckEquation:=true;
     StackPtr:=0;
     EqPtr:=0;
     repeat
           b:=Equations^[Num][EqPtr];
           Case b of
            Command:
             begin
                  b:=Equations^[Num][EqPtr+1];
                  Case b of
                   Nop:;
                   Add:
                    begin
                         r:=pop;
                         r2:=pop;
                         push(r+r2);
                    end;
                   Sub:
                    begin
                         r:=pop;
                         r2:=pop;
                         push(r2-r);
                    end;
                   Mul:
                    begin
                         r:=pop;
                         r2:=pop;
                         push(r*r2);
                    end;
                   Divi:
                    begin
                         r:=pop;
                         if r<>0 then begin
                            r2:=pop;
                            push(r2/r);
                         end else push(r);
                    end;
                   Squa:
                    begin
                         r:=pop;
                         push(sqr(r));
                    end;
                   Root:
                    begin
                         r:=pop;
                         push(sqrt(abs(r)));
                    end;
                  else writeln('Wrong Command encountered!');
                  end;
                  inc(EqPtr,2);
             end;
            RealConst:
             begin
                  b:=Equations^[Num][EqPtr+1];
                  push(Consts[b]);
                  inc(EqPtr,2);
             end;
            Constant:
             begin
                  b:=Equations^[Num][EqPtr+1];
                  push(Constants^[1].Consts[b]);
                  inc(EqPtr,2);
             end;
            end;
     until (Equations^[Num][EqPtr]=EndOfEq);
     if StackPtr<1 then CheckEquation:=false;
end;

var c,c2:word;b:byte;
    bak:EquationType;
begin
     b:=Random(4);
     bak:=Equations^[Num];
     c2:=getlength(Num);
     Case b of
     Nop:; {nothing changes}
     Command: {insert command}
      begin
      end;
     RealConst: {insert realconst}
      begin
      end;
     Constant: {insert constant}
      begin
      end;
     end;
end;

var ch:char;
begin
     setup;
     getinfos;
     for c:=1 to NumOfEq do CreateNewEquation(c,c+2);
     small:=MaxEqEntries;smallptr:=0;
     repeat
     for c:=1 to NumOfEq do begin
         for c2:=1 to NumOfMeas do begin
             TempResults^[c2]:=ExecuteEquation(c,c2);
             writeln(c,'[',c2,'] = ',TempResults^[c2]);
         end;
         for c2:=1 to NumOfMeas do TempResults^[c2]:=TempResults^[c2]-Constants^[c2].Result;
         for c2:=1 to NumOfMeas do OKResults[c2]:=
         ((TempResults^[c2]<=Accuracy) and (TempResults^[c2]>=-Accuracy)) or
         ((TempResults^[c2]>=-Accuracy) and (TempResults^[c2]<=Accuracy));
         found:=true;
         for c2:=1 to NumOfMeas do if OKResults[c2]=false then found:=false;
         SolveEquation[c]:=found;
         if not found then CreateNewEquation(c,c+2) else CutEquation(c);
     end;
     for c:=1 to NumOfEq do if SolveEquation[c] then if getlength(c)<small then begin
         small:=getlength(c);
         smallptr:=c;
     end;
     if smallptr>0 then begin
        writeln('Best solution with ',small,' steps is #',smallptr);
        displayequation(smallptr,1);
     end else writeln('No solution found.');
     ch:=readkey;
     until (ch=#27) or (smallptr>0);
     shutdown;
end.
