unit windou; {(c) 1996 by Daniel Vollmer}
interface
uses crt,dos;
const
  Window:array[0..7] of char='յƸͳԾ'; { window-characters }
  SizeX=80;                              { size of text-screen }
  SizeY=25;
  ScrBufSize=SizeX*SizeY*2;
  TextSeg=$b800;
  SLength=18;                            { string-length for Filenames
                                           (18 chars for dffs2-files)  }
  NoCursor=$0100;                        { constants for setcursor }
  NormCursor=$0c0d;
  HalfCursor=$080d;
  BigCursor=$000f;
  emptychar=#249;
  nobeep:boolean=true;
type
  Menu=record
     entries:byte;
     col:byte;
     MenuData:array[1..SizeY-2] of string[19];
  end;                                   { a simple menu..............
                                           (no same starting letters!) }
  WinString=string[SizeX-2];
  Wind       = record
                     x1,x2,y1,y2,Xsize,ysize,cx,cy,col:byte
               end;
  ScrBuf     = array[1..ScrBufSize] of byte;
  SName      = string[SLength];
  FileRecord = record
                     Name:SName;
                     Attr:byte;
               end;
  ReadFileFunc=function(mask:string):boolean;
const
  MaxFileRecords = 65536 div sizeof(FileRecord)-1;
type
  FileRecords = array[0..MaxFileRecords] of FileRecord; { for filerequest }
var
   ScrBuffer,ScrSave,InpSave : ^ScrBuf; { buffers:ScrBuffer:general screenbuffer
                                          others save screen for menu & input    }
   MenuWin                   : Wind;
   Title                     : WinString;
   Fils                      : ^FileRecords;
   NumFound                  : word;

procedure beep;
function getcursor:word;
procedure setcursor(ccc:word);
function shift : boolean;
procedure gotoxy(x,y:byte);
procedure copybuffer;
procedure copybuffer2(var source,destinat;count:word);
procedure clearbuffer(color:byte);
procedure win(var w:wind;xsize,ysize,color:byte;var Target);
procedure getbuffers;
procedure freebuffers;
procedure input(var s:string;TitleText,PreText:WinString;col:byte);
function DoMenu(var Men:Menu;var ch:Wind;Tit:string):byte;
function ReadInFiles(mask:string):boolean;
function FileRequest(Mask:WinString;LoadColor:byte;RFunc:ReadFileFunc;exp:boolean;Comm:string):string;

implementation

procedure beep;
begin
   if nobeep=false then begin
      Sound(440);
      Delay(80);
      NoSound;
   end;
end;

function getcursor:word;assembler;
asm
   mov   ah,03h
   xor   bh,bh
   int   10h
   mov   ax,cx
end;

procedure setcursor(ccc:word);assembler;
asm
   mov   ah,01h
   mov   cx,ccc
   int   10h
end;

function shift : boolean; assembler;
asm
   push 0040h {bios-data-segment}
   pop  es
   mov  al,es:[$0017]
   and  al,00000011b
end;

procedure gotoxy(x,y:byte);assembler;
asm
   mov  ah,02h
   xor  bh,bh
   mov  dl,x
   mov  dh,y
   int  10h
end;

procedure copybuffer;assembler;
asm
   push     ds
   lds      si,ScrBuffer
   push     TextSeg
   pop      es
   xor      di,di
   mov      cx,ScrBufSize/2
   rep      movsw
   pop      ds
end;

procedure copybuffer2(var source,destinat;count:word);assembler;
asm
   push     ds
   lds      si,source
   les      di,destinat
   mov      cx,count
   rep      movsw
   pop      ds
end;

procedure clearbuffer(color:byte);assembler;
asm
   les      di,ScrBuffer
   xor      di,di
   mov      cx,ScrBufSize/2
   mov      ah,color
   mov      al,32
   rep      stosw
end;

procedure win(var w:wind;xsize,ysize,color:byte;var Target);assembler;
asm
   mov     al,Xsize
   sub     al,4
   cmp     byte ptr title[0],al
   jg      @end
   cmp     byte ptr title[0],0
   jz      @end
   cmp     ysize,3
   jl      @end
   cmp     ysize,SizeY
   ja      @end
   cmp     xsize,SizeX
   ja      @end
   mov     dl,SizeX/2
   mov     bl,xsize
   shr     bl,1
   sub     dl,bl
   mov     dh,SizeY/2
   mov     bl,ysize
   shr     bl,1
   sub     dh,bl
   les     di,dword ptr w
   mov     es:[di],dl
   mov     es:[di+2],dh
   mov     al,dl
   add     al,xsize
   dec     al
   mov     es:[di+1],al
   mov     al,dh
   add     al,ysize
   dec     al
   mov     es:[di+3],al
   mov     al,xsize
   sub     al,2
   mov     ah,ysize
   sub     ah,2
   mov     es:[di+4],ax
   mov     ax,0101h
   mov     es:[di+6],ax
   mov     al,color
   mov     es:[di+8],al

   les     di,Target
   xor     di,di
   mov     al,dh
   xor     ah,ah
   mov     bl,dh
   xor     bh,bh
   shl     ax,7   { y * 128 }
   shl     bx,5   { y *  32 }
   add     ax,bx  {---------}
   mov     bl,dl
   xor     bh,bh
   add     ax,bx
   add     ax,bx
   add     di,ax  {     160 }
   push    di
   mov     ah,color
   push    di
   xor     ch,ch
   add     di,SizeX*2+2
   mov     al,32
   mov     bl,xsize
   sub     bl,2
   mov     si,bx
   add     si,bx
   mov     bl,ysize
   sub     bl,2
@clearloop:
   mov     cx,si
   shr     cx,1
   rep     stosw
   sub     di,si
   add     di,SizeX*2
   dec     bl
   jnz     @clearloop
   pop     di
   mov     al,byte ptr window[0]
   stosw
   mov     cl,xsize
   sub     cl,byte ptr title[0]
   shr     cx,1
   sub     cx,2
   push    cx
   mov     al,byte ptr Window[4]
   rep     stosw
   mov     al,byte ptr Window[1]
   stosw
   mov     cl,byte ptr title[0]
   mov     si,offset title[1]
@writeloop:
   lodsb
   stosw
   dec     cl
   jnz     @writeloop
   mov     al,byte ptr Window[2]
   stosw
   xor  bl,bl
   mov     al,byte ptr title[0]
   and     al,00000001b
   jz      @notodd
   mov     bl,1
@notodd:
   xor     al,al
   mov     cl,xsize
   and     cl,00000001b
   jz      @notodd2
   mov     al,1
@notodd2:
   xor     al,bl
   jz      @notmove
   mov     al,byte ptr Window[4]
   stosw
@notmove:
   pop     cx
   mov     al,byte ptr Window[4]
   rep     stosw
   mov     al,byte ptr Window[3]
   stosw
   pop     di
   add     di,sizex*2
   mov     cl,ysize
   sub     cl,2
   mov     al,byte ptr Window[5]
   xor     bh,bh
   mov     bl,xsize
   dec     bl
   add     bx,bx
@vertwin:
   mov     es:[di],ax
   add     di,bx
   mov     es:[di],ax
   sub     di,bx
   add     di,sizex*2
   dec     cl
   jnz     @vertwin

   mov     al,byte ptr Window[6]
   stosw
   mov     cl,xsize
   sub     cl,2
   mov     al,byte ptr Window[4]
   rep     stosw
   mov     al,byte ptr Window[7]
   stosw
@end:
end;

procedure getbuffers;
begin
     getmem(ScrBuffer,sizeof(ScrBuf));
     getmem(ScrSave,sizeof(ScrBuf));
     getmem(InpSave,sizeof(ScrBuf));
end;

procedure freebuffers;
begin
     freemem(ScrBuffer,sizeof(ScrBuf));
     freemem(ScrSave,sizeof(ScrBuf));
     freemem(InpSave,sizeof(ScrBuf));
end;

procedure input(var s:string;TitleText,PreText:WinString;col:byte);
var
   inpwin:wind;
   WorkStr:WinString;
   ch:char;
   oldcursor:word;
   mark1,mark2:byte;
   c:word;
   ocx,ocy:byte;
   insertb,quit:boolean;

procedure update;
var c:byte;
begin
     gotoxy(1,inpwin.y1+1);
     TextColor(col and 15);
     TextBackGround(0);
     if (mark1=0) or (mark1=mark2) then write(WorkStr)
     else begin
         for c:=1 to mark1-1 do write(WorkStr[c]);
         TextColor(0);
         TextBackGround(col and 15);
         for c:=mark1 to mark2-1 do write(WorkStr[c]);
         TextColor(col and 15);
         TextBackGround(0);
         for c:=mark2 to length(WorkStr) do write(WorkStr[c]);
     end;
     for c:=1 to (SizeX-2)-length(WorkStr) do write(emptychar);
     gotoxy(1+inpwin.cx,inpwin.y1+1);
end;

procedure checksel(Cur,Next:byte);
var w:word;
begin
     if shift then begin
        if Cur=mark1 then mark1:=Next
        else begin
             if Cur=mark2 then mark2:=Next
             else begin
                  mark1:=Next;
                  mark2:=Cur;
             end;
        end;
        if mark1>mark2 then begin
           w:=mark2;
           mark2:=mark1;
           mark1:=w;
        end;
     end;
end;

procedure upmarks;
begin
     if (inpwin.cx+1>=mark1) and (mark1<>mark2) and (inpwin.cx+1<mark2) then dec(mark2)
     else begin
          if (inpwin.cx+1<mark1) then begin
             dec(mark1);
             dec(mark2);
          end;
     end;
end;

procedure left;
begin
     if inpwin.cx>0 then begin
        checksel(inpwin.cx+1,inpwin.cx);
        dec(inpwin.cx);
     end else beep;
end;

procedure right;
begin
     if (inpwin.cx<77) and (inpwin.cx<length(WorkStr)) then begin
        checksel(inpwin.cx+1,inpwin.cx+2);
        inc(inpwin.cx);
     end else beep;
end;

begin
     copybuffer2(mem[TextSeg:0],InpSave^,ScrBufSize shr 1);
     oldcursor:=getcursor;
     ocx:=wherex-1;
     ocy:=wherey-1;
     insertb:=true;
     quit:=false;
     setcursor(halfcursor);
     WorkStr:=PreText;
     Title:=TitleText;
     win(inpwin,SizeX,3,col,mem[TextSeg:0]);
     if PreText='' then begin
        mark1:=0;
        mark2:=0;
     end else begin
         mark1:=1;
         mark2:=length(PreText)+1;
     end;
     inpwin.cx:=Length(PreText);
     update;
     repeat
           ch:=readkey;
           if ch=#0 then begin
              ch:=readkey;
              case ch of
                   #71:for c:=1 to inpwin.cx do left;
                   #75:left;
                   #77:right;
                   #79:for c:=inpwin.cx+1 to length(WorkStr) do right;
                   #82:begin
                            if insertb then begin
                               setcursor(normcursor);
                               insertb:=false;
                            end else begin
                                setcursor(halfcursor);
                                insertb:=true;
                            end;
                       end;
                   #83:begin
                            if (shift) and (mark1<>0) and (mark1<>mark2) then begin
                               delete(WorkStr,mark1,mark2-mark1);
                               if (inpwin.cx+1>=mark1) then inpwin.cx:=mark1-1;
                               mark1:=0;
                               mark2:=0;
                            end else if inpwin.cx<length(WorkStr) then begin
                               delete(WorkStr,inpwin.cx+1,1);
                               upmarks;
                            end else beep;
                       end;
                   end;
              end else case ch of
               #8:begin
                       if inpwin.cx>0 then begin
                          delete(WorkStr,inpwin.cx,1);
                          dec(inpwin.cx);
                          upmarks;
                       end else beep;
                  end;
               #13:quit:=true;
               #27:begin
                        quit:=true;
                        WorkStr:='';
                   end;
               else begin
                    if (inpwin.cx<78) and (length(WorkStr)<78) then begin
                       if insertb then begin
                          Insert(ch,WorkStr,inpwin.cx+1);
                          if (inpwin.cx+1<=mark2) and (inpwin.cx+1>=mark1) then inc(mark2)
                          else begin
                               if (inpwin.cx+1<mark1) and (inpwin.cx+1<mark2) then begin
                                  inc(mark1);
                                  inc(mark2);
                               end;
                          end;
                       end else begin
                           WorkStr[inpwin.cx+1]:=ch;
                           if inpwin.cx=length(WorkStr) then inc(WorkStr[0]);
                       end;
                       if inpwin.cx<77 then inc(inpwin.cx);
                    end else beep;
               end;
           end;
           update;
     until quit;
     s:=WorkStr;
     copybuffer2(InpSave^,mem[TextSeg:0],ScrBufSize shr 1);
     setcursor(oldcursor);
     gotoxy(ocx,ocy);
end;

procedure highline(offst:word;line,x:byte);assembler;
asm
   xor  dh,dh
   xor  bh,bh
   push TextSeg
   pop  es
   mov  al,SizeX*2
   mul  byte ptr line
   inc  ax
   add  ax,offst
   mov  di,ax
   mov  dl,x
   dec  dl
@loop:
   mov  bx,dx
   add  bx,bx
   mov  al,es:[di+bx]
   not  al
   and  al,01111111b
   or   al,00001000b
   mov  es:[di+bx],al
   dec  dl
   jns  @loop
end;

function DoMenu(var Men:Menu;var ch:Wind;Tit:string):byte;
var Size,c:byte;x,y:byte;
    quit:boolean;key:char;
    offst:word;line:byte;
    yes:boolean;
begin
     Size:=0;
     with Men do begin
      with ch do begin
          for c:=1 to entries do if length(MenuData[c])>Size then Size:=length(MenuData[c]);
          Title:=Tit;
          copybuffer2(ScrBuffer^,ScrSave^,ScrBufSize shr 1);
          if size>length(Tit)+4 then win(MenuWin,Size,entries+2,Men.col,ScrBuffer^)
          else win(MenuWin,length(Tit)+4,entries+2,Men.col,ScrBuffer^);
          y:=y1+1;
          x:=x1+1;
          asm
             les        di,ScrBuffer
             lds        si,Men
             mov        dl,ds:[si]
             xor        dh,dh
             xor        ch,ch
             xor        ah,ah
             xor        bh,bh
             mov        al,y
             mov        bl,al
             shl        ax,7   { y * 128 }
             shl        bx,5   { y *  32 }
             add        ax,bx  {---------}
             mov        bl,x
             xor        bh,bh
             add        bx,bx
             add        ax,bx
             mov        offst,ax
             add        di,ax
             mov        ah,ds:[si+1]
             add        si,2
          @stringloop:
             push       si
             push       di
             mov        cl,ds:[si]
             dec        cl
             inc        si
             mov        bh,ah
             dec        ah
             cmp        ah,bh
             jne        @notinc
             dec        ah
          @notinc:
             and        ah,01111111b
             lodsb
             stosw
             mov        ah,bh
          @charloop:
             lodsb
             stosw
             dec        cl
             jnz        @charloop
             pop        di
             add        di,SizeX*2
             pop        si
             add        si,20
             dec        dl
             jnz        @stringloop
          end;
          quit:=false;
          x:=ch.xsize;
          line:=0;
          repeat
                copybuffer;
                highline(offst,line,x);
                key:=readkey;
                if key=#0 then begin
                   key:=readkey;
                   case key of
                        #71:line:=0;
                        #72,#75:if line=0 then line:=entries-1 else dec(line);
                        #77,#80:line:=(line+1) mod entries;
                        #79:line:=Men.entries-1;
                   end;
                end else begin
                    case key of
                        #13,#32:begin
                                     quit:=true;
                                     domenu:=line+1;
                                end;
                        #27:begin
                                 quit:=true;
                                 domenu:=0;
                            end;
                        else begin
                             c:=1;
                             yes:=false;
                             while (c<=Men.entries) and (not yes) do
                             if (upcase(Men.MenuData[c][1])=upcase(key)) then yes:=true else inc(c);
                             if yes then begin
                                line:=c-1;
                                domenu:=line+1;
                                quit:=true;
                             end;
                        end;
                    end;
                end;
          until quit;
          copybuffer2(ScrSave^,ScrBuffer^,ScrBufSize shr 1);
      end;
     end;
     copybuffer;
end;

procedure QuickSort(L, R: Integer);
var
  I, J: Integer;
  X:SName;
  Y:FileRecord;
begin
  I := L;
  J := R;
  X := Fils^[(L + R) shr 1].Name;
  repeat
    while Fils^[I].Name < X do Inc(I);
    while X < Fils^[J].Name do Dec(J);
    if I <= J then
    begin
      Y := Fils^[I];
      Fils^[I] := Fils^[J];
      Fils^[J] := Y;
      Inc(I);
      Dec(J);
    end;
  until I > J;
  if L < J then QuickSort(L, J);
  if I < R then QuickSort(I, R);
end;

function ReadInFiles(mask:string):boolean;
var c:word;
    joker:boolean;
    t:SearchRec;
begin
     ReadInFiles:=true;
     NumFound:=0;
     FindFirst('*.*',Directory,t);
     while DosError=0 do begin
           if (T.Attr and Directory<>0) then begin
              Fils^[NumFound].Name:=T.Name+'\';
              Fils^[NumFound].Attr:=T.Attr;
              inc(NumFound);
           end;
           FindNext(t);
     end;
     FindFirst(Mask,Archive,t);
     while DosError=0 do begin
           Fils^[NumFound].Name:=T.Name;
           Fils^[NumFound].Attr:=T.Attr;
           inc(NumFound);
           FindNext(t);
     end;
     if Fils^[0].Name='.\' then begin
        move(Fils^[1],Fils^[0],sizeof(FileRecords)-sizeof(FileRecord));
        dec(NumFound);
     end;
     joker:=false;
     for c:=1 to length(mask) do if (mask[c]='*') or (mask[c]='?') then joker:=true;
     if (joker=false) then ReadInFiles:=false;
end;

function FileRequest(Mask:WinString;LoadColor:byte;RFunc:ReadFileFunc;exp:boolean;Comm:string):string;
var quit:boolean;
    key:char;
    filewin:wind;
    offst:word;
    line:byte;
    Base:word;
    Dir:string;
    c:word;
    ma:WinString;
    Pat:string;

function printfiles(var Buffer;var Filss;start:word;x,y:byte;count:word;colo:byte):word;assembler;
     asm
        cmp        count,0
        jz         @bye
        les        di,Buffer
        mov        dx,count
        xor        ch,ch
        xor        ah,ah
        xor        bh,bh
        mov        al,y
        mov        bl,al
        shl        ax,7   { y * 128 }
        shl        bx,5   { y *  32 }
        add        ax,bx  {---------}
        mov        bl,x
        xor        bh,bh
        add        bx,bx
        add        ax,bx
        push       ax
        add        di,ax
        mov        ah,Colo
        push       ds
        lds        si,Filss
        add        si,start
     @stringloop:
        push       si
        push       di
        mov        cl,ds:[si]
        push       cx
        inc        si
     @charloop:
        lodsb
        stosw
        dec        cl
        jnz        @charloop
        pop        bx
        mov        cl,SLength
        sub        cl,bl
        mov        al,32
        rep        stosw
        pop        di
        add        di,SizeX*2
        pop        si
        add        si,20
        dec        dx
        jnz        @stringloop
        pop        ds
        pop        ax
@bye:
     end;

procedure NewFileWindow;

procedure checkmask(var m:WinString);
var last,slash,c:byte;
    path:PathStr;NewM:WinString;
begin
     path:='';
     slash:=1;
     c:=pos('\',m);
     while c<>0 do begin
           path:=path+copy(m,1,c);
           delete(m,1,c);
           slash:=c;
           c:=pos('\',m);
     end;
     if Path<>'' then begin
        dec(path[0]);
        chdir(path);
     end;
end;

var c:word;
    b:boolean;
begin
     if NumFound>1 then quicksort(0,NumFound-1);
     copybuffer2(ScrSave^,ScrBuffer^,ScrBufSize shr 1);
     copybuffer;
     Base:=0;
     Line:=0;
     checkmask(ma);
     GetDir(0,Pat);
     if pat[length(Pat)]='\' then dec(pat[0]);
     if (length(pat)+length(ma)+9)>(SizeX-2) then Pat:='...';
     if Comm='' then Title:='Files ['+Pat+'\'+ma+']'
     else Title:='Files ['+Comm+']';
     if length(Title)+2<sizeof(SName)-1 then begin
        b:=true;
        for c:=1 to (sizeof(SName)-1)-(length(Title)+2) do begin
            if b then insert(' ',Title,1)
            else insert(' ',Title,length(Title)+1);
            b:=not b;
        end;
     end;
     if NumFound>SizeY-2 then begin
        win(FileWin,SLength+length(ma)+length(Pat),SizeY,LoadColor,ScrBuffer^);
        offst:=printFiles(ScrBuffer^,Fils^,Base*sizeof(FileRecord),
                          FileWin.x1+1,FileWin.y1+1,SizeY-2,LoadColor);
     end else begin
         if NumFound<1 then win(FileWin,SLength+length(ma)+length(Pat),NumFound+3,LoadColor,ScrBuffer^)
         else win(FileWin,SLength+length(ma)+length(Pat),NumFound+2,LoadColor,ScrBuffer^);
         offst:=printFiles(ScrBuffer^,Fils^,Base*sizeof(FileRecord),
                           FileWin.x1+1,FileWin.y1+1,NumFound,LoadColor);
     end;
end;

procedure esc;
begin
     input(ma,'Filename/Wildcard',ma,LoadColor);
     if ma='' then quit:=true else begin
        if not RFunc(ma) then begin
           FileRequest:=Fexpand(ma);
           quit:=true;
        end else begin
            NewFileWindow;
        end;
     end;
end;

procedure pos1;
begin
      line:=0;
      base:=0;
      if NumFound>SizeY-2 then
      offst:=printFiles(ScrBuffer^,Fils^,Base*sizeof(FileRecord),
                        FileWin.x1+1,FileWin.y1+1,SizeY-2,LoadColor)
      else offst:=printFiles(ScrBuffer^,Fils^,Base*sizeof(FileRecord),
                             FileWin.x1+1,FileWin.y1+1,NumFound,LoadColor);
end;

procedure up;
begin
      if Line>0 then dec(Line)
      else if Base>0 then begin
           dec(Base);
           offst:=printFiles(ScrBuffer^,Fils^,Base*sizeof(FileRecord),
                             FileWin.x1+1,FileWin.y1+1,SizeY-2,LoadColor);
      end;
end;

procedure down;
begin
      if Line<FileWin.ysize-1 then inc(line)
      else if NumFound>SizeY-2 then if (Base+FileWin.ysize)<NumFound then begin
           inc(Base);
           offst:=printFiles(ScrBuffer^,Fils^,Base*sizeof(FileRecord),
                             FileWin.x1+1,FileWin.y1+1,SizeY-2,LoadColor);
      end;
end;

procedure pgup;
begin
     if Line>0 then Line:=0 else if Base>0 then begin
        if Base>SizeY-3 then dec(Base,SizeY-3) else Base:=0;
         offst:=printFiles(ScrBuffer^,Fils^,Base*sizeof(FileRecord),
                           FileWin.x1+1,FileWin.y1+1,SizeY-2,LoadColor);
     end;
end;

procedure ende;
begin
     if NumFound>SizeY-2 then begin
        line:=SizeY-3;
        base:=NumFound-(SizeY-2);
        offst:=printFiles(ScrBuffer^,Fils^,Base*sizeof(FileRecord),
                          FileWin.x1+1,FileWin.y1+1,SizeY-2,LoadColor)
     end else begin
         line:=NumFound-1;
         offst:=printFiles(ScrBuffer^,Fils^,Base*sizeof(FileRecord),
                            FileWin.x1+1,FileWin.y1+1,NumFound,LoadColor);
     end;
end;

procedure pgdown;
begin
     if Line<FileWin.ysize-1 then line:=FileWin.ysize-1
     else if NumFound>SizeY-2 then if (Base+FileWin.ysize-1)<(NumFound-(SizeY-3)) then begin
          inc(Base,SizeY-3);
          offst:=printFiles(ScrBuffer^,Fils^,Base*sizeof(FileRecord),
                            FileWin.x1+1,FileWin.y1+1,SizeY-2,LoadColor);
     end else begin
         inc(Base,NumFound-(Base+FileWin.ysize));
         offst:=printFiles(ScrBuffer^,Fils^,Base*sizeof(FileRecord),
                           FileWin.x1+1,FileWin.y1+1,SizeY-2,LoadColor);
     end;
end;

procedure return;
begin
     if Fils^[Base+Line].Attr and Directory<>0 then begin
        dec(Fils^[Base+Line].Name[0]);
        chdir(Fils^[Base+Line].Name);
        RFunc(ma);
        NewFileWindow;
     end else begin
         if exp then FileRequest:=FExpand(Fils^[Base+Line].Name)
         else FileRequest:=Fils^[Base+Line].Name;
         quit:=true;
     end;
end;

procedure otherkey;
begin
     key:=upcase(key);
     c:=0;
     while (c<=NumFound) and (Fils^[c].Name[1]<>Key) do inc(c);
     if (Fils^[Base+line].Name[1]=key) and (Fils^[Base+line+1].Name[1]=Key) then down
     else begin
          if c<=NumFound then if NumFound<=SizeY-2 then line:=c else begin
             while (c<base) or (c>=Base+SizeY-2) do if c>base then pgdown else pgup;
             line:=c-base;
          end;
     end;
end;

begin
     copybuffer2(ScrBuffer^,ScrSave^,ScrBufSize shr 1);
     FileRequest:='';
     ma:=mask;
     getmem(Fils,sizeof(FileRecords));
     getdir(0,dir);
     dir:=fexpand(dir);
     if not RFunc(mask) then begin
        FileRequest:=mask;
        chdir(dir);
        freemem(Fils,sizeof(FileRecords));
        copybuffer2(ScrSave^,ScrBuffer^,ScrBufSize shr 1);
        copybuffer;
        exit;
     end;
     NewFileWindow;
     quit:=false;
     repeat
           copybuffer;
           highline(offst,line,FileWin.xsize);
           key:=readkey;
           if key=#0 then begin
              key:=readkey;
              case key of
                   #71     :pos1;
                   #72,#75 :up;
                   #73     :pgup;
                   #77,#80 :down;
                   #79     :ende;
                   #81     :pgdown;
              end;
           end else
           case key of
                #13     :return;
                #27     :esc;
                else otherkey;
           end;
     until quit;
     chdir(dir);
     freemem(Fils,sizeof(FileRecords));
     copybuffer2(ScrSave^,ScrBuffer^,ScrBufSize shr 1);
     copybuffer;
     normvideo;
end;

begin
     getbuffers;
end.
