{  These packing routines are based on the LZHUF.C program by
   Haruyasu Yoshizaki. Copyright (C) 1995 Christian Worm.

   This file holds the Pascal unit which makes the interface for
   the assembler library.
}

Unit SupPack;

Interface

Const
  { Declare errorcodes. Note that negative errorcodes are reserved
    for use by library.
  }

  PACK_NOERR=0;  { No error }
  PACK_EOD=-1 ;  { End Of Data before end of unpacking }

Type

{ Type declarations for user read/write functions. Note that the
  user can select any type he or she wants for the buffer argument.
}

  SupPackReadFunc =Function(UserData  : Pointer;
                            Var Buffer;
                            Var Size  : Word): Integer ;

  SupPackWriteFunc=Function(UserData  : Pointer;
                            Var Buffer;
                            Size      : Word): Integer ;

{ Library function declarations: }

Function decode_mem_req: Word ;
{ Returns the number of bytes that the unpacker needs. }

Function do_decode (UserData  : Pointer;
                    ReadFunc  : SupPackReadFunc;
                    WriteFunc : SupPackWriteFunc;
                    WorkBuffer: Pointer): Integer;
{ This function does the unpacking. It returns PACK_NOERR if the
  unpacking were succesfull and returns PACK_EOD if the entier block
  of packed data couldn't be read. Returns the same as the read/write
  functions if they return an error code. Paramerers:

  UserData:
    A pointer that's only used to give the read/write functions (look
    below) as parameter. Asures that the user can work reentrant if he
    wants to.

  ReadFunc:
    This function should read size bytes to buffer. In size the number of
    bytes actually read should be stored. Should return PACK_NOERR or a
    possitive errorcode.

  WriteFunc:
    This function should write size bytes from buffer. Should return
    PACK_NOERR or a possitive errorcode.

  WorkBuffer:
    A memory area that the unpacker can use for its own data. A minimum of
    decode_mem_req bytes is required.
}

{ The following is as by the unpacker - just for the packer: }
Function encode_mem_req: Word ;

Function do_encode (userdata  : Pointer;
                    ReadFunc  : SupPackReadFunc;
                    WriteFunc : SupPackWriteFunc;
                    WorkBuffer: Pointer): Integer ;

{----------------------------------------------------------------------------}

Implementation

{$L PASCOMN.OBJ}
{$L PASDECOD.OBJ}
{$L PASENCOD.OBJ}

Function decode_mem_req: Word;                      External;
Function do_decode (UserData  : Pointer;
                    ReadFunc  : SupPackReadFunc;
                    WriteFunc : SupPackWriteFunc;
                    WorkBuffer: Pointer): Integer;  External;

Function encode_mem_req: Word;                      External;
Function do_encode (UserData  : Pointer;
                    ReadFunc  : SupPackReadFunc;
                    WriteFunc : SupPackWriteFunc;
                    WorkBuffer: Pointer): Integer;  External;

End.