{  These packing routines are based on the LZHUF.C program by
   Haruyasu Yoshizaki. Copyright (C) 1995 Christian Worm.

   This is an example of a program using the Pascal packing interface.
}

Uses SupPack ;

Const
  { Internal error codes: }
  READ_ERR =1;
  WRITE_ERR=2;

Var
  infile : File;      { Files we read from/to }
  outfile: File;

Const
  rd     : Longint=0; { How many bytes read/written }
  written: Longint=0;

{ Writes how long we've come: }
Procedure write_status;
Begin
  Write (#13'Read ', rd, '. Written ', written) ;
End ;

Function Read(u: Pointer; Var Buffer: Byte; Var Size: Word): Integer; Far;
Begin { read from file }

  BlockRead (infile, Buffer, Size, Size) ;

  Inc (rd, Size) ;

  If InOutRes = 0 Then
    Read := PACK_NOERR
  Else
    Read := READ_ERR ; { return errorcode if something went wrong }
End ;

Function Write(u: Pointer; Var Buffer: Byte; Size: Word): Integer; Far;
Var
  BytesWritten: Word;
Begin
  { Write to file: }
  BlockWrite (outfile, buffer, Size, BytesWritten) ;
  Inc (written, BytesWritten) ;
  write_status ;

  If BytesWritten = Size Then
    write := PACK_NOERR
  Else
    write := WRITE_ERR ;
End ;


Var
  pack        : Boolean;
  err         : Integer;
  OperationStr: String;
  mem_req     : Word;
  m           : Pointer;
Begin
  OperationStr := ParamStr (1) ;
  If (ParamCount <> 3) Or Not (OperationStr [1] In ['A','a','E','e']) Then Begin
    WriteLn ('Syntax: SUPPACK.EXE a|e packedfile unpackedfile');
    Halt (1) ;
  End ;

  { A bool that shows if we're packing (TRUE) or unpacking (FALSE): }
  pack := UpCase (OperationStr [1]) <> 'E' ;

  { An errorcode is stored - no error has occurred yet: }
  err := PACK_NOERR ;

  { Open files: }
  If Pack Then Begin
    Assign (infile , ParamStr (3));
    Assign (outfile, ParamStr (2));
  End Else Begin
    Assign (infile , ParamStr (2));
    Assign (outfile, ParamStr (3));
  End ;

  Reset(InFile , 1);     { open infile with a blocksize of 1 byte }
  If IOResult <> 0 Then  { success? }
    Err := READ_ERR;

  Rewrite (Outfile, 1);  { open outfile with a blocksize of 1 byte }
  If IOResult <> 0 Then  { success? }
    Err := WRITE_ERR;

  If Err = PACK_NOERR Then Begin
    { Files are opened. }

    { Allocate memory: }
    If Pack Then
      mem_req := encode_mem_req
    Else
      mem_req := decode_mem_req ;

    GetMem(m, mem_req) ;

    { Call packing/unpacking routines: }
    write_status ;
    If Pack Then
      err := do_encode (Nil, read, write, m)
    Else
      err := do_decode (Nil, read, write, m) ;
    write_status;
    WriteLn ;

    { And release memory: }
    FreeMem (m, mem_req);
  End ;

  { Show a possible error: }
  InOutRes:=0;
  Case err Of
    PACK_EOD   : WriteLn ('Unexpected end of file');
    READ_ERR   : WriteLn ('Read error');
    WRITE_ERR  : WriteLn ('Write error');
  End;

  Halt(err) ;
End.