// These packing routines are based on the LZHUF.C program by
// Haruyasu Yoshizaki. Copyright (C) 1995 Christian Worm.

#ifndef PACKINT
#define PACKINT

/*
Generel beskrivelse (er simplificeret):
Denne pakker kan gemme to typer af informationer i den pakkede fil:

1) En stored karakter komprimeret med dynamisk huffman
2) Et offset+en lngde. Dette gres ved at gemme en karakter som
   i punkt 1, men med vrdien 256+lngde. Nr der er gemt sdan
   en karakter vil der efterflgende kommer et 12 bit offset hvor
   de 6 mest betydende bit eventuelt er komprimeret med statisk huffman.

Mht punkt 2 s virker pakkeren p den mde at den hele tiden lser ind
i en ring buffer. Hvis man lser en streng fra den upakkede fil som
findes et andet sted i buffern, s gemmer man offset'et p denne + lngde.
Derved har man opnet en betragtelig kompression.

Se i PACK.CPP for en mere udfrlig forklaring.

Bemrk: Over alt i disse rutiner hvor en bit liste gemmes i en eller flere
bytes gemmes der i bytene fra lave til hje adresser. Men: I hver
byte er den mindst betydende bit den frste og den mest den sidste.
*/

#define MIN_PACK_LEN  3
// Det mindste antal bytes der kan pakkes (behandles som i punkt 2)

#define MAX_PACK_LEN 67
// Den lngst mulig streng der kan pakkes

#define BUFSIZE (4096+MAX_PACK_LEN-1)
// Antal bytes i ringbufferen. De 4096 bytes er hvad der kan adresseres
// med tolv bits. MAX_PACK_LEN lgges til da der hele tiden er lst
// dette stykke foran i bufferen i forhold til hvad der
// pakkes. Dette gres for at muliggre at man kan finde en streng
// et andet sted i bufferen der passer med det der er lst. Da der gemmes
// et offset relativt til det sted der pakkes kan vi addresere alle relevante
// steder p tolv bits (se dist). Den sidste trkkes fra da dette offset
// angiver EOF:

#define ENDOFS 4095
// Denne vrdi skrives som offset nr den sidste byte er net

#define normal(a) ((a)>=BUFSIZE ? (a)-BUFSIZE : (a))
// Wrapper automatisk rundt hvis der adresseres udover bufferen

#define getbytebit(byte,bit) ((byte) & (1<<(bit)))
#define setbytebit(byte,bit) (byte|=(1<<(bit)))
// Stter og lser en bit i en byte

#define FILEBUFLEN 512
// Antal bytes der skal gemmes fr putbytes/getbytes (virtual funktioner
// defineret af brugeren) kaldes (lse/skrive bufferens strelse)

#define USETABL
// Nr denne er defineret bruges huffman tabel til kompresion af de verste
// 6 bits af offset (se i selve .CPP filerne). Da der kan komme
// copyright problemer mht brug af tabellerne kan dette sls fra.

//#define OLD_RECONST
// Nr denne er defineret bruges den originale LZHUF Huffman reconst
// procedure - ellers den nye alternative og mindre kompilcerede men
// langsommere. Bemrk at det pakkede format ndre sig alt efter
// om denne er defineret eller ej, og at assembler udgaven af pakkeren
// ikke supporter den gamle reconst proceudre.

// Disse konstanter bruges af huffman:
#define N_CHAR    (256+MAX_PACK_LEN-MIN_PACK_LEN+1) // Antallet af leaf noder
#define T         (N_CHAR * 2 - 1) // Antallet af noder i alt incl leafs
#define R         (T - 1)           // Rodens position
#define MAX_FREQ  0x8000     // Nr rodens frekvens nr hertil kaldes reconst

#endif