// These packing routines are based on the LZHUF.C program by
// Haruyasu Yoshizaki. Copyright (C) 1995 Christian Worm.

#ifndef PACK
#define PACK

#include <packint.hpp>
#include <huffman.hpp>

// Klasse til at skrive bits:
class bitwrite {
  char buffer[FILEBUFLEN];
  unsigned bufbyteofs;
  char bufbitofs;

  public:
  void initwrite();

  virtual void write(char* buffer, int bufsize)=0;
  // Kaldes nr et antal bytes er parat.

  void putbits(unsigned code, char bitcount);
  // Skriver de nederste bitcount bits af code til vores buffer

  void flushbuf();
  // Skriv buffer - klassen virker frst igen nr initwrite er kaldt!
};

// Flgende klasse lser bytes til en buffer
class byteread {
  char buffer[FILEBUFLEN];
  unsigned bufbyteofs;
  int bytesback;
  int handle;

  public:
  int getbyte(); // returnerer -1 ved fejl
  void initread();

  virtual int read(char* buffer, int bufsize)=0;
};

class pack_huffman:base_huff,protected bitwrite {
  public:
  base_huff::inithuff; // Skal vre public

  void writecode(unsigned charecter);
  // Gemmer en karakter/kode med huffman
};

#define BIN_NULL BUFSIZE
// Den vrdi left/right/parent har nr de ikke peger p noget

class bintree {
  unsigned left[BUFSIZE+1+256];
  unsigned right[BUFSIZE+1];
  unsigned father[BUFSIZE+1];
  // Disse er noder for hver karakter
  // De sidste 256 karakterer af left angiver start for hver
  // af de 256 kakterer. Hvis father er BIN_NULL er noden ikke brugt
  // Elementet [BUFSIZE] er der for at sikre, at hvis der indexseres
  // med en BIN_NULL vrdi, s sker der ikke noget.

  public:

  unsigned char ascbuf[BUFSIZE+MAX_PACK_LEN-1];
  // +MAX_PACK_LEN-1 er lagt til, da de frste MAX_PACK_LEN-1
  // i bufferen ogs str efter den egentlig buffer
  // Dette gres for at gre sammenligninger hurtigere

  void initbintree();

  void insertnode(int &matchofs, int& matchlen, int insertofs);
  void deletenode(unsigned ofs);
};

// Denne klasse udgr selve interfacet til brugeren:
class encode:pack_huffman,byteread,bintree {
  void writepacked(unsigned bufofs, unsigned buflen);
  // Hvis der skal gemmes et offset og en lngde gres det via denne

  public:

  void do_encode();
  // Starter kompresionen.
};

#endif
