/* These packing routines are based on the LZHUF.C program by
   Haruyasu Yoshizaki. Copyright (C) 1995 Christian Worm.

   This is an example on a program which uses the C pakcking interface.
*/

#include <suppack.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#define READ_ERR    1
#define WRITE_ERR   2
#define PACK_NO_MEM 3

FILE* infile;
FILE* outfile;
long rd=0,written=0;

void write_status(void) {
  printf("\rRead %li. Written %li",rd,written);
}

int far pascal read(void far* u, char far *buffer,unsigned far* size) {
  rd+=*size=fread(buffer,sizeof(char),*size,infile); /* Read from file */
  return PACK_NOERR;
}

int far pascal write(void far* u, char far* buffer, unsigned size) {
  /* Write to file and return error: */
  size_t a=fwrite(buffer,sizeof(char),size,outfile);
  written+=a;
  write_status();
  return (a==size) ? PACK_NOERR : WRITE_ERR;
}

main(int argc, char* argv[]) {
  int pack;
  int err;

  if((argc!=4) || ((toupper(argv[1][0])!='A') && (toupper(argv[1][0])!='E'))) {
    printf("Syntax: SUPPACK.EXE a|e packedfile unpackedfile\n");
    return 1;
  }

  /* A bool that shows if we're packing (TRUE) or unpacking (FALSE): */
  pack=(toupper(argv[1][0])=='E') ? 0 : 1;

  /* An errorcode is stored in err - no error has occurred yet: */
  err=PACK_NOERR;

  /* Open files: */
  infile=fopen(argv[pack ? 3 : 2],"rb");
  outfile=fopen(argv[pack ? 2 : 3],"wb");

  if(infile==NULL) err=READ_ERR;
  if(outfile==NULL) err=WRITE_ERR;

  if(err==0) {
    /* The files are opened. */

    /* Allocate memory: */
    char* m=(char*)calloc(pack ? encode_mem_req() : decode_mem_req(),sizeof(char));

    if(m==NULL) /* If there's not enough memory */
      err=PACK_NO_MEM;
    else {
      /* Call packing/unpacking routines: */
      write_status();
      err=pack ? do_encode(NULL,read,write,m) : do_decode(NULL,read,write,m);
      write_status();
      printf("\n");

      /* And free the memory: */
      free(m);
    }
  }

  /* Show a possible error: */
  switch(err) {
    case PACK_EOD:    printf("Unexpected end of file\n"); break;
    case PACK_NO_MEM: printf("Not enough memory\n"); break;
    case READ_ERR:    printf("Read error\n"); break;
    case WRITE_ERR:   printf("Write error\n"); break;
  }

  return err;
};