.model tiny
codeseg
.386
org 100h
Int2FKennung equ 0f3h
; (c) 1996 by Daniel Vollmer
;-----------------------------C-O-D-E-------------------------------------------

Dos macro Func
  mov	 ah,Func
  int	 21h
endm

start:
  jmp    @ColourInstall
;------------------------------------D-A-T-A------------------------------------
Go db 0
Active db 0
Tab db 33 dup (0),15 dup (1001b),10 dup (0011b),7 dup (1001b),26 dup (0),6 dup (1001b),26 dup (0),4 dup (1001b),129 dup (0)
;***********************I*N*T*S*************************************************

Int2FHandler proc far
  cmp	 ah, Int2FKennung
  je	 @forme
  db	 0eah
  Old2F  dw ?,? 		; old int...
@forme:
  cmp	 al,1			; function: return codeseg
  je	 @GetSegm
  mov	 al,ah
  ror	 al,2			; inverse kennung...
  iret
@GetSegm:
  push	 cs
  pop	 es
  iret
Int2FHandler endp

Int16Handler proc far
  push   bx
  xor    bx,bx
  or     ah,ah
  setz   bl
  cmp    ah,10h
  sete   bh
  or     bl,bh                  ; combine...
i16@no:
  pushf
  db	 9Ah
  Old16  dw ?,?
  pushf                         ; saves result flags...
  or     bl,bl
  jz     i16@exit
  mov    cs:[Go],1
i16@exit:
  popf
  pop    bx
  retf   2
Int16Handler endp

Int1CHandler proc far
  cmp    cs:[active],1
  je     i1c@end

  pusha
  push   ds

  mov    ax,0b800h
  push	 040h
  pop    ds
  movzx  bx,byte ptr ds:[062h]  ; pagenum...
  mov    cx,ds:[04ch]
  mov    dx,ds:[04ch]           ; pagesize in byte

  shr	 dx,4			; convert to segment...
  cmp	 bx,0
  jz	 i@gotaddress
i@incloop:
  add	 ax,dx			; add pagesize
  dec	 bx
  jnz	 i@incloop
i@gotaddress:
  mov    ds,ax
  xor    si,si
  shr    cx,1

  cmp    ds:[319],byte ptr 0
  jne    i1c@go

  cmp    cs:[go],1
  jne    i1c@bye

i1c@go:
  mov    cs:[go],byte ptr 0
  mov    cs:[active],byte ptr 1
i@loop:
  lodsw
  movzx  bx,al
  mov    al,cs:[offset Tab+bx]
  or     al,al
  jz     i@next
  and    ah,11110000b
  or     ah,al
  mov    ds:[si-1],ah
i@next:
  dec    cx
  jnz    i@loop

i1c@bye:
  mov    ds:[319],byte ptr 0
  pop    ds
  popa
  mov    cs:[active],0
i1c@end:
  db     0eah
  Old1c  dw ?,?
Int1CHandler endp

Transient Label Word

@ColourInstall:
  mov	 ah,Int2fKennung
  xor	 al,al
  push	 ax
  int	 2fh			; already installed?
  pop	 bx
  ror	 bh,2
  or	 al,al
  jz	 @install
  cmp	 bh,al
  je	 @already
  mov	 ah,9
  lea	 dx,BelegtMsg
  jmp	 @@quit
@already:
  mov	 al,1
  int	 2fh
  mov	 si,es

  mov    al,2fh
  Dos	 35h
  mov	 bx,es
  cmp	 bx,si
  jne	 @noway

  mov    es,si

  mov    al,16h
  Dos	 35h
  mov	 bx,es
  cmp	 bx,si
  jne    @noway

  mov    es,si

  mov    al,1ch
  Dos	 35h
  mov	 bx,es
  cmp	 bx,si
  jne	 @noway

  mov    es,si

  mov    al,2fh
  mov	 dx,es:[Old2f]
  mov	 ds,es:[Old2f+2]
  Dos	 25h

  mov	 al,16h
  mov	 dx,es:[Old16]
  mov	 ds,es:[Old16+2]
  Dos	 25h

  mov    al,1ch
  mov    dx,es:[Old1c]
  mov    ds,es:[Old1c+2]
  Dos	 25h

  Dos    49h                    ; free mem...

  push   cs
  pop    ds

  lea    dx, FreeMsg
  Dos	 9
@@quit:
  xor	 al,al
  Dos	 4ch
@noway:
  lea	 dx,NoRemoveMsg
  Dos	 9
  jmp	 @@quit
@install:
  mov    al,2fh
  Dos	 35h
  mov	 [Old2f],bx
  mov	 [Old2f+2],es
  lea	 dx, Int2fHandler
  Dos	 25h

  mov	 al,16h
  Dos	 35h
  mov	 [Old16],bx
  mov	 [Old16+2],es
  lea	 dx, Int16Handler
  Dos	 25h

  mov    al,1ch
  Dos	 35h
  mov    [Old1c],bx
  mov    [Old1c+2],es
  lea    dx, Int1cHandler
  Dos	 25h

  mov	 es,cs:[2ch]
  Dos	 49h

  lea	 dx,InstallMsg
  Dos	 09h

  lea	 dx,Transient
  shr	 dx,4
  inc    dx
  Dos    31h

BelegtMsg db "no.",36
NoRemoveMsg db "nr.",36
InstallMsg db "yo.",36
FreeMsg db "cu.",36
end start
