UNCRUNCH PROC NEAR
;from TheDraw
;Parameters Required:
;  DS:SI  Crunched image source pointer.
;  ES:DI  Display address pointer.
;  CX     Length of crunched image source data.
;
       PUSH    SI                      ;Save registers.
       PUSH    DI
       PUSH    AX
       PUSH    BX
       PUSH    CX
       PUSH    DX
       JCXZ    u@Done

       MOV     DX,DI                   ;Save X coordinate for later.
       XOR     AX,AX                   ;Set Current attributes.
       CLD

u@LOOPA: LODSB                           ;Get next character.
       CMP     AL,32                   ;If a control character, jump.
       JC      u@ForeGround
       STOSW                           ;Save letter on screen.
u@Next:  LOOP    u@LOOPA
       JMP     Short u@Done

u@ForeGround:
       CMP     AL,16                   ;If less than 16, then change the
       JNC     u@BackGround            ;foreground color.  Otherwise jump.
       AND     AH,0F0H                 ;Strip off old foreground.
       OR      AH,AL
       JMP     u@Next

u@BackGround:
       CMP     AL,24                   ;If less than 24, then change the
       JZ      u@NextLine                ;background color.  If exactly 24,
       JNC     u@FlashBitToggle          ;then jump down to next line.
       SUB     AL,16                   ;Otherwise jump to multiple output
       ADD     AL,AL                   ;routines.
       ADD     AL,AL
       ADD     AL,AL
       ADD     AL,AL
       AND     AH,8FH                  ;Strip off old background.
       OR      AH,AL
       JMP     u@Next

u@NextLine:
       ADD     DX,160                  ;If equal to 24,
       MOV     DI,DX                   ;then jump down to
       JMP     u@Next                    ;the next line.

u@FlashBitToggle:
       CMP     AL,27                   ;Does user want to toggle the blink
       JC      u@MultiOutput             ;attribute?
       JNZ     u@Next
       XOR     AH,128                  ;Done.
       JMP     u@Next

u@MultiOutput:
       CMP     AL,25                   ;Set Z flag if multi-space output.
       MOV     BX,CX                   ;Save main counter.
       LODSB                           ;Get count of number of times
       MOV     CL,AL                   ;to display character.
       MOV     AL,32
       JZ      u@StartOutput             ;Jump here if displaying spaces.
       LODSB                           ;Otherwise get character to use.
       DEC     BX                      ;Adjust main counter.

u@StartOutput:
       XOR     CH,CH
       INC     CX
       REP STOSW
       MOV     CX,BX
       DEC     CX                      ;Adjust main counter.
       LOOPNZ  u@LOOPA                   ;Loop if anything else to do...

u@Done:  POP     DX                      ;Restore registers.
       POP     CX
       POP     BX
       POP     AX
       POP     DI
       POP     SI
       RET

UNCRUNCH ENDP

