program animate;                  {(c) 1996 by Daniel Vollmer}
const
  QuarterFrameRate=70;
  MaxTotalFrames=16382;
type
  schummel=array[1..5] of byte;
  lengthindextype=array[0..MaxTotalFrames] of word;
  framearraytype=array[0..MaxTotalFrames] of ^schummel;
var
   vseg:word;
   vp:pointer;
   Anim:^framearraytype;
   AnimIndex:^lengthindextype;
   NumFrames:word;
   Buffer:array[1..5000] of byte;

procedure switch(source:word;dest:word); assembler;
asm
   push ds
   mov  es,dest
   mov  ds,source
   xor  si,si
   xor  di,di
   mov  cx,65536 shr 2
   db $66;
   rep  movsw
   pop  ds
end;

procedure setmodeq;
var i:byte;
type
  twrec=record reg:word; func,data:byte; end;
  twarr=array[0..22] of twrec;
const
  tweak:twarr=(
    (reg:$03d4; func:$00; data:$5f), { hor. total }
    (reg:$03d4; func:$01; data:$3f), { hor. display enable end }
    (reg:$03d4; func:$02; data:$40), { blank start }
    (reg:$03d4; func:$03; data:$82), { blank end }
    (reg:$03d4; func:$04; data:$4e), { retrace start }
    (reg:$03d4; func:$05; data:$9a), { retrace end }
    (reg:$03d4; func:$06; data:$23), { vertical total }
    (reg:$03d4; func:$07; data:$b2), { overflow register }
    (reg:$03d4; func:$08; data:$00), { preset row scan }
    (reg:$03d4; func:$09; data:$61), { max scan line/char heigth }
    (reg:$03d4; func:$10; data:$0a), { ver. retrace start }
    (reg:$03d4; func:$11; data:$ac), { ver. retrace end }
    (reg:$03d4; func:$12; data:$ff), { ver. display enable end }
    (reg:$03d4; func:$13; data:$20), { offset/logical width }
    (reg:$03d4; func:$14; data:$40), { underlinde location }
    (reg:$03d4; func:$15; data:$07), { ver. blank start }
    (reg:$03d4; func:$16; data:$17), { ver. blank end }
    (reg:$03d4; func:$17; data:$a3), { mode control }
    (reg:$03c4; func:$01; data:$01), { clock mode register }
    (reg:$03c4; func:$04; data:$0e), { memory mode register }
    (reg:$03ce; func:$05; data:$40), { mode register }
    (reg:$03ce; func:$06; data:$05), { misc. register }
    (reg:$03c0; func:$10; data:$41)  { mode control }
  );
begin
  asm
     mov ax,13h
     int 10h
     mov dx,03d4h; mov al,11h; out dx,al; inc dx; in al,dx; and al,7fh
     mov ah,al; mov al,11h; dec dx; out dx,ax;
  end;
  for i:=0 to 22 do
    with tweak[i] do begin
      if reg<>$03c0 then port[reg]:=func else port[reg]:=func+32;
      port[reg+1]:=data;
    end;
  asm
     mov dx,03d4h; mov al,11h; out dx,al; inc dx; in al,dx; or al,80h
     mov ah,al; mov al,11h; dec dx; out dx,ax;
  end;
end;

procedure dopal(c,r,g,b:byte); assembler; asm
  mov dx,3c8h; mov al,[c]; out dx,al; inc dx; mov al,[r]
  out dx,al; mov al,[g]; out dx,al; mov al,[b]; out dx,al; end;

procedure retrace; assembler;
asm
   mov   cx,4*70/QuarterFrameRate
@loop:
  mov dx,3dah; @vert1: in al,dx; test al,8; jz @vert1
  @vert2: in al,dx; test al,8; jz @vert2
  dec    cx
  jnz    @loop
end;

function readanim(Name:String):word; {frames}
var f:file;
    NumF:word;
    c:word;
begin
     assign(f,Name+'.ani');
     reset(f,1);
     BlockRead(f,NumF,sizeof(word));
     getmem(AnimIndex,sizeof(word)*(NumF+1));
     getmem(Anim,sizeof(pointer)*(NumF+1));
     for c:=0 to NumF do BlockRead(f,AnimIndex^[c],sizeof(word));
     for c:=0 to NumF do begin
         if MaxAvail>=AnimIndex^[c] then getmem(Anim^[c],AnimIndex^[c])
         else begin
              writeln('Not enough memory...');
              halt(1);
         end;
         BlockRead(f,Anim^[c]^,AnimIndex^[c]);
     end;
     close(f);
     readanim:=NumF;
end;

procedure freeanim(NumF:word);
var c:word;
begin
     for c:=0 to NumF do freemem(anim^[c],AnimIndex^[c]);
     freemem(anim,sizeof(pointer)*(NumF+1));
     freemem(animindex,sizeof(word)*(NumF+1));
end;

function unpack(var frame;len:word):byte;external; {size of one row}
procedure doanim(var a;Siz:byte;segg:word);external;
{$l doanim2.obj}

var
   c:word;
   ac:word;
begin
     NumFrames:=ReadAnim('beet');
     getmem(vp,65535);
     vseg:=seg(vp^);
     fillchar(vp^,65535,0);
     setmodeq;
     for c:=0 to 255 do dopal(c,c div 4,c div 4,c div 4);
     ac:=0;
     repeat
           ac:=ac mod (NumFrames+1);
           c:=unpack(Anim^[ac]^,AnimIndex^[ac]);
           if c<64 then doanim(buffer,c,vseg)
           else doanim(anim^[ac]^[2],c,vseg);
           retrace;
           switch(vseg,$a000);
           inc(ac);
     until port[$60]=1;
     asm
        mov ax,3
        int 10h
     end;
     writeln('Free Mem: ',MemAvail,' Biggest Block: ',MaxAvail);
     freemem(vp,65535);
     freeanim(NumFrames);
end.
