#include "clib.h"
#include "text.h"
#include "palette.h"

#define NUMTRAILS 25

void SS_Plasma(void);
void SS_Trails(void);
BYTE *ssbg;


// Plasma Internals
void adjust(int xa,int ya,int x,int y,int xb,int yb, int iparm);
void subDivide(int x1, int y1, int x2, int y2, int iparm);
void TextPlasmaCloud(void);
BYTE *buff;
#define PLASMAX
#define PLASMAY

// Screen savers
void main(void)
{
    BYTE f;
    WORD k;

    InitTxt(0);                             // Initialise Text Library
    InitMouse();
    ClrScr();
    ShowMouse();
    CurPos(0,0);
    LoadBin("b.bin");
    SetMode(S80x25);
    HighBk();
    printf("TRAILS DEMO written by David Thornley (Embaressed :)\n");
    getch();
    SS_Trails();
    printf("PLASMA DEMO written by David Thornley (Embaressed :)\n");
    getch();
    SS_Plasma();
    getch();
    HideMouse();
}

//------------------------------------------------------------------------------
// This draws a rotates a plasma palette in text mode!!!!!!!!!!!!
// with random sinus distortions (maybe0 but for sure a plasma gas cloud
//
void SS_Plasma(void)
{
    BYTE del;
    short ticks;
    WORD mx,my;
    WORD x,y,k;
    DWORD f,d,n,dir;
    WORD index, offset;
    BYTE chr,attr;

    HideCur();
    mx=MousePosX();
    my=MousePosY();
    ssbg=malloc(TMODEX*TMODEY*2+10);       // The size of the screen
    if(ssbg==0)
    {
        printf("NO MEMORY???");
        getch();
    }
    MouseOff();
    for(f=0;f!=TMODEX*TMODEY*2;f++)
        ssbg[f]=videotxt[f];
    for(f=1;f<=TMODEX*TMODEY*2;f+=2)
        videotxt[f]=0*16+8;             // Make the attribute 8 (BLACK *16+GREY)
    MouseOn();
    buff=malloc(TMODEX*TMODEY+10);
    memset(buff,0,TMODEX*TMODEY+10);
    TextPlasmaCloud();
    FastWr(0,0,15,"CEDIT SS- PLASMA");
    ticks=0;
    d=0;
    n=random(8)%20+1;
    dir=0;
    while(!kbhit() && MousePosX()==mx && MousePosY()==my && MouseBut()==0)
    {
        if(ticks==((n-21)*-1))
        {
            if(n>d) d++;
            if(n<d) d--;
            if(d==n) d=n;
        }
        if(ticks==((n-21)*-1)*100)
        {
            n=random(8)%20+1;
            ticks=0;
            if(dir==1) dir=0;
            else dir=1;
        }
        MouseOff();
//        CpPage(0,1);
 //       SWPage(1);
        for(k=160;k!=2000-160;k++)
        {
            videotxt[k*2]=plasma[buff[k]*2];
            videotxt[k*2+1]=plasma[(buff[k]*2)+1];
            if(dir==1)
                buff[k]++;
            else
                buff[k]--;
            if(buff[k]==0)
                buff[k]=240;
            if(buff[k]==241)
                buff[k]=1;
        }
   //     CpPage(1,0);
   //     SWPage(0);
        MouseOn();
        delay(d);
        ticks++;
    }
    if(kbhit()) getch();
    MouseOff();
    for(f=0;f!=TMODEX*TMODEY*2;f++)
        videotxt[f]=ssbg[f];
    MouseOn();
    ShowCur();
    free(ssbg);
    free(buff);
}

// -----------------------------------------------------------------------------
// Recursive sub-division algoithm
// Draws a cloud in an array call buff[TMODEX*TMODEY];
//

void TextPlasmaCloud(void)
{
    DWORD graininess = 00000004;          // GRAININESS (IE. More MOUNTAINS)
    DWORD pseudorandom;
    DWORD d;
    int tstvar;
    int x,y,i;
    int l;
    BYTE r;
    DWORD parm;
    int iparm;                             /* iparm1 = parm1 * 16 */

    parm  = graininess;
    iparm = (parm * 8);
    if (parm <= 0.0) iparm = 16;
        if (parm >= 100) iparm = 800;

    random(8);

    buff[000*000]=1+(random(8)%242);
    buff[TMODEX-1]=1+(random(8)%242);
    buff[TMODEX-1*(TMODEY-1*TMODEX)]=1+(random(8)%242);
    buff[000+(TMODEY-1*TMODEX)]=1+(random(8)%242);

    subDivide(0,0,TMODEX-1,TMODEY-1,iparm);
}

void subDivide(int x1, int y1, int x2, int y2, int iparm)
{
    unsigned char c1, c2, c3, c4;
    int diffx, diffy;
    int x,y;
    diffx = x2-x1;
    diffy = y2-y1;
    if ( diffx < 2 && diffy < 2 ) return;

    x = (x1+x2)/2;
    y = (y1+y2)/2;

    adjust(x1,y1,x,y1,x2,y1,iparm);
    adjust(x2,y1,x2,y,x2,y2,iparm);
    adjust(x1,y2,x,y2,x2,y2,iparm);
    adjust(x1,y1,x1,y,x1,y2,iparm);

    c1=buff[(y*TMODEX)+x];
    if ( c1 == 0 )
    {
        c1=buff[(y1*TMODEX)+x1];    // top left
        c2=buff[(y1*TMODEX)+x2];    // top right
        c3=buff[(y2*TMODEX)+x1];    // bot left
        c4=buff[(y2*TMODEX)+x2];    // bot right
        buff[(y*TMODEX)+x]=(c1+c2+c3+c4)/4;
    }

    subDivide(x1,y1,x,y,iparm);
    subDivide(x,y1,x2,y,iparm);
    subDivide(x,y,x2,y2,iparm);
    subDivide(x1,y,x,y2,iparm);
}

void adjust(int xa,int ya,int x,int y,int xb,int yb,int iparm)
{
    unsigned char a,b;
    int d;
    int f,g;
    long pseudorandom;
    int v;

   // a=buff[(y*TMODEX)+x];

    if((f=xa-xb) < 0)
        f=(xa-xb)*-1;
    if((g=ya-yb) < 0)
        g=(ya-yb)*-1;
    d = f+g;

    pseudorandom = iparm;
    pseudorandom = pseudorandom*((random(16)>>3)-2048);
    pseudorandom = pseudorandom*d;
    d = pseudorandom >> 15;
    a=buff[(ya*TMODEX)+xa];
    b=buff[(yb*TMODEX)+xb];
    v = ((a+b)/2)+d;  // ((buff[(ya*TMODEX)+xa]+buff[(yb*TMODEX)+xb])>>1)+d;
    if(v<1)
       v = 1;
    if(v > 241)
       v = 241;
    buff[(y*TMODEX)+x]=v;
}



// -----------------------------------------------------------------------------
// This screen saver saves the screen, makes the background attribute all 8
// (GREY) and bounces round a line of random colours.
void SS_Trails(void)
{
    struct
    {
        BYTE colour;
        short x,y;
        int xv,yv;
    } trails[NUMTRAILS];

    DWORD f,g,h;
    DWORD count;
    WORD mx,my;

    HideCur();
    mx=MousePosX();
    my=MousePosY();
    ssbg=malloc(TMODEX*TMODEY*2);       // The size of the screen
    for(f=0;f!=TMODEX*TMODEY*2;f++)
        ssbg[f]=videotxt[f];
                                        // Make the attribute 8 (BLACK *16+GREY)
    for(f=1;f<=TMODEX*TMODEY*2;f+=2)
        videotxt[f]=0*16+8;
    FastWr(0,0,15,"CEDIT SS- TRAILS");

    for(count=0;count!=NUMTRAILS;count++)
    {
        trails[count].colour=random(8)%16;
        trails[count].x=random(8)%TMODEX;
        trails[count].y=random(8)%TMODEY;
        ChrWr(trails[count].x,trails[count].y,'',trails[count].colour);
        trails[count].xv=random(8)%2+1; trails[count].yv=random(8)%2+1;
    }
    f=0;
    g=10;
    h=100;
    while(!kbhit() && MousePosX()==mx && MousePosY()==my && MouseBut()==0)
    {
        if(f>=h)
        {
            h=random(8)%100+50;              // randomise how often we randomise
            g=random(8)%40+10;               // randomise delay
            f=0;                            // reset counter
            for(count=0;count!=NUMTRAILS;count++)
            {
notboth:        trails[count].xv=(random(8)%4-2)+1;      // randomise velocitys
                trails[count].yv=(random(8)%4-2)+1;
                if(trails[count].xv==0 && trails[count].yv==0)
                    goto notboth;
            }
        }
        CpPage(0,1);
        SWPage(1);
        for(count=0;count!=TMODEX*TMODEY*2;count+=2)
        {
            videotxt[count]=ssbg[count];
            videotxt[count+1]=8;
        }
        FastWr(0,0,15,"CEDIT SS- TRAILS");
        for(count=0;count!=NUMTRAILS;count++)
        {
            trails[count].colour=random(8)%16;               // randomise colours
            trails[count].x+=trails[count].xv;
            trails[count].y+=trails[count].yv;
            if(trails[count].x > TMODEX-1 || trails[count].x < 0)
            {
                trails[count].xv=-trails[count].xv;
                trails[count].x+=trails[count].xv;
            }
            if(trails[count].y > TMODEY-1 || trails[count].y < 0)
            {
                trails[count].yv=-trails[count].yv;
                trails[count].y+=trails[count].yv;
            }
            ChrWr(trails[count].x,trails[count].y,'',trails[count].colour);
        }
        CpPage(1,0);
        SWPage(0);
        delay(g);
        f++;
    }
    if(kbhit()) getch();

    for(f=0;f!=TMODEX*TMODEY*2;f++)
        videotxt[f]=ssbg[f];
    ShowCur();
    free(ssbg);
}


/**********************************************

	Set Vertical Fine Scroll Register

	>Text mode: no more than 1 character,
	>VGA: 9 pixels!)
	>
	>Val: 0 1 2 3 4 5 6 7 8
	>Pos: 1 2 3 4 5 6 7 8 0


void V_VerticalFine(UBYTE Y)
{
	asm{
		mov	dx,0x3d4;
		mov	ah,Y;
		mov	al,8;
		out	dx,ax;
	}
}



	Set Horizontal PEL Panning Register

	>Text mode: no more than 1 character!


void V_HorizontalFine(UBYTE X)
{
	asm{
		mov	dx,0x3c0;
		mov	al,0x33;
		out	dx,al;
		mov	al,X;
		out	dx,al;
	}
}
}
void TextPlasmaCloud(void)
{
    DWORD graininess = 00000004;          // GRAININESS (IE. More MOUNTAINS)
    DWORD pseudorandom;
    DWORD d;
    int tstvar;
    int x,y,i;
    int l;
    BYTE r;
    DWORD parm;
    int iparm;

    parm  = graininess;
    iparm = (parm * 8);
    if (parm <= 0.0) iparm = 16;
        if (parm >= 100) iparm = 800;

    random(8);

    buff[000*000]=1+(random(8)%242);
    buff[TMODEX-1]=1+(random(8)%242);
    buff[TMODEX-1*(TMODEY-1*TMODEX)]=1+(random(8)%242);
    buff[000+(TMODEY-1*TMODEX)]=1+(random(8)%242);

    subDivide(0,0,TMODEX-1,TMODEY-1,iparm);
}

void subDivide(int x1, int y1, int x2, int y2, int iparm)
{
   int x,y;
   int v;

   x = (x2+x1)>>1;
   y = (y2+y1)>>1;

   adjust(x1,y1,x ,y1,x2,y1,iparm);
   adjust(x2,y1,x2,y ,x2,y2,iparm);
   adjust(x1,y2,x ,y2,x2,y2,iparm);
   adjust(x1,y1,x1,y ,x1,y2,iparm);

   if(buff[(y*TMODEX)+x] == 0)
   {
      v = (buff[(y1*TMODEX)+x1]+buff[(y1*TMODEX)+x2]+buff[(y2*TMODEX)+x2]+buff[(y2*TMODEX)+x1]+2) >>2;
      buff[(y*TMODEX)+x]=v;
      videotxt[((y*TMODEX)+x)*2]=v;
      getch();
   }
   else
        return;

   subDivide(x1,y1,x ,y ,iparm);
   subDivide(x ,y1,x2,y ,iparm);
   subDivide(x ,y ,x2,y2,iparm);
   subDivide(x1,y ,x ,y2,iparm);
}


void adjust(int xa,int ya,int x,int y,int xb,int yb, int iparm)
{
   int d;
   int v;
   int f,g;
   long pseudorandom;

//   if(buff[(y*TMODEX)+x] != 0)
//      return;

   if((f=xa-xb) < 0)
        f=(xa-xb)*-1;
   if((g=ya-yb) < 0)
        g=(ya-yb)*-1;
   d = f+g; // abs(xa-xb) + abs(ya-yb);

   pseudorandom = iparm;
   pseudorandom = pseudorandom*((random(16)>>3)-2048);
   pseudorandom = pseudorandom*d;
   d = pseudorandom >> 15;
   v = ((buff[(ya*TMODEX)+xa]+buff[(yb*TMODEX)+xb])>>1)+d;
   if(v<1)
      v = 1;
   if(v > 241)
      v = 241;
   buff[(y*TMODEX)+x]=v;
      videotxt[((y*TMODEX)+x)*2]=v;
//   videotxt[(y*TMODEX)+x]=v;
}
**********************************************/

