Program StarFieldCodedByLegend;

(*
 Glasses3D {True = On, False = Off}
 G3DConfig {1 = Red Lens On Left, Blue Lens On Right}
           {2 = Blue Lens On Left, Red Lens On Right}

 Just Something Extra I Threw In. If You Have 3D-Glasses You Can Use
 Them To View The Stars Dodging And Hurling At You. (Nifty Explanation)
                                       ____________________
     * <- OffSet  * <- Real          /                      \
     |    Star    |    Star        /|   Blue    /\    Red    |\
     Red          Blue           /  |   Lens   |  |   Lens   |  \
                               /     \________/    \________/     \

 The Red/Blue, Blue/Red Creates A 3D Effect When Your Eye Focus In On One
 Star, Kinda Like Crossing Your Eyes (Dont Try To Cross Them!, Your Eyes Do
 It Automatically). Isn't That Special?

*)

{$G+}

Uses
 Crt;

(***** P R O G R A M   V A R I A B L E S ***********************************)

Type
 GrCh = Array[1..8] Of Byte;

Const
 X1Bound = 0;
 X2Bound = 320;
 Y1Bound = 0;
 Y2Bound = 200;
 Z1Bound = 0;
 Z2Bound = 256;
 VGA = $A000;
 Alpha : Array[1..41] of GrCh =
 ((0,8,20,34,65,127,65,65), (0,63,65,65,63,65,65,63), (0,28,34,1,1,65,34,28),
 (0,63,97,65,65,65,97,63),  (0,127,1,1,31,1,1,127),   (0,127,1,1,31,1,1,1),
 (0,60,66,1,1,113,65,62),   (0,65,65,65,127,65,65,65),(0,127,8,8,8,8,8,127),
 (0,127,8,8,8,9,9,6),       (0,65,33,17,15,17,33,65), (0,1,1,1,1,1,65,127),
 (0,65,99,85,73,65,65,65),  (0,65,67,69,73,81,97,65), (0,28,34,65,65,65,34,28),
 (0,63,65,65,63,1,1,1),     (0,28,34,65,65,113,34,92),(0,63,65,65,63,9,17,33),
 (0,127,65,1,127,64,65,127),(0,127,8,8,8,8,8,8),      (0,65,65,65,65,65,65,62),
 (0,65,65,65,65,34,20,8),   (0,65,65,65,73,73,73,54), (0,65,34,20,8,20,34,65),
 (0,65,34,20,8,8,8,8),      (0,127,32,16,8,4,2,127),  (0,0,0,0,0,0,0,0),
 (0,62,97,81,73,69,67,62),  (0,8,12,10,8,8,8,127),    (0,62,65,32,16,8,4,127),
 (0,62,65,64,32,64,65,62),  (0,17,17,17,127,16,16,16),(0,127,1,1,63,64,64,63),
 (0,60,2,1,63,65,65,62),    (0,127,65,64,32,16,8,8),  (0,62,65,65,62,65,65,62),
 (0,62,65,65,126,64,32,28), (0,0,0,0,0,16,16,8),        (0,0,0,0,0,0,24,24),
 (0,67,35,16,8,4,98,97),    (0,0,0,0,127,0,0,0));

Type
 Vector = Record
  X, Y, Z: Integer;
 End;
 Vortex = Record
  X, Y: Integer;
 End;
 RGBType = Record
  R, G, B: Byte;
 End;
 VirtualP    = Array [1..64000] Of byte;
 RGB256      = Array[0..255,1..3] Of byte;
 DataPicLine = Array[0..319] Of Byte;
 PalType     = Array[0..255] Of RGBType;
 VirtPtr     = ^VirtualP;

Var
 Glasses3D: Boolean;
 MaxStars, Speed, A, X, Y, Z, TempVal: Integer;
 StarField: Array[1..6400] Of Vector;
 Plot: Array[1..6400] Of Vortex;
 G3DConfig: Byte;
 VirScr: VirtPtr;
 VAddr: Word;

(***** A S S E M B L Y   G R A P H I C S   R O U T I N E S *****************)

Procedure StartGraphics; Assembler;
Asm
 mov ax, 13h
 int 10h
End;

Procedure StartText; Assembler;
Asm
 mov  ax, 3h
 int  10h
End;

Procedure SetColor(Color, Red, Green, Blue: Byte); Assembler;
Asm
 mov dx, 3c8h
 mov al, [Color]
 out dx, al
 inc dx
 mov al, [Red]
 out dx, al
 mov al, [Green]
 out dx, al
 mov al, [Blue]
 out dx, al
End;

Procedure Cls(Color: Byte; Where: Word); Assembler;
Asm
 push es
 mov  cx, 32000
 mov  es, [Where]
 xor  di, di
 mov  al, [Color]
 mov  ah, al
 rep  stosw
 pop  es
End;

Procedure PutPixel(X, Y: Integer; Color : Byte; Where: Word);
Begin
 If (X > X1Bound) And (X < X2Bound) And (Y > Y1Bound) And (Y < Y2Bound) Then
  Asm
   push ds
   push es
   mov  ax, [Where]
   mov  es, ax
   mov  bx, [X]
   mov  dx, [Y]
   push bx
   mov  bx, dx
   mov  dh, dl
   xor  dl, dl
   shl  bx, 6
   add  dx, bx
   pop  bx
   add  bx, dx
   mov  di, bx
   xor  al, al
   mov  ah, [Color]
   mov  es: [di],ah
   pop  es
   pop  ds
  End;
End;

Procedure WaitRetrace; Assembler;
Label
 l1, l2;
Asm
 mov  dx, 3dah
l1:
 in   al, dx
 test al, 8
 jnz  l1
l2:
 in   al, dx
 test al, 8
 jz   l2
End;

Procedure SetUpVirtual;
Begin
 GetMem(VirScr, 64000);
 VAddr := Seg(VirScr^);
End;

Procedure ShutDown;
Begin
 FreeMem(VirScr, 64000);
End;

Procedure Flip(Source, Dest: Word); Assembler;
Asm
 push ds
 mov  ax, [Dest]
 mov  es, ax
 mov  ax, [Source]
 mov  ds, ax
 xor  si, si
 xor  di, di
 mov  cx, 32000
 rep  movsw
 pop  ds
end;

(***** P R O G R A M   F U N C T I O N S ***********************************)

Procedure InitParams;
Var
 I, Code: Integer;
Begin
 If ParamCount < 1 Then
 Begin
  Write('---');
  Write('  3D StarField  Coded By Legend (Blitz)  Adamantium Dream BBS  206-845-3570  ');
  WriteLn('---');
  WriteLn(' Usage: LDStars.Exe [Glasses] [GConfig] [MaxStars] [Speed]');
  WriteLn;
  WriteLn('        Glasses   1=True/0=False, Use 3D-Glasses Support');
  WriteLn('        GConfig   1 = Red Lens On Left, Blue Lens On Right');
  WriteLn('                  2 = Blue Lens On Left, Red Lens On Right');
  WriteLn('        MaxStars  Max Stars To Display (6400 Is The Limit)');
  WriteLn('        Speed     Increment Of Z Axis (Speed Of Stars)');
  WriteLn;
  WriteLn(' Xmple: LDStars.Exe 1 1 1600 1');
  WriteLn('        LDStars.Exe 0 0 3200 2');
  WriteLn;
  WriteLn(' Note!: Do Not Leave Out Any Of These Parameters!  Even If Glasses Is');
  WriteLn('        False, You Must Have "Something" For GConfig.  Don''t Go Too');
  WriteLn('        Big With The MaxStars.  And Don''t Go Too Fast With Speed');
  WriteLn('        Remember, The Source Is Included!  Don''t Rip! Learn!!');
  WriteLn;
  Write('---');
  Halt;
 End;
 If ParamStr(1) = '1' Then Glasses3D := True Else Glasses3D := False;
 Val(ParamStr(2), G3DConfig, Code);
 Val(ParamStr(3), MaxStars, Code);
 Val(ParamStr(4), Speed, Code);
End;

Procedure InitScreen;
Begin
 StartGraphics;
 SetUpVirtual;
 Cls(0, VAddr);
 Flip(VAddr, Vga);
 For TempVal := 1 To 64 Do
 Begin
  SetColor(TempVal, 0, 0, 0);
 End;
End;

Procedure CreateStars;
Var
 ZCount: Integer;
Begin
 For TempVal := 1 To MaxStars Do
 Begin
  Inc(ZCount, 1);
  If ZCount > 256 Then ZCount := 1;
  StarField[TempVal].X := Random(X2Bound) - (X2Bound Div 2) + X1Bound;
  StarField[TempVal].Y := Random(Y2Bound) - (Y2Bound Div 2) + Y1Bound;
  StarField[TempVal].Z := Random(Z2Bound Div 2);
 End;
End;

Procedure CalcStars;
Begin
 For TempVal := 1 To MaxStars Do
 Begin
  X := StarField[TempVal].X;
  Y := StarField[TempVal].Y;
  Z := 255 - StarField[TempVal].Z;
  If (Z <= 0) Then Z := 1;
  Plot[TempVal].X := ((X * Z2Bound) Div Z) + (X2Bound Div 2);
  Plot[TempVal].Y := ((Y * Z2Bound) Div Z) + (Y2Bound Div 2);
 End;
End;

Procedure ResetStar(Index: Integer);
Begin
 StarField[TempVal].X := Random(X2Bound) - (X2Bound Div 2) + X1Bound;
 StarField[TempVal].Y := Random(Y2Bound) - (Y2Bound Div 2) + Y1Bound;
 StarField[TempVal].Z := 1;
End;

Procedure iPixel(X1, Y1, Z1: Integer; DrawPixel: Boolean);
Begin
 If DrawPixel = True Then
 Begin
  If Glasses3D = True Then
  Begin
   PutPixel(X1 - (Z1 Div 16) - 1, Y1, (Z1 Div 8), VAddr);
   PutPixel(X1 + (Z1 Div 16) + 1, Y1, (Z1 Div 8) + 31, VAddr);
  End
  Else
  Begin
   PutPixel(X1, Y1, (Z1 Div 8), VAddr);
  End;
 End
 Else
 Begin
  If Glasses3D = True Then
  Begin
   PutPixel(X1 - (Z1 Div 16) - 1, Y1, 0, VAddr);
   PutPixel(X1 + (Z1 Div 16) + 1, Y1, 0, VAddr);
  End
  Else
  Begin
   PutPixel(X1, Y1, 0, VAddr);
  End;
 End;
End;

Procedure DrawStars;
Begin
 For TempVal := 1 To MaxStars Do
 Begin
  X := Plot[TempVal].X;
  Y := Plot[TempVal].Y;
  Z := StarField[TempVal].Z;
  If (X > X1Bound) And (X < X2Bound) And (Y > Y1Bound) And (Y < Y2Bound) Then
   If (Z < Z2Bound) Then iPixel(X, Y, Z, True) Else ResetStar(TempVal)
  Else
   ResetStar(TempVal);
 End;
End;

Procedure EraseStars;
Begin
 For TempVal := 1 To MaxStars Do
 Begin
  X := Plot[TempVal].X;
  Y := Plot[TempVal].Y;
  Z := StarField[TempVal].Z;
  If (X > X1Bound) And (X < X2Bound) And (Y > Y1Bound) And (Y < Y2Bound) Then
   If (Z < Z2Bound) Then iPixel(X, Y, Z, False) Else ResetStar(TempVal)
  Else
   ResetStar(TempVal);
 End;
End;

Procedure MoveStars;
Begin
 For TempVal := 1 To MaxStars Do
  Inc(StarField[TempVal].Z, Speed);
End;

Procedure DoneScreen;
Begin
 ShutDown;
 StartText;
 Write('---');
 Write('  3D StarField  Coded By Legend (Blitz)  Adamantium Dream BBS  206-845-3570  ');
 WriteLn('---');
 Halt;
End;

Procedure StarsLoop;
Begin
 CalcStars;
 DrawStars;
 Flip(VAddr, Vga);
 EraseStars;
 MoveStars;
End;

Function LongDiv(X: Longint; Y: Integer): Integer;
Inline($59/$58/$5A/$F7/$F9);

Function LongMul(X, Y: Integer): Longint;
Inline($5A/$58/$F7/$EA);

Procedure PhaseColors(A, B, C1, C2, C3, D1, D2, D3 : Integer);
Var
 I: integer;
 R1,G1,B1: longint;
 N, NAdd: integer;
Begin
 N := 1;
 NAdd := LongDiv(256, B - A);
 For I := A To B Do Begin
  If Glasses3D = False Then
  Begin
   StarsLoop;
   StarsLoop;
  End;
  R1 := (LongDiv(LongMul(D1 - C1, N), 256)) + C1;
  G1 := (LongDiv(LongMul(D2 - C2, N), 256)) + C2;
  B1 := (LongDiv(LongMul(D3 - C3, N), 256)) + C3;
  SetColor(255 - I, R1, G1, B1);
  SetColor(I, R1, G1, B1);
  Inc(N, NAdd);
 End;
End;

(***** M A I N   P R O G R A M   L O O P ***********************************)

Var
 Ch: Char;
Begin
 InitParams;
 InitScreen;
 CreateStars;
 If Glasses3D = True Then
 Begin
  If G3DConfig = 1 Then
  Begin
   PhaseColors(  0, 32,  0,  0,  0,  0,  0, 63);
   PhaseColors( 31, 65,  0,  0,  0, 63,  0,  0);
  End
  Else
  Begin
   PhaseColors(  0, 32,  0,  0,  0, 63,  0,  0);
   PhaseColors( 31, 65,  0,  0,  0,  0,  0, 63);
  End;
 End
 Else
 Begin
  PhaseColors(  0, 36,  0,  0,  0,  0, 63, 32);
 End;
 Repeat
  StarsLoop;
 Until KeyPressed;
 DoneScreen;
End.