{$IFDEF VER70}{$A+}{$D-}{$E-}{$R-}{$S-}{$I-}{$N-}{$Q-}{$X+}{$Y-}{$ENDIF}
{$IFDEF VER60}{$A+}{$D-}{$E-}{$R-}{$S-}{$I-}{$N-}{$X+}{$ENDIF}

{
  Name Of Unit    : Sprited Support Library (SPRLIB.PAS)                   
  Version Number  : 0.6 (14/12/96)                                         
  Compiler Needed : Turbo Pascal 6.0 or 7.0                                
  Description     : Low-Level Routines used by Sprited (In ASM)            
  Author          : Karma                                                  
 }

UNIT SPRLIB;

INTERFACE

CONST HexStr   : ARRAY[0..15] Of Char = '0123456789ABCDEF';
                                               (* Used by Convert2Hex *)
TYPE  VGAType = ARRAY[0..63999] Of Byte;
      VGAPtr = ^VGAType; (* Screen Buffer, used to point to $A000:0000 *)

VAR   YTable  : ARRAY[0..199] Of Word;  (* Y Table for Putpixel etc *)
      VGASeg  : VGAPtr;
      MouseX,
      MouseY,                           (* Values read from mouse *)
      Button  : Word;
      Width   : Word;
      MouseFnd: Boolean;

(* VGA Routines *)
PROCEDURE SetMode(Mode : Byte);
PROCEDURE PutPixel(X, Y : Integer; Colour : Byte);
FUNCTION GetPixel(X, Y : Integer) : Byte;
PROCEDURE WaitForRetrace;
PROCEDURE FilledBox(X1, Y1, X2, Y2 : Integer; Colour : Byte);
PROCEDURE SetPalette(Colour, Red, Green, Blue : Byte);
PROCEDURE GetPalette(Colour : Byte; VAR R, G, B : Byte);
PROCEDURE CalcScreenY(Width : Word);
(* CRT Replacement Routines *)
PROCEDURE GotoXY(X, Y : Word);
PROCEDURE MyWrite(Txt : String; Colour : Byte);
FUNCTION Convert2Hex(Num : Word) : String;(* Not in CRT, it had to go somewhere *)
(* Mouse Routines *)
PROCEDURE TurnMouseOn;
PROCEDURE ShowMouse;
PROCEDURE HideMouse;
PROCEDURE MouseStatus;

IMPLEMENTATION

{
 VGA Routines
 }

PROCEDURE SetMode(Mode : Byte); ASSEMBLER;
ASM
   MOV   AH, 00H
   MOV   AL, Mode
   INT   10H
END;

PROCEDURE PutPixel(X, Y : Integer; Colour : Byte); ASSEMBLER;
ASM
  LES DI, VGASeg
  ADD DI, X
  MOV BX, Y
  ADD BX, BX
  ADD DI, DS:[BX + OFFSET YTable]
  MOV AL, Colour
  MOV ES:[DI], AL
END;

FUNCTION GetPixel(X, Y : Integer) : Byte; ASSEMBLER;
ASM
  LES DI, VGASeg
  ADD DI, X
  MOV BX, Y
  ADD BX, BX
  ADD DI, DS:[BX + OFFSET YTable]
  MOV AL, ES:[DI]
END;

PROCEDURE WaitForRetrace; ASSEMBLER;
ASM
    MOV  DX, 3DAH
@1:
    IN   AL, DX
    TEST AL, 8
    JNZ  @1
@2:
    IN  AL, DX
    TEST AL, 8
    JZ  @2
END;

PROCEDURE FilledBox(X1, Y1, X2, Y2 : Integer; Colour : Byte); ASSEMBLER;
ASM
  MOV DI, X1
  CMP DI, X2
  JBE @DontSwapXVals
  XCHG DI, X2
  MOV X1, DI
 @DontSwapXVals:
  MOV AX, Y1
  CMP AX, Y2
  JBE @DontSwapYVals
  XCHG AX, Y2
  MOV Y1, AX
 @DontSwapYVals:
  MUL Width
  ADD DI, AX
  MOV CX, X2
  SUB CX, X1
  INC CX
  MOV SI, CX
  MOV BX, Width
  SUB BX, CX
  MOV DX, Y2
  SUB DX, Y1
  INC DX
  LES AX, VGASeg
  ADD DI, AX
  MOV AL, Colour
 @YLoop:
  REP STOSB
  ADD DI, BX
  MOV CX, SI
  DEC DX
  JNZ @YLoop
END;

PROCEDURE SetPalette(Colour, Red, Green, Blue : Byte); ASSEMBLER;
ASM
    MOV  DX, 3C8H
    MOV  AL, [Colour]
    OUT  DX, AL
    INC  DX
    MOV  AL, [Red]
    OUT  DX, AL
    MOV  AL, [Green]
    OUT  DX, AL
    MOV  AL, [Blue]
    OUT  DX, AL
END;

PROCEDURE GetPalette(Colour : Byte; VAR R, G, B : Byte);
VAR Red, Green, Blue : Byte;
BEGIN
   ASM
      CALL   WaitforRetrace;
      MOV    DX, 3C7H
      MOV    AL, [Colour]
      OUT    DX, AL
      ADD    DX, 2
      IN     AL, DX
      MOV    [Red], AL
      IN     AL, DX
      MOV    [Green], AL
      IN     AL, DX
      MOV    [Blue], AL
   END;
  R := Red;
  G := Green;
  B := Blue;
END;

PROCEDURE CalcScreenY(Width : Word);
(* Pre-calculates Screen-Y values, makes Putpixel even faster! *)
VAR I : INTEGER;
BEGIN
  For I := 0 To 199 Do
    YTable[I] := I * Width;
END;

{
 CRT Replacement Routines
 }

PROCEDURE GotoXY(X, Y : Word); ASSEMBLER;
ASM
    MOV    AX, Y
    MOV    DH, AL
    DEC    DH
    MOV    AX, X
    MOV    DL, AL
    DEC    DL
    MOV    AH, 2
    XOR    BH, BH
    INT    10H
END;

PROCEDURE MyWrite(Txt : String; Colour : Byte); ASSEMBLER;
(* No need for DIRECTVIDEO:=FALSE, also outputs in colour! *)
ASM
  LES  DI, Txt
  MOV  CL, ES:[DI]
  INC  DI
  XOR  CH, CH
  MOV  BL, Colour
  JCXZ @Outofhere (* String Empty? outofhere! *)
 @Output:
  MOV  AH, 0Eh
  MOV  AL, ES:[DI]
  INT  10h (* Print string *)
  INC  DI
  LOOP @Output
 @Outofhere:
END;

FUNCTION Convert2Hex(Num : Word) : String;
(* Convert a integer to hex, but returns it as a string. *)
VAR  Loop  : Byte;
     S     : String[2];
BEGIN
   For Loop := 1 To 2 Do
   BEGIN
      S := HexStr[Lo(Num) AND $F] + S;
      Num := Num SHR 4;
   END;
   If S[1] = '0' Then Convert2Hex := '$' + S[2] Else
    Convert2Hex := '$' + S;
END;

{
 Mouse Routines
 }

PROCEDURE TurnMouseOn; ASSEMBLER;
(* I used Ralf Browns Interrupt list as a reference for these routines *)
ASM
     MOV  AX, 0
     INT  33H
     CMP  AX, - 1 (* If AX=FFFFH Then mouse found *)
     JNE  @NoMouse
     MOV  MouseFnd, TRUE
     @NoMouse:
END;

PROCEDURE ShowMouse; ASSEMBLER;
ASM
     MOV  AX, 1
     INT  33H
END;

PROCEDURE HideMouse; ASSEMBLER;
ASM
     MOV  AX, 2
     INT  33H
END;

PROCEDURE MouseStatus; ASSEMBLER;
(* CX returns a value between 0..639, so we divide it by 2 *)
(* MouseX then holds a value between 0..319 (the screen width) *)
ASM
     MOV  AX, 3
     INT  33H
     SHR  CX, 1
     MOV  MouseX, CX
     MOV  MouseY, DX (* 0..199 *)
     MOV  Button, BX
    (* BX=1 Left pressed, BX=2 Right pressed, BX=3 Left & Right pressed *)
    (* BX=4 Middle pressed. *)
END;

END.