#define SET 1
#define NORMAL 1
#define MASK 2
#define ERASE 3

#ifndef byte
 #define byte unsigned char
 #define word unsigned int
 #define d_word unsigned long
#endif

#define FILL _GFILLINTERIOR
#define BORDER _GBORDER

#ifndef byte
 #define byte unsigned char
#endif

#ifndef word
 #define word unsigned int
#endif

#define CLIP 0
#define OUT_CLIP 1
#define NO_CLIP 2

#define INVERSE 0

#define FONTS 128
#define FONT_SIZE 8

#define SCREEN (byte huge *)0xA0000000

byte huge *screen;

word cos_table[256], sin_table[256], cos_table2[256], sin_table2[256];

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void screen_set(word value, int c, size_t count)
{
 if (value>63999) return;
 memset(screen+value,c,count);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void put_image(int x, int y, byte huge *image,
	      word width, word height, word option)
{
 word value=(word)(y*320+x),
      tileseg=FP_SEG(image),
      tileoff=FP_OFF(image),
      scrnseg=FP_SEG(screen),
      scrnoff=FP_OFF(screen);

 if (option==NORMAL)
 {
  _asm
  {
   push    ds

   mov     ax,[tileseg]
   mov     ds,ax
   mov     si,[tileoff]

   mov     ax,[scrnseg]
   mov     es,ax
   mov     di,[scrnoff]
   add     di,[value]

   mov     cx,[height]

   mov     bx,[x]
   mov     dx,[y]

   start:
   cmp     dx,199
   jg      end

   push    cx

   cmp     dx,0
   jl      start_end

   mov     cx,[width]

   mid:
   cmp     bx,319
   jg      mid_end
   cmp     bx,0
   jl      mid_end

   mov     al,[si]
   mov     es:[di],al

   mid_end:
   inc     bx
   inc     di
   inc     si
   loop    mid

   sub     di,[width]

   start_end:
   add     di,320
   inc     dx
   mov     bx,[x]
   pop     cx

   loop    start

   end:
   pop     ds
  }
 }
 else if (option==MASK)
 {
  _asm
  {
   push   ds

   mov    ax,[tileseg]
   mov    ds,ax
   mov    si,[tileoff]

   mov    ax,[scrnseg]
   mov    es,ax
   mov    di,[scrnoff]
   add    di,[value]

   mov    bx,[x]
   mov    dx,[y]

   mov    cx,[height]

   star2:
   cmp    dx,199
   jg     mid6

   push   cx

   cmp    dx,0
   jl     mid4

   mov    cx,[width]

   mid2:
   cmp    bx,319
   jg     mid3
   cmp    bx,0
   jl     mid3

   mov    al,ds:[si]
   cmp    al,0
   je     mid3
   mov    es:[di],al

   mid3:
   inc    di
   inc    si
   inc    bx

   loop   mid2

   sub    di,[width]

   mid4:
   add    di,320
   inc    dx
   mov    bx,[x]

   pop    cx

   loop   star2

   mid6:
   pop ds
  }
 }
 else if (option==INVERSE)
 {
  _asm
  {
   push   ds

   mov    ax,[tileseg]
   mov    ds,ax
   mov    si,[tileoff]

   mov    ax,[scrnseg]
   mov    es,ax
   mov    di,[scrnoff]
   add    di,[value]

   mov    bx,[x]
   mov    dx,[y]

   mov    cx,[height]

   inv_star2:
   cmp    dx,199
   jg     inv_mid6

   push   cx

   cmp    dx,0
   jl     inv_mid4

   mov    cx,[width]

   inv_mid2:
   cmp    bx,319
   jg     inv_mid3
   cmp    bx,0
   jl     inv_mid3

   mov    al,ds:[si]
   mov    ah,al
   shr    ah,1
   shr    ah,1
   shr    ah,1
   shl    ah,1
   shl    ah,1
   shl    ah,1
   add    ah,7
   sub    ah,al
   mov    al,ah
   mov    es:[di],al

   inv_mid3:
   inc    di
   inc    si
   inc    bx

   loop   inv_mid2

   sub    di,[width]

   inv_mid4:
   add    di,320
   inc    dx
   mov    bx,[x]

   pop    cx

   loop   inv_star2

   inv_mid6:
   pop ds
  }
 }
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void get_image(int x, int y, byte huge *image, word width, word height)
{
 word value=(word)(y*320+x),
      tileseg=FP_SEG(image),
      tileoff=FP_OFF(image),
      scrnseg=FP_SEG(screen),
      scrnoff=FP_OFF(screen);

 _asm
  {
   push    ds

   mov     ax,[tileseg]
   mov     ds,ax
   mov     si,[tileoff]

   mov     ax,[scrnseg]
   mov     es,ax
   mov     di,[scrnoff]
   add     di,[value]

   mov     cx,[height]

   mov     bx,[x]
   mov     dx,[y]

   start:
   cmp     dx,199
   jg      end

   push    cx

   cmp     dx,0
   jl      start_end

   mov     cx,[width]

   mid:
   cmp     bx,319
   jg      mid_end
   cmp     bx,0
   jl      mid_end

   mov     al,es:[di]
   mov     [si],al

   mid_end:
   inc     bx
   inc     di
   inc     si
   loop    mid

   sub     di,[width]

   start_end:
   add     di,320
   inc     dx
   mov     bx,[x]
   pop     cx

   loop    start

   end:
   pop     ds
  }
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void put_rotated(int scrn_x, int scrn_y, byte huge *image, byte option,
		 byte angle,
		 word x_left, word y_top, word x_right, word y_bottom)
{
 word right_x=(word)(cos_table[angle]);
 word right_y=(word)(sin_table[angle]);
 word down_x=(word)(cos_table2[angle]);
 word down_y=(word)(sin_table2[angle]);

 word x=(8<<8)-(right_x<<3)-(down_x<<3);
 word y=(8<<8)+(right_y<<3)+(down_y<<3);
 word ox=x, oy=y;

 word scrn_seg=FP_SEG(screen);
 word scrn_off=(scrn_y<<8)+(scrn_y<<6)+scrn_x;

 word image_seg=FP_SEG(image);
 word image_off=FP_OFF(image);

 word x_clip=scrn_x;
 word old_x_clip=x_clip;
 word y_clip=scrn_y;

 if (option==CLIP)
 {
  _asm
  {
   push  ds

   mov   ax,[image_seg]
   mov   ds,ax

   mov   ax,[scrn_seg]
   mov   es,ax
   mov   di,[scrn_off]

   mov   ax,[x]
   mov   dx,[y]

   mov   cx,16

   start:
   mov   bx,[y_clip]
   cmp   bx,[y_bottom]
   jl    start_mid
   jmp   end

   start_mid:
   push  cx

   cmp   bx,[y_top]
   jle   startend

   mov   cx,16

   mid:
   cmp   ah,0
   jl    midend
   cmp   ah,15
   jg    midend
   cmp   dh,0
   jl    midend
   cmp   dh,15
   jg    midend

   mov   bx,[x_clip]
   cmp   bx,[x_left]
   jle   midend
   cmp   bx,[x_right]
   jge   midend

   mov   si,[image_off]
   mov   bl,dh
   shl   bl,1
   shl   bl,1
   shl   bl,1
   shl   bl,1
   add   bl,ah
   and   bh,0x00
   add   si,bx

   mov   bl,[si]
   dec   bl
   dec   bl
   jz    nodraw
   inc   bl
   inc   bl

   mov   es:[di],bl

   midend:
   nodraw:

   add   ax,[right_x]
   sub   dx,[right_y]
   inc   di
   inc   [x_clip]

   loop mid

   sub   di,16

   startend:
   add   di,320
   inc   [y_clip]
   mov   ax,[old_x_clip]
   mov   [x_clip],ax

   mov   ax,[ox]
   mov   dx,[oy]
   add   ax,[down_x]
   sub   dx,[down_y]
   mov   [ox],ax
   mov   [oy],dx

   pop   cx

   dec   cx
   jz    end
   jmp   start

   end:
   pop   ds
  }
 }
 else if (option==OUT_CLIP)
 {
  _asm
  {
   push  ds

   mov   ax,[image_seg]
   mov   ds,ax

   mov   ax,[scrn_seg]
   mov   es,ax
   mov   di,[scrn_off]

   mov   ax,[x]
   mov   dx,[y]

   mov   cx,16

   start2:
   push  cx

   mov   cx,16

   mid2:
   cmp   ah,0
   jl    midend2
   cmp   ah,15
   jg    midend2
   cmp   dh,0
   jl    midend2
   cmp   dh,15
   jg    midend2

   mov   bx,[y_clip]
   cmp   bx,[y_top]
   jl    mid3
   cmp   bx,[y_bottom]
   jg    mid3

   mov   bx,[x_clip]
   cmp   bx,[x_left]
   jl    mid3
   cmp   bx,[x_right]
   jle    midend2

   mid3:
   mov   si,[image_off]
   mov   bl,dh
   shl   bl,1
   shl   bl,1
   shl   bl,1
   shl   bl,1
   add   bl,ah
   and   bh,0x00
   add   si,bx

   mov   bl,[si]
   dec   bl
   dec   bl
   jz    midend2
   inc   bl
   inc   bl
   mov   es:[di],bl

   midend2:
   sub   ax,[right_x]
   add   dx,[right_y]
   inc   di
   inc   [x_clip]

   loop mid2

   sub   di,16

   startend2:
   add   di,320
   inc   [y_clip]
   mov   ax,[old_x_clip]
   mov   [x_clip],ax

   mov   ax,[ox]
   mov   dx,[oy]
   sub   ax,[down_x]
   add   dx,[down_y]
   mov   [ox],ax
   mov   [oy],dx

   pop   cx

   dec   cx
   jz    end2
   jmp   start2

   end2:
   pop   ds
  }
 }
 else if (option==NO_CLIP)
 {
  _asm
  {
   push ds

   mov  ax,[image_seg]
   mov  ds,ax

   mov  ax,[scrn_seg]
   mov  es,ax
   mov  di,[scrn_off]

   mov  ax,[x]
   mov  dx,[y]

   mov  cx,16

   start_no_clip:
   push  cx

   mov   cx,16

   mid_no_clip1:
   cmp   ah,0
   jl    midend_no_clip
   cmp   ah,15
   jg    midend_no_clip
   cmp   dh,0
   jl    midend_no_clip
   cmp   dh,15
   jg    midend_no_clip

   mov   si,[image_off]
   mov   bl,dh
   shl   bl,1
   shl   bl,1
   shl   bl,1
   shl   bl,1
   add   bl,ah
   and   bh,0x00
   add   si,bx

   mov   bl,[si]
   dec   bl
   dec   bl
   jz    midend_no_clip
   inc   bl
   inc   bl
   mov   es:[di],bl

   midend_no_clip:
   sub   ax,[right_x]
   add   dx,[right_y]
   inc   di

   loop mid_no_clip1

   add   di,304

   mov   ax,[ox]
   mov   dx,[oy]
   sub   ax,[down_x]
   add   dx,[down_y]
   mov   [ox],ax
   mov   [oy],dx

   pop   cx

   dec   cx
   jz    end_no_clip
   jmp   start_no_clip

   end_no_clip:
   pop  ds
  }
 }
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void put_compressed(int x, int y, byte huge *image)
{
 word scrn_seg=FP_SEG(screen),
      scrn_off=FP_OFF(screen)+(y<<8)+(y<<6)+x,
      image_seg=FP_SEG(image),
      image_off=FP_OFF(image);

 _asm
 {
  push  ds

  mov   ax,[image_seg]
  mov   ds,ax
  mov   si,[image_off]

  mov   ax,[scrn_seg]
  mov   es,ax
  mov   di,[scrn_off]

  start:
  mov   cx,[si]
  cmp   cl,0
  je    end

  mov   bl,ch
  and   ch,0x00

  draw:
  mov   es:[di],bl
  inc   di
  dec   bh
  jz    update
  loop  draw
  inc   si
  inc   si
  jmp   start

  update:
  add   di,304
  mov   bh,16
  loop  draw
  inc   si
  inc   si
  jmp   start

  end:
  pop   ds
 }
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void box(byte option, int x1, int y1, int x2, int y2, byte color)
{
 int a, b;
 word width=x2-x1+1, height=y2-y1+1;

 if (option==BORDER)
 {
  screen_set(y1*320+x1,color,width);
  for (a=y1+1;a<y2;a++)
  {
   screen_set(a*320+x1,color,1);
   screen_set(a*320+x2,color,1);
  }
  screen_set(y2*320+x1,color,width);
 }
 else if (option==FILL)
 {
  a=y1;
  do
  {
   screen_set(a*320+x1,color,width);
  } while (a++<=y2);
 }
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

byte allocate_screen(void)
{
 screen=(byte huge *)halloc((long)64000,1);
 if (screen==NULL)
 {
  printf("error allocating screen buffer\n");
  return(FAILURE);
 }
 return(SUCCESS);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void free_screen(void)
{
 if (screen!=NULL) hfree(screen);
}


/****************************************************************************/
/****************************************************************************/
/****************************************************************************/
