#ifndef  _LSP_TABLE
#define  _LSP_TABLE

#define  MAX 64


#define  swap(A,B) {A^=B; B^=A; A^=B; }


typedef  struct {
    int length;
    unsigned char *address;
}   LSP;


LSP      *node[200],*temp;


void     AddLSPMark(int x,int y,int length,unsigned char *address)
{
    int  loop;
    LSP  *source,*target;

    if( (unsigned)y>=(unsigned)200 || \
        x+length<0 || x>=320 || length<=0 ) return ;

    if( x<0 ) {
        address-=x;
        length+=x;
        x=0;
    }

    if( x+length >= 320 ) {
        length=320-x;
    }

    source=node[y];
    target=temp;

    for(loop=0;loop<x;target++,source++) {
        loop+=source->length;
        memcpy(target,source,sizeof(LSP));
    }

    target--;
    target->length-=loop-x;
    target++;

    target->length=length;
    target->address=address;
    target++;

    for(;loop<=x+length;source++) loop+=source->length;
    source--;

    target->length=loop-(x+length);
    target->address=source->address+(x+length)-(loop-source->length);
    target++;
    source++;

    for(;loop<320;target++,source++) {
        loop+=source->length;
        memcpy(target,source,sizeof(LSP));
    }

    swap((long)node[y],(long)temp);
}


void     SetNode(void)
{
    int  loop;

    for(loop=0;loop<200;loop++) node[loop]=malloc(sizeof(LSP)*MAX);
    temp=malloc(sizeof(LSP)*MAX);
}


#endif


// IDEA : neolith
// CODE : NOERROR / GARGOYLE