model large
.386

.stack

.data
include chaos.inc
include palette.inc
include font.inc
include text.inc
FRAME     = 600                 ; Time between two interrupts is 97.5%
				; of total frame time - the interrupt comes
				; somewhat _before_ the Vertical Retrace
				; actually starts.
OldTmr       dd ?
TmrVal       dw ?               ; count to the timer chip
DOSTmrCnt    dw ?               ; counter used in calling the old timer
textcount    dw 0
loopcount    db 0
dirflag      db 0
dirfl        db,0
start        dw 0b040h
startchar    dw 0b030h
scrollval    db 1
scrolldel    db 4
logost       dw 7226 
logoct       db 1
raster       db 00,00,01,02,06,10,13,15
	     db 18,20,22,24,26,28,30,32
	     db 34,36,38,40,41,42,43,45
	     db 47,48,49,50,51,52,53,54 
	     db 54,53,52,51,50,49,48,47
	     db 45,43,42,41,40,38,36,34
	     db 32,30,28,26,24,22,20,18
	     db 15,13,10,06,02,01,00,00
watertable   db 54h,54h,54h,54h
	     db 55h,55h,55h,55h,55h
	     db 56h,56h,56h,56h,56h,56h,56h,56h,56h,56h
	     db 55h,55h,55h,55h,55h
	     db 54h,54h,54h,54h,54h,54h,54h,54h
	     db 55h,55h,55h,55h,55h,55h
	     db 56h,56h,56h,56h,56h,56h,56h,56h,56h,56h
	     db 55h,55h,55h,55h,55h,55h
	     db 54h,54h,54h,54h
	     db 54h,54h,54h,54h
	     db 55h,55h,55h,55h,55h
	     db 56h,56h,56h,56h,56h,56h,56h,56h,56h,56h
	     db 55h,55h,55h,55h,55h
	     db 54h,54h,54h,54h,54h,54h,54h,54h
	     db 55h,55h,55h,55h,55h,55h
	     db 56h,56h,56h,56h,56h,56h,56h,56h,56h,56h
	     db 55h,55h,55h,55h,55h,55h
	     db 54h,54h,54h,54h
	     db 54h,54h,54h,54h
	     db 55h,55h,55h,55h,55h
	     db 56h,56h,56h,56h,56h,56h,56h,56h,56h,56h
	     db 55h,55h,55h,55h,55h
	     db 54h,54h,54h,54h,54h,54h,54h,54h
	     db 55h,55h,55h,55h,55h,55h
	     db 56h,56h,56h,56h,56h,56h,56h,56h,56h,56h
	     db 55h,55h,55h,55h,55h,55h
	     db 54h,54h,54h,54h
watercnt     dw 0
waterctr     db 0
.code main
.startup
	cli
	in   al,21h
	push ax
	mov  al,11111110b
	out  21h,al
	
	in   al,0a1h
	push ax
	mov  al,11111111b
	out  0a1h,al
	sti
	
	mov  ax,13h
	int  10h

	mov  dx,03ceh      ;turns off odd/even
	mov  al,5
	out  dx,al
	inc  dx
	in   al,dx
	and  al,11101111b
	out  dx,al
	dec  dx

	mov  al,6
	out  dx,al
	inc  dx
	in   al,dx
	and  al,11111101b
	out  dx,al
 
	mov  dx,03c4h      ;disables chain 4.
	mov  al,4
	out  dx,al
	inc  dx
	in   al,dx
	and  al,11110111b
	or   al,4
	out  dx,al


	mov  ax,0a000h     ;clear screen
	sub  di,di
	mov  es,ax
	mov  cx,0ffffh
	mov  ax,di
	rep  stosw

	
	mov  dx,03d4h      
	mov  al,14h        ;enables dword addressing
	out  dx,al
	inc  dx
	in   al,dx
	and  al,10111111b
	out  dx,al
	dec  dx
 
	mov  al,17h        ;enables byte addressing
	out  dx,al
	inc  dx
	in   al,dx
	or   al,01000000b
	out  dx,al

	mov  dx,03d4h      ;split screen line 128
	mov  al,18h
	out  dx,al
	inc  dx
	mov  al,128
	out  dx,al

	dec  dx
	mov  al,07
	out  dx,al
	inc  dx
	in   al,dx
	and  al,11101111b
	out  dx,al
	dec  dx

	mov  al,09
	out  dx,al
	inc  dx
	in   al,dx
	and  al,10111111b
	out  dx,al

	dec  dx            ;set start address of top
	mov  al,0ch
	out  dx,al
	inc  dx
	mov  al,0c9h
	out  dx,al
	dec  dx
	mov  al,0dh
	out  dx,al
	inc  dx
	mov  al,040h
	out  dx,al

	mov  dx,03d4h   ;Unprotect first 8 regs of 03d4h
	mov  al,11h
	out  dx,al
	inc  dx
	in   al,dx
	and  al,127
	out  dx,al

	mov  dx,03d4h
	mov  al,13h
	out  dx,al
	inc  dl
	mov  al,160
	out  dx,al
	
	mov     ax,musicseg            ; adr. AdLib Player
	mov     cs:Player[2],ax
	mov     ah,6
	call    PlayM
	jnc     NO_CARD_PRESENT
	mov     BYTE PTR cs:[PlayM],0C3h ; RET
NO_CARD_PRESENT:
	mov     ah,0                ; init music
	mov     bx,musicseg
	mov     cx,2390
	call    PlayM
	mov     ah,2
	mov     bx,0
	call    PlayM
	
	call zeropal
	call InitVRServer
	call putpal
keywait:mov  dx,60h
	in   al,dx
	cmp  al,1
	jne  keywait
ending:
	call RemoveVRServer 
	 
	 mov     ah,2
	 mov     bx,0
	 call    PlayM              ; Stop Music

	
	pop  ax
	out  0a1h,al
	
	pop  ax
	out  21h,al
	
	mov  ax,0003h
	int  10h

.exit
	
VR:     cli
        mov  cx,160
       
clear:  mov  dx,03c8h
	mov  al,0
	out  dx,al
	inc  dl
	out  dx,al
	out  dx,al

	mov  dl,0c6h
	mov  al,255
	out  dx,al

horiza :in   al,dx
	test al,1
	jz   horiza 
	
	mov  dl,0c9h
	sub  al,al
	out  dx,al

horizb :in   al,dx
	test al,1
	jnz  horizb 
	mov  dl,0dah
horizc :in   al,dx
	test al,1
	jz   horizc

loop    clear
	
	mov  cx,64
gradlp: mov  dl,0c8h
	mov  al,1
	out  dx,al
	inc  dl
	sub  al,al
	out  dx,al
	out  dx,al

	mov  dl,0dah
horiz1a:in   al,dx
	test al,1
	jz   horiz1a
	mov  dl,0c9h
	mov  bx,64
	sub  bx,cx
	mov  al,byte ptr raster[bx]
	out  dx,al
	
	mov  dl,0dah
horiz1b:in   al,dx
	test al,1
	jnz  horiz1b
horiz1c:in   al,dx
	test al,1
	jz   horiz1c
	
loop    gradlp
	
	mov  dl,0c8h
	mov  al,0
	out  dx,al
	inc  dl
	out  dx,al
	out  dx,al

	mov  dl,0dah
horiz2a:in   al,dx
	test al,1
	jz   horiz2a
	mov  dl,0c9h
	sub  al,al
	out  dx,al
	mov  dl,0dah
horiz2b:in   al,dx
	test al,1
	jnz  horiz2b
horiz2c:in   al,dx
	test al,1
	jz   horiz2c
	
	cmp  dirfl,0
	jne  up2
	add  logost,160
	cmp  logost,21626
	jne  stilld2
	mov  dirfl,1
stilld2:jmp  setst2
up2:    
	sub  logost,160
	cmp  logost,7226   
	jne  setst2  
	mov  dirfl,0

setst2: call putpic
	
	cmp  dirflag,0
	jne  up
	sub  start,320
	cmp  start,35840
	jg   stilldn
	mov  dirflag,1
stilldn:jmp  setst
up:     add  start,320
	cmp  start,45120
	jl   setst  
	mov  dirflag,0

setst:  call txt 
	
	sti
endlp:  ret

PreVR: 
	cli
	mov  dl,0c6h
	mov  al,127
	out  dx,al

	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,6 
	out  dx,al
	mov  al,0
	out  dx,al

	mov  dl,0dah
horiz3a:in   al,dx
	test al,1
	jz   horiz3a
	
	mov  dl,0c9h
	mov  al,16
	out  dx,al
	
	mov  dl,0dah
horiz3b:in   al,dx
	test al,1
	jnz  horiz3b
horiz3c:in   al,dx
	test al,1
	jz   horiz3c
	
	inc  waterctr
	cmp  waterctr,3
	jne  noreset
	mov  waterctr,0
	inc  watercnt
	cmp  watercnt,28
	jne  noreset
	mov  watercnt,0
	
noreset:mov  cx,43*2

water:  mov  dl,0dah
horiz4a:in   al,dx
	test al,1
	jz   horiz4a
	
	mov  dl,0d4h
	mov  al,4
	out  dx,al
	inc  dl
	mov  bx,cx
	add  bx,watercnt
	mov  al,watertable[bx]
	out  dx,al
	
	mov  dl,0dah
horiz4b:in   al,dx
	test al,1
	jnz  horiz4b
horiz4c:in   al,dx
	test al,1
	jz   horiz4c
	mov  dl,0dah
loop    water
	
	mov  dl,0dah
horiz5a:in   al,dx
	test al,1
	jz   horiz5a
	
	mov  dl,0d4h
	mov  al,4
	out  dx,al
	inc  dl
	mov  al,54h
	out  dx,al
	
	mov  dl,0dah
horiz5b:in   al,dx
	test al,1
	jnz  horiz5b
horiz5c:in   al,dx
	test al,1
	jz   horiz5c
	
	sti
	ret

txt:    
	mov  dl,0d4h
	mov  al,0ch
	out  dx,al
	inc  dl
	mov  al,byte ptr start+1
	out  dx,al
	dec  dl
	mov  al,0dh
	out  dx,al
	inc  dl
	mov  al,byte ptr start
	out  dx,al
	
	
nochar: add  start,1
	cmp  startchar,45264
	jne  justsc
	sub  start,160
	sub  startchar,160
justsc: dec  scrollval
	cmp  scrollval,0
	je   txtloop
just:   ret
txtloop:
	push es
	mov  ax,0a000h
	mov  es,ax
	mov  scrollval,4
	add  startchar,4
	mov  di,startchar
	push di 
txtlp:  mov  bx,textcount
	inc  textcount
	mov  al,text[bx]
	test al,al
	jne  char
	mov  textcount,0
	jmp  txtlp
char:   
	mov  si,offset font
	sub  al,32
	sub  ah,ah
	mov  cx,16*35
	mul  cx
	add  si,ax
	
	mov  dx,03c4h
	mov  ax,0102h
	out  dx,ax
	pop  di
	push di
	mov  cx,35
txtlp1: lodsd
	mov  [es:di],eax
	mov  [es:di+160],eax
	add  di,320
	loop txtlp1
	
	mov  ax,0202h
	out  dx,ax
	pop  di
	push di
	mov  cx,35
txtlp2: lodsd
	mov  [es:di],eax
	mov  [es:di+160],eax
	add  di,320
	loop txtlp2
	
	mov  ax,0402h
	out  dx,ax
	pop  di
	push di
	mov  cx,35
txtlp3: lodsd
	mov  [es:di],eax
	mov  [es:di+160],eax
	add  di,320
	loop txtlp3
	
	mov  ax,0802h
	out  dx,ax
	pop  di
	add  di,4
	push di
	sub  di,4
	mov  cx,35
txtlp4: lodsd    
	mov  [es:di],eax
	mov  [es:di+160],eax
	add  di,320
	loop txtlp4
	pop  di
	pop  es
	ret

putpal: mov  si,offset palette
	mov  dx,03c8h
	mov  al,0
	out  dx,al
	inc  dx
	mov  cx,768
palloop:outsb
	loop palloop
	ret

zeropal:
	mov  dx,03c8h
	mov  al,0
	out  dx,al
	inc  dx
	mov  cx,768
	mov  al,0
rep     out  dx,al
	ret

putpic: 
	push ds
	mov  ax,0a000h      
	mov  es,ax
	mov  ax,seg PICTURE
	mov  ds,ax
	mov  si,offset PICTURE
	mov  di,logost
	mov  bx,29
	
	mov  dx,03c4h
	mov  ax,0102h
	out  dx,ax
picloop1:  
	mov  cx,7
rep     movsd
	movsw
	add  di,290
	dec  bx
	jne  picloop1
	
	mov  di,logost
	mov  bx,29
	mov  ax,0202h
	out  dx,ax
picloop2:  
	mov  cx,7
rep     movsd
	movsw
	add  di,290
	dec  bx
	jne  picloop2
	
	mov  di,logost
	mov  bx,29
	mov  ax,0402h
	out  dx,ax
picloop3:  
	mov  cx,7
rep     movsd
	movsw
	add  di,290
	dec  bx
	jne  picloop3

	mov  di,logost
	mov  bx,29
	mov  ax,0802h
	out  dx,ax
picloop4:  
	mov  cx,7
rep     movsd
	movsw
	add  di,290
	dec  bx
	jne  picloop4
	pop  ds
	ret


WaitNextVR  MACRO             ; wait for NEXT Vertical Retrace
LOCAL   w1, w2        
	mov     dx,03DAh
w1:     in      al,dx           ; wait for a non-retrace period
	test    al,8
	jnz     w1

w2:     in      al,dx
	test    al,8            ; wait for retrace
	jz      w2
ENDM

Timer:           ; the actual timer routine

	push    ax
	push    bx
	push    cx
	push    dx
	push    si                      ; save normal 8086 registers
	push    di
	push    bp
	push    ds
	push    es

	mov     al,20h                  ; send End Of Interrupt signal
	out     20h,al                  ; to PIC

	mov     dx,seg TmrVal           ; point DS to proper data segment
	mov     ds,dx

	mov     dx,03DAh
@@wnvr: in      al,dx                   ; wait until we are _not_ in a
	test    al,8                    ; retrace (just to make sure...)
	jnz     @@wnvr

	call    PreVR                   ; call the Pre-VR function
	
	;clc
	mov     ah,3                ; play music
	call DWORD PTR cs:[Player]
	
	mov     bx,TmrVal             ; count for timer chip
	
	mov     dx,03DAh
@@wvr:  in      al,dx                   ; wait for the retrace
	test    al,8
	jz      @@wvr

	mov     al,30h                  ; counter mode 0 - interrupt on
	out     43h,al                  ; terminal count
	mov     al,bl
	out     40h,al                  ; set timer count and restart timer
	mov     al,bh
	out     40h,al
	
	call    VR         ; call the VR function

	
	
	;mov     ax,TmrVal
	;add     DOSTmrCnt,ax          ; add timer count to DOS timer count
	;jnc     @@noDOSTmr              ; if carry set (count 65536), call
					; DOS timer
	pushf
	call    [OldTmr]              ; call old timer
	 
@@noDOSTmr:
	pop     es
	pop     ds
	pop     bp
	pop     di
	pop     si                      ; restore saved registers
	pop     dx
	pop     cx
	pop     bx
	pop     ax

	iret

InitVRServer:

	push    ds

	mov     ax,3508h                ; save old interrupt 8 vector
	int     21h
	mov     word ptr OldTmr,bx
	mov     word ptr OldTmr+2,es

	mov     ax,seg Timer
	mov     ds,ax
	mov     dx,offset Timer         ; set new timer interrupt
	mov     ax,2508h
	int     21h
	
	pop     ds

	call    SyncVRServer           ; synchronize timer to display refresh

	ret

SyncVRServer:

	cli                             ; disable interrupts for maximum
					; accuracy
@@read:
	WaitNextVR                      ; wait for next Vertical Retrace

	mov     al,36h
	out     43h,al
	sub     al,al                   ; reset the timer
	out     40h,al
	out     40h,al


	WaitNextVR                      ; wait for next Vertical Retrace

	sub     al,al
	out     43h,al
	in      al,40h
	mov     ah,al
	in      al,40h                  ; read timer count - time between
	xchg    al,ah                   ; two Vertical Retraces
	neg     ax
	mov     TmrVal,ax


	WaitNextVR                      ; wait for next Vertical Retrace

	mov     al,36h
	out     43h,al
	sub     al,al                   ; reset timer again
	out     40h,al
	out     40h,al


	WaitNextVR                      ; wait...

	sub     al,al
	out     43h,al
	in      al,40h
	mov     ah,al                   ; and read the timer count again
	in      al,40h
	xchg    al,ah
	neg     ax

	mov     dx,ax

	sub     dx,TmrVal
	cmp     dx,2                    ; If the difference between the two
	jg      @@read                  ; values read was >2, read again.
	cmp     dx,-2
	jl      @@read

	mov     bx,FRAME            ; Time between two interrupts is
	mul     bx                      ; FRAMETIME/10 % of the total time
	mov     bx,1000                 ; between two Vertical Retraces.
	div     bx

	shr     ax,1
	mov     TmrVal,ax             ; timer chip count

	mov     bx,TmrVal

	WaitNextVR                      ; wait for Vertical Retrace

	mov     al,30h                  ; counter mode 0 - interrupt on
	out     43h,al                  ; terminal count
	mov     al,bl                   ; Restart timer with the new speed
	out     40h,al                  ; right after the beginning of the
	mov     al,bh                   ; Retrace.
	out     40h,al

	mov     DOSTmrCnt,0           ; count used in calling the old timer

	mov     al,20h                  ; send EOI signal to the PIC
	out     20h,al

	sti                             ; enable ints

	ret

RemoveVRServer:

	cli                             ; disable interrupts

	mov     al,36h                  ; DOS default timer mode
	out     43h,al
	sub     al,al                   ; set timer count to 65536 - 18.2Hz
	mov     al,0FFh                 ; (DOS default)
	out     40h,al
	out     40h,al

	push    ds
	mov     ax,2508h
	mov     dx,word ptr OldTmr        ; restore old timer int
	mov     ds,word ptr OldTmr+2
	int     21h
	pop     ds

	mov     al,20h                  ; send EOI signal to PIC
	out     20h,al

	mov     al,36h                  ; DOS default timer mode
	out     43h,al
	sub     al,al                   ; set timer count to 65536 - 18.2Hz
	mov     al,0FFh                 ; (DOS default)
	out     40h,al
	out     40h,al

	sti                             ; enable interrupts
	ret

PlayM:  call DWORD PTR cs:[Player]
rtn:    ret

Player    DW     0,0

ends main 

musicseg segment para use32 
include alibi.inc
ends musicseg

end
