                        org 0x200000
                        bits 32

TheStart                pop dword [ReturnOff]
                        pop dword [ReturnSel]

                        mov [TempVar],word 0x03ff
                        mov [TempVar+2],dword IDT
                        lidt [TempVar]

                        ; disable all irqs except keyboard + timer
                        in al,0x21
                        mov [OldIRQMask],al
                        mov al,0xfc
                        out 0x21,al

                        ; init keyboard-watch-for-ESC-and-die-handler (IRQ1)
                        mov al,9
                        mov dx,cs
                        mov ebx,KeyHandler
                        call SetVector

                        ; init ticker (IRQ0)
                        mov al,8
                        mov dx,cs
                        mov ebx,TickHandler
                        call SetVector

                        sti

                        %include "fractal.inc"

ShutDown                cli

                        ; restore irqs
                        mov al,[OldIRQMask]
                        out 0x21,al

                        mov [TempVar],word 0x03ff
                        mov [TempVar+2],dword 0
                        lidt [TempVar]

                        push dword [ReturnSel]
                        push dword [ReturnOff]
                        retf

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Exit:
;  EAX = random number
;  all other registers have same values as on entry
GetRandom               push ecx
                        mov eax,[.RandomNess1]
                        mov ecx,[.RandomNess2]
                        rol eax,cl
                        mov [.RandomNess2],eax
                        add eax,ecx
                        mov [.RandomNess1],eax
                        mov ecx,[.RandomNess3]
                        add eax,ecx
                        mov [.RandomNess4],eax
                        add eax,[.RandomNess1]
                        mov [.RandomNess3],eax
                        pop ecx
                        ret
.RandomNess1            dd 0x18ef064a           ; set one of these
.RandomNess2            dd 0xe589a0cb           ; to seed the generator
.RandomNess3            dd 0x19827593           ; to seed the generator
.RandomNess4            dd 0xabc23950           ; to seed the generator
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  EAX = seed for the random number generator
SeedRandom              mov [GetRandom.RandomNess1],eax
                        call GetRandom
                        mov [GetRandom.RandomNess2],eax
                        call GetRandom
                        mov [GetRandom.RandomNess3],eax
                        call GetRandom
                        mov [GetRandom.RandomNess4],eax
                        ret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
KeyHandler              push ax

.WaitForIt              in al,64h               ;64h is status port-key done yet?
                        test al,02h             ;Check if controller is done
                        jnz .WaitForIt          ;Not ready-wait
                        in al,60h               ;It's ready-get the code.
                        push ax

                        in al,61h               ;Get control status
                        mov ah,al               ;Copy it
                        or al,80h               ;Set KB enable bit
                        out 61h,al              ;Write to control port
                        xchg ah,al              ;Send original value
                        out 61h,al              ;Back again

                        pop ax
                        cmp al,128
                        ja .BreakCode

                        ; time to exit the demo
                        mov [esp+2],dword ShutDown
                        mov al,0x20
                        out 0x20,al
                        pop ax
                        iret

.BreakCode              mov al,0x20
                        out 0x20,al                       

                        pop ax
                        iret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
TickHandler             push ax

                        inc dword [Tick]

                        mov al,0x20
                        out 0x20,al                       

                        pop ax
                        iret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Entry:
;  AL = interrupt to set handler of
;  DX:EBX = location of new handler
; Exit:
;  all registers undefined
SetVector               xor ecx,ecx
                        mov cl,al
                        mov [IDT+ecx*8],bx
                        mov [IDT+ecx*8+2],dx
                        mov [IDT+ecx*8+4],word 0x8e00
                        rol ebx,16
                        mov [IDT+ecx*8+6],bx
                        ret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Exit:
;  AH = interrupt to get handler of
;  DX:EBX = location of handler
;  all other registers undefined
GetVector               xor ecx,ecx
                        mov cl,ah
                        mov bx,[IDT+ecx*8+6]
                        mov dx,[IDT+ecx*8+2]
                        rol ebx,16
                        mov bx,[IDT+ecx*8]
                        ret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; al = palette entry number to change
; bl = red
; cl = green
; dl = blue
SetPalette              push ax
                        push dx

                        mov si,dx
                        
                        push ax
                        mov dx,0x3c6
                        mov al,0xff
                        out dx,al
                        pop ax

                        mov dx,0x3c8
                        out dx,al

                        mov dx,0x3c9
                        mov al,bl
                        out dx,al
                        mov al,cl
                        out dx,al
                        mov ax,si
                        out dx,al

                        pop dx
                        pop ax
                        ret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
                        times  32-(($-TheStart) %% 32)  db 0
                        section .bss
IDT                     resb 256*8
TempVar                 resd 2
ReturnOff               resd 1
ReturnSel               resd 1
OldIRQMask              resd 1
RightArrow              resd 1
DownArrow               resd 1
LeftArrow               resd 1
UpArrow                 resd 1
EnterKey                resd 1
NumPad5                 resd 1
Tick                    resd 1
BubbleBuffer            resb 64000
cr                      resq 1
ci                      resq 1
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

