{$G+}
unit SDSLite;
{
    Sound Deluxe System 5
    a Maple Leaf production, 1996-1997
    (Maple Leaf is a.k.a. Gruian Radu Bogdan)
    ---------------------------------------------------------------------
    SDS Lite kernel interface (short)
    ---------------------------------------------------------------------
    This program is part of the Sound Deluxe System 5, and it cannot
    be modified or sold without the written permission of the author. The
    author does not assume any responsability for the incidental loss or
    hardware/software damages produced while using this program or any other
    part of the Sound Deluxe System. The author also does not assume any
    responsability for the damages produced by using modified parts of this
    package.  Blah, blah...
    ---------------------------------------------------------------------
}

interface

uses alloc, ems, fcache, files, strings, sds_k, math;

{}
{            Constants and 'keywords' used everywhere in SDS             }
{}

Const

{ Version definitions }

       TrackerVer         : word    = $0504;        { 5.04 }
       HeaderSign         : Longint = $35534453;    { 'SDS5' }
       SDS_Version                  = '5.04 Lite';      { like TrackerVer, but string }
       TrackerName        : string  = 'Sound Deluxe System '+SDS_Version;  { <=32 bytes! }

{ Soundcards }

       SB                 = 1;  { Plain Sound Blaster (DSP 1.0)              }
       SB2                = 1;  { Sound Blaster 2.0 (DSP 2.x)                }
       SBPro              = 2;  { Sound Blaster Pro (DSP 3.x)                }
       SB16ASP            = 3;  { Sound Blaster 16 ASP (DSP 4.0)             }
       SBAWE32            = 3;  { Sound Blaster AWE 32 (DSP 5.0)             }
       GUS                = 4;  { Gravis UltraSound                          }
       PAS                = 5;  { Pro Audio Spectrum                         }
       PASPlus            = 5;  { Pro Audio Spectrum Plus                    }
       PAS16              = 5;  { Pro Audio Spectrum 16                      }
       WSS                = 6;  { WSS/AudioTrix Pro/GUS MAX CODEC            }
       Aria               = 7;  { Aria soundcard (Sierra SC180xxx DSP chip)  }
       Silence            = 8;  { No Sound (UltraSilence(tm)Pro++/16!)       }


{ Memory manager vars }

       GUSbase            : word    = $200;         { MUST be set when loading into GUS }
       UseGUS             : boolean = False;        { MUST be set when loading into GUS }
       UseEMS             : boolean = False;        { True if samples must be loaded into EMS }
       gus_DRAM           : longint = 0;


{ General purpose vars }

       Amplif_NoSound               = 0;            { Amplification percents.    }
       Amplif_Normal                = 100;          { Of course, any value might }
       Amplif_NormalAndHalf         = 150;          { be used, not only these    }
       Amplif_Double                = 200;          { predefined ones ...        }
       Amplif_DoubleAndHalf         = 250;
       Amplif_Triple                = 300;
       Amplif_Quadruple             = 400;

       On                           = True;         { ON/OFF flags }
       Off                          = False;

       PAL                          = 1;            { PAL/NTSC mode consts }
       NTSC                         = 0;

       PAN_LEFT                     = 0;
       PAN_RIGHT                    = 15;
       PAN_MIDDLE                   = 8;
       PAN_SOMEWHERE_LEFT           = 4;
       PAN_SOMEWHERE_RIGHT          = 12;

{ Load/Save vars }

       LoadError          : Byte    = 0;            { Load-error codes. See docs. }
       SaveError          : Byte    = 0;            { Save-error codes. See docs. }

       UserRoutine        : Pointer = nil;          { Called by SDS_Load_... while loading. If it is NIL, no call is performed}
       Action             : Byte    = 0;            { Actions. See docs. }
       ActionPARA         : Byte    = 0;            { Action idx. See docs. }

       TextPtr            : Pointer = nil;          { pointer to a data area where a text is stored }
       TextSize           : Word    = 0;            { nr. of bytes in that text area }

       EOC                : byte    = $EC;
       MINF                         = $464E494D;    { 'MINF' }
       SDES                         = $53454453;    { 'SDES' }
       SNAM                         = $4D414E53;    { 'SNAM' }
       PATT                         = $54544150;    { 'PATT' }
       MTXT                         = $54584554;    { 'TEXT' }
       SDAT                         = $54414453;    { 'SDAT' }
       STYP                         = $50595453;    { 'STYP' }


{}
{                          New SDS data types                            }
{}

Type

{ SDM format definitions }

       SDMInt_HeadType    = record     {internal format}
                              Patterns, Entries, Samples : word;
                              Channels, InitGVolume, InitSpeed, InitBPM : byte;
                              VRI : array [0..31] of byte;
                              MasterVolume : byte;
                              PattAddrTabPtr : pointer;
                              ChannelStatus :  longint;
                            end;
       SDMInt_InstType    = record
                              Volume : byte;
                              C2Speed : word;
                              Address : longint;
                              Size, LoopStart, LoopEnd : word;
                            end;
       FX_Type            = record
                              address     : longint;  {used by SDS kernel}
                              size        : longint;  {used by SDS kernel}
                              pitch       : word;     {used by SDS kernel}
                              volume      : byte;     {used by SDS kernel}
                              panning     : byte;     {used by SDS kernel}
                              trueaddress : longint;  {alloc/dealloc}
                            end;


{}
{                             SDS variables                              }
{}

Var

     ModuleName   : String;                         { Module's name }
     Author       : String;                         { Author, if available }

     Entries      : byte;                           { Orders }
     Patterns     : byte;                           { Patterns }
     Samples      : byte;                           { Samples }
     Channels     : byte;                           { Channels }

     Order        : array [byte] of byte;           { Order list }
     Sample       : array [byte] of pointer;        { Samples addresses }
     SamSize      : array [byte] of word;           { Sizes }
     SName        : array [byte] of string[35];     { Names }
     SamType      : array [byte] of byte;           { Type: bit 0 = 8bit(0), 16bit(1)
                                                                6 = delta packed(1), normal(0)
                                                                7 = unsigned(1),signed(0) }
     Pattern      : array [byte] of pointer;        { Patterns addresses }
     PattSize     : array [byte] of word;           { Sizes }

{}
{                  SDS interface functions declaration                   }
{}

{ Memory manager functions }

function SDS_alloc (size:longint) : pointer;        { Alloc a block in GUS DRAM, EMS or conv. }
function SDS_free (var p:pointer) : boolean;        { Deallocates the specified block }
function SDS_mavail : longint;                      { If UseGUS=True : returns free DRAM available }
                                                    {    UseEMS=True : returns EMS amount available }
                                                    {    Otherwise   : returns conventional memory available }

{ Load/Save functions }

procedure SDS_UnLoad(var module:pointer);
function  SDS_Load(name:string; LoadSamples:boolean):Pointer;

function  SDS_Read_SDM(var f:file; LoadSamples:boolean):Pointer;
function  SDS_Load_SDM(name:string; LoadSamples:boolean):Pointer;

{ FX routines }

procedure SDS_FX_Read_FX (var f:file; size:longint; LoadFlags:Byte; var fx : fx_type);
procedure SDS_FX_Load_FX (name:string; LoadFlags:Byte; var fx : fx_type);
procedure SDS_FX_Free_FX (var fx:fx_type);
procedure SDS_FX_Setup_FX(var fx:fx_type; pitch:word; volume,panning:byte);
{kernel internal:}
function  SDS_FX_OpenChannel : byte;
procedure SDS_FX_Shoot(chn:byte; var fx:fx_type);

{ SDS kernel routines }

procedure SDS_Init(Card, Base, Irq, Dma:word);far;
procedure SDS_Done;far;
procedure SDS_StartPlay(module:pointer; InitSpd, MixSpeed, Pal:word);far;
procedure SDS_StartFromPosition(module:pointer; InitSpd, MixSpeed, Pal, Order, Row:word);far;
procedure SDS_StopPlay;far;
procedure SDS_SetSurround(surroundmod:boolean);far;
procedure SDS_SetAmplification(percent:word);far;
procedure SDS_SetPollMix(pollmode:boolean);far;
procedure SDS_Poll;far;
procedure SDS_Services;far;

{ I/O routines }

function SDS_ReadBlock (var f:file; p:pointer; size:word; xorval:byte) : word;
function SDS_WriteBlock(var f:file; p:pointer; size:word; xorval:byte) : word;

{ For both routines, if (XorVal and 1=1) then the sample must be loaded/saved as
  a 16-bit sample. For conversion:
     Smp8_unsigned  = 255 * ( Smp16_unsigned / 65535 )
     Smp8_signed    = Smp8_unsigned xor 80h  (GUPE uses 7Fh !!!)
     Smp16_unsigned = 65535 * ( Smp8_unsigned / 255 )
     Smp16_signed   = Smp16_unsigned-32768
}


{ Other useful routines }

procedure CallUserRoutine;
function  FineTune2Speed(ft:byte):word;
function  AsciiZ2String(var v; maxlen:byte):string;
function  CompressPattern(     source:pointer;
                               chnls, lines:word;
                           var dest:pointer;
                           var CompressedSize:word ):boolean;
{ 'Samples' MUST be set in order to call 'CompressPattern()' function !!! }

implementation

{}
{   SDS memory manager functions                                         }
{}


type  gus_chunk_type = ^gct;
      gct            = record
                         addr, size : longint;
                         next : gus_chunk_type;
                       end;  { sort of a single chained list }
const gus_MCB : gus_chunk_type = nil;


procedure gusDelay;near;assembler;
asm
  mov dx,300h
  in al,dx
  in al,dx
  in al,dx
  in al,dx
  in al,dx
  in al,dx
  in al,dx
end;

procedure gusPoke(addr:longint; b:byte);near;
var AddrLo:word; AddrHi:byte;
begin
  AddrLo:=word(addr and $FFFF);
  AddrHi:=byte(longint(addr and $FF0000) shr 16);
  port [gusBase+$103]:=$43; { set DRAM I/O address LOW }
  portw[gusBase+$104]:=AddrLo;
  port [gusBase+$103]:=$44; { set DRAM I/O address HIGH }
  port [gusBase+$105]:=AddrHi;
  port [gusBase+$107]:=b;   { write byte }
end;

function gusPeek(addr:longint):byte;near;
var AddrHi,b:byte; AddrLo:word;
begin
  AddrLo:=word(addr and $FFFF);
  AddrHi:=byte(longint(addr and $FF0000) shr 16);
  port [gusBase+$103]:=$43; { set DRAM I/O address LOW }
  portw[gusBase+$104]:=AddrLo;
  port [gusBase+$103]:=$44; { set DRAM I/O address HIGH }
  port [gusBase+$105]:=AddrHi;
  b:=port[gusBase+$107];
  gusPeek:=b;
end;

procedure gusHowMuchDRAM; { determines how much DRAM has the card (max 1 Mb detected) }
const MaxDetected = 1024*1024; { 1 Mb - std. GUS supports only bits 0-19 of the linear address }
var addr : longint;
begin
  addr:=256*1024; { 256 kb = default }
  gus_DRAM:=0;
  repeat
    gusPoke(addr,$AA);
    gusDelay;
    gusDelay;
    if (gusPeek(addr)<>$AA) then gus_DRAM:=addr-1;
    addr:=addr+256*1024; {next bank}
  until (gus_DRAM>0) or (addr>=MaxDetected);
  if (addr>=MaxDetected) and (gus_DRAM=0) then gus_DRAM:=MaxDetected-1;
end;

function galloc (size:longint) : pointer;
var p,ap,q:gus_chunk_type; stop:boolean;
begin
  if gus_MCB=nil { first allocation ? } then begin
    gus_MCB:=malloc(sizeof(gct));
    gus_MCB^.next:=nil;
    gus_MCB^.addr:=1; { Start with address 1, not with 0 !!! }
    gus_MCB^.size:=size;
    galloc:=pointer(1);  { 1 instead of zero, to avoid NIL }
  end else begin
    { search the lowest address that out block can start from }
    p:=gus_MCB; stop:=false; q:=nil;
    while (p^.next<>nil) and (not stop) do begin
      ap:=p^.next;
      if ap=nil then stop:=true else begin
        if size <= ap^.addr - (p^.addr+longint(p^.size)) then begin
          { block fits here! first create a descriptor for it }
          q:=malloc(sizeof(gct));
          q^.addr:=p^.addr+longint(p^.size);
          q^.size:=size;
          { link descriptor to chain }
          q^.next:=ap;
          p^.next:=q;
          stop:=true;
        end else p:=p^.next; { does not fit, test the next locations }
      end;
    end;
    if (q=nil) and (stop or (p^.next=nil)) then begin { last element }
      if p^.addr+longint(p^.size)+longint(size) <= gus_DRAM then begin { check if enough DRAM }
        { allocate a new block at the end of the chain }
        q:=malloc(sizeof(gct));
        q^.addr:=p^.addr+longint(p^.size);
        q^.size:=size;
        { link descriptor to the chain }
        q^.next:=nil;
        p^.next:=q;
      end else q:=nil;
    end;
    if q=nil then galloc:=nil else galloc:=pointer(q^.addr);
  end;
end;

function gus_free (var p:pointer) : boolean;
var q,bq:gus_chunk_type; x:pointer;
begin
  if p=nil then begin
    gus_free:=true;
    exit
  end;
  q:=gus_MCB; { head of the chained list of descriptors }
  bq:=nil;    { "before q" }
  while (q<>nil) and (q^.addr<>longint(p)) do begin
    if q=gus_MCB then bq:=q else bq:=bq^.next;
    q:=q^.next;
  end;
  if q=nil then gus_free:=false { deallocation has failed, cannot find the given DRAM address }
  else begin
    { we have to deallocate q from the descriptors chain }
    if q=gus_MCB { first element ? } then begin
      gus_MCB:=q^.next;
      x:=q; gus_free:=free(x); q:=x;  { deallocate memo }
    end else begin
      bq^.next:=q^.next; { erase linkage }
      x:=q; gus_free:=free(x); q:=x;  { deallocate memo }
    end;
    p:=nil;
  end;
end;

function gus_alloc (size:longint) : pointer;
var p,aux:pointer;
    s_addr, e_addr : longint;
    fill_sz:longint;
begin
{ the first DRAM alloc ? If yes, init GUS and read how much memory onboard }
  if gus_MCB=nil then gusHowMuchDRAM;
{ allocate block }
  p:=galloc(size);
  if p<>nil then begin
  { check 256k page crossing }
    s_addr:=longint(p);          { start DRAM address }
    e_addr:=longint(p)+size-1;   { end DRAM address }
    if (s_addr and $C0000)<>(e_addr and $C0000) then begin { a 256k page has been crossed }
      fill_sz:=(e_addr and $FFFC0000)-s_addr;  { fill-up buffer (temp) }
      gus_free(p);                  { deallocate block }
      aux:=galloc(fill_sz);         { fill-up the rest of the page }
      p:=gus_alloc(size);           { recursive alloc }
      gus_free(aux);                { deallocate fill-up buf }
    end;
  end;
  gus_alloc:=p;  { return allocated block }
end;

function gus_avail : longint; { returns the TOTAL memory available, not the greatest block ! }
var p:gus_chunk_type; avail:longint;
begin
  p:=gus_MCB; avail:=gus_DRAM;
  while p<>nil do begin
    avail:=avail-p^.size;
    p:=p^.next
  end;
  gus_avail:=avail;
end;

function ems_alloc (size:longint) : pointer;
var handle:word;
begin
  handle:=emsAlloc(((size-1) div 16384) + 1); { size in 16k pages }
  if handle=0 then
    ems_alloc:=nil
  else
    ems_alloc:=ptr($F000 or handle,0);   { Fxxx:0, where xxx is the EMS handle }
end;

function ems_free (var p:pointer) : boolean;
var handle:word;
begin
  handle:=seg(p^) and $0FFF;
  ems_free:=emsFree(handle);
  if handle=0 then p:=nil;
end;

function ems_avail : longint;
begin
  ems_avail:=longint(emsFreePages)*16384;
end;

var auxalloc : pointer;

{ Allocates a block in GUS's DRAM, EMS or conventional memory. When UseGUS
  is True, it also takes care about not crossing 256k page boundary. }
function sds_alloc (size:longint) : pointer;
begin
{ if a GUS is present, then alloc a chunk into its DRAM : }
  if UseGUS then
    sds_alloc:=gus_alloc(size)
  else
{ if EMS is present and user wants, allocate a block into it : }
    if UseEMS then begin
      auxAlloc:=ems_alloc(size);
      if auxAlloc=nil then sds_alloc:=malloc(size) else sds_alloc:=auxAlloc;
    end else
{ else, do a normal allocation in the fuckin conventional memory : }
      sds_alloc:=malloc(size);
end;

function sds_free (var p:pointer) : boolean;
begin
{ if sample was loaded into GUS DRAM, then free it from there : }
  if UseGUS then
    sds_free:=gus_free(p)
  else begin
{ if sample was loaded into EMS, deallocate it from there : }
    if (seg(p^) and $F000 = $F000) { in EMS } then
      sds_free:=ems_free(p)
    else
{ else, do a normal deallocation : }
      sds_free:=free(p);
  end;
end;

function sds_mavail : longint;
begin
  if UseGUS then sds_mavail:=gus_avail else
  if UseEMS then sds_mavail:=ems_avail + mavail else
                 sds_mavail:=mavail;
end;

{}
{   Other useful routines                                                }
{}

Procedure CallUserRoutine;assembler;
asm
  cmp    word ptr UserRoutine[2],0   {is segment=0 (NIL) ?}
  je     @NoFuckinCall
  push   ds
  push   bp
  call   dword ptr UserRoutine
  pop    bp
  pop    ds
@NoFuckinCall:
end;

Function FineTune2Speed(ft:byte):word;
const
  FTune : Array [0..15] of Word =
  ( 8363,8413,8463,8529,8581,8651,8723,8757,7895,7941,7985,8046,8107,8169,8232,8280 );
begin
  FineTune2Speed:=FTune[FT];
end;

Function AsciiZ2String(var v; maxlen:byte):string;
var s:string; k:byte; c:char;
begin
  s:=''; k:=0;
  if maxlen>0 then begin
    repeat
      c:=char(mem[seg(v):ofs(v)+k]); inc(k);
      if c<>#0 then s:=s+c;
    until (k>=maxlen) or (c=#0);
  end;
  AsciiZ2String:=s;
end;

function CompressPattern(source:pointer; chnls, lines:word; var dest:pointer; var CompressedSize:word ):boolean;
{ this function assumes that 'Samples' variable is already set to the right
  value, otherwise a wrong compression will be made !!! }
var l,c,pattoffs:word; b:byte;
    cevent, event : array [0..31] of
                    array [0..4]  of byte; { SDS events ! }
begin
  {shrinks source into dest}
  pattoffs:=0;
  fillchar(cevent,32*5,$FF);
  fillchar(event,32*5,$AB);
  for l:=0 to lines-1 do begin
    move(mem[seg(source^):l*chnls*5],event,chnls*5);
    for c:=0 to chnls-1 do begin
      if (event[c][0]=cevent[c][0]) and (event[c][1]=cevent[c][1]) and
         (event[c][2]=cevent[c][2]) and (event[c][3]=cevent[c][3]) and
         (event[c][4]=cevent[c][4]) then begin
         mem[seg(Dest^):pattoffs]:=$FF; {the same event}
         inc(pattoffs)
      end else begin
         if ((event[c][0] or event[c][1] or event[c][3] or event[c][4]) = 0)
            and (event[c][2] and $41 = $41) then begin
            mem[seg(Dest^):pattoffs]:=$FD; {null event}
            inc(pattoffs);
         end else begin
            mem[seg(Dest^):pattoffs]:=event[c][0];
            inc(pattoffs);
            {}if event[c][1]>Samples then event[c][1]:=0;{!!!!!!!!!}
            mem[seg(Dest^):pattoffs]:=event[c][1];
            inc(pattoffs);
            b:=event[c][2];
            if (event[c][3]<>0) then begin
               mem[seg(Dest^):pattoffs]:=b or $80;
               mem[seg(Dest^):pattoffs+1]:=event[c][3];
               mem[seg(Dest^):pattoffs+2]:=event[c][4];
               inc(pattoffs,3);
            end else begin
               mem[seg(Dest^):pattoffs]:=b and $7F;
               inc(pattoffs);
            end;
         end;
      end;
    end;
    move(event,cevent,32*5);
  end;
  {reallocate this pattern}
  CompressedSize:=pattoffs;
  CompressPattern:=(realloc(Dest,CompressedSize)>=CompressedSize)
end;

{}
{   I/O routines                                                         }
{}

var RemindSome : array [0..7] of byte; { used to "extend" the sample in GUS DRAM
                                         in order to prevent the ugly UltraClicks(tm) }

function gus_UpLoad(var f:file; addr:longint; size:word; xorval:byte) : word;
{ this routine is very slow, but what the fuck... }
var k:longint; r:word; c:byte; poz:longint; w:integer;
    delta,xv:byte;
label _fuck;
begin {$i-}
  if size=0 then begin
    gus_UpLoad:=0;
    exit;
  end;
  poz:=filepos(f);
  ResetBuffer;
  r:=0; CacheEOF:=false;
  delta:=0; xv:=xorval and $80;
  for k:=addr to addr+longint(size)-1 do begin
    if CacheEOF then goto _fuck;
    c:=ReadByte(f);
    if xorval and 1 = 0 then c:=c xor xv
    else begin
          inc(r);
          if xorval and $41 = $41 then begin
            c:=c+delta;
            delta:=c;
          end;
          w:=c;
          c:=ReadByte(f);
          if xorval and $41 = $41 then begin
            c:=c+delta;
            delta:=c;
          end;
          w:=w+(integer(c) shl 8);  { 16-bit signed - that's all SDS knows... }
          w:=w xor $8000;
          c:=byte(w shr 8) xor $80; { 8-bit signed }
    end;
    if xorval and $41 = $40 {delta format} then begin
      c:=c+delta;
      delta:=c;
    end;
    gusPoke(k,c); inc(r);
    if (addr+longint(size)-1-k)<=7 then
      RemindSome[addr+longint(size)-1-k]:=c; { store this byte ! }
  end;
_fuck:
  (*
  { extend the sample by adding a few extra bytes (8) at the end of it -
    this is done in order to prevent the UltraClicks(TM)!  The bytes are
    already stored into RemindSome[] }
  for k:=addr+longint(size) to addr+longint(size)+7 do
    gusPoke(k,RemindSome[k-(addr+longint(size))]);
  *) {... this shit used to generate more clicks... :(...}
  { now restore status and exit }
  seek(f,poz+longint(r));
  gus_UpLoad:=r;
end;

function ems_UpLoad(var f:file; p:pointer; size:word; xorval:byte) : word;
var Handle,pages,i,j,fval,r:word; poz:longint; c:byte; w:integer;
    xv,delta:byte;
label _fuck;
begin {$i-}
  if size=0 then begin
    ems_UpLoad:=0;
    exit;
  end;
  handle:=seg(p^) and $FFF;
  pages:=((size-1) div 16384)+1;
  poz:=FilePos(f);
  xv:=xorval and $80; delta:=0;
  ResetBuffer;
  r:=0; CacheEOF:=false;
  for i:=0 to pages-1 do begin
    emsSaveMapping(handle);
    emsMap(handle,i,0);
    if i=pages-1 then fval:=(size-1) mod 16384 else fval:=16383;
    for j:=0 to fval do begin
      if CacheEOF then goto _fuck else begin
        c:=ReadByte(f);
        if XorVal and 1 = 0 then c:=c xor xv
        else begin { it's a 16-bit-signed sample ... }
          inc(r);
          if xorval and $41 = $41 then begin
            c:=c+delta;
            delta:=c;
          end;
          w:=c;
          c:=ReadByte(f);
          if xorval and $41 = $41 then begin
            c:=c+delta;
            delta:=c;
          end;
          w:=w+(integer(c) shl 8);  { 16-bit signed - that's all SDS knows... }
          w:=w xor $8000;
          c:=byte(w shr 8) xor $80; { 8-bit signed }
        end;
        if xorval and $41 = $40 then begin
          c:=c + delta;
          delta:=c;
        end;
        mem[emsPageFrameAddr:j]:=c;  { write byte into EMS page }
        inc(r);
      end;
    end;
    emsRestoreMapping(handle);
  end;
_fuck:
  seek(f,poz+longint(r));
  ems_UpLoad:=r;
end;

function cnv_UpLoad(var f:file; p:pointer; size:word; xorval:byte) : word;
var r:word; poz,k:longint; c:byte; w:integer;
    xv,delta:byte;
begin {$i-}
  if size=0 then begin
    cnv_UpLoad:=0;
    exit;
  end;
  if xorval=0 then
    blockread(f,p^,size,r) { no xor is necessarry, load it directly }
  else begin
    poz:=filepos(f);
    xv:=xorval and $80; delta:=0;
    ResetBuffer;
    r:=0; CacheEOF:=false;
    for k:=0 to size-1 do begin
      if CacheEOF then k:=size-1 else begin
        c:=ReadByte(f);
        if XorVal and 1 = 0 then c:=c xor xv
        else begin { it's a 16-bit-signed sample ... }
          inc(r);
          if xorval and $41 = $41 then begin
            c:=c+delta;
            delta:=c;
          end;
          w:=c;
          c:=ReadByte(f);
          if xorval and $41 = $41 then begin
            c:=c+delta;
            delta:=c;
          end;
          w:=w+(integer(c) shl 8);  { 16-bit signed - that's all SDS knows... }
          w:=w xor $8000;
          c:=byte(w shr 8) xor $80; { 8-bit signed }
        end;
        if xorval and $41 = $40 then begin
          c:=c+delta;
          delta:=c;
        end;
        mem[seg(p^):ofs(p^)+k]:=c;
        inc(r);
      end;
    end;
    seek(f,poz+longint(r));
  end;
  cnv_UpLoad:=r;
end;

function gus_DownLoad(var f:file; addr:longint; size:word; xorval:byte) : word;
var r:word; k,poz:longint; c:byte; w:integer;
label _fuck;
begin
  if size=0 then begin
    gus_DownLoad:=0;
    exit;
  end;
  r:=0; poz:=filepos(f);
  OutBuffIndex:=0;
  for k:=addr to addr+longint(size)-1 do begin
    c:=GusPeek(addr);
    if XorVal<>1 then c:=c xor xorval
    else begin { it's a 16-bit-signed sample ... }
      w:=((c xor $80) shl 8) - 32768;
      if not WriteByte(f,w and $FF) then goto _fuck;
      c:=(w shr 8) and $FF;
    end;
    if not WriteByte(f,c) then goto _fuck;
    inc(r);
  end;
_fuck:
  FlushBuffer(f);
  seek(f,poz+r);
  gus_DownLoad:=r;
end;

function ems_DownLoad(var f:file; p:pointer; size:word; xorval:byte) : word;
var r:word; k,poz:longint; c:byte;
    handle, pages,i, j, fv : word;
    w:integer;
label _fuck;
begin
  if size=0 then begin
    ems_DownLoad:=0;
    exit;
  end;
  handle:=seg(p^) and $FFF;
  pages:=((size-1) div 16384)+1;
  r:=0; poz:=filepos(f);
  OutBuffIndex:=0;
  for i:=0 to pages-1 do begin
    emsMap(handle,i,0);
    if i=pages-1 then fv:=(size-1) mod 16384 else fv:=16383;
    for j:=0 to fv do begin
      c:=mem[emsPageFrameAddr:j];
      if XorVal and 1 = 0 then c:=c xor (xorval and $80)
      else begin { it's a 16-bit-signed sample ... }
        w:=((c xor $80) shl 8) - 32768;
        if not WriteByte(f,w and $FF) then goto _fuck;
        c:=(w shr 8) and $FF;
      end;
      if not WriteByte(f,c) then goto _fuck;
      inc(r);
    end;
  end;
_fuck:
  FlushBuffer(f);
  seek(f,poz+r);
  ems_DownLoad:=r;
end;

function cnv_DownLoad(var f:file; p:pointer; size:word; xorval:byte) : word;
var r:word; k,poz:longint; c:byte; w:integer;
label _fuck;
begin
  if size=0 then begin
    cnv_DownLoad:=0;
    exit;
  end;
  poz:=filepos(f);
  if xorval=0 then
    BlockWrite(f,p^,size,r)
  else begin
    r:=0; OutBuffIndex:=0;
    for k:=0 to size-1 do begin
      c:=mem[seg(p^):ofs(p^)+k];
      if XorVal<>1 then c:=c xor xorval
      else begin { it's a 16-bit-signed sample ... }
        w:=((c xor $80) shl 8) - 32768;
        if not WriteByte(f,w and $FF) then goto _fuck;
        c:=(w shr 8) and $FF;
      end;
      if not WriteByte(f,c) then goto _fuck;
      inc(r);
    end;
_fuck:
    FlushBuffer(f);
  end;
  seek(f,poz+r);
  cnv_DownLoad:=r;
end;


function sds_ReadBlock (var f:file; p:pointer; size:word; xorval:byte) : word;
begin
  if UseGUS then
    sds_ReadBlock:=gus_UpLoad(f,longint(p),size,xorval)
  else begin
    if (seg(p^) and $F000 = $F000) then {from EMS}
      sds_ReadBlock:=ems_UpLoad(f,p,size,xorval)
    else
      sds_ReadBlock:=cnv_UpLoad(f,p,size,xorval); {from conv. memory}
  end;
end;

function sds_WriteBlock(var f:file; p:pointer; size:word; xorval:byte) : word;
begin
  if UseGUS then
    sds_WriteBlock:=gus_DownLoad(f,longint(p),size,xorval)
  else begin
    if (seg(p^) and $F000 = $F000) then {into EMS}
      sds_WriteBlock:=ems_DownLoad(f,p,size,xorval)
    else
      sds_WriteBlock:=cnv_DownLoad(f,p,size,xorval); {into conv. memory}
  end;
end;

{}
{   SDM loader, revision 1.3                                             }
{}

Function SDS_Read_SDM(var f:file; LoadSamples:boolean):Pointer;
type chunktype = record name:longint; size:longint end;
var module:pointer;
    a,b,r:word;
    chunk : chunktype;
    _EOC:byte;
    header : record
               Sign   : LongInt;
               Name   : Array [0..63] of byte; {ASCIIZ}
               Author : Array [0..63] of byte; {ASCIIZ}
               Chunks : Word;  { # of chunks in song, except this header }
               TrkName : array [0..31] of byte; { SDS/tracker name }
               TrkVer : Word;  { SDS/tracker version }
               PCompr : Byte;  { Patterns' compression type (0=none) }
             end;
    mi:sdmint_headtype;
    si:sdmint_insttype;
    sdes_c, sdat_c, patt_c, snam_c : word;
    known : boolean;
    OldPosition:longint;
function ReadData(var Dat; size:word):boolean;
begin
  blockread(f,Dat,size,r);
  readdata:=r=size;
end;
procedure readchunk;
begin
  blockread(f,chunk,8,r);
end;
function testEOC:boolean;
begin
  blockread(f,_EOC,1,r);
  testEOC:=(r=1)and(_EOC=EOC);
end;
procedure IgnoreChunk;
begin
  seek(f,filepos(f)+chunk.size);
end;
begin

  if UseEMS and (not emsDetect) then UseEMS:=false;

  sds_read_sdm:=nil;

  OldPosition:=FilePos(f);

  { read general info header }
  ReadData(header,sizeof(header));
  if (r<>sizeof(header)) or (header.Sign<>headerSign) then begin
    loaderror:=2; exit
  end;
  ModuleName:=AsciiZ2String(header.name,64);
  Author:=AsciiZ2String(header.author,64);
  if header.PCompr>1 then begin
    loaderror:=7; exit
  end;

  { read MINF chunk }
  readchunk;
  if chunk.name<>MINF then begin
    loaderror:=11; exit
  end;
  if not readdata(mi,sizeof(mi)) then begin
    loaderror:=11; exit
  end;
  module:=malloc(sizeof(mi)+mi.patterns+mi.entries+word(mi.samples)*sizeof(si));
  if module=nil then begin
    loaderror:=3; exit;
  end;
  mi.PattAddrTabPtr:=@pattern;
  mi.ChannelStatus:=$FFFFFFFF; {all channels ON}
  entries:=mi.entries;
  patterns:=mi.patterns;
  samples:=mi.samples;
  channels:=mi.channels;
  move(mi,module^,sizeof(mi));
  readdata(ptr(seg(module^),sizeof(mi))^,mi.patterns);
  readdata(order,mi.entries);
  move(order,ptr(seg(module^),sizeof(mi)+patterns)^,mi.entries);
  if not testEOC then begin
    loaderror:=10; sds_unload(module); exit
  end;

  { read the other chunks }
  sdes_c:=0; sdat_c:=0; patt_c:=0; snam_c:=0;
  FillChar(SamType,256,0); { default = 8-bit samples }

  for a:=1 to header.chunks-1 {w/out MINF} do begin

    known:=false;
    readchunk; {read chunk's id}

    if r<8 {chunk has not been readed} then begin
      loaderror:=13; sds_unload(module); exit
    end;

    if chunk.name = MTXT {TEXT chunk} then begin
      known:=true;
      action:=5; calluserroutine;
      { create a TEXT area }
      if TextPtr<>nil then free(TextPtr);
      TextPtr:=malloc(chunk.size); TextSize:=chunk.size;
      readdata(TextPtr^,TextSize);
    end;

    if chunk.name = STYP {STYP chunk} then begin
      known:=true;
      readdata(SamType[1],chunk.size); { Read flags }
    end;

    if chunk.name = PATT {PATT chunk} then begin
      known:=true;
      if patt_c>patterns-1 then known:=false {just ignore it}
      else begin
        action:=2; actionPara:=patt_c; calluserroutine;
        pattsize[patt_c]:=chunk.size; {interesting method, isn't it ? :) }
        pattern[patt_c]:=malloc(pattsize[patt_c]);
        if pattern[patt_c]=nil then begin
          loaderror:=3; sds_unload(module); exit
        end;
        if not readdata(pattern[patt_c]^,pattsize[patt_c]) {read pattern} then begin
          loaderror:=2; sds_unload(module); exit
        end;
      end;
      inc(patt_c);
    end;

    if chunk.name = SNAM {SNAM chunk} then begin
      known:=true;
      inc(snam_c);
      if (snam_c>samples) or (chunk.size<>35) then known:=false else begin
        readdata(sname[snam_c][1],chunk.size);
        sname[snam_c]:=Asciiz2String(sname[snam_c][1],35);
      end;
    end;

    if chunk.name = SDES {SDES chunk} then begin
      known:=true;
      inc(sdes_c);
      if sdes_c>samples then known:=false else begin
        action:=6; actionPara:=sdes_c; calluserroutine;
        readdata(si,sizeof(si));
        SamSize[sdes_c]:=si.size div (1+SamType[sdat_c]);
        if (SamSize[sdes_c]>0) and LoadSamples then begin { only if sample exists and must be loaded }
          Sample[sdes_c]:=sds_alloc(SamSize[sdes_c]+8);
          if Sample[sdes_c]=nil { error ? } then begin
            loaderror:=3; sds_unload(module); exit
          end;
        end else Sample[sdes_c]:=nil;
        si.LoopStart:=si.LoopStart div (1+SamType[sdes_c]);
        si.LoopEnd:=si.LoopEnd div (1+SamType[sdes_c]);
        si.Size:=si.Size div (1+SamType[sdes_c]);
        if UseGUS then si.Address:=longint(Sample[sdes_c]) else si.Address:=seg(Sample[sdes_c]^);
        move(si,ptr(seg(module^),sizeof(mi)+patterns+entries+(sdes_c-1)*sizeof(si))^,sizeof(si));
      end;
    end;

    if chunk.name = SDAT {SDAT chunk} then begin
      known:=true;
      if sdat_c>=sdes_c {trying to read sample data before its descriptor ?} then begin
        loaderror:=12; sds_unload(module); exit
      end;
      inc(sdat_c);
      if (sdat_c>samples) or (Sample[sdat_c]=nil) then known:=false else begin
        action:=3; actionPara:=sdat_c; calluserroutine;
        if LoadSamples then begin
          r:=sds_readblock(f,Sample[sdat_c],SamSize[sdat_c],SamType[sdat_c]);
          if (r<SamSize[sdat_c]*(1+SamType[sdat_c])) then begin
            loaderror:=2; sds_unload(module); exit;
          end;
        end;
      end;
    end;

    if not known then IgnoreChunk; { ignore all the unknown chunks }

    if not testEOC then begin {end of chunk?}
      loaderror:=10; sds_unload(module); exit
    end;

  end;

  loaderror:=0;
  sds_read_sdm:=module;
end;

Function SDS_Load_SDM(name:string; LoadSamples:boolean):Pointer;
var f:file;
begin
  if not openforinput(f,name) then begin
    loaderror:=1; {file not found}
    exit
  end;
  sds_load_sdm:=sds_read_sdm(f,LoadSamples);
  closefile(f);
end;

{}
{   SDS FX routines, revision 1.0, 31 march 1997                         }
{}

procedure SDS_FX_Read_FX (var f:file; size:longint; LoadFlags:Byte; var fx : fx_type);
var r:word;
begin

  fx.size := size;
  if (LoadFlags and 1 = 1) {is sample 16bit?} then fx.size:=fx.size div 2;


  with fx do begin
     trueaddress := longint(sds_alloc(fx.size + 8));
     if trueaddress = 0 then begin
        loaderror:=3; {not enough memory for FX}
        exit
     end;
     volume  := $40; {default: maximum}
     pitch   := 428; {default: 1712/4 = middle C (fundamental DO)}
     panning := 8;   {default: middle}
  end;

  r:=sds_readblock(f, pointer(fx.trueaddress), fx.size, LoadFlags);
  if r<>size then begin
    loaderror:=2; {FX I/O error}
    exit
  end;

  if not UseGUS then
    fx.address:=seg(pointer(fx.trueaddress)^)
  else
    fx.address:=fx.trueaddress;

end;

procedure SDS_FX_Load_FX (name:string; LoadFlags:Byte; var fx : fx_type);
var f:file;
begin {$i-}
  if not openforinput(f,name) then begin
    loaderror:=1;
    exit;
  end;
  sds_fx_read_fx(f,filesize(f),LoadFlags,fx);
  closefile(f);
end;

procedure SDS_FX_Free_FX (var fx:fx_type);
begin
  sds_free(pointer(fx.trueaddress));
  fillchar(fx,sizeof(fx),0);
end;

procedure SDS_FX_Setup_FX(var fx:fx_type; pitch:word; volume,panning:byte);
begin
  fx.volume  := volume;
  fx.pitch   := pitch;
  fx.panning := panning;
end;

function SDS_FX_OpenChannel:byte;assembler;
asm
  jmp far ptr sds_k.sds_fx_openchannel
end;

procedure SDS_FX_Shoot(chn:byte; var fx:fx_type);assembler;
asm
  leave
  jmp far ptr sds_k.sds_fx_shoot
end;

{}
{   SDS kernel routines                                                  }
{}

(*
  Note:
  All the routines below use a small trick to call the kernel's routines.
  In this manner, the stack is left untouched and does not grow up
  excessively. The returning points from the real kernel' routines is not
  the end of THESE routines but the instructions immediately following
  the caller.  This idea is based on the fact that, at the far routine's
  entrance, Pascal creates a stack frame which is disabled using the LEAVE
  instruction below. This is true for all the routines containing parameters
  in their declaration, and NOT TRUE for simple far routines. This version
  of SDS has been cooked and compiled under Turbo Pascal 7.0 and the routines
  below worked perfectly. I really don't know the behaviour under other
  compilers.
  (Or else: the routines below pass all the responsability, including
  parameters and stack cleaning, to the kernel's routines (defined in the
  SDS.ASM file)).
*)

procedure sds_init(Card, Base, Irq, Dma:word);assembler;
asm
  mov UseGUS,False
  mov ax,Card
  cmp ax,4
  jne @1
  mov UseGUS,True     { UseGUS and GUSbase are used by the memory manager }
  mov ax,Base         { and I/O manager, and thus they have to be set up  }
  mov GUSbase,ax      { correctly                                         }
@1:
  leave
  jmp far ptr sds_k.sds_init
end;

procedure sds_done;assembler;
asm
  jmp far ptr sds_k.sds_done
end;

procedure sds_startplay(module:pointer; InitSpd, MixSpeed, Pal:word);assembler;
asm
  leave
  jmp far ptr sds_k.sds_startplay
end;

procedure SDS_StartFromPosition(module:pointer; InitSpd, MixSpeed, Pal, Order, Row:word);assembler;
asm
  leave
  jmp far ptr sds_k.sds_startfromposition
end;

procedure sds_stopplay;assembler;
asm
  jmp far ptr sds_k.sds_stopplay
end;

procedure sds_setsurround(surroundmod:boolean);assembler;
asm
  leave
  jmp far ptr sds_k.sds_setsurround
end;

procedure sds_setamplification(percent:word);assembler;
asm
  leave
  jmp far ptr sds_k.sds_setamplification
end;

procedure sds_setpollmix(pollmode:boolean);assembler;
asm
  leave
  jmp far ptr sds_k.sds_setpollmix
end;

procedure sds_poll;assembler;
asm
  jmp far ptr sds_k.sds_poll
end;

procedure sds_services;assembler;
asm
  jmp far ptr sds_k.sds_services
end;

{}
{   Load/Unload general functions                                        }
{}

procedure SDS_UnLoad;
var a:word;
begin
  for a:=0 to 255 do begin
    if Sample[a]<>nil then sds_free(Sample[a]);
    if Pattern[a]<>nil then free(Pattern[a]);
    Pattern[a]:=nil;
    Sample[a]:=nil;
    SName[a]:='';
    SamSize[a]:=0;
  end;
  if module<>nil then free(module);
  if (TextSize>0) and (TextPtr<>nil) then free(TextPtr);
end;

function SDS_Load(name:string; LoadSamples:boolean):Pointer;
begin
  name:=ucase(name); LoadError:=0;
  SDS_Load:=sds_load_sdm(name,LoadSamples);
end;

var k:word;
begin
  for k:=0 to 255 do begin
    Sample[k]:=nil;
    Pattern[k]:=nil;
    SName[k]:='';
  end;
end.
