COMMENT _

     //----------------------------------------------------------------\
     |  Sound Deluxe System 5                                          |
     |  by Maple Leaf (a.k.a Gruian Radu), 1996,1997                   |
     |   ARIA soundcard (in stereo only)                              |
     |  **** not tested! ****					       |
     \----------------------------------------------------------------//
_

ariaDesc    db       "Aria driver v0.02, by Maple Leaf, 1996.",0

;
;   Functions-Offsets Table
;

aria_driver dw       offset drvg_InitDriver ; sb_InitDriver
            dw       offset drvg_DoneDriver ; sb_DoneDriver
            dw       offset aria_StartMixer
            dw       offset aria_StopMixer
            dw       offset mx_SetVoiceVolume
            dw       offset mx_GetVoiceVolume
            dw       offset mx_SetVoicePanning
            dw       offset mx_GetVoicePanning
            dw       offset mx_SetVoiceFreq
            dw       offset mx_GetVoiceFreq
            dw       offset mx_PlayVoice
            dw       offset mx_StopVoice
            dw       offset mx_SetGlobalVolume
            dw       offset mx_SetAmplification
            dw       offset mx_DoPoll_stereo
            dw       offset aria_SetMasterVolume
            dw       offset aria_TickAwaited

; Internal data 

aria_Freq   dw       11025     ; x=0
            dw       22050     ; x=1
            dw       44100     ; x=2

aria_Mode     dw       1         ; 22050 kHz
aria_BuffOffs dw       0
aria_busy     dw       0

;
;   StartMixer (DX=Mixing speed, AX=# of voices)
;

nproc   aria_StartMixer

        ClipVoices 4, 32
        mov      cs:mxVoices,ax        ; Store max # of active voices

        call     ariaChooseFreq

        and      edx,0FFFFh
        mov      cs:cmixspd,dx
        add      edx,edx
        mov      cs:mxMixSpd,edx

        mov      cs:dmAutoInit,1       ; autoinit-dma mode (obsolete)
        mov      cs:aria_BuffOffs,0
        mov      cs:aria_Busy,0

        call     mxBuildPeriods_stereo ; Build the periods table
        call     mxBuildProcTab_stereo ; Build the Post-Processing Table
        call     mxInitVars_stereo     ; Init all internal counters

        call     ariaInit
        mov      dx,offset aria_MainIRQ
        call     irqRedirectIRQ
        call     ariaSetAudioFormat
        call     ariaStartPlayback     ; Start DSP

        retn
nendp   aria_StartMixer

;
;   StopMixer ()
;

nproc   aria_StopMixer
        push     ax
        call     ariaStopPlayback
        call     irqRestoreIRQ
        call     ariaReset
        pop      ax
        retn
nendp   aria_StopMixer

;
;   Main IRQ routine
;

nproc   aria_MainIRQ
        pushf
        cli
        push     ax bx cx dx

        mov      dx,cs:mxPort
        in       ax,dx
        cmp      ax,1     ; Aria's DSP-generated irq ?
        jne      amie22

        cmp      cs:aria_Busy,1
        je       amie22

        mov      cs:aria_Busy,1

        mov      bx,7C00h ; 8000h-512*2
        add      dx,4
        mov      ax,6100h
        out      dx,ax    ; set DSP address
        add      dx,2
        in       ax,dx    ; get FIFO-Buffer offset for playback
        add      ax,bx
        sub      dx,2     ; base+4
        out      dx,ax    ; set FIFO address

        mov      cx,512   ; transfer a full packet
        add      dx,2     ; base+6

        push     ds si

        mov      si,cs:aria_BuffOffs
        mov      ds,cs:mxDMAbuf1

amie3:  and      si,3FFFh       ; **** only if mixahead-buffer is 16k !!! ****
        outsw                   ; write word into DSP RAM
        dec      cx
        sjnz     amie3

        mov      ax,10h
        call     ariaCommand    ; transfer completed
        mov      ax,0FFFFh
        call     ariaCommand    ; command terminator

        mov      cs:aria_BuffOffs,si  ; update offset

        pop      si ds

        mov      cs:aria_Busy,0

amie22: mov      al,20h
        out      20h,al         ; primary controller EOI
        cmp      cs:mxIRQ,8
        sjb      amie21
        out      0A0h,al        ; secondary controller EOI

amie21: pop      dx cx bx ax
        sti ; Quite useless ...
        popf
        iret
nendp   aria_MainIRQ

;
;   SetMasterVolume ( AL=volume (0-255) )
;

nproc   aria_SetMasterVolume
        push     dx ax
        mov      ax,0004h      ; "set master volume"
        call     ariaCommand
        pop      ax
        push     ax
        mov      ah,al
        shr      ax,1   ; (0-7FFFh)
        call     ariaCommand   ; LEFT volume
        call     ariaCommand   ; RIGHT volume
        mov      ax,0FFFFh
        call     ariaCommand   ; command terminator
        pop      ax dx
        retn
nendp   aria_SetMasterVolume


; Other routines 

nproc   ariaChooseFreq       ; In: DX=user's mixing freq

        push     ax cx dx si di

        mov      ax,0FFFFh ; distance

        mov      si,offset aria_Freq
        mov      di,offset aria_Freq + 2  ; default = 22050 Hz

        mov      cx,3

acf1:   push     dx
        cmp      dx,cs:[si]
        sjae     acf4
        push     ax
        mov      ax,cs:[si]
        sub      ax,dx
        mov      dx,ax
        pop      ax
        jmp      short acf2
acf4:   sub      dx,cs:[si]
acf2:   cmp      dx,ax     ; smaller distance ?
        sja      acf3
        mov      ax,dx     ; store new distance
        mov      di,si     ; store offset
acf3:   pop      dx
        add      si,2
        loop     acf1
        mov      dx,cs:[di] ; reload freq
        sub      di,offset aria_Freq
        shr      di,1
        mov      cs:aria_Mode,di
        pop      di si dx cx ax
        retn
nendp   ariaChooseFreq


nproc   ariaInit       ; switch soundcard to ARIA native mode

        push     ax ecx dx

        mov      dx,cs:mxPort
        add      dx,2
        mov      ax,0C8h
        out      dx,ax     ; PCM audio, 22kHz

        add      dx,2      ; base+4
        mov      ax,6102h
        out      dx,ax     ; set DSP address

        add      dx,2      ; base+6
        mov      ax,0
        out      dx,ax     ; clear task init flag

        mov      ax,0
        call     ariaCommand
        mov      ax,0
        call     ariaCommand
        mov      ax,0
        call     ariaCommand
        mov      ax,0
        call     ariaCommand
        mov      ax,0FFFFh
        call     ariaCommand

        mov      dx,cs:mxPort
        add      dx,4     ; ADDR port

        mov      cx,0FFFFh

ai1:    mov      ax,6102h
        out      dx,ax    ; set DSP address

        add      dx,2
        in       ax,dx    ; read DSP memory location

        sub      dx,2

        cmp      ax,1     ; 1 = "DSP task initialized"
        sje      ai2
        loop     ai1

        pop      dx ecx ax  ; DSP task was NOT initialized !
        retn  ; error!

ai2:    mov      dx,cs:mxPort
        add      dx,2
        mov      ax,0CAh
        out      dx,ax      ; complete Aria init

    ; set the size of a digital audio packet (in words!)

        mov      ax,5
        call     ariaCommand   ; "set dig. audio packet size"
        mov      ax,512
        call     ariaCommand   ; 512 words = 1KB
        mov      ax,0FFFFh
        call     ariaCommand   ; command terminator

        pop      dx ecx ax
        retn
nendp   ariaInit

nproc   ariaCommand       ; In: AX=command
        push     cx dx ax
        mov      cx,0FFFFh
        mov      dx,cs:mxPort
        add      dx,2
ac1:    in       ax,dx     ; read STATUS port
        test     ax,8000h  ; bit 15 = DSP 16-bit DATA port busy(1)/ready(0)
        sjz      ac2
        dec      cx
        sjnz     ac1
        pop      ax dx cx
        retn
ac2:    sub      dx,2      ; COMMAND port
        pop      ax
        out      dx,ax     ; send command
        pop      dx cx
        retn
nendp   ariaCommand

nproc   ariaSetAudioFormat
        push     ax dx
        cmp      cs:cMixSpd,22050
        sjbe     asaf1        ; freq. of 44100 Hz requires additional commands...
        mov      ax,6         ; set playback mode
        call     ariaCommand
        mov      ax,0         ; ... to 0 (4mono/2stereo/no synthesis)
        call     ariaCommand
        mov      ax,0FFFFh    ; command terminator
        call     ariaCommand
        mov      dx,cs:mxPort
        add      dx,2
        mov      ax,8Ah
        out      dx,ax
asaf1:  mov      ax,0003h     ; "set digital audio format"
        call     ariaCommand
        mov      ax,cs:aria_Mode
        shl      ax,4
        or       ax,0001h     ; 8-bit stereo, spec. frequency
        call     ariaCommand
        mov      ax,0FFFFh
        call     ariaCommand  ; command terminator
        pop      dx ax
        retn
nendp   ariaSetAudioFormat

nproc   ariaStartPlayback
        push     ax
        mov      ax,0011h      ; start playback
        call     ariaCommand
        mov      ax,0000h      ; hardware channel 0 (stereo)
        call     ariaCommand
        mov      ax,0FFFFh     ; command terminator
        call     ariaCommand
        pop      ax
        retn
nendp   ariaStartPlayback

nproc   ariaStopPlayback
        push     ax
        mov      ax,0012h      ; stop playback
        call     ariaCommand
        mov      ax,0000h      ; hardware channel 0 (stereo)
        call     ariaCommand
        mov      ax,0FFFFh     ; command terminator
        call     ariaCommand
        pop      ax
        retn
nendp   ariaStopPlayback

nproc   ariaReset
        push     ax dx
        cmp      cs:cMixSpd,22050
        jbe      ar1
        mov      ax,6         ; set playback mode
        call     ariaCommand
        mov      ax,2         ; ... to 2 (2mono/1stereo/32synthesis)
        call     ariaCommand
        mov      ax,0FFFFh    ; command terminator
        call     ariaCommand
        mov      dx,cs:mxPort
        add      dx,2
        mov      ax,0CAh
        out      dx,ax
ar1:    mov      dx,cs:mxPort
        add      dx,2
        mov      ax,0040h
        out      dx,ax        ; switch to SB-emu mode

  ; ARIA SDK claims that the card should be initialized again in SB-emu mode
  ; Daniel Tauritz's program doesn't do something like this... shit knows
  ; why. So the following part may be wrong...

;---------------------------------------------------------------------[???]--
        mov      ax,0      ; ID 00h = "Init DSP"
        call     ariaCommand
        mov      ax,0
        call     ariaCommand
        mov      ax,0001h  ; SB-emu(default)!
        call     ariaCommand
        mov      ax,0
        call     ariaCommand
        mov      ax,0FFFFh ; command terminator
        call     ariaCommand
;---------------------------------------------------------------------[???]--

        pop      dx ax
        retn
nendp   ariaReset

nproc   aria_TickAwaited
        push     ax
        mov      ax,cs:mxLastDmaPositionUsed
        sub      ax,cs:aria_BuffOffs
        sjge     ata1
        add      ax,DMABufSize*16
ata1:   shr      ax,2
        cmp      ax,cs:mxMaxMix
        sjae     ata2
        pop      ax
        clc  ; awaited!
        retn
ata2:   mov      cs:mxLastDistance,0 ; reset auto-correction flag
        pop      ax
        stc  ; not awaited!
        retn
nendp   aria_TickAwaited
