;     Ŀ
;        Sound Deluxe System 5, a Maple Leaf production               
;        1996-1997                                                    
;           
;        Global data (common to the whole SDS)                        
;           
;        You will surely find out many _BUGx_ variables spread        
;        everywhere around. Well, they were put there when I still    
;        believed in the even-address tricks on 386/486... they       
;        can be removed without problems.                             
;     

;--< Tables >---------------------------------------------------------------
FreqTab          dd       1800 dup(0)  ; Max 1800 periods admited
PostTab          db       MaxChannels*256 dup(0); Post-Processing Table for max N channels
AmplifTab        db       256 dup(0)   ; Amplification table

Pitch            dw       1712, 1616, 1524, 1440, 1356, 1280, 1208, 1140, 1076, 1016, 960,  912
                 dw       856,  808,  762,  720,  678,  640,  604,  570,  538,  508,  480,  453
                 dw       428,  404,  381,  360,  339,  320,  302,  285,  269,  254,  240,  226  ; <- "C2" !
                 dw       214,  202,  190,  180,  170,  160,  151,  143,  135,  127,  120,  113
                 dw       107,  101,  95,   90,   85,   80,   75,   71,   67,   63,   60,    56
                 dw       53,   50,   47,   45,   42,   40,   37,   35,   33,   31,   30,    28 ; <-extended octave, for ST3 compatibility
                 dw       26  ; (extended, only for B-6 correct vibrato)
;--< DMA >------------------------------------------------------------------

DmaPageReg       dw       0087h        ; Page register for DMA channel #0
                 dw       0083h        ; Page register for DMA channel #1
                 dw       0081h        ; Page register for DMA channel #2
                 dw       0082h        ; Page register for DMA channel #3
                 dw       0000h        ; Page register for DMA channel #4 (used only by FD Controller)
                 dw       008bh        ; Page register for DMA channel #5
                 dw       0089h        ; Page register for DMA channel #6
                 dw       008ah        ; Page register for DMA channel #7

;--< Ticks-specific variables >---------------------------------------------

TicksPerSec      dw       50           ; Default = 50 ticks per second
ArpSpeed         dw       0            ; Arpeggio-tick speed
TickSpeed        dw       0            ; Logical ticks speed
PortamentoXor    db       0            ; not tick-specific, but ...
_bug_99_         db       0
TimerSpeed       dw       0            ; 1234DCh/TicksPerSecond

;--< Module-specific variables >--------------------------------------------

SpeedCounter     dw       6            ; counter
ArpTC            dw       0            ; arpeggio counter

Patterns         dw       0            ; # of patterns
Entries          dw       0            ; # of entries in song order
Samples          dw       0            ; # of instruments (samples)
Channels         db       4            ; # of channels

RestartRow       db       0            ; where to restart from when Cxx encountered

S_Order          dw       0            ;* used by sds_startplay() si
S_Row            dw       0            ;* de sds_startfromposition()
S_Module         dd       0            ;*
S_InitSpd        dw       0            ;*
S_MixSpeed       dw       0            ;*
S_PAL            dw       0            ;*

PattAddrTabPtr   dd       ?            ; Pointer to Pattern Addresses Table
PattSizeTab      db       256 dup(64)  ; Lines per pattern for each pattern

Order            db       256 dup(0)   ; Orders

SVol             db       256 dup(0)   ;\
SC2Spd           dw       256 dup(0)   ; |
SAddress         dd       256 dup(0)   ; | Samples' specific parameters
SSize            dw       256 dup(0)   ; |
SLoopStart       dw       256 dup(0)   ; |
SLoopEnd         dw       256 dup(0)   ;/

;--< Others >---------------------------------------------------------------

IsPlaying        db       0            ; "Playing/Not Playing" flag
ExistEffects     db       0            ; Effects flag
mustBreak        db       0            ; must break pattern?
_bug_xx_         db       0

;--< these were previously in SDS.ASM >-------------------------------------

CCard            dw       7            ; Current card (def.= no sound)
Func             dw       0            ; Functions table offset. A stoopid initialization.
FreqMod          dw       0            ; Default = NTSC
FMod             dd       3579545      ; NTSC magic / 2
                 dd       3546895      ; PAL magic / 2
cMixSpd          dw       22050        ; Current Mixing Speed. !!! When stereo, cmixspd = NormalMixSpd/2, except for GUS !!!

;--< Effects-specific variables >-------------------------------------------

TremoloOrig      dd       MaxChannels dup(0)

ToNoteAttended   dd       MaxChannels dup(0)
ToNoteSpeed      db       MaxChannels dup(0)

BPara            db       MaxChannels dup(0)
BPara2           db       MaxChannels dup(0)

WPara            dd       MaxChannels dup(0)
WPara2           dd       MaxChannels dup(0)

RTTicks          db       MaxChannels dup(0) ; Retrig-Tremor-Arpeggio control counters
                                             ; (these 3 effects share the
                                             ; same control data)

VibratoAmpl      dd       MaxChannels dup(0)
VibratoOrig      dd       MaxChannels dup(0)
VibratoStep      db       MaxChannels dup(0)
VibratoIndex     db       MaxChannels dup(0)

COffs            db       MaxChannels dup(0)
