;                            Sound Deluxe System 5
;                           by Maple Leaf, 1996-1997
;
; --<<<< External Syncronization Block >>>>---------------------------------
; This is a block of data which is permanently updated during the play.
; Its start address can be found in memory at address 0:[4FCh] (4 bytes).
;
;  Notes meaning:
;     RW = Mainly read. May be written, but has no effect
;     WR = Read/Write (has effect if overwritten)
;     R  = read only
;     R! = READ ONLY ! Serious damages might occur if it's overwritten by user
;

;Ŀ
ExtSyncrBlock: ;  The order SHOULD NOT be changed !
;

; NAME           WHAT?    DEF.VAL   NOTE  REL.OFFS   COMMENT
;------------------------------------------------------------------------------------------------
DoPollAddr       dd       0         ;R!;  0        ; SDS_Poll() routine address
Semaphores       db       16 dup(0) ;RW;  4        ; 16 semaphors. Increased w/ effect Z1x (x=0-F)
CEntry           dw       0         ;R ;  20       ; Current entry
CPattern         dw       0         ;RW;  22       ; Current pattern
CLinesPerPatt    dw       64        ;WR;  24       ; Max lines for current pattern
CRow             dw       0         ;RW;  26       ; Current row in the pattern
AllowBPM         db       1         ;WR;  28       ; Allow BPM changes - flag
AllowPanning     db       1         ;WR;  29       ; Allow panning changes - flag
GlobalVolume     db       40h       ;RW;  30       ; Global volume = MAX
MasterVolume     db       0FFh      ;RW;  31       ; Master volume for SB/SBPro/SB16/PAS (0FFh=max)
AmplPercent      dw       0         ;R ;  32       ; Amplification percent
SurroundMode     db       1         ;WR;  34       ; Surround mode (1=on, 0=off)
SDS_Flags_1      db       0         ;RW;  35       ; 8 flags, (bit=1=on) :
                                                   ;  bit:   0 : Song has finished (at least) once (1)
                                                   ;         1 : SDS is playing (1) or not (0)
                                                   ;         2 : SDS is PAUSED (1=paused)
                                                   ;      rest : unused
Speed            dw       6         ;R ;  36       ; Song's speed
BPM              dw       7Dh       ;R ;  38       ; Song's BPM based tempo
RowPtr           dd       0         ;R!;  40       ; pointer to current row
ServRoutAddr     dd       0         ;R!;  44       ; Services routine address
PollMod          db       0         ;R!;  48       ; 1=poll, 0=timer
ChannelsStatus   dd       0FFFFFFFFh;WR;  49       ; status (on/off) for each channel (a bit of 1 = on)
UserCounter      dd       0         ;RW;  53       ; user counter, incremented BPM*2/5 times per second
StereoMode       db       0         ;R ;  57       ; 0=mono mode, 1=stereo mode
MixAheadDistance dw       0         ;RW;  58       ; Reserved. (distance in bytes between mix-ahead ptr and DMA ptr) - (it's probable that it won't exist in the future versions)
Signature        dd       0         ;WR;  60       ; pointer to ASCIIZ string (SDS-name and author)
SDS_Magic        db       "SDS5"    ;RW;  64       ; magic sequence. (used for ESB identification by external programs)
ArpeggioMode     db       1         ;RW;  68       ; 0=slow arpeggio, 1=fast arpeggio (ST3,UT1.6)
fx_channels      db       0         ;WR;  69       ; number of fx channels. incremented by sds_fx_openchannel()
fx_startchn      db       0         ;R!;  70       ; FX start channel (=song's channels)

Unused_Yet_      db       37 dup(0) ;  ;  71       ; unused (yet), reserved for future developement

CSam             db    32 dup(0FFh) ;R!;  108      ; Currently playing instruments
CNote            db       32 dup(0) ;R!;  140      ; Currently playing notes
CVol             db       32 dup(0) ;RW;  172      ; Currently playing volumes
VRI              db       32 dup(0) ;R ;  204      ; Voice Repartition Info (panning)
Event            db       160 dup(0);R!;  236      ; Current event (row), unpacked

;--< Voice-specific variables >---------------------------------------------

VoiceVol         dd       32 dup(0) ;R ;  396      ; Volumes
VoiceFreq        dd       32 dup(0) ;R ;  524      ; Frequencies
VoicePeriod      dd       32 dup(0) ;R ;  652      ; Periods
VoiceSize        dd       32 dup(0) ;R!;  780      ; Sizes
VoiceLoopStart   dd       32 dup(0) ;R ;  908      ; Loop-Start points
VoiceLoopEnd     dd       32 dup(0) ;R ;  1036     ; Loop-End points
VoicePos         dd       32 dup(0) ;R ;  1164     ; LoWord = counter, HiWord = Positions
VoiceSeg         dd       32 dup(0) ;R!;  1292     ; Start segments

; future versions will probably have here other info ...
