{
    Sound Deluxe System 5, a Maple Leaf production, 1996-1997
    Pascal demo for poll-mixing

    This program is freeware, you may do whatever you want with it, you
    may even sell it to your grandmother, as long as you give some little
    credits to Maple Leaf in your wonderful production.
}

{$m 20000,0,0}  {don't forget to reduce the heap!}

{$define polled}                                                                                                (**)
uses xmode,crt;

var poll,api : pointer;
    magic    : longint;

(*==========================================================================*)
(* Very-very-very simple SDS external interface                             *)
(*==========================================================================*)

procedure init_poll;near;assembler;
{reads SDS API entry point and POLL routine far address}
asm
  mov ax,0
  mov es,ax
  les di,dword ptr es:[4fch]
  db 66h; mov ax,word ptr es:[di]
  db 66h; mov word ptr poll,ax      {poll routine address}
  db 66h; mov ax,word ptr es:[di+44]
  db 66h; mov word ptr api,ax       {sds api entry point}
  db 66h; mov ax,word ptr es:[di+64]
  db 66h; mov word ptr magic,ax     {"SDS5" magic}
end;

procedure timer_mode;near;assembler;
{switches SDS to TIMER mode using API service #5}
asm
  mov ax,500h
  call dword ptr api
end;

procedure poll_mode;near;assembler;
{switches SDS to POLL mode using API service #5}
asm
  mov ax,501h
  call dword ptr api
end;

procedure slide_vol;near;assembler;
{slides volume down with one unit - must be called several times to turn it off}
asm
  mov ah,7
  call dword ptr api
end;

(*==========================================================================*)
(* Mode X init/uninit, palette and other shits                              *)
(*==========================================================================*)

procedure init_xmode;
var pal:array[byte] of record r,g,b:byte end;
    a:word;
begin
  xinitvideo(0);
  xclrvram;
  for a:=1 to 255 do with pal[a] do begin
    r:=Trunc(63-63*a/255);
    g:=Trunc(63*a/255);
    b:=Trunc(30*a/255);
  end;
  with pal[0] do begin
    r:=0; g:=0; b:=0;    {because they're onto the stack...}
  end;
  xsetpalette(@pal);
  xsetvpage(0);
end;

procedure done_xmode;
begin
  xtextmode(25);
  writeln('Pascal demo program for polling music using SDS, by Maple Leaf, 1997');
end;

(*==========================================================================*)
(* Kind of a simple "plasma" builder                                        *)
(*==========================================================================*)

function plasma(a,b:integer):byte;
var aa,bb:real;
begin
  aa:=a/200; bb:=b/320;
  plasma:=trunc(128+100*sin(aa*2*pi)*cos(bb*2*pi)+
                    27*cos(aa*7*pi)*cos(bb*pi/30) );
end;

procedure init_plasma;
var a,b:integer;
begin
  for a:=0 to 199 do
    for b:=0 to 319 do
      xplot(b,a,plasma(a,b),0);
end;

(*==========================================================================*)
(* This is the scrolling part with POLL mixing in background                *)
(*==========================================================================*)

procedure scroll_demo;
var row,delta,sld:word; cvol:byte;
begin
  row:=0;
  delta:=1;
  repeat
{$ifdef polled}
    asm call dword ptr poll end; {right before waiting for a vertical retrace
                                  to start, we have a lot of dead time which
                                  can be used by SDS to keep up the music.
                                  This is the right time for calling the POLL
                                  routine}
{$endif}
    xvwait;
    xsplit(row shl 2);
    row:=row+delta;
    if row>100 then delta:=-delta
  until port[$60]=1;

{$ifdef polled}

  {ESC was pressed. Continue the animation while sliding down the volume}

  sld:=0;
  repeat
    asm call dword ptr poll end; {poll mix}
    xvwait;
    xsplit(row shl 2);
    row:=row+delta;
    if row>100 then delta:=-delta;
    inc(sld);
    if sld and 3 = 0 then slide_vol; {slide volume}
    {read global volume}
    asm
      mov ax,0
      mov es,ax
      les di,dword ptr es:[4fch]   {ESB address in ES:DI}
      add di,30                    {offset of 'GlobalVolume' field in ESB}
      mov al,es:[di]               {read gvolume}
      mov cvol,al                  {and save it}
    end;
  until cvol=0;  {stop when volume is zero}

  {and, because the mixing is about 1/4 second earlier than what you hear,
   we need a short time here, to allow SDS slide the volume completely}

  sld:=0;
  repeat
    asm call dword ptr poll end; {poll mix}
    xvwait;
    xsplit(row shl 2);
    row:=row+delta;
    if row>100 then delta:=-delta;
    inc(sld)
  until sld=100; {stop it after a while}

{$endif}

end;


begin

{$ifdef polled}
  init_poll;    {read POLL routine address and API entry point}
  if magic<>$35534453 then begin
    writeln('SDS background session not found. Run batch file _PASCAL!.BAT');
    halt;
  end;
{$endif}

  init_xmode;   {init 320x200x256/4 and set a gradient palette}

{$ifdef polled}
  timer_mode;   {switch SDS to TIMER mode, because a slow shit follows}
{$endif}

  init_plasma;  {this is the slow shit... plasma generator}

{$ifdef polled}
  poll_mode;    {SDS can be switched to POLL mode now.}
{$endif}

  scroll_demo;  {a simple scroll while polling music}
  done_xmode;   {back to text mode}
end.