//****************************************************************************
//  Sound Deluxe System 5, a Maple Leaf production, 1996-1997
//  Borland C++ 3.1 minidemo for external poll-mixing
//****************************************************************************
// This program is freeware, you may do whatever you want with it, you
// may even sell it to your grandmother, as long as you give some little
// credits to Maple Leaf in your wonderful productions.
//
// sorry for so many assembler parts...
// this is maple leaf. :-)  i guess my brain was made in assembler, too! :-|)
//
// compile it with SMALL or MEDIUM memory model !
//****************************************************************************
// ... and btw...  compare the ways in which this small intro works in POLL
// and TIMER mode! You'll be amused (I was!).
//****************************************************************************

#define polled

//*** included files *********************************************************
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
//****************************************************************************

//*** types defs, data and others ********************************************
typedef unsigned int word;
typedef unsigned char byte;
typedef struct { byte width,height; } size;

const start_line = 32;
char  text[512] =
"MAPLE LEAF PRESENTS ...   ...   ...   ...   ...   \
SOUND DELUXE SYSTEM 5.04  -  \
THE ULTIMATE SOUNDSYSTEM !    \
DESIGNED TO HELP ANY DEMOCODER IN HIS WORK !   \
START TO USE IT RIGHT NOW, IT IS ... -FREE- ... !   \
THIS LITTLE INTRO SHOULD TELL YOU ENOUGH ABOUT SDS \
CAPABILITIES...  DO NOT HESITATE !!!  . . . . . . . . .               \
~";  // MUST end with '~' !!!

word coffs[256];  // offsets
size cdim [256];  // dimensions (width/height)
byte pal[768];    // palette
word fontsize;    // font size
byte font[40000]; // font data

//***************************************************************************
// Extremely simple SDS interface (only the BASIC stuff needed for polling)
//***************************************************************************

unsigned long poll, api;   // addresses

// tests if SDS is playing in background (poll/timer)
void sds_findsession() {
  asm {
    push es
    mov ax,0
    mov es,ax
    les di,dword ptr es:[0x4fc]    // ESB address in ES:DI now
    mov ax,es:[di+66]              // field 64 (dword) = "SDS5" if active
    cmp ax,0x3553  // "SD"         // is it there ?
    jne no_sds                     // if nope, go shoot yourself
    mov ax,es:[di]
    mov word ptr poll,ax
    mov ax,es:[di+2]
    mov word ptr poll[2],ax        // polling routine address
    mov ax,es:[di+44]
    mov word ptr api,ax
    mov ax,es:[di+46]
    mov word ptr api[2],ax         // api services routine address
    pop es
    // switch SDS to POLL mode using API service #5
    mov ax,0x501
    call dword ptr api
  }
  return;
no_sds:
  asm pop es
  printf("Sorry, I cannot find an active SDS session. Run _BC31!.BAT batch file.\n");
  exit(-1);
}

void sds_poll() {
  asm call dword ptr poll
}

//***************************************************************************
// mode-X vga shits. only 320x200x4/256
//***************************************************************************

byte xpara[47] = { 0x063,0,0x05f,1,0x4f,2,0x50,3,0x82,4,0x54,5,0x80,6,0xbf,7,0x1f,0x10,0x9c,
		   0x11,0x8e,0x12,0x8f,0x15,0x96,0x16,0xb9,9,0x41,0x14,0,0x17,0xe3,0xa0,0xf,
		   0x40,1,0xc8,0,0,0,0x80,0x3e,0,0x7d,0x80,0xbb };


// sets the video memory's start address
void x_SetStartAddress(word offs) {
  asm {
    mov bx,word ptr offs
    mov dx,0x3d4
    mov al,0x0c
    mov ah,bh
    out dx,ax
    mov al,0x0d
    mov ah,bl
    out dx,ax
  }
}

// enables all the four planes
void x_EnableAll() {
  asm {
    mov dx,0x3c4
    mov ax,0xf02
    out dx,ax
  }
}

// changes the red, green and blue composition for a palette entry
void x_setrgb(byte col,byte r,byte g,byte b) {
  outp(0x3c8,col);
  outp(0x3c9,r);
  outp(0x3c9,g);
  outp(0x3c9,b);
}

// sets a given palette
void x_SetPalette(byte* pal) {
  for (int k=0; k<256; k++)
    x_setrgb(k,*(pal+3*k),*(pal+3*k+1),*(pal+3*k+2));
}

// initializes the 320x200/256 4-pages VGA mode ("mode-x")
void x_ModeX() {
  asm {
    mov ax,0x13
    int 0x10      // bios init
    mov dx,0x3c4
    mov ax,0x604
    out dx,ax     // chain 4 mode off
    mov ax,0x100
    out dx,ax	  // async reset
    mov si,0
    mov al,byte ptr xpara[si]
    mov dx,0x3c2
    out dx,al     // set timing/size
    mov dx,0x3c4
    mov ax,0x300
    out dx,ax	  // restart sequencer
    mov al,0x11
    mov dx,0x3d4
    out dx,al     // select vertical retrace end reg
    inc dx
    in al,dx
    and al,0x7f   // mask out write protect
    out dx,al
    dec dx
    inc si
    mov cx,16
  }
  loop1:
  asm {
    mov ax,word ptr xpara[si]
    add si,2
    out dx,ax
    loop loop1
    mov ax,word ptr xpara[si+2]   // xmax
    shr ax,3
    mov ah,al
    mov al,0x13
    out dx,ax     // vga crtc offset reg, et voila! we're in x-mode!
  }
}

// restores the text mode
void x_Text() {
  asm {
    mov ax,3
    int 0x10
  }
}

// waits for vertical retrace
void x_retrace() {
  asm mov dx,0x3da
  l1:  asm { in al,dx
	     test al,8
	     jnz l1 }
  l2:  asm { in al,dx
	     test al,8
	     jz l2 }
}

// clears the video memory
void x_ClearVideoMemory() {
  asm {
    push es
    push di
    mov ax,0x0a000
    mov es,ax
    mov di,0
    mov cx,16384
    db 0x66; mov ax,0; dw 0 // background colour = 0 !!!
    db 0x66; rep stosw
    pop di
    pop es
  }
}

//****************************************************************************
// font "manager" - sounds like windows...   :-(
//****************************************************************************

// Font Maker 2.0 file format:
//
//    offset   size(bytes)     meaning
//    ---------------------------------------------------------
//     +0          4	       magic sign "FM20"
//     +4          28          font name
//     +32         256*2       chars offsets in file (256 words)
//     +544        256*2       chars dimensions (width,height,width,height...)
//     +1056       256*3       palette (r,g,b,r,g,b,...)
//     +1058       2           font data size
//     +1826       ???         font data


void font_load(char *name) {
  FILE *fontfile;
  if ((fontfile=fopen(name,"rb"))==NULL) {
    printf("Sorry, pal. Cannot find the font data file.\n");
    exit(-1);
  }
  fseek(fontfile,32L,0);        // skip the magic and name.. assuming they're okay
  fread(&coffs,2,256,fontfile); // read offsets
  fread(&cdim,2,256,fontfile);  // read dimensions
  fread(&pal,768,1,fontfile);   // read palette
  fread(&fontsize,2,1,fontfile);      // read size
  fread(&font,fontsize,1,fontfile);   // read font data
  fclose(fontfile);
  for (int k=0; k<256; coffs[k++]-=1826);  // compute rel offsets (in memory)
}

//****************************************************************************
// scroll routine. enjoy.
//****************************************************************************

const start_offs = start_line*80 + 78;
int   charidx=0,col=0;
word  offs = 0;
byte  coldata[257];

void draw_column() {  // uses 'offs', 'charidx' and 'col' vars !

  // extract char dimensions, used later

  int dimx = cdim[text[charidx]].width;
  int dimy = cdim[text[charidx]].height;

  // bad char info ?
  if ((dimx>80)||(dimx<=0)||(dimy<=0)||(dimy>50)) {
    // just clear the column in this case
    asm {
      mov ax,0xa000
      mov es,ax
      mov di,start_offs
      add di,offs
      sub di,80
      mov cx,dimy
      shl cx,2
      inc cx
      mov al,0
      mov dx,320
    }
    loop3:
      asm {
	mov es:[di],al
	add di,dx
	dec cx
	jnz loop3
      }
    return;
  }

  // extract a column of pixels from the font data and
  // store it into 'coldata' table

  asm {
    mov bx,charidx
    mov bl,byte ptr text[bx]
    mov bh,0
    add bx,bx
    mov bx,word ptr coffs[bx]
    add bx,col
    mov di,offset coldata
    mov cx,dimy
    mov dx,dimx
  }
  loop1:
    asm {
      mov al,byte ptr font[bx]
      mov byte ptr [di],al
      add bx,dx
      inc di
      dec cx
      jnz loop1
    }

  // 'coldata' has been filled with 'dimy' bytes (starting from 0)
  // it's now time to write down these fuckin bytes as groups of
  // four pixels (4x4), in the rightmost part of the screen

  asm {
    push es
    push si
    push di
    push cx
  }

  asm {
    mov ax,0xa000
    mov es,ax

    // first clear the upper part
    mov di,start_offs
    add	di,offs
    sub di,80
    mov byte ptr es:[di],0

    // now draw the text column
    mov si,offset coldata
    mov di,start_offs
    add	di,offs
    mov cx,dimy
    mov dx,320
  }
  loop2:
    asm {
      lodsb
      mov es:[di],al
      mov es:[di+80],al
      mov es:[di+160],al
      mov es:[di+240],al
      add di,dx
      dec cx
      jnz loop2
    }

  asm {
    pop cx
    pop di
    pop si
    pop es
  }

}

void do_scroll() {
  offs = 0;
  x_EnableAll();  // enable all planes

  do {
#ifdef polled
    sds_poll();   // right before waiting for the vertical retrace, the
		  // program still has a lot of time which is normally not
		  // used. this is the right moment for polling music!
#endif
    x_retrace();
    x_SetStartAddress(offs);
    draw_column();
    if ( ++col >= cdim[text[charidx]].width ) {
      col=0;
      charidx++;
    }
    offs++;
  } while ((text[charidx]!='~')&&(inp(0x60)!=1));  // until end of txt or ESC

#ifdef polled
  if (text[charidx]=='~') return;
  // sliding down the volume...
  int k = 110;
  do {
    asm mov ah,7
    asm call dword ptr api    // slide vol using API service #7
    x_retrace();
    sds_poll();   // continue polling!
    x_retrace();
    sds_poll();   // continue polling! (the music is still kept up)
    k--;
  } while (k>0);
  // volume is now zero, no sound, no scream, no motherfucking dream...
#endif

}

//****************************************************************************
// main shit
//****************************************************************************

void main() {
#ifdef polled
  sds_findsession();			// tests if SDS, inits poll mode
#endif
  font_load("winter2.fm2"); 	        // load font
  x_ModeX();   				// init mode-x
  x_ClearVideoMemory();                 // get rid of garbage
  x_SetPalette(&pal[0]);     		// set font's palette
  do_scroll();				// minidemo part
  x_Text();    				// restores text mode
}