{$M 20000,0,0}  {don't forget to reduce the heap!}
uses sds, crt, alloc, esb, dos, sds_det, sdsetup;

{
  Sound Deluxe System 5, a Maple Leaf production, 1996-1997
  Background (shell) player
  * not intended for demos/intros! See POLL.PAS for such an example! *
}

var module  : pointer;
    a       : word;
    freq    : word;
    gain    : word;

    surmode : boolean;
    palmode : byte;

    parac, paras : string;

begin
  writeln('Ŀ');
  writeln('  Sound Deluxe System 5, a Maple Leaf production, 1996-1997      ');
  writeln('  Background player v1.1 (example program)                       ');
  writeln('    ');
  writeln('  For problems/questions concerning this program or any other    ');
  writeln('  part of Sound Deluxe System, please contact me.                ');
  writeln('');
  writeln;

  if paramcount=0 then begin
    writeln(#13#10'Usage: BGPLAYER module_name [executable_file [para1][para2]...[parax]]');
    writeln('Where module_name is the name of the module to play, and executable_file is the');
    writeln('filename of an executable file (EXE/COM/BAT) to be run while playing music.');
    writeln('The rest of the parameters are transmitted to the executable as its params.');
    writeln('If executable_file is ommited, then COMSPEC string is assumed (...\COMMAND.COM)');
    writeln('Example: BGPLAYER MY_SONG.MOD INTRO.EXE /nosetup /fast /lalala');
    halt;
  end;

  if paramcount>1 then
    parac:=paramstr(2)
  else
    parac:=getenv('COMSPEC');

  paras:='';
  if paramcount>2 then
    for a:=3 to paramcount do paras:=paras+paramstr(a)+' ';


  {default values}
  card:=Silence; UseEMS:=true; UseUMB:=true; surmode:=on; palmode:=NTSC; gain:=110;
  sds_setup(card,irq,dma,base,freq,gain,palmode,surmode,UseEMS,UseUMB);

  {maybe ESC has been pressed...}
  if ESC_WAS_PRESSED then begin
    writeln('ESC was pressed during setup.');
    halt;
  end;

  sds_init(card,base{BasePort},irq{IRQ},dma{DMA#});

  UseEMS:=true;
  UseUMB:=true;
  module:=sds_load(paramstr(1),Card<>Silence);

  if loaderror<>0 then begin
    writeln('Error loading module (errorcode=',loaderror,')');
    sds_done;  {dont forget to close SDS before exit!}
    halt
  end;

  writeln;
  textattr:=15;
  writeln('"',ModuleName,'"');
  textattr:=10;
  writeln(channels,' channels, ',patterns,' patterns, ',entries,' orders, ',Samples,' samples');
  textattr:=7;

  sds_setsurround(surmode);
  sds_setpollmix(false);
  sds_setamplification(gain);

  sds_startplay(module, 0{InitSpeed(0=auto)}, freq{MixSpeed}, palmode{1=Pal,0=NTSC});

  textattr:=14;
  write('Type EXIT to stop playing and return to parent process');
  textattr:=7;
  writeln('.'#13#10);

  swapvectors;
  exec(parac,paras);
  swapvectors;

  case doserror of
    2,3 : writeln('Error: file not found (',parac,')'#13#10);
    8 : writeln('Error: not enough memory to load executable file'#13#10);
  end;

  writeln('Stopping sound...'); sds_stopplay;
  writeln('Shuting down SDS ...'); sds_done;
  writeln('Unloading module ...'); sds_unload(module);

  if loaderror<>0 then writeln('Deallocation error.');
end.