/*************************************************************************\
*         RADCTEST - (c)1997 Zephyr/Plasm/DNS - No rights reserved        *
*                                                                         *
* Just a small test of RADC.ASM.  I could have made a LoadRadFile() func  *
* but i decided that you probably won't be loading a file anyway, so what *
* would the point be?  See RADC.ASM for more info.  Don't forget the      *
* credits! =P                                                             *
\*************************************************************************/

//And shayde thought HIS code was messy... =]

#include <alloc.h>
#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <dos.h>
#define banner "RADC v1.1 - (c)1997 Zephyr/Plasm/DNS"    //Title bar

void extern far StartRad(unsigned char far *RadPointer);//Start the rad
void extern far StopRad(void);                          //Stop the rad
void extern far SetMasterVolume(unsigned char VolPos);  //Set the volume
void extern far NextOrder(void);                        //Skip to next order
void extern far PrevOrder(void);                        //Rewind to last order
extern unsigned char NoteTrigger[9]; //0 if no note else volume of note (0-64)
extern unsigned char TimerMode;      //Timer mode (0=fast 50hz,1=slow 18.2hz)
extern unsigned int OrderPos;        //Current order playing
extern unsigned int OrderSize;       //Total number of orders
extern unsigned char Line;           //Current line playing (of 64 lines)
extern unsigned char MasterVolume;   //Master volume - dont write to this! :)

unsigned long filesize(char *filename) //Function to return filesize of
{                                      //filename
	struct find_t ffblk;
	unsigned long done;
	done = _dos_findfirst(filename,_A_NORMAL,&ffblk);
	if (done)
		return 0;
	else
		return ffblk.size;
}

void flushkbd(void) //Flush keyboard buffer
{
	asm mov ax,0x40
	asm mov es,ax
	asm mov di,0x80
	asm mov ax,word ptr es:[di]
	asm mov di,0x1a
	asm mov word ptr es:[di],ax
	asm mov di,0x1c
	asm mov word ptr es:[di],ax
}

void main(int argc,char *argv[])        //er... main? :)
{
	unsigned char far *RadPointer;      //pointer to rad file in memory
	FILE *radfile;                      //file pointer
	long radsize=0;                     //size of rad
	int i,x,y;                          //index,x screen pos, and y screen pos
	unsigned char Volume=64;            //volume of music
	char ch;                            //place to store key presses
	char *TimerStr[2] = { "normal (50hz)", "slow (18.2hz)" };

	if (argc!=2)                        //Check for correct # of arguments
	{
		printf("%s\n",banner);
		printf("\nusage: RADC [filename]\n");
		exit(1);
	}

	radsize=filesize(argv[1]);	        //Get size of radfile

	if (!radsize)                       //Does the file exist?
	{                                   //If not, quit
		printf("%s\n",banner);
		printf("\nerror: cannot open file (%s)\n",argv[1]);
		exit(1);
	}

	if (!(RadPointer=farmalloc(radsize)))//Farmalloc memory for radfile
	{                                   //Quit if farmalloc failed
		printf("%s\n",banner);
		printf("\nerror: cannot farmalloc %ld bytes\n",radsize);
		exit(1);
	}

	radfile=fopen(argv[1],"rb");        //Open the radfile
	fread(RadPointer,radsize,1,radfile);//Read data into memory
	fclose(radfile);                    //Close the file
	StartRad(RadPointer);               //Start playing the music
	printf("%s - Timer mode: %s\n",banner,TimerStr[TimerMode]);                  //Print out the banner
	x=wherex();	y=wherey();             //Get current screen coordinates
	_setcursortype(_NOCURSOR);          //Kill the cursor
	flushkbd();                         //Flush the keyboard buffer
	ch=0xff;                            //Clear the key
	while (ch!=27)                      //Loop until key is pressed
	{
		gotoxy(x,y);
		printf("Playing %s - line: %d/63 - ord: %d/%d - vol: %d ",argv[1],Line,OrderPos,OrderSize-1,Volume,MasterVolume);

		if (kbhit())                    //Did user press a key?
			ch=getch();                 //If so.. get it
		switch (ch)                     //What was that key again?
		{
			case '+':                   //Oh, a plus?
				if (Volume<64)          //Then if the volume is less than 64
					Volume++;           //make it a bit louder...
				SetMasterVolume(Volume);//And tell RADC to set it
				ch=0xff;                //Clear the key
				break;                  //Continue playing
			case '-':                   //A minus??
				if (Volume>0)           //Well then, as long as the volume
					Volume--;           //isn't zero, make it a bit quieter
				SetMasterVolume(Volume);//And, of course, tell RADC to set it
				ch=0xff;                //Clear that key
				break;                  //Continue playing

			case 0:                     //Ack!  The key was ASCII 0?!
				ch=getch();             //Well.. there is prolly another key
										//to get then...
				switch(ch)              //Lets check to see what it was
				{
					case 77:            //Ah-Ha!  The right arrow key!
						NextOrder();    //Lets skip up one order
						ch=0xff;        //the usuall...
						break;          //yeah yeah..
					case 75:            //Oh wait, it was the LEFT arrow key
						PrevOrder();    //Better back up one order
						ch=0xff;        //blah
						break;          //bleck
				}
		}
	}
	_setcursortype(_NORMALCURSOR);      //Restore the cursor
	printf("\n");                       //Go down 1 line
	StopRad();                          //Stop the music
	farfree(RadPointer);                //Free the allocated memory
	flushkbd();                         //Flush keyboard buffer
}



