;  8-bit  - Write DSP command DA
;  16-bit - Write DSP command D9




;1) Limit SB Pro (stereo) mode to 22khz! But mono to 45...
;speed ups....larger DMA treshold?
;Search 'Voice volume' -- SBPRO.TXT sez it's Reigster4, but I see some ASM
;sez it's 2...and those examples use the filters!
;I used 4.

;POSSIBLE PROBLEMS FOR NO SOUND...
;1) Mixer not set correctly

;NO MOVEMENTS...
;1) IRQ error
;2) DMA error
;3) Command error (very likely)



;RULE OF THE THUMB FOR CHOOSING BETWEEN 8/16 BITS DMA TRANSFER.
;1) If user forced setting, go ahead.
;2) Else, if user didn't force setting, search for 8-bit DMA. If not present,
;   (unlikely), use 16-bit.
;   I may also try using 16-bit first..
;[]--------------------------------------------------------------------------[]
;| AUDIO MANAGER 3.0: SOUND BLASTER DRIVER by Kenneth Foo. 1994.              |
;[]--------------------------------------------------------------------------[]
.CSEG   AM
SDI_SB_INFO DB 'AUDIO MANAGER 3.0: SOUND BLASTER DRIVER 1.2 by Kenneth Foo. 1994/95.'
	DD_ALIGN
	SDIproc_SB      dw      _SBgetInfo
			dw      _SBdetect
			dw      _SBreset
			dw      _SBinit
			dw      _SBdeinit
			dw      _SBstart
			dw      _SBstop
			dw      _DSMpoll
			dw      _DSMsetUpdate
			dw      _DSMinitTrack
			dw      _DSMdeinitTrack
			dw      _DSMsetSample
			dw      _DSMsetVolume
			dw      _DSMsetFrequency
			dw      _DSMsetPanPos
			dw      _DSMsetOffset
			dw      _DSMkeyOn
			dw      _DSMkeyOff
			dw      _DSMallocMem
			dw      _DSMdeallocMem
			dw      _DSMloadSample
			dw      _DSMunloadSample
	SB SDIhardware <>
	OrigSBIRQ       dd      0               ;Original IRQ handler
	SDI_SB_BLASTER  DB 'BLASTER',0
	SDI_SB_PORT     DB 'A',0
	SDI_SB_IRQ      DB 'I',0
	SDI_SB_DMA8     DB 'D',0
	SDI_SB_DMA16    DB 'H',0
	SDI_SB_TYPE     DB 'T',0
	SDI_SB_Filter   DB 0,0,0        ;Output,Master,VoiceVol
	DW_ALIGN        ;16-BIT DMA USES ALIGN 2?
	;SDI_SBbuffer    db      2 dup(128)      ;SBpro L-R init buffer
	SDI_SBbuffer    db      0,0,1,0,-1      ;2 dup(128)      ;SBpro L-R init buffer

;
;_SB - Function dispatcher                                             
;
CODE_ALIGN
_SB     PROC    NEAR
	shl     bx,1
	jmp     SDIproc_SB[bx]
	ENDP
;
;_SBgetInfo - Get address of SB hardware info structure                
;OUT:  DX:AX=Hardware SDI structure address                            
;
_SBgetInfo PROC NEAR
	mov     dx,cs
	mov     ax,offset SB
	ret
	ENDP
;
;_SBdetect - Autodetect SB                                             
;OUT:  DX:AX=Hardware SDI structure address                            
;N:    Repeats detection 4 times while not-available flag is set...    
;
_SBdetect PROC NEAR USES CX
	mov     cx,4
	@@RepeatDetect:
	call    _SBdetectB      ;Call at least twice...(hardware detection
	jnc     short @@OK      ;problem...dunno why)
	loop    @@RepeatDetect
	@@OK:
	ret
	ENDP
_SBdetectB      PROC NEAR USES BX CX DX DI ES
	LOCAL   IRQ2:DWORD,IRQ3:DWORD,IRQ5:DWORD,IRQ7:DWORD,\
		IRQ10:DWORD,IRQ11:DWORD,IRQ12:DWORD,IRQ15:DWORD,\
		dma1:byte,dma2:byte,dma1r:byte,dma2r:byte

	test    SB.SDIflags,100b        ;FORCED USER SETTING?
	jnz     @@UserSetting           ;(User has overwritten SB.SDIxxx!!)
					;The recommended method is through
					;AM.AM_SDIxxxx!!

	;
	;ENVIRONMENT VARIABLE DETECTION
	;
	;SEARCH BLASTER ENVIRONMENT VARIABLE

	mov     SB.SDIport,0FFFFh;
	mov     SB.SDIirq,0FFFFh;
	mov     SB.SDIdma8,0FFFFh;
	mov     SB.SDIdma16,0FFFFh;
	mov     SB.SDIversion,0FFFFh;

	push    cs
	push    offset SDI_SB_BLASTER
	call    _UTILsearchEnvVar
	jc      @@NoBlasterVariable
	;GET PORT (HEX)
	push    cs
	push    offset SDI_SB_PORT
	push    es
	push    di
	push    word ptr 0              ;End Of Line char
	push    word ptr 1              ;Case insensitive
	call    _UTILsearchStr
	jc      @@NoBlasterVariable
	inc     bx
	push    es
	push    bx
	push    word ptr 3              ;3 hex digits...
	call    _UTILcnvHexStr2DW
	mov     SB.SDIport,ax
	;GET IRQ (DECIMAL?)
	push    cs
	push    offset SDI_SB_IRQ
	push    es
	push    di
	push    word ptr 0              ;End Of Line char
	push    word ptr 1              ;Case insensitive
	call    _UTILsearchStr
	jc      @@NoBlasterVariable
	inc     bx
	push    es
	push    bx
	push    word ptr 2              ;Up to 2 decimal digits...
	call    _UTILcnvDecStr2DW
	mov     SB.SDIirq,ax
	;GET 8-BIT DMA (DECIMAL)
	push    cs
	push    offset SDI_SB_DMA8
	push    es
	push    di
	push    word ptr 0              ;End Of Line char
	push    word ptr 1              ;Case insensitive
	call    _UTILsearchStr
	jc      short @@NoBlasterVariable
	inc     bx
	push    es
	push    bx
	push    word ptr 1              ;Up to 1 decimal digits...
	call    _UTILcnvDecStr2DW
	mov     SB.SDIdma8,ax
	;GET 16-BIT DMA (DECIMAL)
	push    cs
	push    offset SDI_SB_DMA16
	push    es
	push    di
	push    word ptr 0              ;End Of Line char
	push    word ptr 1              ;Case insensitive
	call    _UTILsearchStr
	jc      short @@NoFoundBlasterDMA16
	inc     bx
	push    es
	push    bx
	push    word ptr 1              ;Up to 1 decimal digits...
	call    _UTILcnvDecStr2DW
	mov     SB.SDIdma16,ax
	@@NoFoundBlasterDMA16:
	;call    _SBreset               ;RESET DSP
	;GET TYPE (DECIMAL)
	push    cs
	push    offset SDI_SB_TYPE
	push    es
	push    di
	push    word ptr 0              ;End Of Line char
	push    word ptr 1              ;Case insensitive
	call    _UTILsearchStr
	jc      short @@NoBlasterVariable
	inc     bx
	push    es
	push    bx
	push    word ptr 1              ;Up to 1 decimal digits...
	call    _UTILcnvDecStr2DW
	;DETERMINE TYPE AND SET DSP VERSION ACCORDINGLY.
	cmp     al,1                    ;1=Old SoundBlasters
	jne     short @@NotOld          ;Set version 1.0.
	mov     ax,0100h
	jmp     @@SetAbility
	@@NotOld:
	cmp     al,2                    ;2=SB pro 1.X
	jne     short @@NotPro
	mov     ax,0300h
	jmp     @@SetAbility
	@@NotPro:
	cmp     al,3                    ;3=New SB
	jne     short @@NotNew
	mov     ax,0201h
	jmp     @@SetAbility
	@@NotNew:
	cmp     al,4                    ;4=SB pro 2.X
	jne     short @@NotPro2
	mov     ax,0300h
	jmp     @@SetAbility
	@@NotPro2:

	;For SB16 basic ...T is 6! -- nono...this one has MIDI?
	mov     ax,0400h                ;Else, assume SB 16
	jmp     @@SetAbility
      @@NoBlasterVariable:

	;
	;HARDWARE AUTODETECT
	;
	;SOUND BLASTER PORT DETECTION
	mov     ax,AM.AM_SDIport
	cmp     ax,0FFFFh
	je      short @@NoForcePort
	mov     SB.SDIport,ax
	@@NoForcePort:
	cmp     SB.SDIport,0FFFFh
	jne     short @@SBfound
	mov     SB.SDIPort,0210h        ;Start from 210h
	@@DetectAgain:
	call    _SBreset
	jnc     short @@SBfound
	add     SB.SDIPort,010h         ;Try next port... (multiples of 10h)
	cmp     SB.SDIPort,02F0h        ;Until port 02F0h
	jbe     short @@DetectAgain
	mov     ErrorCode,ERR_NoHardware;Then, error...no SB.
	jmp     @@Error
	@@SBfound:
	;SOUND BLASTER IRQ DETECTION
	mov     ax,AM.AM_SDIirq
	cmp     ax,0FFFFh
	je      short @@NoForceIrq
	mov     SB.SDIirq,ax
	@@NoForceIrq:
	cmp     SB.SDIirq,0FFFFh
	jne     @@FoundIRQ
	cli
	mov     SB.SDIIRQ,0             ;Reset to 0
	call    GetINT, 08h+2
	mov     word ptr IRQ2[0],bx
	MOV     WORD PTR IRQ2[2],es
	call    GetINT, 08h+3
	mov     word ptr IRQ3[0],bx
	mov     word ptr IRQ3[2],es
	call    GetINT, 08h+5
	mov     word ptr IRQ5[0],bx
	mov     word ptr IRQ5[2],es
	call    GetINT, 08h+7
	mov     word ptr IRQ7[0],bx
	mov     word ptr IRQ7[2],es
	call    GetINT, 070h-8+10
	mov     word ptr IRQ10[0],bx
	mov     word ptr IRQ10[2],es
	call    GetINT, 070h-8+11
	mov     word ptr IRQ11[0],bx
	mov     word ptr IRQ11[2],es
	call    GetINT, 070h-8+12
	mov     word ptr IRQ12[0],bx
	mov     word ptr IRQ12[2],es
	call    GetINT, 070h-8+15
	mov     word ptr IRQ15[0],bx
	mov     word ptr IRQ15[2],es
	call    SetINT, 08h+2, cs,offset _IRQ2  ;If high irq, the high irq
	call    SetINT, 08h+3, cs,offset _IRQ3  ;will occur AFTER irq 2!
	call    SetINT, 08h+5, cs,offset _IRQ5
	call    SetINT, 08h+7, cs,offset _IRQ7
	call    SetINT, 070h-8+10, CS,offset _IRQ10
	call    SetINT, 070h-8+11, CS,offset _IRQ11
	call    SetINT, 070h-8+12, CS,offset _IRQ12
	call    SetINT, 070h-8+15, CS,offset _IRQ15
	mov     al,020h
	out     020h,al
	in      al,021h
	push    ax
	and     al,01010011B            ;Enable IRQ 2,3,5,7
	out     021h,al
	mov     al,020h
	out     0a0h,al
	in      al,0a1h
	push    ax
	and     al,01100011B            ;Enable IRQ 10,11,12,15
	out     0a1h,al
	sti
	mov     al,0f2h                 ;Initiate IRQ!
	call    SBwrite                 ;(An undocumented stuff?)
	@@WaitINT:
	cmp     SB.SDIIRQ,0
	je      short @@WaitINT
	cli
	mov     al,020h
	out     0a0h,al
	pop     ax
	out     0a1h,al
	mov     al,020h
	out     020h,al
	pop     ax
	out     021h,al
	call    SetINT, 08h+2, WORD PTR IRQ2[2],WORD PTR IRQ2[0]
	call    SetINT, 08h+3, WORD PTR IRQ3[2],WORD PTR IRQ3[0]
	call    SetINT, 08h+5, WORD PTR IRQ5[2],WORD PTR IRQ5[0]
	call    SetINT, 08h+7, WORD PTR IRQ7[2],WORD PTR IRQ7[0]
	call    SetINT, 070h-8+10, WORD PTR IRQ10[2],WORD PTR IRQ10[0]
	call    SetINT, 070h-8+11, WORD PTR IRQ11[2],WORD PTR IRQ11[0]
	call    SetINT, 070h-8+12, WORD PTR IRQ12[2],WORD PTR IRQ12[0]
	call    SetINT, 070h-8+15, WORD PTR IRQ15[2],WORD PTR IRQ15[0]
	sti
	@@FoundIRQ:
	;SOUND BLASTER 8/16 BIT DMA DETECTION
	mov     ax,AM.AM_SDIDMA8
	cmp     ax,0FFFFh
	je      short @@NoForceDma8
	mov     SB.SDIdma8,ax
	@@NoForceDma8:
	cmp     SB.SDIdma8,0FFFFh
	jne     @@FoundDMA8
	;8-BIT DMA DETECTION
	mov     al,0d3h                 ;Turn off speaker
	call    SBwrite
	mov     al,040h                 ;Set sample rate to 22000Hz
	call    SBwrite                 ;Value = 256 - (1000000/Hz)
	mov     al,0D3H
	call    SBwrite
	mov     al,014h                 ;Set 8bit DMA transfer mode
	call    SBwrite
	mov     al,0FFh ;010h           ;8bit DAC mode or is it length?
	call    SBwrite
	cli
	xor     al,al                   ;Clear Flip-Flop
	out     0ch,al
	in      al,8                    ;Get original status of DMA chip 1
	and     al,0f0h ;e0h
	mov     dma1,al
	xor     al,al                   ;Reset DSP...
	call    SBwrite
	mov     cx,0                    ;Wait for a DMA to be requested.
	@@WaitFlag8:                     ;When it's requested, DMA registers
	in      al,8                    ;are modified. Don't ask me how.
	and     al,0f0h ;e0h
	mov     dma1r,al
	cmp     al,dma1
	jne     @@DMArequested8
	loop    @@WaitFlag8
	@@DMArequested8:
	sti
	call    _SBreset            ;DSP confused already. Heh heh.
	;---Now, determine which DMA occured.
	mov     al,dma1
	not     al
	and     al,dma1r
	shr     al,4
	mov     cl,4-1                  ;Test 4 channels.
	xor     ah,ah                   ;Start from DMA0
	@@CheckDMAbit8:
	test    al,1
	jnz     short @@DMAfound8
	shr     al,1
	inc     ah
	loop    @@CheckDMAbit8
	mov     ah,1                    ;No 8-bit DMA. Force to 1 ?
	;jmp     short @@DetectDMA16     ;No 8-bit DMA. Try detect 16-bit one.
	@@DMAfound8:
	mov     al,ah
	xor     ah,ah
	mov     SB.SDIdma8,ax           ;Store DMA channel number.
	;jmp     @@FoundDMA
	@@FoundDMA8:
	;16-BIT DMA DETECTION
	@@DetectDMA16:
	mov     ax,AM.AM_SDIDMA16
	cmp     ax,0FFFFh
	je      short @@NoForceDma16
	mov     SB.SDIdma16,ax
	@@NoForceDma16:
	cmp     SB.SDIdma16,0FFFFh
	jne     @@FoundDMA16
	mov     al,0e1h                 ;Get AH:AL=Maj:Min DSP version
	call    SBwrite
	call    SBread
	mov     ah,al
	call    SBread
	cmp     ax,0400h
	jb      @@Not16BitSoundCard
	;mov     al,0d3h                 ;Turn off speaker
	;call    SBwrite
	mov     al,041h                 ;Set sample rate to 20000Hz
	call    SBwrite                 ;Set rate hi-lo
	mov     al,20000/256
	call    SBwrite
	mov     al,20000 AND 255
	call    SBwrite
	mov     al,0b6h
	call    SBwrite
	mov     al,010h                 ;16-bit mono signed PCM
	call    SBwrite
	;mov     al,014h                ;Set 8bit DMA transfer mode
	;call    SBwrite
	mov     al,0FFh                 ;Just like what I did with 8-BIT Detect
	call    SBwrite
	cli
	xor     al,al                   ;Clear Flip-Flop
	out     0d8h,al
	in      al,0d0h                 ;Get original status of DMA chip 2
	and     al,0f0h
	mov     dma2,al
	xor     al,al                   ;Reset DSP...
	call    SBwrite
	mov     cx,0 ;60000             ;Wait for a DMA to be requested.
	@@WaitFlag16:                    ;When it's requested, DMA registers
	in      al,0d0h                 ;are modified. Don't ask me how.
	and     al,0f0h
	mov     dma2r,al
	cmp     al,dma2
	jne     @@DMArequested16
	loop    @@WaitFlag16
	@@DMArequested16:
	sti
	call    _SBreset            ;DSP confused already. Heh heh.
	;---Now, determine which DMA occured.
	mov     al,dma2
	not     al
	and     al,dma2r
	shr     al,4
	mov     cl,4-1                  ;Test 4 channels.
	mov     ah,4                    ;Start from DMA4
	@@CheckDMAbit16:
	test    al,1
	jnz     short @@DMAfound16
	shr     al,1
	inc     ah
	loop    @@CheckDMAbit16
	jmp     short @@Not16BitSoundCard
	@@DMAfound16:
	mov     al,ah
	xor     ah,ah
	mov     SB.SDIdma16,ax          ;Store DMA channel number.
	jmp     short @@FoundDMA16
	@@Not16BitSoundCard:
	mov     ah,5                    ;No 16-bit DMA. Force to 5 ?
	;mov     ErrorCode,ERR_NoHardware        ;16-BIT DMA not found!
	;jmp     @@Error
	@@FoundDMA16:
	call    _SBreset                ;DSP confused already. Heh heh.
	;call    _SBreset                ;Reset it ...
	;doerr   ERR_NoHardware
	;SOUND BLASTER TYPE DETECTION.
	;DSP versions and capability
	; <  2.00               8-bits Mono 22.05khz Non-autoinit
	; =  2.00               8-bits Mono 22.05khz Autoinit
	; >  2.00               8-bits Mono 44.10khz Autoinit
	; >= 3.00               8-bits Mono/Stereo 44.10khz Autoinit
	; >= 4.00               8/16-bits Mono/Stereo 44.10khz Autoinit
	;SOUND BLASTER TYPES AND RESPECTIVE DSP VERSIONS
	;SoundBlaster (original)        - DSP 1.00
	;SoundBlaster 1.5               - DSP 2.00
	;SoundBlaster 2.0               - DSP 2.01
	;SoundBlaster Pro               - DSP 3.00
	;SoundBlaster Pro 2             - DSP 3.00 ? (not sure)
	;SoundBlaster 16                - DSP 4.00
	;SoundBlaster AWE32             - DSP 4.00 (I think)

	call    _SBreset                ;Reset it ...
	doerr   ERR_NoHardware
	mov     ax,AM.AM_SDIversion     ;Get AH:AL=Maj:Min DSP version
	cmp     ax,0FFFFh
	je      short @@NoForceVer
	mov     SB.SDIVersion,ax
	@@NoForceVer:
	cmp     SB.SDIVersion,0FFFFh
	jne     short @@VerFound
	mov     al,0e1h
	call    SBwrite
	call    SBread
	mov     ah,al
	call    SBread
	mov     SB.SDIVersion,ax
	@@VerFound:
@@UserSetting:
	mov     ax,SB.SDIVersion
@@SetAbility:
	mov     SB.SDIversion,ax
	;BY DEFAULT, WE CHOOSE 22KHZ 8-BITS MONO
	mov     SB.SDIMaxRate,21739
	and     SB.SDIHardwareInfo,not 11b
	;BIT 0  1=Stereo available (not necessarily used)
	;    1  1=16-bit sound available
	;CHECK IF WE CAN GO 44KHZ
	cmp     ax,0201h
	jb      short @@No44
	;44khz max
	mov     SB.SDIMaxRate,43478
	@@No44:
	;CHECK IF STEREO AVAILABLE
	cmp     ax,0300h
	jb      short @@NoStereo
	;Stereo
	or      SB.SDIHardwareInfo,01b
	mov     SB.SDIMaxRate,43478
	@@NoStereo:
	;CHECK IF 16-BIT SOUND AVAILABLE
	cmp     ax,0400h
	jb      short @@No16BIT
	;16BIT Sound available
	mov     SB.SDIMaxRate,44100        ;?? Direct speed setting!
	or      SB.SDIHardwareInfo,10b
	@@No16BIT:
	call    _SBreset            ;Reset it ...
	;Update Memory Manager info for free memory left...
	call    _MEMupdateInfo          ;Amount of free memory for Sound System.
	mov     eax,MEM_EMSfree
	cmp     eax,MEM_BaseFree
	jae     short @@EMSlarger
	mov     eax,MEM_BaseFree
	@@EMSlarger:
	mov     SB.SDIRAM,eax
	clc
	ret
	@@Error:
	mov     ax,ErrorCode
	stc
	ret
	_IRQ2:  mov     SB.SDIIRQ,2
		iret
	_IRQ3:  mov     SB.SDIIRQ,3
		iret
	_IRQ5:  mov     SB.SDIIRQ,5
		iret
	_IRQ7:  mov     SB.SDIIRQ,7
		iret
	_IRQ8:  mov     SB.SDIIRQ,8
		iret
	_IRQ9:  mov     SB.SDIIRQ,9
		iret
	_IRQ10: mov     SB.SDIIRQ,10
		iret
	_IRQ11: mov     SB.SDIIRQ,11
		iret
	_IRQ12: mov     SB.SDIIRQ,12
		iret
	_IRQ15: mov     SB.SDIIRQ,15
		iret
	ENDP
;
;_SBreset - Reset SoundBlaster                                         
;IN:   SB.SDIport must be set.                                         
;OUT:  Carry 0=Success 1=Error                                         
;
_SBreset        PROC NEAR
	;Reset the DSP by sending 1, (delay), then 0
	mov     dx,SB.SDIPort
	add     dx,6
	mov     al,1
	out     dx,al
	in      al,dx                   ;Wait at least 3 microseconds
	in      al,dx
	in      al,dx
	in      al,dx
	xor     al,al
	out     dx,al
	;Wait for SB signature (0AAh)
	mov     cx,064h                 ;Up to 100 times retry...
	@@WaitForSignature:
	mov     dx,SB.SDIPort           ;POLLING - WAIT FOR SIGNATURE
	add     dx,0Eh                  ;          TO BE AVAILABLE.
	in      al,dx
	test    al,080h
	jnz     short @@DataAvailable
	loop    @@WaitForSignature
	jmp     @@SBnotFoundAtPort
	@@DataAvailable:
	mov     dx,SB.SDIPort           ;GET THE SIGNATURE
	add     dx,0ah
	in      al,dx
	cmp     al,0AAh
	je      short @@SBfoundAtPort
	loop    @@WaitForSignature
	@@SBnotFoundAtPort:
	stc
	ret
	@@SBfoundAtPort:                  ;SB found at port.
	clc
	ret
	ENDP
;
;_SBinit - Initialize SB                                               
;OUT:  Carry 0=Success 1=Error                                         
;!:    _SBdetect must be run first (handled automatically by           
;      _AMinitSystem                                                   
;
_SBinit PROC NEAR
	call    _SBreset
	call    _DSMinit
	ret
	ENDP
;
;_SBdeinit - Deinitialize SB                                           
;OUT:  Carry 0=Success 1=Error                                         
;
_SBdeinit PROC NEAR
	call    _DSMdeinit
	call    _SBreset    ;Stop
	call    _SBreset    ;Deinit
	ret
	ENDP
;
;_SBstart - Prepare SB to start sound output                           
;IN:   MixRate, Flag:W (Flag: Bit 0=Stereo 1=16-bit)                   
;OUT:  Carry 0=Success 1=Error                                         
;
_SBstart PROC NEAR USES BX CX DX DS, MixRate:WORD,Flag:WORD
	LOCAL   PlayRoutine:WORD,PlayRoutineIRQ:WORD

	;LIMIT CAPABILITIES AND SET FLAGS
	mov     ax,Flag
	mov     ah,al
	mov     al,SB.SDIHardwareInfo
	and     al,ah
	and     al,11b
	and     SB.SDIFlags,not 11b
	or      SB.SDIFlags,al
	;CLIP MIXING RATE
	mov     ax,SB.SDIMaxRate                ;SBpro in stereo mode is
	cmp     SB.SDIversion,0400h             ;SB pro only!
	jae     short @@MonoSBpro
	test    SB.SDIFlags,1b                  ;limited to 22khz!
	jz      short @@MonoSBpro
	shr     ax,1
	@@MonoSBpro:
	mov     bx,MixRate
	cmp     bx,ax ;SB.SDIMaxRate
	jbe     @@NoProblem
	mov     bx,ax ;SB.SDIMaxRate
	@@NoProblem:
	mov     SB.SDIMixingRate,bx

	;SELECT TRANSFER METHOD ACCORDING TO DSP VERSION
	mov     dx,offset PlayAutoInitIRQ
	mov     ax,SB.SDIVersion
	cmp     ax,0400h
	jb      short @@NotSB16
	mov     cx,offset PlaySB16
	jmp     @@DoneDSP
	@@NotSB16:
	cmp     ax,0300h
	jb      short @@NotSBPro
	mov     cx,offset PlaySB210     ;Same starter!! PlaySBPro
	jmp     @@DoneDSP
	@@NotSBPro:
	cmp     ax,0200h
	jbe     short @@NotSB210
	mov     cx,offset PlaySB210
	jmp     @@DoneDSP
	@@NotSB210:
	cmp     ax,0200h
	jb      short @@NotSB200
	mov     cx,offset PlaySB200
	jmp     @@DoneDSP
	@@NotSB200:
	mov     cx,offset PlaySBold
	mov     dx,offset PlaySingleCycleIRQ
	@@DoneDSP:
	mov     PlayRoutine,cx
	mov     PlayRoutineIRQ,dx


	;HOOK SB IRQ TO THE APPROPRIATE IRQ HANDLER!
	cli
	mov     dx,SB.SDIIRQ                       ;Set software INT number
	add     dx,08h
	cmp     dx,7+8
	jbe     short @@LowIRQ
	add     dx,070h-8-8             ;-8 converts to 0-7, -8 for that +8...
	@@LowIRQ:
	push    dx
	call    GetINT
	mov     word ptr OrigSBIRQ[0],bx
	mov     word ptr OrigSBIRQ[2],es
	push    dx
	push    cs
	push    PlayRoutineIRQ
	call    SetINT
	sti
	push    SB.SDIIRQ
	call    EnableIRQ
	push    word ptr 2              ;Enable IRQ 2 too! High IRQs need
	call    EnableIRQ               ;them!

	;SETUP MIXER & SAVE MIXER INFO
	cmp     SB.SDIVersion,0300h
	jb      short @@NoMixer
        cmp     SB.SDIVersion,0400h     ;CL screwed up SB16's SBPro mixer!
        jge     short @@NoMixer
;;PUPPY DOG - BETA-TEST PART!
;cmp     SB.SDIVersion,0400h
;jae     short @@NoMixer
	mov     dx,SB.SDIport
	add     dl,4
	xor     al,al                           ;Data Reset
	out     dx,al

	mov     al,0Eh                          ;Output
	out     dx,al
	inc     dx
	in      al,dx
	mov     SDI_SB_Filter[0],al
;comment ~
        mov     al,SB.SDIFlags
	and     al,00000001b
	shl     al,1       ;Bit 1 0=Mono 1=Stereo
	or      al,100000b ;Bypass filter
	out     dx,al
	dec     dx
;~

;        ;===Set stereo without modifying anything else...
;        and     al,NOT 10b      ;Clear stereo flag...
;        mov     ah,SB.SDIFlags
;        and     ah,1b
;        shl     ah,1
;        or      al,ah
;        out     dx,al
;        dec     dx
;        ;============================= (SB 16 as gain controls...)


;Don't kacau mixer?
	;mov     al,022h                         ;Master volume
	;out     dx,al
	;inc     dx
	;in      al,dx
	;mov     SDI_SB_Filter[1],al
	;mov     al,0FFh
	;out     dx,al
	;dec     dx

	;mov     al,04h                          ;Voice volume
	;out     dx,al
	;inc     dx
	;in      al,dx
	;mov     SDI_SB_Filter[2],al
	;mov     al,0FFh
	;out     dx,al
	;;dec     dx
	@@NoMixer:

comment ~
	;SBPRO QUIRK! NEEDS TO OUTPUT 1 BYTE TO INIT LEFT-RIGHT!!
	cmp     SB.SDIVersion,0400h
	jae     @@Mono2
	test    SB.SDIFlags,01b
	jz      @@Mono2
	mov     dx,SB.SDIIRQ                       ;Set software INT number
	add     dx,08h
	cmp     dx,7+8
	jbe     short @@LowIRQ2
	add     dx,070h-8-8
	@@LowIRQ2:
	push    dx
	call    GetINT
      push    dx
      push    es bx
	mov     StereoFlag,0
	push    dx
	push    cs
	push    offset SBproStereoInit
	call    SetINT
	sti
	push    SB.SDIIRQ                          ;Enable IRQ
	call    EnableIRQ
	push    SB.SDIDMA8                         ;Set DMA
	push    word ptr 048h   ;Non auto-init
	mov     ax,cs
	shl     eax,16
	mov     ax,offset SDI_SBbuffer
	shl     eax,4
	push    ax
	shr     eax,16
	push    ax
	push    word ptr 1
	call    setDMA
	mov     al,0d3h ;Speaker off...0d1h
	call    SBwrite
	mov     al,040h                         ;Rate
	call    SBwrite
	mov     al,09ch                         ;10khz
	call    SBwrite
	mov     al,014h                         ;Tell DSP output 1 silent byte
	call    SBwrite
	xor     al,al
	call    SBwrite
	xor     al,al
	call    SBwrite
	mov     al,091h                         ;090=Auto init (091h=not)
	call    SBwrite
	sti
	@@WaitFlag:
	cmp     StereoFlag,1
	jne     short @@WaitFlag
	call      SetINT                          ;Restore INT
	jmp     short @@Mono2
	StereoFlag      db 0
     SBproStereoInit:
	push    ax dx ds
	setDS
	mov     StereoFlag,1
	mov     dx,SB.SDIport
	add     dx,0eh
	in      al,dx
        ;mov     al,20h

	mov     al,020h
	out     0a0h,al
        out     020h,al

        ;cmp     SB.SDIIRQ,7
        ;ja      short @@HighIRQ2
        ;out     020h,al
        ;jmp     short @@Done2
        ;@@HighIRQ2:
        ;out     0a0h,al
        ;@@Done2:
	pop     ds dx ax
	iret
	@@Mono2:
~

	mov     ax,SB.SDIdma8           ;8-bit DMA for 8-bit sounds,
	test    SB.SDIFlags,10b         ;16-bit DMA for 16-bit sounds.
	jz      short @@Bit8Sound       ;Not necessarily though!
	cmp     SB.SDIdma16,0FFFFh      ;Use 16-bit DMA if available...
	je      short @@Bit8Sound
	mov     ax,SB.SDIdma16
	@@Bit8Sound:
	push    ax
	push    SB.SDIMixingRate   ;Use the clipped mixing rate
	movzx   ax,SB.SDIFlags
	push    ax
	call    _DSMstart
	doerr   ERR_HardwareProblem

	;SETUP SOME STUFFS FOR PRECAUTIONS?
	;mov     al,0d1h                         ;Turn on speaker
	;call    SBwrite
	;===DMA CONTINUE, SOMEHOW, HANGS THE POLLING ON SB...
	;===SO, IT'LL MAKE THE SYSTEM HANG...OH WELL...
	;mov     al,0d4h                         ;DMA continue
	;call    SBwrite
;        xor     al,al                           ;Reset DSP for precaution?
;        call    SBwrite

	mov     al,0d1h                         ;Turn on speaker
	call    SBwrite
	call    PlayRoutine

	quit
	ENDP

	;
	;PLAYBACK INITIATOR AND IRQ
	;
GetTimeConstant PROC NEAR
	;SET UP REAL SB MIXING RATE
	mov     bx,SB.SDIMixingRate
	test    SB.SDIFlags,01b                 ;Stereo? Mul rate by 2!
	jz      short @@Mono
	shl     bx,1
	@@Mono:
	mov     dx,0fh                          ;Set SB sample rate
	mov     ax,04240h
	div     bx
	shl     dx,1                            ;Round up error! :)
	cmp     dx,bx                           ;If remainder >= half of
	jb      short @@NoRoundUp               ;the divisor value, we need
	inc     ax                              ;a round up! (>= 0.5)
	@@NoRoundUp:
	mov     bx,ax
	mov     dx,0fh
	mov     ax,04240h
	div     bx
	test    SB.SDIFlags,01b                 ;Stereo? Div rate by 2!
	jz      short @@Mono2
	shr     ax,1
	@@Mono2:
	mov     SB.SDIMixingRate,ax
	neg     bx                              ;Get time constant in BX
	add     bx,256
	ret
	ENDP
PlaySingleCycleIRQ PROC FAR
	push    ax dx ds
	setDS
	mov     al,014h                         ;8-bit mono low speed
	call    SBwrite
	mov     dx,DSM_DMAsize                  ;Length
	dec     dx
	mov     al,dl
	call    SBwrite
	mov     al,dh
	call    SBwrite
	mov     dx,SB.SDIport                      ;Ackowledge IRQ
	add     dx,0eh
	in      al,dx
	mov     al,20h
	cmp     SB.SDIIRQ,7
	ja      short @@HighIRQ
	out     020h,al
	jmp     short @@Done
	@@HighIRQ:
	out     0a0h,al
	@@Done:
	pop     ds dx ax
	iret
	ENDP
PlayAutoInitIRQ PROC FAR
	push    ax dx ds
	setDS   ;????????????????????????????
	mov     dx,SB.SDIport                      ;Ackowledge IRQ

	;Bug borrowed from MIDAS sound player. :-)
	add     dx,0eh
	test    SB.SDIFlags,10b                 ;16-bit?
	jz      short @@Bit8                    ;If yes, acknowledge IRQ
	inc     dx                              ;by reading 2xE, *NOT* 2xF.
	@@Bit8:
	in      al,dx

	mov     al,20h
	cmp     SB.SDIIRQ,7
	ja      short @@HighIRQ
	out     020h,al
	jmp     short @@Done
	@@HighIRQ:
	out     0a0h,al
	@@Done:
	pop     ds dx ax
	iret
	ENDP
;------------------------------------SOUND BLASTER 16.
PlaySB16        PROC NEAR
	mov     al,041h                         ;Set sampling rate in HERTZ!
	call    SBwrite                         ;Hi-Lo
	mov     dx,SB.SDIMixingRate
	mov     al,dh
	call    SBwrite
	mov     al,dl
	call    SBwrite
	test    SB.SDIFlags,10b
	jz      short @@Bit8
	;--16 BIT
	;FAILS!
	mov     al,00b6h        ;b4h ;6h (change from 6 to 4 in midas ss 4)
	call    SBwrite
	mov     al,010h                         ;16-bit mono signed PCM
	test    SB.SDIFlags,01b
	jz      short @@Bit16Mono
	mov     al,030h                         ;16-bit stereo signed PCM
	@@Bit16Mono:
	call    SBwrite
	jmp     short @@SetLen
      @@Bit8:
	;WORKS!
	;--8 BIT
	mov     al,0c6h
	call    SBwrite
	xor     al,al                           ;8-bit mono UNsigned PCM
	test    SB.SDIFlags,01b
	jz      short @@Bit8Mono
	mov     al,020h                         ;8-bit stereo UNsigned PCM
	@@Bit8Mono:
	call    SBwrite
      @@SetLen:
	mov     dx,DSM_DMAsize                  ;Length
	dec     dx
	mov     al,dl
	call    SBwrite
	mov     al,dh
	call    SBwrite
	ret
	ENDP

;New correction. Not b6h, but b4h!
comment ~
	SBCMD   41h                     ; set DSP output sampling rate
	SBCMD   <[byte sbRate+1]>       ; sampling rate high byte
	SBCMD   <[byte sbRate]>         ; sampling rate low byte

	test    [sbMode],sd8bit         ; 8-bit mode?
	jnz     @@8bit

	SBCMD   0B4h                    ; 16-bit output
	test    [sbMode],sdMono         ; mono?
	jnz     @@mono16
	SBCMD   30h                     ; 16-bit stereo signed PCM
	jmp     @@setlen
@@mono16:
	SBCMD   10h                     ; 16-bit mono signed PCM
	jmp     @@setlen

@@8bit:
	SBCMD   0C6h                    ; 8-bit output
	test    [sbMode],sdMono         ; mono?
	jnz     @@mono8
	SBCMD   20h                     ; 8-bit stereo unsigned PCM
	jmp     @@setlen
@@mono8:
	SBCMD   00h                     ; 8-bit mono unsigned PCM

@@setlen:
	SBCMD   <[byte sbBlockLength]>    ; transfer length low byte
	SBCMD   <[byte sbBlockLength+1]>  ; transfer length high byte

@@err:
	ret
ENDP

~

;------------------------------------SOUND BLASTER PRO.
;PlaySBPro       PROC NEAR
;        ;AT LAST! OUTPUT!
;        call    GetTimeConstant
;        mov     al,040h                         ;Rate
;        call    SBwrite
;        mov     al,bl
;        call    SBwrite
;        mov     al,048h                         ;8-bit mono low speed
;        call    SBwrite
;        mov     dx,DSM_DMAsize                  ;Length
;        dec     dx
;        mov     al,dl
;        call    SBwrite
;        mov     al,dh
;        call    SBwrite
;        mov     al,090h                         ;090=Auto init (091h=not)
;        call    SBwrite
;        ret
;        ENDP
;------------------------------------SOUND BLASTER 2.10.
PlaySB210       PROC NEAR
	call    GetTimeConstant
	mov     al,040h                         ;Rate
	call    SBwrite
	mov     al,bl
	call    SBwrite
	mov     al,048h                         ;8-bit mono low speed
	call    SBwrite
	mov     dx,DSM_DMAsize                  ;Length
	dec     dx
	mov     al,dl
	call    SBwrite
	mov     al,dh
	call    SBwrite
	mov     al,090h                         ;090=Auto init (091h=not)
	call    SBwrite
	ret
	ENDP
;------------------------------------SOUND BLASTER 2.00.
PlaySB200       PROC NEAR
	call    GetTimeConstant
	mov     al,040h                         ;Rate
	call    SBwrite
	mov     al,bl
	call    SBwrite
	mov     al,048h                         ;8-bit mono low speed
	call    SBwrite
	mov     dx,DSM_DMAsize                  ;Length
	dec     dx
	mov     al,dl
	call    SBwrite
	mov     al,dh
	call    SBwrite
	mov     al,01ch                         ;090=Auto init. Lo Speed.
	call    SBwrite
	ret
	ENDP
;------------------------------------SOUND BLASTER ORIGINAL (1.xx)
PlaySBold       PROC NEAR
	call    GetTimeConstant
	mov     al,040h                         ;Rate
	call    SBwrite
	mov     al,bl
	call    SBwrite
	mov     al,014h                         ;8-bit mono low speed
	call    SBwrite
	mov     dx,DSM_DMAsize                  ;Length
	dec     dx
	mov     al,dl
	call    SBwrite
	mov     al,dh
	call    SBwrite
	ret
	ENDP
;
;_SBstop - Stop SB from sound output                                   
;OUT:  Carry 0=Success 1=Error                                         
;
_SBstop PROC NEAR USES DX
	;RESTORE MIXER INFO
	cmp     SB.SDIVersion,0300h
	jb      short @@NoMixer
	mov     dx,SB.SDIport
	add     dl,4
	xor     al,al                           ;Data Reset
	out     dx,al

	mov     al,0Eh                          ;Output
	out     dx,al
	inc     dx
	mov     al,SDI_SB_Filter[0]
	out     dx,al
	dec     dx

	;mov     al,022h                         ;Master volume
	;out     dx,al
	;inc     dx
	;mov     al,SDI_SB_Filter[1]
	;out     dx,al
	;dec     dx

	;mov     al,04h                          ;Voice volume
	;out     dx,al
	;inc     dx
	;mov     al,SDI_SB_Filter[2]
	;out     dx,al
	@@NoMixer:

	;STOP HARDWARE
	call    _SBreset
	call    _SBreset
	mov     al,0d3h                         ;Turn off speaker
	call    SBwrite
	mov     al,0d0h                         ;Halt DMA
	call    SBwrite


	;8-bit  - Write DSP command DA          ;SB16 stop
	;16-bit - Write DSP command D9
	cmp     SB.SDIVersion,0400h
	jb      @@NOTSB16STOP
	mov     al,0DAh
	test    SB.SDIFlags,10b
	jz      @@SB16STOPMONO
	mov     al,0d9h
	@@SB16STOPMONO:
	call    SBwrite
	@@NOTSB16STOP:




	mov     ax,SB.SDIdma8           ;8-bit DMA for 8-bit sounds,
	test    SB.SDIFlags,10b         ;16-bit DMA for 16-bit sounds.
	jz      short @@Bit8Sound
	mov     ax,SB.SDIdma16
	@@Bit8Sound:
	push    ax
	call    StopDMA
	;TELL DSM TO STOP
	call    _DSMstop
	jc      @@Error2
	;UNHOOK IRQ
	cli
	mov     dx,SB.SDIIRQ                       ;Set software INT number
	add     dx,08h
	cmp     dx,7+8
	jbe     short @@LowIRQ
	add     dx,070h-8-8
	@@LowIRQ:
	push    dx
	push    OrigSBIRQ
	call    SetINT
	sti
	quit
	ENDP

;
;
;
;SUPPORTING ROUTINES
;
;
;

;
;SoundBlaster DSP read/write routines
;
;INPUT: [AL=Byte to send]
;OUTPUT:[AL=Byte to read]
;RETURNS CARRY FLAG. 0=SUCCESS 1=FAILURE
;INPUT/OUTPUT = AL
;SBwritetime     PROC NEAR USES CX DX         ;Write to DSP. Timed.
;        MOV     DX,SB.SDIport
;        ADD     DL,0Ch
;        MOV     CX,0200h
;        MOV     AH,AL
;        @@Waiting:
;        IN      AL,DX
;        OR      AL,AL
;        JNS     SHORT @@Done
;        LOOP    @@Waiting
;        STC
;        RET
;        @@Done:
;        OUT     DX,AL
;        CLC
;        RET
;        SBwritetime     ENDP
;SBreadtime      PROC NEAR USES CX DX         ;Read from DSP. Timed.
;        MOV     DX,SB.SDIport
;        ADD     DL,0Eh
;        MOV     CX,0200h
;        @@Waiting:
;        IN      AL,DX
;        OR      AL,AL
;        JS      SHORT @@Done
;        LOOP    @@Waiting
;        STC
;        RET
;        @@Done:
;        SUB     DL,04h
;        IN      AL,DX
;        CLC
;        RET
;        SBreadtime      ENDP
;NO RETURN FLAG.
;INPUT/OUTPUT = AL
SBwrite         PROC NEAR USES DX            ;Write to DSP. Not timed.
	MOV     DX,SB.SDIport
	ADD     DL,0Ch
	MOV     AH,AL
	@@Waiting:
	IN      AL,DX
	OR      AL,AL
	JS      SHORT @@Waiting
	MOV     AL,AH
	OUT     DX,AL
	RET
	SBwrite ENDP
SBread          PROC NEAR USES DX            ;Read from DSP. Not timed.
	MOV     DX,SB.SDIport
	ADD     DL,0Eh
	MOV     AH,AL
	@@Waiting:
	IN      AL,DX
	OR      AL,AL
	JNS     SHORT @@Waiting
	SUB     DL,04h
	IN      AL,DX
	RET
	SBread  ENDP

.CSEG_ENDS      AM

comment ~
SB SDI_ <_SBgetInfo,     ,\
	 _SBdetect,      ,\
	 _SBreset        ,\
	 _SBinit         ,\
	 _SBdeinit       ,\
	 _SBstart        ,\
	 _SBstop         ,\
	 _DSMpoll        ,\
	 _DSMsetUpdate   ,\
	 _DSMinitTrack   ,\
	 _DSMdeinitTrack ,\
	 _DSMpauseTrack         ;Call again to unpause (XOR)
	 _DSMsetSample   ,\
	 _DSMsetVolume   ,\
	 _DSMsetFrequency,\
	 _DSMsetPanPos   ,\
	 _DSMsetOffset   ,\
	 _DSMkeyOn       ,\
	 _DSMkeyOff      ,\
	 _DSMallocMem    ,\
	 _DSMdeallocMem  ,\
	 _DSMloadSample  ,\
	 _DSMunloadSample>
~





;
;8/16-BIT DMA DETECTION. ASSUMES 8/16-BIT FOR 8-BIT WAVE
;
	COMMENT ~
	;SOUND BLASTER DMA DETECTION
	mov     ax,AM.AM_SDIDMA
	mov     SB.SDIdma,ax
	cmp     ax,0FFFFh
	jne     @@FoundDMA
	mov     al,0d3h                 ;Turn off speaker
	call    SBwrite
	mov     al,040h                 ;Set sample rate to 22000Hz
	call    SBwrite                 ;Value = 256 - (1000000/Hz)
	mov     al,0D3H
	call    SBwrite
	mov     al,014h                 ;Set 8bit DMA transfer mode
	call    SBwrite
	mov     al,0FFh ;010h           ;8bit DAC mode or is it length?
	call    SBwrite
	cli
	in      al,8                    ;Get original status of DMA chip 1
	and     al,0f0h ;e0h            ;and 2.
	mov     dma1,al
	in      al,0d0h
	and     al,0f0h
	mov     dma2,al
	xor     al,al                   ;Reset DSP...
	call    SBwrite
	mov     cx,60000                ;Wait for a DMA to be requested.
	@@WaitFlag:                     ;When it's requested, DMA registers
	in      al,8                    ;are modified. Don't ask me how.
	and     al,0f0h ;e0h            ;f0h?
	mov     dma1r,al
	cmp     al,dma1
	jne     @@DMArequested
	in      al,0d0h
	and     al,0f0h
	mov     dma2r,al
	cmp     al,dma2
	jne     @@DMArequested
	loop    @@WaitFlag
	@@DMArequested:
	sti
	call    _SBreset                ;DSP confused already. Heh heh.
	;---Now, determine which DMA occured.
	mov     ah,dma2
	not     ah
	and     ah,dma2r
	;mov     ah,dma2r
	and     ah,11110000b
	mov     al,dma1         ;ah
	not     al              ;ah
	and     al,dma1r        ;ah
	;mov     al,dma1r
	shr     al,4
	or      al,ah                   ;Bit 7=DMA 7 Bit0=DMA0
	mov     cl,8-1                  ;Test 8 channels.
	xor     ah,ah                   ;Start from DMA0
	@@CheckDMAbit:
	test    al,1
	jnz     short @@DMAfound
	shr     al,1
	inc     ah
	loop    @@CheckDMAbit
	mov     ErrorCode,ERR_NoHardware;DMA not found!
	jmp     @@Error
	@@DMAfound:
	mov     al,ah
	xor     ah,ah
	mov     SB.SDIdma,ax            ;Store DMA channel number.
	@@FoundDMA:
	~

;
;8/16-BIT DMA DETECTION. ASSUMES 8-BIT DMA FOR 8-BIT WAVE, 16 FOR 16.
;
	COMMENT ~
	;SOUND BLASTER 8/16 BIT DMA DETECTION
	mov     ax,AM.AM_SDIDMA
	mov     SB.SDIdma,ax
	cmp     ax,0FFFFh
	jne     @@FoundDMA
	;8-BIT DMA DETECTION
	mov     al,0d3h                 ;Turn off speaker
	call    SBwrite
	mov     al,040h                 ;Set sample rate to 22000Hz
	call    SBwrite                 ;Value = 256 - (1000000/Hz)
	mov     al,0D3H
	call    SBwrite
	mov     al,014h                 ;Set 8bit DMA transfer mode
	call    SBwrite
	mov     al,0FFh ;010h           ;8bit DAC mode or is it length?
	call    SBwrite
	cli
	xor     al,al                   ;Clear Flip-Flop
	out     0ch,al
	in      al,8                    ;Get original status of DMA chip 1
	and     al,0f0h ;e0h
	mov     dma1,al
	xor     al,al                   ;Reset DSP...
	call    SBwrite
	mov     cx,0                    ;Wait for a DMA to be requested.
	@@WaitFlag:                     ;When it's requested, DMA registers
	in      al,8                    ;are modified. Don't ask me how.
	and     al,0f0h ;e0h
	mov     dma1r,al
	cmp     al,dma1
	jne     @@DMArequested
	loop    @@WaitFlag
	@@DMArequested:
	sti
	call    _SBreset            ;DSP confused already. Heh heh.
	;---Now, determine which DMA occured.
	mov     al,dma1
	not     al
	and     al,dma1r
	shr     al,4
	mov     cl,4-1                  ;Test 4 channels.
	xor     ah,ah                   ;Start from DMA0
	@@CheckDMAbit:
	test    al,1
	jnz     short @@DMAfound
	shr     al,1
	inc     ah
	loop    @@CheckDMAbit
	jmp     short @@DetectDMA16     ;No 8-bit DMA. Try detect 16-bit one.
	@@DMAfound:
	mov     al,ah
	xor     ah,ah
	mov     SB.SDIdma,ax            ;Store DMA channel number.
	jmp     @@FoundDMA
	;16-BIT DMA DETECTION
	@@DetectDMA16:
	mov     al,0e1h                 ;Get AH:AL=Maj:Min DSP version
	call    SBwrite
	call    SBread
	mov     ah,al
	call    SBread
	cmp     ax,0400h
	jb      @@Not16BitSoundCard
	mov     al,0d3h                 ;Turn off speaker
	call    SBwrite
	mov     al,041h                 ;Set sample rate to 20000Hz
	call    SBwrite                 ;Set rate hi-lo
	mov     al,20000/256
	call    SBwrite
	mov     al,20000 AND 255
	call    SBwrite
	mov     al,0b6h
	call    SBwrite
	mov     al,010h                 ;16-bit mono signed PCM
	call    SBwrite
	;mov     al,014h                ;Set 8bit DMA transfer mode
	;call    SBwrite
	mov     al,0FFh                 ;Just like what I did with 8-BIT Detect
	call    SBwrite
	cli
	xor     al,al                   ;Clear Flip-Flop
	out     0d8h,al
	in      al,0d0h                 ;Get original status of DMA chip 2
	and     al,0f0h
	mov     dma2,al
	xor     al,al                   ;Reset DSP...
	call    SBwrite
	mov     cx,0 ;60000             ;Wait for a DMA to be requested.
	@@WaitFlag2:                    ;When it's requested, DMA registers
	in      al,0d0h                 ;are modified. Don't ask me how.
	and     al,0f0h
	mov     dma2r,al
	cmp     al,dma2
	jne     @@DMArequested2
	loop    @@WaitFlag2
	@@DMArequested2:
	sti
	call    _SBreset            ;DSP confused already. Heh heh.
	;---Now, determine which DMA occured.
	mov     al,dma2
	not     al
	and     al,dma2r
	shr     al,4
	mov     cl,4-1                  ;Test 4 channels.
	mov     ah,4                    ;Start from DMA4
	@@CheckDMAbit2:
	test    al,1
	jnz     short @@DMAfound2
	shr     al,1
	inc     ah
	loop    @@CheckDMAbit2
	jmp     short @@Not16BitSoundCard
	@@DMAfound2:
	mov     al,ah
	xor     ah,ah
	mov     SB.SDIdma,ax            ;Store DMA channel number.
	jmp     short @@FoundDMA
	@@Not16BitSoundCard:
	mov     ErrorCode,ERR_NoHardware        ;16-BIT DMA not found!
	jmp     @@Error
	@@FoundDMA:
	~



;
;SB/SBPRO/SB16 stuff
;

comment ~

/* Soundblaster Basic commands */
#define DSPSendOneSample        0x10
#define DSPGetOneSample         0x20

#define DSPStartDMA                     0x14
#define DSPStartADCDMA          0x24

#define DSPSpeakerOn                    0xD1
#define DSPSpeakerOff           0xD3

#define DSPGetVersion           0xE1
#define DSPGetCopyright         0xE3

#define DSPSetTimeConstant 0x40

#define DSPPauseDMA                     0xD0
#define DSPContinueDMA          0xD4

/* Soundblaster 2.0 and Pro commands */
#define DSPSetHSDMASize         0x48
#define DSPStartHSDMA           0x91

#define DSPStartHSADCDMA        0x99

/* Soundblaster Pro commands */

#define DSPSBProADCStereo       0xA8
#define DSPSBProADCMono         0xA0

/* Soundblaster 16 commands */
#define DSPSB16SetSpeed                 0x42

#define DSPSB16Start16DMA               0xB6
#define DSPSB16Start8DMA                0xC6

#define DSPSB16Start16ADCDMA  0xBE
#define DSPSB16Start8ADCDMA     0xCE

#define DSPSB16Stereo                   0x20
#define DSPSB16Mono                             0x00

#define DSPSB16StereoSign       0x30
#define DSPSB16MonoSign         0x10

#define DSPSB16Pause16DMA       0xD9
#define DSPSB16Pause8DMA        0xDA

#define DSPSB16Cont16DMA                0x47
#define DSPSB16Cont8DMA                 0x45










;Mixer registers...
;0=Not available (don't set mixer)
unsigned char SBProMixRegs[] = { 0x22, 0x04, 0x26, 0x2E, 0x28, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00};
unsigned char SB16MixRegs[]  = { 0x30, 0x32, 0x34, 0x38, 0x36, 0x41, 0x44, 0x46, 0x3F, 0x3A, 0x3B};


void mix_write(int device, int channel, unsigned char level)
{
	int r1,r2;

#ifdef DEBUG_PROC
	printf("mix_write: device %i channel %i level %i\n",device,channel,(int)level);
#endif

	if( device > 8 )
		channel = SBtype >= 4 ? MIXleft : MIXright;

	if( (SBtype <= 3) && (device == MIXmicrophone) )
		level >>= 1;

	if( SBtype <= 3 && SBProMixRegs[device] )               // Soundblaster Pro shares each register between two channels
	{
		r1 = SbReadMixerReg(SBProMixRegs[device]);

		switch( channel )                       // We have to set the correct part of the byte.
		{
			case MIXright: r2 = (r1 & 0xF0) + (level>>4); break;
			case MIXleft:   r2 = (r1 & 0x0F) + (level & 0xF0); break;
			case MIXboth:  r2 = (level & 0xF0) + (level>>4); break;
		}

		SbWriteMixerReg(SBProMixRegs[device],r2);
	}

	if( SBtype >= 4 && SB16MixRegs[device] )                        // Soundblaster 16 uses register per channel
		switch( channel )                                                                               // Makes things a bit easier, no?
		{
			case MIXleft:   SbWriteMixerReg(SB16MixRegs[device]  ,level); break;
			case MIXright:  SbWriteMixerReg(SB16MixRegs[device]+1,level); break;
			case MIXboth:  SbWriteMixerReg(SB16MixRegs[device]  ,level);
								SbWriteMixerReg(SB16MixRegs[device]+1,level); break;
		}
}




void mix_set_sb16_output(int value)
{
#ifdef DEBUG_PROC
	printf("mix_set_sb16_output: %i\n",value);
#endif

	SbWriteMixerReg(0x3C,value);            // Send output value raw :)
}

void mix_set_sb16_input(int channel, int value)
{
#ifdef DEBUG_PROC
	printf("mix_set_sb16_value: channel %i value %i\n",channel,value);
#endif

	switch( channel )
	{
		case MIXboth:  SbWriteMixerReg(0x3E,value);
		case MIXleft:  SbWriteMixerReg(0x3D,value); break;
		case MIXright: SbWriteMixerReg(0x3E,value); break;
	}
}

void mix_set_input(int value)
{
	int i;

#ifdef DEBUG_PROC
	printf("mix_set_input: %x",value);
#endif

	SbReadMixerReg(0x0C);                   // Read input control byte

/*  bit:  7 6 5 4 3 2 1 0           F=frequency (0=low, 1=high)
			 x x T x F S S x           SS=source (00=MIC, 01=CD, 11=LINE)
												T=input filter switch (ANFI) */

//      i &= 0xF9;
	i |= 0x20;

	switch( value )
	{
		case 0x18: i |= 6; break;
		case 0x06: i |= 2; break;
		case 0x01: break;
	}




















The Input register selects the SB Pro sound input source and filter type.

              Index = 0Ch
              Ŀ
               7  6  5  4  3  2  1  0 
              
                           
                                     
                Ŀ Ŀ
                 In Filter         ADC Source        
                 000 - Low         00 - Microphone 1 
                 001 - High        01 - CD           
                 010 - No Filter   10 - Microphone 2 
                  11 - Line In      
                                    



The Output register determines whether to output sound in stereo or mono, in
stereo two bytes must be sent for each sample, the first one goes to the left
channel and the next one goes to the right. This register allows you to
bypass the output filter.

              Index = 0Eh
              Ŀ
               7  6  5  4  3  2  1  0 
              
                                       
           Ŀ Ŀ
            DNFI                    VSTC       
            0 - Use O/P Filter      0 - Mono   
            1 - Bypass O/P Filter   1 - Stereo 
            


The Master Volume register allows you to set the master volume of each
channel:

              Index = 22h
              Ŀ
               7  6  5  4  3  2  1  0 
              
                   
                                     
             ĿĿ
              Master Volume  Master Volume 
                  Left           Right     
             


The Voice Volume register allows you to set the volume of each channel for
DSP output:

              Index = 04h
              Ŀ
               7  6  5  4  3  2  1  0 
              
                   
                                     
              ĿĿ
               Voice Volume  Voice Volume 
                   Left          Right    
              

                 Voice Volume    Voice Volume
                    Left            Right


The FM Volume register allows you to set the volume of each channel for
FM wave synthesis:



              Index = 26h
              Ŀ
               7  6  5  4  3  2  1  0 
              
                   
                                     
                Ŀ   Ŀ
                 FM Volume     FM Volume 
                   Left          Right   
                   


The CD Volume register allows you to set the volume of each channel for
CD output:

              Index = 28h
              Ŀ
               7  6  5  4  3  2  1  0 
              
                   
                                     
                Ŀ   Ŀ
                 CD Volume     CD Volume 
                   Left          Right   
                   


The Line Volume register allows you to set the volume of each channel for
line in channel:


              Index = 2Eh
              Ŀ
               7  6  5  4  3  2  1  0 
              
                   
                                     
               Ŀ Ŀ
                Line Volume   Line Volume 
                   Left          Right    
                

The Mic Mixing register allows you to set the input volume for the
microphone:

              Index = 0Ah
              Ŀ
               7  6  5  4  3  2  1  0 
              
                                    
                                        
                                 Ŀ
                                  Mic Mixing 
                                 




~
