;[]--------------------------------------------------------------------------[]
;| AUDIO MANAGER 3.0: NO-SOUND DRIVER by Kenneth Foo. 1994.                   |
;[]--------------------------------------------------------------------------[]
.CSEG   AM
SDI_NS_INFO DB 'AUDIO MANAGER 3.0: NO-SOUND DRIVER by Kenneth Foo. 1994.'
	DD_ALIGN
	SDIproc_NS      dw      _NSgetinfo
			dw      _NS0 ;detect
			dw      _NS0 ;reset
			dw      _NS0 ;init
			dw      _NS0 ;deinit
			dw      _NS4 ;start
			dw      _NS0 ;stop
			dw      _NS0 ;poll
			dw      _NSsetUpdate
			dw      _NS2 ;initTrack
			dw      _NS2 ;deinitTrack
			dw      _NS6 ;setSample
			dw      _NS4 ;setVolume
			dw      _NS6 ;setFrequency
			dw      _NS4 ;setPanPos
			dw      _NS6 ;setOffset
			dw      _NS0 ;keyOn
			dw      _NS0 ;keyOff
			dw      _NSallocMem
			dw      _NS4 ;deallocMem
			dw      _NSloadSample
			dw      _NS0 ;unloadSample
	NS SDIhardware <>
;
;_NS - Function dispatcher                                             
;
_NS     PROC NEAR
	shl bx,1
	jmp SDIproc_NS[bx]
	ENDP
_NS0    PROC NEAR
	clc
	ret
	ENDP
_NS2    PROC NEAR
	clc
	ret 2
	ENDP
_NS4    PROC NEAR
	clc
	ret 4
	ENDP
_NS6    PROC NEAR
	clc
	ret 6
	ENDP
;
;_NSdetect                                                             
;OUT:  DX:AX=Hardware SDI structure address                            
;_NSreset                                                              
;_NSinit                                                               
;_NSdeinit                                                             
;_NSstart                                                              
;IN:   MixRate, Flag:W (Flag: Bit 0=Stereo 1=16-bit)                   
;_NSstop                                                               
;_NSpoll                                                               
;_NSallocMem                                                           
;IN:   NumberBytes:DWORD                                               
;OUT:  EAX=Handle if Carry0 (Success)                                  
;_NSdeallocMem                                                         
;IN:   Handle:DWORD                                                    
;_NSloadSample                                                         
;IN:   SmpStrucAdd:DWORD,FileHandle:WORD,FilePos:DWORD                 
;OUT:  EAX=Pos past sample                                             
;_NSunloadSample                                                       
;IN:   SmpStrucAdd:DWORD                                               
;_NSsetSample                                                          
;IN:   Track:WORD,SmpStrucAdd:DWORD                                    
;_NSsetVolume                                                          
;IN:   Track:WORD,Volume:WORD                                          
;_NSsetFrequency                                                       
;IN:   Track:WORD,Frequency:DWORD                                      
;_NSsetPanPos                                                          
;IN:   Track:WORD,PanPos:WORD                                          
;_NSsetOffset                                                          
;IN:   Track:WORD,Offset:DWORD                                         
;_NSkeyOn                                                              
;IN:   Track:WORD                                                      
;_NSkeyOff                                                             
;IN:   Track:WORD                                                      
;
_NSgetInfo PROC NEAR
	mov     dx,seg NS
	mov     ax,offset NS
	clc
	ret
	ENDP
_NSallocMem PROC NEAR ;NBytes:DWORD
	xor     eax,eax
	clc
	ret 4
	ENDP
_NSloadSample PROC NEAR USES DS SI, StrucAdd:DWORD, Hdl:WORD,FPos:DWORD
	lds     si,StrucAdd
	mov     eax,[ds:si][SmpX.SMPlength]
	add     eax,FPos
	clc
	ret
	ENDP
;
;_NSupdate                                                             
;IN:   UpdateRate:WORD,UpdateRoutine:DWORD                             
;
_NSsetUpdate PROC NEAR UpdateRate:WORD,UpdateR:DWORD
	;USE TIMER CHIP MANAGER------------------------------------
	;USE TIMER CHIP MANAGER------------------------------------
	;USE TIMER CHIP MANAGER------------------------------------
	;USE TIMER CHIP MANAGER------------------------------------
	clc
	ret
	ENDP
.CSEG_ENDS      AM



