;TO ADD..S3M EFX=SET EVENT
;[]------------------------------------------------------------------------[]
;| AUDIO MANAGER III by Kenneth Foo aka TechnoMaestro 1994.                 |
;[]------------------------------------------------------------------------[]
;  S3M MUSIC LOADER (LOAD S3M INTO AMM FORMAT IN MEMORY)
;
;NOTES
; AMM was actually built around the S3M format. However, AMM does not
; use the 1-tick-faster volume slides. It will, however, emulate it when
; the S3M bug emulation bit is set in the AMM module.
;
; Therefore, many S3M peculiarities are borrowed. For example, in many
; effects, effect parameter 0 means using the previous value, whereas in
; MODs, it will use THAT value itself. For example, volume slides with
; parameter 0 means continue volume slides in S3M and AMM, but in MODs,
; it means slide with speed 0, which essentially does nothing.
;
; Also, S3M has this bug in it's TREMOR. A value of 0 actually means 1.
; (Actual tremor values are 1-tick larger).
;
; S3M also has numerous other bugs. They are as follows...
;
;  Period clipping doesn't take into account signed values.
;   Especially in slides, where the period can go into the negative value
;   range, S3M will just assume it as an unsigned value. So, it will clip
;   any negative values to it's largest period value (which is, actually
;   the lowest tone).
;
;  Scream Tracker editor bug:
;   - Watch out for patterns with it's pointers pointing to the start of the
;     S3M file (MemSeg=0). 0 actually means that there is NO PATTERN.
;     RMP (Renaissance Module Player) suffers this problem and gets problems
;     loading Omniphilla (Rama Gardens II).
;   - Scream Tracker also has this really annoying bug in it's note list.
;     Sometimes, you will get notes/volumes/effects with it's track value
;     out of range. Those, I presume, are once present tracks...but were
;     deleted...and poor ST3 forgot to remove them. Just process them like
;     normal events but IGNORE THEM. (You'll need to update the pointers
;     to the notes).
;
; This loader might still have problems. It failed when loading 2ND_SKAV.S3M
; using Base-only memory.
;
;
;DATA IN CODE SEGMENT
;
.CSEG   AM
AM_MI_S3M_INFO DB 'AUDIO MANAGER 3.0: S3M LOADER by Kenneth Foo',01ah
	S3Mheader       LABEL BYTE
		S3MsongName     db 28 dup(0)
		S3Meof          db 01ah
		S3Mtyp          db 0
		S3Munused1      dw 0
		S3MordNum       dw 0
		S3MinsNum       dw 0
		S3MpatNum       dw 0
		S3Mflags        dw 0
		S3Mcwtv         dw 0
		S3Mffv          dw 0
		S3Mmarker       db 'SCRM'
		S3Mgv           db 0
		S3Mis           db 0
		S3Mit           db 0
		S3Mmv           db 0
		S3Muc           db 0
		S3Mdp           db 0
		S3Munused2      db 8 dup(0)
		S3Mspecial      dw 0
		S3MchannelSetting db 32 dup(0)
	S3MSMPheader    LABEL BYTE
		S3MSMPt         db 0
		S3MSMPfileName  db 13 dup(0)
		S3MSMPmemSeg    dw 0
		S3MSMPlength    dd 0
		S3MSMPloopB     dd 0
		S3MSMPloopP     dd 0
		S3MSMPvolume    db 0
		S3MSMPunused1   db 0
		S3MSMPp         db 0
		S3MSMPf         db 0
		S3MSMPc2spd     dd 0
		S3MSMPunused2   dd 0
		S3MSMPintGp     dw 0
		S3MSMPint512    dw 0
		S3MSMPintLastUsed dd 0
		S3MSMPname      db 28 dup(0)
		S3MSMPmarker    db 'SCRS'
	S3M_TMPpatLen           dw 0
	S3M_Buffer              db 32 dup(0)    ;Pan position buffer

.CSEG_ENDS AM
;
;CODE
;
.CSEG   AM

;
;_AMmusicLoadS3M                                                          
;I:  FileHandle:W, PosInFile:D                                            
;O:  Carry0 = Success, EAX=Pos in file past music                         
;    Carry1 = Error. AX=Error.                                            
;
_AMmusicLoadS3M proc uses ebx ecx edx si di es ds fs, FileHandle:WORD,PosInFile:DWORD

LOCAL   TMPbuffer:WORD,TMPpatternCount:WORD,TMPpatternOffset:DWORD,\
	TMPtotalSampleSize:DWORD,TMPmemPos:DWORD,TMPorigFilePos:DWORD,\
	TMPsmpPtr:WORD,TMPsmpCnt:WORD,TMPpatPtr:WORD,TMPfurthestOffset:DWORD,\
	TMPbufferReadOffset:WORD,TMProwOffset:WORD,TMProwCount:BYTE

	setDS

	;CHECK AM SYSTEM, IF INITIALIZED.
	mov     ErrorCode,ERR_NotPossible
	test    AM.AM_Status,1b
	jz      @@Error
	;CHECK IF A MODULE IS ALREADY LOADED
	test    AM.AM_Status,1000000000000b
	mov     ErrorCode,ERR_AlreadyDone
	jnz     @@Error

	mov     eax,PosInFile
	mov     TMPorigFilePos,eax

	;LOAD S3M HEADER
	mov     ErrorCode,ERR_CannotManageDisk
	push    Filehandle
	push    PosInFile
	push    word ptr 0
	call    _DMseekFile
	jc      @@Error
	push    FileHandle                      ;Read 96-byte header
	push    seg S3Mheader
	push    offset S3Mheader
	push    word ptr 060h
	call    _DMreadFile
	jc      @@Error
	add     PosInFile,060h

	;SET/RESET DATAS
	mov     Music.MUSextraDataLength,0
	mov     ErrorCode,ERR_BadData           ;===Check type=16 (ST3)===
	cmp     S3Mtyp,16
	jne     @@Error
	;mov     eax,dword ptr S3Mmarker         ;===Check 'SCRM' string
	cmp     dword ptr S3Mmarker,'MRCS' ;SCRM_Marker
	jne     @@Error
	mov     cx,28                           ;===SET MUSIC NAME===
	xor     bx,bx
	@@CopyName:
	mov     al,S3MsongName[bx]
	mov     Music.MUSname[bx],al
	inc     bx
	loop    @@CopyName
	mov     cx,40-28
	@@ClearName:
	mov     Music.MUSname[bx],0
	inc     bx
	loop    @@ClearName
	mov     Music.MUSversion,0              ;===Version of AM Tracker===
	mov     ax,S3MordNum                    ;===Num orders/samples/pats===
	mov     Music.MUSsongLength,ax
	mov     ax,S3MinsNum
	mov     Music.MUSnumberSamples,ax
	mov     ax,S3MpatNum
	mov     Music.MUSnumberPatterns,ax
	mov     bx,0110b                        ;===Info/flags===
	mov     ax,S3Mcwtv                      ;Get tracker version
	cmp     ax,01320h
	jae     short @@NewVersions
	or      bl,100000b ;Fast volume slides (early S3Ms)
	@@NewVersions:
	sub     ax,01000h
	mov     Music.MUSnativeTrackerVersion,ax

	mov     ax,S3Mflags                     ;Default. S3M limit, bugs,reset
	test    ax,10000b                       ;speed, stereo.
	jz      short @@S3Mlimit                ;*Throw off special custom
	or      bl,1b ;MOD limit                ;*data, vol optimization,
	@@S3Mlimit:                             ;*and old S3M support.
	test    S3Mmv,10000000b
	jz      short @@Mono
	or      bl,10000b ;Stereo
	@@Mono:
	test    ax,1000000b
	jz      short @@NoFastVolSlide
	or      bl,100000b ;Fast volume slides (early S3Ms)
	@@NoFastVolSlide:

	mov     Music.MUSinfo,bx
	mov     Music.MUSsource,3               ;===Source=== Coverted from S3M
	mov     al,S3Mgv                        ;===Global volume (0-64)
	xor     ah,ah
	shl     ax,2 ;AMM (0-256)
	mov     Music.MUSmasterVolume,ax
	mov     al,S3Mmv                        ;===Master volume (0-128,bit7)
	xor     ah,ah
	and     al,01111111b
	shl     ax,1 ;AMM (0-256)
	mov     Music.MUSamplification,ax
	mov     al,S3Mis                        ;===Init speed/tempo===
	mov     Music.MUSinitSpeed,al
	mov     al,S3Mit
	mov     Music.MUSinitTempo,al

	mov     cx,32                           ;===Channel setting.===
	xor     dx,dx                           ;DX=highest track number = number tracks
	xor     bx,bx
	mov     di,1    ;Start from track 1!
	@@SearchChannels:                       ;Does not retain L/R flags for
	mov     ah,255                          ;255=Disabled
	mov     al,S3MchannelSetting[bx]        ;for channels!
	cmp     al,255
	je      @@BlankSetting
	mov     dx,di                           ;DX=Highest channel number
	test    al,10000000b                    ;Disabled channel...
	jnz     short @@BlankSetting
	;jz      short @@NotDisabledTrack
	;jmp     short @@Left
	;@@NotDisabledTrack:
	cmp     al,16
	jae     @@BlankSetting  ;Error ;Adlib melody unsupported!
	mov     ah,0 ;For faster execution? ;24 ;3*8
	cmp     al,8
	jb      short @@Left
	mov     ah,128 ;For faster execution? ;104 ;128-(3*8)
	@@Left:
      @@BlankSetting:
	mov     Music.MUSinitPan[di],ah
	inc     di
	;@@BlankSetting:
	inc     bx
	loop    @@SearchChannels
	or      dx,dx ;di,di                           ;No tracks = error!
	jz      @@Error
	mov     Music.MUSnumberTracks,dx ;di        ;===Number tracks===

	;GET SEQUENCES
	push    FileHandle                      ;Read 96-byte header
	push    seg MI_Buffer
	push    offset MI_Buffer
	movzx   eax,Music.MUSsongLength
	add     PosInFile,eax
	push    ax
	call    _DMreadFile
	jc      @@Error
	xor     bx,bx
	mov     cx,Music.MUSsongLength
	@@CopySequence:
	mov     al,byte ptr MI_Buffer[bx]
	xor     ah,ah
	cmp     al,254
	jb      short @@NormalPat
	mov     ax,65534                        ;Skip
	je      short @@NormalPat
	mov     ax,65535                        ;End of song
	@@NormalPat:
	shl     bx,1
	mov     Music.MUSsequence[bx],ax
	shr     bx,1
	inc     bx
	loop    @@CopySequence

	;GET ACTUAL PLAY LENGTH.
	;SEARCH TILL END OF SONG MARKER...THAT'S THE ACTUALY PLAY LENGTH.
	;S3M CAN HAVE EXTRA PATTERNS AFTER THE END OF SONG MARKER!
	;FOR EXAMPLE, THE ASM '94 INTRO MUSIC.
comment ~
	xor     bx,bx
	mov     cx,Music.MUSsongLength
	@@FindActualLength:
	cmp     Music.MUSsequence[bx],65535
	je      short @@FoundEOS
	inc     bx
	inc     bx
	loop    @@FindActualLength
	@@FoundEOS:
	shr     bx,1
	;inc     bx
	mov     Music.MUSsongPlayLength,bx
~
mov     ax,Music.MUSsongLength
mov     Music.MUSsongPlayLength,ax

	;GET SAMPLE INFOS AND CONVERT THEM...
	;===READ SAMPLE INFOS===
	mov     TMPtotalSampleSize,0
	mov     ErrorCode,ERR_CannotManageDisk
	push    FileHandle                      ;Read sample pointers
	push    seg MI_Buffer
	push    offset MI_Buffer
	movzx   eax,Music.MUSnumberSamples
	shl     ax,1
	add     PosInFile,eax
	push    ax
	call    _DMreadFile
	jc      @@Error
	mov     TMPsmpPtr,0
	mov     di,(SIZE SmpX)                  ;First sample (SMP1)
	mov     cx,Music.MUSnumberSamples
	or      cx,cx
	jz      @@NoSampleInfo
	mov     TMPsmpCnt,cx
      @@ReadSampleInfo:
	;----------=====READ SAMPLE INFO
	mov     ErrorCode,ERR_CannotManageDisk
	mov     bx,TMPsmpPtr

;cmp     bx,28*2
;jb      short @@NoTTimeToShit
;nop
;nop
;nop
;@@NoTTimeToShit:

	movzx   eax,word ptr MI_Buffer[bx]      ;Position file
	shl     eax,4                           ;x 16
	add     eax,TMPorigFilePos
	push    Filehandle
	push    eax
	push    word ptr 0
	call    _DMseekFile
	jc      @@Error
	push    FileHandle                      ;Read S3M SMP header
	push    seg S3MSMPheader
	push    offset S3MSMPheader
	push    word ptr 80
	call    _DMreadFile
	jc      @@Error
	;--------=====CONVERT TO AMS FORMAT IN MEMORY
	;Make length 0 first... (for phun..)
	mov     dword ptr MI_SampleInfos[di][SmpX.SMPlength],0

	mov     ErrorCode,ERR_BadData           ;Must be sample, not adlib smp!
	xor     bx,bx                           ;===Sample file name===
	mov     cx,13
	@@SMPfileName:
	mov     al,S3MSMPfileName[bx]
	mov     byte ptr MI_SampleInfos[di][SmpX.SMPfileName][bx],al
	inc     bx
	loop    @@SMPfileName
	mov     cx,28                           ;===Sample name===
	xor     bx,bx
	@@SMPname:
	mov     al,S3MSMPname[bx]
	mov     byte ptr MI_SampleInfos[di][SmpX.SMPname][bx],al
	inc     bx
	loop    @@SMPname
	mov     word ptr MI_SampleInfos[di][SmpX.SMPname][bx],0 ;Last 2 bytes = 0
	cmp     S3MSMPt,1                       ;0=No smp, 1=SMP 2,3=Adlib
	ja      @@Error
	jb      @@BlankSampleInfo
	cmp     dword ptr S3MSMPmarker,'SRCS'
	jne     @@Error
	movzx   eax,S3MSMPmemSeg                ;===STORE POS IN FILE AS
	shl     eax,4                           ;===POS IN MEMORY FIRST...
	mov     dword ptr MI_SampleInfos[di][SmpX.SMPmemPos],eax
	mov     eax,S3MSMPlength                ;===Sample length,loopB,loopP
	mov     dword ptr MI_SampleInfos[di][SmpX.SMPlength],eax
;32-BYTE BOUNDARY LAHHH....
add     eax,31
and     eax,0FFFFFFE0h
add     TMPtotalSampleSize,eax
	mov     eax,S3MSMPloopB
	mov     dword ptr MI_SampleInfos[di][SmpX.SMPloopB],eax
	mov     eax,S3MSMPloopP
	mov     dword ptr MI_SampleInfos[di][SmpX.SMPloopP],eax
	mov     al,S3MSMPvolume                 ;===Volume===
	mov     byte ptr MI_SampleInfos[di][SmpX.SMPvolume],al
	cmp     S3MSMPp,0                       ;===Packed sample not supported
	jne     @@Error
	mov     al,S3MSMPf                      ;===Stereo/16-bit sample not
	test    al,110b                         ;===supported
	jnz     @@Error
	xor     ah,ah                           ;===Check looped flag
	test    al,1b                           ;Unsigned too...
	jz      @@NotLooped
	or      ah,1000b
	@@NotLooped:
	;mov     al,ah
	;xor     ah,ah
	shr     ax,8
	or      al,10b ;8-bit
	mov     word ptr MI_SampleInfos[di][SmpX.SMPinfo],ax
	mov     eax,S3MSMPc2spd                 ;===Mid C===
	cmp     eax,0
	jne     short @@MidCNot0
	mov     ax,8363                 ;FORCE TO 8363 AVOIDS DIV 0 ERR!
	@@MidCNot0:
	mov     dword ptr MI_SampleInfos[di][SmpX.SMPmidC],eax
	;jmp     short @@NotBlank
      @@BlankSampleInfo:
	add     TMPsmpPtr,2
	add     di,(SIZE SmpX)
	dec     TMPsmpCnt
	jnz     @@ReadSampleInfo
      @@NoSampleInfo:

	;ALLOCATE MEMORY FOR SAMPLES
	;mov     ErrorCode,ERR_CannotManageDisk
	mov     eax,TMPtotalSampleSize          ;Allocate one BIG memory chunk
	;add     eax,2048                        ;Add 2k safety pool
	push    eax
	call    _AMallocMem
	doerr   ERR_NotEnoughMemory
	mov     MI_SampleMemHandle,eax


;mov     ax,0e07h        ;BEEP!
;int     010h
;mov     ax,0eb0h
;int     010h

	;READ PATTERN POINTERS
	mov     ErrorCode,ERR_CannotManageDisk
	push    Filehandle
	push    PosInFile
	push    word ptr 0
	call    _DMseekFile
	jc      @@Error
	push    FileHandle
	push    seg MI_Buffer
	push    offset MI_Buffer
	mov     ax,Music.MUSnumberPatterns
	shl     ax,1
	add     PosInFile,eax
	push    ax
	call    _DMreadFile
	jc      @@Error

	;READ CHANNEL PAN POSITION (32 bytes)
	;==!! Contains junk in unused channels! Thus, ignore those with
	;==!! unused channel flag!
	;==!! New to Scream Tracker 3.20!
	cmp     S3Mdp,252
	jne     short @@NoPanningPos
	mov     ErrorCode,ERR_CannotManageDisk
	push    FileHandle
	push    seg S3M_Buffer
	push    offset S3M_Buffer
	add     PosInFile,32
	push    ax
	call    _DMreadFile
	jc      @@Error
	xor     bx,bx
	mov     dx,03h                          ;By default, panning value = 3 & C (left,right)
	mov     cx,32                           ;Max 32 channels
	@@DoPanPos:
	test    S3MchannelSetting[bx],10000000b
	jnz     short @@Disabled_NoPan
	mov     al,S3M_Buffer[bx]
	test    al,100000b
	jz      short @@UseDefaultPanPos
	and     al,011111b
	shl     al,3                            ;Inaccurate 0-15 to 0-128 pan!
	;jmp     short @@WritePanValue
	;@@UseDefaultPanPos:
	;mov     al,dl
	;shl     al,3                            ;Inaccurate 0-15 to 0-128 pan!
	;@@WritePanValue:
	mov     Music.MUSinitPan[bx+1],al       ;Track *1* (not 0 as in S3M?)
	@@UseDefaultPanPos:     ;Default pan pos: Use the L or R thingy! (Channel setting)
	@@Disabled_NoPan:
	xor     dl,15
	inc     bx
	loop    @@DoPanPos
	@@NoPanningPos:

	;ALLOCATE MEMORY FOR TRACKS' PATTERNS & TEMPORARY BUFFER
	mov     bx,2                            ;Alloc track memory
	mov     cx,Music.MUSnumberTracks        ;BX=2 (start from Track1)
	@@AllocateTracks:
	mov     ax,(64*(SIZE NoteX))
	mul     Music.MUSnumberPatterns
	xchg    ax,dx
	shl     eax,16
	mov     ax,dx
	push    eax
	call    _MEMqAlloc
	doerr   ERR_NotEnoughMemory
	mov     di,AM_TrackTable[bx]
	mov     [cs:TrackX.TRKmemHandle][di],eax
	inc     bx
	inc     bx
	loop    @@AllocateTracks
	;---ALLOCATE TEMPORARY BUFFER---        ;Alloc temporary buffer.
	;xor     eax,eax                        ;We allocate MORE THAN
	mov     ax,Music.MUSnumberTracks        ;sufficient bytes bcoz of the
	mov     bx,(6*64)+((SIZE NoteX)*64)     ;structure of S3M. Up to 32
	mul     bx                              ;channels may be present?
	add     ax,64   ;Add 64 coz of end of row markers!
	adc     dx,0
	push    dx                              ;(or is it 16?) Each note
	push    ax                              ;can be up to 6 bytes long!
	call    _MEMallocBase                   ;Extra 5x64xNumTracks for
	doerr   ERR_NotEnoughMemory             ;intermeddiate buffer.
	mov     TMPbuffer,dx
	;=====================================================================;
	;Due to the weird structure of S3Ms, I have to create an intermeddiate;
	;buffer and convert the S3M data to there. Then, from there, I copy   ;
	;the contents into the actual memory patterns.                        ;
	;=====================================================================;
	mov     TMPpatternOffset,0
	mov     TMPpatPtr,0                     ;Structure of TMPbuffer
	mov     ax,Music.MUSnumberTracks        ;5x64   Track1
	mov     bx,(SIZE NoteX)*64              ;5x64   Track2
	mul     bx                              ;5x64   ...
	mov     TMPbufferReadOffset,ax          ;xxxx   S3M patterns...


	;READ PATTERNS
	mov     ax,Music.MUSnumberPatterns
	mov     TMPpatternCount,ax
	@@ReadPatterns: ;------------------------------------------------
	mov     ErrorCode,ERR_CannotManageDisk
	;=====Clear tracks...
	mov     es,TMPbuffer
	cld
	xor     di,di
	mov     ax,Music.MUSnumberTracks
	mov     bx,(SIZE NoteX)*64
	mul     bx
	mov     cx,ax
	mov     al,255
	rep     stosb

	mov     bx,TMPpatPtr
	movzx   eax,word ptr MI_Buffer[bx]      ;Position file
	shl     eax,4                           ;x 16
	;****************************************************************
	;***UNDOCUMENTED. MEM SEG OF 0 = NO PATTERN! JUST IGNORE IT...***
	;****************************************************************
	jz      @@DonePattern
	add     eax,TMPorigFilePos
	push    Filehandle
	push    eax
	push    word ptr 0
	call    _DMseekFile
	jc      @@Error
	push    FileHandle                      ;Get length of packed pattern
	push    cs
	push    offset S3M_TMPpatLen
	push    word ptr 2
	call    _DMreadFile
	jc      @@Error
	sub     S3M_TMPpatLen,2                 ;Length includes the length word
	push    FileHandle
	push    TMPbuffer
	push    TMPbufferReadOffset
	push    S3M_TMPpatLen
	call    _DMreadFile
	jc      @@Error
		;@@ReadData:     ;-----------------------------------------
		;ES     = SEG of TMPbuffer
		;SI     = OFFSET in TMPbuffer
		;FS:DI  = SEG:OFF of AMM pattern
		mov     es,TMPbuffer
	cmp     S3M_TMPpatLen,0                 ;Totally empty pattern...
	je      @@DonePattern
		mov     TMProwOffset,0
		mov     si,TMPbufferReadOffset
		mov     TMProwCount,64
	      @@ReadNote:
		mov     al,es:[si]
		and     al,11111b               ;Get channel(track) number
		xor     ah,ah                   ;and get offset in TMPbuffer
	;*****************************************************************
	;***UNDOCUMENTED. OUT OF TRACK-RANGE DATA AND IT'S RELATED BYTES *
	;***MUST BE IGNORED!                                             *
	;*****************************************************************
		;TRACK OUT OF RANGE!
		cmp     ax,Music.MUSnumberTracks
		jb      short @@InTrackRange
		mov     al,es:[si]
		inc     si
		dec     S3M_TMPpatLen
		test    al,100000b
		jz      short @@XNoNote
		inc     si
		inc     si
		sub     S3M_TMPpatLen,2
		@@XNoNote:
		test    al,1000000b
		jz      short @@XNoVol
		inc     si
		dec     S3M_TMPpatLen
		@@XNoVol:
		test    al,10000000b
		jz      short @@XNoEFX
		inc     si
		inc     si
		sub     S3M_TMPpatLen,2
		@@XNoEFX:
		jmp     short @@ReadNote
		@@InTrackRange:


		mov     bx,(SIZE NoteX)*64
		mul     bx
		mov     di,TMProwOffset
		add     di,ax

		mov     al,es:[si]
		inc     si
		dec     S3M_TMPpatLen
		or      al,al                   ;0=Row done
		jz      @@DoneRow
		test    al,100000b              ;===Get NOTE and SAMPLE
		jz      short @@NoNote
		mov     ah,es:[si]
		mov     [es:di][NoteX.NOTEnote],ah ;255=Blank. Same as AMM.
		inc     si
		mov     ah,es:[si]
		or      ah,ah                   ;S3M. Blank=0 .. AMM,Blank=255
		jz      short @@InsNotPresent
		mov     [es:di][NoteX.NOTEsampleNumber],ah
		@@InsNotPresent:
		inc     si
		sub     S3M_TMPpatLen,2
		js      @@Error
		@@NoNote:
		test    al,1000000b             ;===Get VOLUME
		jz      short @@NoVol
		mov     ah,es:[si]
		mov     [es:di][NoteX.NOTEvolume],ah
		inc     si
		dec     S3M_TMPpatLen
		js      @@Error
		@@NoVol:
		test    al,10000000b            ;===Get EFX number and data
		jz      @@NoCmd
		mov     bl,es:[si]              ;Data without command (cmd0)
		inc     si                      ;= no effect (0).
		mov     bh,es:[si]
		inc     si
		sub     S3M_TMPpatLen,2
		js      @@Error
		;================================================;
		;;
		;CONVERSION OF MOD EFFECTS INTO AMM EFFECTS;
		;CONVERSION OF MOD EFFECTS INTO AMM EFFECTS;
		;CONVERSION OF MOD EFFECTS INTO AMM EFFECTS;
		;;
		;================================================;
		;**********FOR NOW, CLEAR ALL EFX***********
		;mov     bl,255
		;mov     bh,255
			;SET SPEED
			cmp     bl,'A'-64
			jne     @@NotSS
			mov     bl,MI@EFXsetSpeed
			jmp     @@DoneEFX
			@@NotSS:
			;JUMP TO ORDER
			cmp     bl,'B'-64
			jne     @@NotJTO
			mov     bl,MI@EFXpatternJump
			jmp     @@DoneEFX
			@@NotJTO:
			;BREAK PATTERN (to row)
			cmp     bl,'C'-64
			jne     @@NotBP
			;Convert decimal to hexadecimal
			mov     bl,MI@EFXpatternBreak
			mov     al,bh
			shr     al,4
			mov     ah,10
			mul     ah
			and     bh,0Fh
			add     bh,al
			jmp     @@DoneEFX
			@@NotBP:
			;VOLUME SLIDES
			cmp     bl,'D'-64
			jne     @@NotVS
			mov     bl,MI@EFXvolumeSlide
			jmp     @@DoneEFX
			@@NotVS:
			;SLIDE DOWNS
			cmp     bl,'E'-64
			jne     @@NotSD
			mov     bl,MI@EFXslideDown
			jmp     @@DoneEFX
			@@NotSD:
			;SLIDE UPS
			cmp     bl,'F'-64
			jne     @@NotSU
			mov     bl,MI@EFXslideUp
			jmp     @@DoneEFX
			@@NotSU:
			;SLIDE TO NOTE
			cmp     bl,'G'-64
			jne     @@NotSTN
			mov     bl,MI@EFXslideToNote
			jmp     @@DoneEFX
			@@NotSTN:
			;VIBRATO
			cmp     bl,'H'-64
			jne     @@NotV
			mov     bl,MI@EFXvibrato
			jmp     @@DoneEFX
			@@NotV:
			;TREMOR
			cmp     bl,'I'-64
			jne     @@NotTREMOR
			mov     bl,MI@EFXtremor
			jmp     @@DoneEFX
			@@NotTREMOR:
			;ARPEGGIO
			cmp     bl,'J'-64
			jne     @@NotARP
			mov     bl,MI@EFXarpeggio
			jmp     @@DoneEFX
			@@NotARP:
			;CONTINUE VIBRATO AND DO VOLUME SLIDE
			cmp     bl,'K'-64
			jne     @@NotVVS
			mov     bl,MI@EFXvibrato_VolumeSlide
			jmp     @@DoneEFX
			@@NotVVS:
			;CONTINUE SLIDE TO NOTE AND DO VOLUME SLIDE
			cmp     bl,'L'-64
			jne     @@NotSTNVS
			mov     bl,MI@EFXslideToNote_VolumeSlide
			jmp     @@DoneEFX
			@@NotSTNVS:
			;SET SAMPLE OFFSET
			cmp     bl,'O'-64
			jne     @@NotSO
			mov     bl,MI@EFXsetSampleOffset
			jmp     @@DoneEFX
			@@NotSO:
			;TREMOLO
			cmp     bl,'R'-64
			jne     @@NotTREMOLO
			mov     bl,MI@EFXtremolo
			jmp     @@DoneEFX
			@@NotTREMOLO:
			;RETRIGGER
			cmp     bl,'Q'-64
			jne     @@NotR
			mov     bl,MI@EFXretrigger
			jmp     @@DoneEFX
			@@NotR:
			;TEMPO
			cmp     bl,'T'-64
			jne     @@NotTempo
			mov     bl,MI@EFXsetTempo
			jmp     @@DoneEFX
			@@NotTempo:
			;MASTER VOLUME
			cmp     bl,'V'-64
			jne     @@NotMV
			mov     bl,MI@EFXsetMasterVolume
			jmp     @@DoneEFX
			@@NotMV:
			;PANNING (AMIGA)
			cmp     bl,'X'-64
			jne     @@NotP
			mov     bl,MI@EFXsetPan
			cmp     bh,128
			jbe     short @@NormalPan
			cmp     bh,255          ;255=Disable
			je      short @@NormalPan
			;ELSE, *ASSUME* IT'S SURROUND.
			mov     bh,254  ;Surround panning! (DMP USES 0A4h)
			@@NormalPan:    ;NOT SUPPORTED YET!
			jmp     @@DoneEFX
			@@NotP:
			;EVENT
			cmp     bl,'Z'-64
			jne     @@NotEVt
			mov     bl,MI@EFXevent
			jmp     @@DoneEFX
			@@NotEVt:
			;FINE VIBRATO
			cmp     bl,'U'-64
			jne     @@NotFVib
			mov     bl,MI@EFXfineVibrato
			jmp     @@DoneEFX
			@@NotFVib:
			;SPECIAL COMMANDS ('S')
			cmp     bl,'S'-64
			jne     @@NotSpecial
			mov     bl,bh
			shr     bl,4
			and     bh,0Fh
			  ;SET FILTER
			  cmp     bl,0
			  jne     @@NotSF
			  mov     bl,MI@EFXsetFilter
			  jmp     @@DoneEFX
			  @@NotSF:
			  ;SET GLISSANDO
			  cmp     bl,1
			  jne     @@NotGLISS
			  mov     bl,MI@EFXsetGlissando
			  jmp     @@DoneEFX
			  @@NotGLISS:
			  ;SET FINE TUNE
			  cmp     bl,2
			  jne     @@NotFT
			  mov     bl,MI@EFXsetFineTune
			  jmp     @@DoneEFX
			  @@NotFT:
			  ;SET VIBRATO WAVEFORM
			  cmp     bl,3
			  jne     @@NotVW
			  mov     bl,MI@EFXsetVibratoWaveform
			  jmp     @@DoneEFX
			  @@NotVW:
			  ;SET TREMOLO WAVEFORM
			  cmp     bl,4
			  jne     @@NotTW
			  mov     bl,MI@EFXsetTremoloWaveform
			  jmp     @@DoneEFX
			  @@NotTW:
			  ;SET PANNING (AMIGA) - INACCURATE! SINCE MID = 7!
			  cmp     bl,4
			  jne     @@NotPan
			  shl     bh,3
			  mov     bl,MI@EFXsetPan
			  jmp     @@DoneEFX
			  @@NotPan:
			  ;STEREO CONTROL
			  cmp     bl,0Ah
			  jne     @@NotSC
			  mov     bl,MI@EFXstereoControl
			  jmp     @@DoneEFX
			  @@NotSC:
			  ;PATTERN LOOP
			  cmp     bl,0Bh
			  jne     @@NotPL
			  mov     bl,MI@EFXpatternLoop
			  jmp     @@DoneEFX
			  @@NotPL:
			  ;NOTE CUT
			  cmp     bl,0Ch
			  jne     @@NotNC
			  mov     bl,MI@EFXcutNote
			  jmp     @@DoneEFX
			  @@NotNC:
			  ;NOTE DELAY
			  cmp     bl,0Dh
			  jne     @@NotND
			  mov     bl,MI@EFXdelayNote
			  jmp     @@DoneEFX
			  @@NotND:
			  ;PATTERN DELAY
			  cmp     bl,0Eh
			  jne     @@NotPD
			  mov     bl,MI@EFXpatternDelay
			  jmp     @@DoneEFX
			  @@NotPD:
			  ;FUNK REPEAT(INVERT LOOP)
			  cmp     bl,0Fh
			  jne     @@NotFR
			  mov     bl,MI@EFXinvertLoop   ;funkRepeat
			  jmp     @@DoneEFX
			  @@NotFR:
			@@NotSpecial:

			;Unknown effect...throw it off..
			mov     bl,255
			@@DoneEFX:
			mov     [es:di][NoteX.NOTEeffect],bl
			mov     [es:di][NoteX.NOTEeffectData],bh
		@@NoCmd:
		jmp     short @@DoneNote
	      @@DoneRow:
		add     TMProwOffset,(SIZE NoteX)
;THIS IS JUST A SAFETY PRECAUTION...MAKES IT IMPOSSIBLE FOR MEMORY OVERWRITE!
;dec     TMProwCount             ;Maybe a cheat by FC to
;jz      short @@DonePattern     ;avoid rippings? :) PIG SHIT.
	      @@DoneNote:
	      mov       ErrorCode,ERR_BadData
	      cmp       S3M_TMPpatLen,0
	      jne       @@ReadNote

	      @@DonePattern:
		;========COPY PROCESSED TMPBUFFER CONTENT INTO MEMORY...
		mov     ErrorCode,ERR_CannotManageMemory
		mov     cx,Music.MUSnumberTracks
		mov     bx,2            ;Start from track 1
		xor     si,si
		@@CopyTracks:
		mov     di,AM_TrackTable[bx]
		push    [cs:TrackX.TRKmemHandle][di]
		push    TMPpatternOffset
		call    _MEMqGetAddress
		jc      @@Error
		mov     fs,dx
		mov     di,ax
		mov     dx,(SIZE NoteX)*64
		@@Copy:
		mov     al,es:[si]
		mov     fs:[di],al
		inc     si
		inc     di
		dec     dx
		jnz     short @@Copy
		inc     bx
		inc     bx
		loop    @@CopyTracks
		add     TMPpatternOffset,(SIZE NoteX)*64
	add     TMPpatPtr,2
	dec     TMPpatternCount
	jnz     @@ReadPatterns


	;DEALLOCATE TEMPORARY BUFFER
	push    TMPbuffer
	push    word ptr 0
	call    _MEMdeallocBase
	doerr   ERR_CannotManageMemory

comment ~
mov     ax,0e07h
int     010h
mov     ax,0e07h
int     010h
mov     ax,0e07h
int     010h
;
pushad
mov     eax,TMPtotalSampleSize          ;Allocate one BIG memory chunk
call    ShitHead2
db '0123456789ABCDEF'
ShitHead2:
pop     di
mov     cx,4*2  ;8 digits...
@@PrintHex2:
	rol     eax,4
	push    eax
	mov     bl,al
	and     bx,1111b
	mov     ah,0eh
	mov     al,cs:[bx][di]
	int     010h
	pop     eax
loop    @@PrintHex2
mov     ax,0e0dh        ;Carriage return...
int     010h
mov     ax,0e0ah
int     010h
mov     ah,0            ;Wait key
int     016h
popad
;
~








;mov     ax,0e07h        ;BEEP!
;int     010h
;mov     ax,0eb0h
;int     010h

	;LOAD SAMPLES
	mov     ErrorCode,ERR_CannotManageDisk
	mov     TMPfurthestOffset,0
	mov     TMPmemPos,0
	mov     bx,2                            ;Start from sample 1...
	mov     cx,Music.MUSnumberSamples
	@@LoadingSamples:
;mov     ax,0eb1h        ;BEEP!
;int     010h

	mov     di,MI_Samples[bx]               ;Set handle and mem pos
	mov     edx,[cs:SmpX.SMPmemPos][di]     ;===POS IN FILE IS IN MEMPOS
	mov     eax,MI_SampleMemHandle          ;===OVERWRITE MEMPOS WITH
	mov     [cs:SmpX.SMPmemHandle][di],eax  ;===REAL POSITION IN MEMORY.
	mov     eax,TMPmemPos
	mov     [cs:SmpX.SMPmemPos][di],eax
	mov     eax,[cs:SmpX.SMPlength][di]
;32-BYTE BOUNDARY LAHHH....
add     eax,31
and     eax,0FFFFFFE0h
	add     TMPmemPos,eax                   ;Increment memory pos
	or      eax,eax
	jz      short @@EmptySample

comment ~
mov     ax,0e07h
int     010h
mov     ax,0e07h
int     010h
mov     ax,0e07h
int     010h
;
pushad
mov     eax,TMPmemPos ;Past mem loc ...edx ;TMPtotalSampleSize          ;Allocate one BIG memory chunk
call    ShitHead
db '0123456789ABCDEF'
ShitHead:
pop     di
mov     cx,4*2  ;8 digits...
@@PrintHex:
	rol     eax,4
	push    eax
	mov     bl,al
	and     bx,1111b
	mov     ah,0eh
	mov     al,cs:[bx][di]
	int     010h
	pop     eax
loop    @@PrintHex
mov     ax,0e0dh        ;Carriage return...
int     010h
mov     ax,0e0ah
int     010h
mov     ah,0            ;Wait key
int     016h
popad
;
~

	push    cs                              ;Load sample...
	push    di
	push    FileHandle
	push    edx
	call    _AMloadSample
	jc      @@Error2
	cmp     eax,TMPfurthestOffset           ;Get largest offset
	jbe     short @@NotFurthest
	mov     TMPfurthestOffset,eax
	@@NotFurthest:
	@@EmptySample:
	inc     bx
	inc     bx
	loop    @@LoadingSamples

	mov     eax,TMPfurthestOffset           ;Returns offset past end

	or      AM.AM_Status,1000000000000b        ;Set LOADED
	quit
	_AMmusicLoadS3M endp

.CSEG_ENDS AM


comment ~
				S3M Module header
	  0   1   2   3   4   5   6   7   8   9   A   B   C   D   E   F
	Ŀ
  0000:  Song name, max 28 chars (end with NUL (0))                    
	Ĵ
  0010:                                                1AhTyp x  x 
	Ĵ
  0020: OrdNum InsNum PatNum  Flags  Cwt/v  Ffi   'S''C''R''M'
	Ĵ
  0030: g.vi.si.tm.vu.cd.p x  x  x  x  x  x  x  x Special
	Ĵ
  0040: Channel settings for 32 channels, 255=unused,+128=disabled     
	Ĵ
  0050:                                                                
	Ĵ
  0060: Orders; length=OrdNum (should be even)                         
	Ĵ
  xxx1: Parapointers to instruments; length=InsNum*2                   
	Ĵ
  xxx2: Parapointers to patterns; length=PatNum*2                      
	Ĵ
  xxx3: Channel default pan positions                                  
	Ĵ
	xxx1=70h+orders
	xxx2=70h+orders+instruments*2
	xxx3=70h+orders+instruments*2+patterns*2

	Parapointers to file offset Y is (Y-Offset of file header)/16.
	You could think of parapointers as segments relative to the
	start of the S3M file.

	Type    = File type: 16=ST3 module
	Ordnum  = Number of orders in file (should be even!)
	Insnum  = Number of instruments in file
	Patnum  = Number of patterns in file
	Cwt/v   = Created with tracker / version: &0xfff=version, >>12=tracker
			ST3.00:0x1300 (NOTE: volumeslides on EVERY frame)
			ST3.01:0x1301
			ST3.03:0x1303
			ST3.20:0x1320
	Ffi     = File format information
			1=[VERY OLD] signed samples
			2=unsigned samples
	Flags   =  [ These are old flags for Ffv1. Not supported in ST3.01
		   |  +1:st2vibrato
		   |  +2:st2tempo
		   |  +4:amigaslides
		   | +32:enable filter/sfx with sb
		   ]
		    +8: 0vol optimizations
			  Automatically turn off looping notes whose volume
			  is zero for >2 note rows.
		   +16: amiga limits
			  Disallow any notes that go beond the amiga hardware
			  limits (like amiga does). This means that sliding
			  up stops at B#5 etc. Also affects some minor amiga
			  compatibility issues.
		   +64: st3.00 volumeslides
			  Normally volumeslide is NOT performed on first
			  frame of each row (this is according to amiga
			  playing). If this is set, volumeslide is performed
			  ALSO on the first row. This is set by default
			  if the Cwt/v files is 0x1300
		  +128: special custom data in file (see below)
	Special = pointer to special custom data (not used by ST3.01)
	ExtHead = pointer to extended header data area (generally after)
		  the main header)
	g.v     = global volume (see next section)
	m.v     = master volume (see next section) 7 lower bits
		  bit 8: stereo(1) / mono(0)
	i.s     = initial speed (command A)
	i.t     = initial tempo (command T)
	u.c     = ultra click removal. ST3 uses u.c gus channels to
		  guarantee, that u.c/2 channels run without any clicks.
		  If more channels are used, some clicks might appear.
		  The number displayed in ST3 order page is u.c/2
	d.p     = 252 when default channel pan positions are present
		  in the end of the header (xxx3). If !=252 ST3 doesn't
		  try to load channel pan settings.

	Channel settings (byte per channel):
	  bit 8: channel enabled
	bit 0-7: channel type
		 0..7   : Left Sample Channel 1-8
		 8..15  : Right Sample Channel 1-8
		 16..31 : Adlib channels (9 melody + 5 drums)

	Channel pan settings (byte per channel):
	bit 6-7: reserved
	  bit 5: 1=default pan position specified, 0=use defaults:
		 for mono 7, for stereo 3 or C.
	bit 0-3: default pan position


	Global volume directly divides the volume numbers used. So
	if the module has a note with volume 48 and master volume
	is 32, the note will be played with volume 24. This affects
	both Gravis & SoundBlasters.

	Master volume only affects the SoundBlaster. It controls
	the amount of sample multiplication (see mixing section
	of this doc). The bigger the value the bigger the output
	volume (and thus quality) will be. However if the value
	is too big, the mixer may have to clip the output to
	fit the 8 bit output stream. The default value works
	pretty well. Note that in stereo, the mastermul is
	internally multiplied by 11/8 inside the player since
	there is generally more room in the output stream.

	Order list lists the order in which to play the patterns. 255=--
	is the end of tune mark and 254=++ is just a marker that is
	skipped.



     * When a patterndelay and a pattern break are on the same row, the delay
       comes before the break.

     * When a patternloop and a pattern break are on the same row, the loop
       comes before the break.


     * Fine Vibrato command. (Four times more accurate than normal vibrato)

~



