;[]------------------------------------------------------------------------[]
;| AUDIO MANAGER III by Kenneth Foo aka TechnoMaestro 1994.                 |
;[]------------------------------------------------------------------------[]
;  MOD MUSIC LOADER (LOAD MOD INTO AMM FORMAT IN MEMORY)
;
;NOTES
; Upon loading, useless effects are thrown out. That is, effects that does
; essentially nothing. For example, Volume Slide with speed 0. This does
; nothing and only wastes processing power.
;
; This, however, means that MOD files that are converted into AMM format
; cannot be converted 100% identically to the original MOD, but it will
; sound right.
;
; I've encountered one 16-channel MOD (WHY16.MOD) that has samople names that
; end with a char 0 at the first or second byte of the sample name. This
; name should actually be cancelled, but my loader will not do so.
; Platinum Play III cuts off these invalid names by printing sample names
; until they encounter an ASCIIZ 0 or end of name.
;
;
;DATA IN CODE SEGMENT
;
.CSEG   AM
AM_MI_MOD_INFO DB 'AUDIO MANAGER 3.0: MOD LOADER by Kenneth Foo',01ah
	MOD_Marker      dd 0
	MOD_Markers     db 'M.K.',31,4
			db 'M!K!',31,4
			db 'FLT4',31,4
			db 'FLT8',31,8
			db 'OCTA',31,8
			db 'TDZ1',31,1
			db 'TDZ2',31,2
			db 'TDZ3',31,3
			db '5CHN',31,5
			db '6CHN',31,6
			db '7CHN',31,7
			db '8CHN',31,8
			db '9CHN',31,9
			db '10CH',31,10
			db '11CH',31,11
			db '12CH',31,12
			db '13CH',31,13
			db '14CH',31,14
			db '15CH',31,15
			db '16CH',31,16
			db '1CHN',31,1
			db '2CHN',31,2
			db '3CHN',31,3
			db 4 dup(0FFh),31,8        ;Used in Renegade's Classika demo.
			db '17CH',31,17
			db '18CH',31,18
			db '19CH',31,19
			db '20CH',31,20
			db '21CH',31,21
			db '22CH',31,22
			db '23CH',31,23
			db '24CH',31,24
			db '25CH',31,25
			db '26CH',31,26
			db '27CH',31,27
			db '28CH',31,28
			db '29CH',31,29
			db '30CH',31,30
			db '31CH',31,31
			db '32CH',31,32
			db 0
.CSEG_ENDS AM
;
;CODE
;
.CSEG   AM

;
;_AMmusicLoadMOD                                                          
;I:  FileHandle:W, PosInFile:D                                            
;O:  Carry0 = Success, EAX=Pos in file past music                         
;    Carry1 = Error. AX=Error.                                            
;
_AMmusicLoadMOD proc uses bx cx dx si di es ds fs, FileHandle:WORD,PosInFile:DWORD
LOCAL TMPbuffer:WORD,TMPbytesPerRow:WORD,TMPpatternLength:WORD,TMPpatternCount:WORD,\
TMPtrackNumber:WORD,TMPtrackCount:WORD,TMPpatternOffset:DWORD,TMProwCount:WORD,\
TMPhighestDelta:WORD,TMPtotalSampleSize:DWORD,TMPmemPos:DWORD

	setDS
	;CHECK AM SYSTEM, IF INITIALIZED.
	mov     ErrorCode,ERR_NotPossible
	test    AM.AM_Status,1b
	jz      @@Error

	;CHECK IF A MODULE IS ALREADY LOADED
	test    AM.AM_Status,1000000000000b
	mov     ErrorCode,ERR_AlreadyDone
	jnz     @@Error

	;RESET DATAS
	mov     Music.MUSnativeTrackerVersion,00000h
	mov     Music.MUSextraDataLength,0
	mov     ErrorCode,ERR_CannotManageDisk
	mov     Music.MUSversion,0
	xor     bx,bx                           ;Clear music name
	mov     cx,40
	@@ClearName:
	mov     Music.MUSname[bx],0
	inc     bx
	loop    @@ClearName
	mov     Music.MUSversion,0              ;Version
	mov     ax,MI.MImasterVolume ;AM_MusicMasterVolume         ;Master volume
	mov     Music.MUSmasterVolume,ax
	mov     ax,AM.AM_Amplification         ;Amplification
	mov     Music.MUSamplification,ax
	mov     Music.MUSinitSpeed,6            ;Init speed
	mov     Music.MUSinitTempo,125          ;Init tempo
	mov     eax,000808000h                  ;Pan flags: LRRL format for MOD
	mov     bx,1    ;Start from Track 1 ! xor     bx,bx
	mov     cx,AM@MaxTracks
	@@SetPanFlags:
	mov     Music.MUSinitPan[bx],al
	ror     eax,16
	inc     bx
	loop    @@SetPanFlags

	;mov     Music.MUSinfo,10001b            ;AMIGA note limit,stereo.
	mov     Music.MUSinfo,10000b            ;AMIGA note limit,stereo.
	mov     Music.MUSsource,2               ;Coverted from MOD

	;DETERMINE NUMBER CHANNELS
	push    Filehandle
	mov     eax,PosInFile
	add     eax,1080
	push    eax
	push    word ptr 0
	call    _DMseekFile
	jc      @@Error
	push    FileHandle                      ;Read 4-byte marker
	push    seg MOD_Marker
	push    offset MOD_Marker
	push    word ptr 4
	call    _DMreadFile
	jc      @@Error
	;***SEARCH FOR CORRECT 4-BYTE MARKER AND GET INFO***
	mov     Music.MUSnumberTracks,4
	mov     Music.MUSnumberSamples,15
	xor     bx,bx
	@@CheckMarker:
	mov     eax,dword ptr MOD_Markers[bx]
	cmp     al,0 ;End of markers list
	je      short @@NoMoreMarkers
	cmp     eax,MOD_Marker
	jne     short @@NextMarker
	mov     al,byte ptr MOD_Markers[bx+4]
	xor     ah,ah
	mov     Music.MUSnumberSamples,ax
	mov     al,byte ptr MOD_Markers[bx+5]
	mov     Music.MUSnumberTracks,ax
	jmp     short @@NoMoreMarkers
	@@NextMarker:
	add     bx,6
	jmp     short @@CheckMarker
	@@NoMoreMarkers:

	;READ MUSIC NAME
	push    Filehandle
	push    PosInFile
	push    word ptr 0
	call    _DMseekFile
	jc      @@Error
	push    FileHandle                      ;Read music name
	push    seg Music.MUSname
	push    offset Music.MUSname
	push    word ptr 20
	call    _DMreadFile
	jc      @@Error
	add     PosInFile,20

	;READ AND DECIPHER SAMPLE INFOS...
	mov     bx,2                            ;From sample number 1...
	mov     TMPtotalSampleSize,0            ;FOR MEMORY ALLOCATION...
	mov     cx,Music.MUSnumberSamples
	@@ReadSample:
	;---READ SAMPLE INFO---
	push    FileHandle
	push    seg MI_Buffer
	push    offset MI_Buffer
	push    word ptr 30
	call    _DMreadFile
	jc      @@Error
	;---RESET AND SETUP SAMPLE STRUCTURE---
	push    bx cx
	mov     di,MI_Samples[bx]
	xor     bx,bx
	mov     cx,22                           ;Sample name
	@@CopySMPName:
	mov     al,byte ptr MI_Buffer[bx]
	mov     [cs:SmpX.SMPname][di][bx],al
	inc     bx
	loop    @@CopySMPName
	mov     cx,28-22
	@@ClearSMPName:
	mov     [cs:SmpX.SMPname][di][bx],0
	inc     bx
	loop    @@ClearSMPName
	xor     eax,eax                         ;Sample length
	mov     ax,word ptr MI_Buffer[22]
	xchg    al,ah
	shl     eax,1
	mov     [cs:SmpX.SMPlength][di],eax
;32-BYTE BOUNDARY LAHHH....
add     eax,31
and     eax,0FFFFFFE0h
add     TMPtotalSampleSize,eax
	xor     eax,eax                         ;Fine tune
	mov     bl,byte ptr MI_Buffer[24]   ;(MidC)
	add     bl,8
	and     bl,1111b
	xor     bh,bh
	shl     bx,1
	mov     ax,MI_FineTuneFrequency[bx]
	mov     [cs:SmpX.SMPmidC][di],eax
	mov     al,byte ptr MI_Buffer[25]   ;Volume
	mov     [cs:SmpX.SMPvolume][di],al
	xor     eax,eax                         ;Loop offset
	mov     ax,word ptr MI_Buffer[26]
	xchg    al,ah
	shl     eax,1
	mov     [cs:SmpX.SMPloopB][di],eax
	xor     eax,eax                         ;Loop past
	mov     ax,word ptr MI_Buffer[28]
	xchg    al,ah
	shl     eax,1
	add     eax,[cs:SmpX.SMPloopB][di]
	mov     [cs:SmpX.SMPloopP][di],eax
	mov     [cs:SmpX.SMPinfo][di],10010b    ;INFO: Signed 8-bit
	mov     eax,[cs:SmpX.SMPloopP][di]
	sub     eax,[cs:SmpX.SMPloopB][di]
	cmp     eax,2
	jbe     short @@NoLooping
	or      [cs:SmpX.SMPinfo][di],1000b     ;INFO: Looped
	@@NoLooping:
	xor     bx,bx
	mov     cx,13
	@@ClearSMPfileName:
	mov     [cs:SmpX.SMPfileName][di][bx],0
	inc     bx
	loop    @@ClearSMPfileName
	pop     cx bx
	add     PosInFile,30
	add     bx,2
	dec     cx
	jnz     @@ReadSample

	;GET SONG LENGTH AND SEQUENCES
	mov     ax,130
	cmp     Music.MUSnumberSamples,15
	je      short @@OldFormat
	add     ax,4 ;With 4-byte marker
	@@OldFormat:
	add     PosInFile,eax
	push    FileHandle
	push    seg MI_Buffer
	push    offset MI_Buffer
	push    ax
	call    _DMreadFile
	jc      @@Error
	mov     al,byte ptr MI_Buffer[0]
	xor     ah,ah
	mov     Music.MUSsongLength,ax
	mov     Music.MUSsongPlayLength,ax      ;FOR MODS (NOT S3M), LENGTH IS REAL.
	xor     bx,bx
	mov     cx,128
	xor     ah,ah
	@@CopySequence:
	mov     al,byte ptr MI_Buffer[bx][2]
	shl     bx,1
	mov     Music.MUSsequence[bx],ax
	shr     bx,1
	inc     bx
	loop    @@CopySequence
	shl     bx,1
	mov     Music.MUSsequence[bx],65535     ;END OF SONG MARKER...
						;NOT REALLY NEEDED.


	;DETERMINE NUMBER OF PATTERNS PRESENT
	;Error would occur if song length = 0, since we would register
	;one pattern as present.
	xor     bx,bx
	xor     ax,ax
	mov     cx,128          ;I've seen NST files using a value
	@@FindNumberPatterns:   ;less 1 for song length! A trick, maybe?
	cmp     Music.MUSsequence[bx],ax
	jbe     short @@NotHighest
	mov     ax,Music.MUSsequence[bx]
	@@NotHighest:
	inc     bx
	inc     bx
	loop    @@FindNumberPatterns
	inc     ax
	mov     Music.MUSnumberPatterns,ax

	;ALLOCATE SAMPLE MEMORY
	mov     eax,TMPtotalSampleSize          ;Allocate one BIG memory chunk
	;add     eax,2048                        ;Add 2k safety pool
	push    eax
	call    _AMallocMem
	doerr   ERR_NotEnoughMemory
	mov     MI_SampleMemHandle,eax

	;ALLOCATE MEMORY FOR TRACKS' PATTERNS & TEMPORARY BUFFER
	mov     bx,2                            ;Alloc track memory
	mov     cx,Music.MUSnumberTracks        ;BX=2 (start from Track1)
	@@AllocateTracks:
	mov     ax,(64*(SIZE NoteX))
	mul     Music.MUSnumberPatterns
	xchg    ax,dx
	shl     eax,16
	mov     ax,dx
	push    eax
	call    _MEMqAlloc
	doerr   ERR_NotEnoughMemory
	mov     di,AM_TrackTable[bx]
	mov     [cs:TrackX.TRKmemHandle][di],eax
	inc     bx
	inc     bx
	loop    @@AllocateTracks
	;---ALLOCATE TEMPORARY BUFFER---        ;Alloc temporary buffer.
	xor     eax,eax                         ;Size is NumberTracks x 256
	mov     ax,Music.MUSnumberTracks        ;bytes.
	shl     ax,8
	push    eax
	call    _MEMallocBase
	doerr   ERR_NotEnoughMemory
	mov     TMPbuffer,dx

	;READ PATTERNS AND SPLIT 'EM UP INTO SEPARATE TRACKS
	mov     ax,Music.MUSnumberTracks
	shl     ax,2
	mov     TMPbytesPerRow,ax
	shl     ax,6
	mov     TMPpatternLength,ax
	mov     ErrorCode,ERR_CannotManageDisk

	mov     TMPpatternOffset,0
	mov     ax,Music.MUSnumberPatterns
	mov     TMPpatternCount,ax
	@@ReadPatterns: ;------------------------------------------------
	push    FileHandle
	push    TMPbuffer
	push    word ptr 0
	push    TMPpatternLength
	call    _DMreadFile
	jc      @@Error
	xor     eax,eax
	mov     ax,TMPpatternLength
	add     PosInFile,eax
		;ES     = SEG of TMPbuffer
		;SI     = OFFSET in TMPbuffer
		;FS:DI  = SEG:OFF of AMM pattern
		mov     TMPtrackNumber,1
		xor     si,si
		mov     ax,Music.MUSnumberTracks
		mov     TMPtrackCount,ax
		@@ReadTracks: ;------------------------------------------
		push    si

		mov     bx,TMPtrackNumber
		shl     bx,1
		mov     di,AM_TrackTable[bx]
		push    [cs:TrackX.TRKmemHandle][di]
		push    TMPpatternOffset
		call    _MEMqGetAddress
		mov     fs,dx
		mov     di,ax
			mov     TMProwCount,64
			@@ReadRows: ;------------------------------------
			mov     es,TMPbuffer
			mov     al,es:[si]
			mov     ah,es:[si+2]
			mov     bl,ah
			shr     ah,4
			and     al,11110000b
			or      al,ah           ;AL=Instrument number
			and     bl,00001111b    ;BL=MOD effect number
			mov     bh,es:[si+3]    ;BH=MOD effect data
			or      al,al
			jnz     short @@SamplePresent
			mov     al,255          ;255=Use previous...
			@@SamplePresent:
			mov     fs:[di][NoteX.NOTEsampleNumber],al

			;================================================;
			;;
			;CONVERSION OF MOD EFFECTS INTO AMM EFFECTS;
			;CONVERSION OF MOD EFFECTS INTO AMM EFFECTS;
			;CONVERSION OF MOD EFFECTS INTO AMM EFFECTS;
			;;
			;================================================;
			mov     fs:[di][NoteX.NOTEvolume],255
			or      bx,bx
			jnz     short @@EffectPresent
			mov     fs:[di][NoteX.NOTEeffect],255
			mov     fs:[di][NoteX.NOTEeffectData],255
			jmp     @@DoneEFX2EFX
			@@EffectPresent:
			;ARPEGGIO
			cmp     bl,0
			jne     @@NotArp
			mov     bl,MI@EFXarpeggio
			or      bh,bh
			jnz     @@DoneEFX
			mov     bl,255          ;No effect. MI@noEffect
			jmp     @@DoneEFX
			@@NotArp:
			;SLIDE UP
			cmp     bl,1
			jne     @@NotSU
			mov     bl,MI@EFXslideUp
			or      bh,bh
			jz      @@UselessEFX
			jmp     @@DoneEFX
			@@NotSU:
			;SLIDE DOWN
			cmp     bl,2
			jne     @@NotSD
			mov     bl,MI@EFXslideDown
			or      bh,bh
			jz      @@UselessEFX
			jmp     @@DoneEFX
			@@NotSD:
			;SLIDE TO NOTE
			cmp     bl,3
			jne     @@NotSTN
			mov     bl,MI@EFXslideToNote
			jmp     @@DoneEFX
			@@NotSTN:
			;VIBRATO
			cmp     bl,4
			jne     @@NotVib
			mov     bl,MI@EFXvibrato
			jmp     @@DoneEFX
			@@NotVib:
			;CONTINUE SLIDE TO NOTE + VOLUME SLIDE
			cmp     bl,5
			jne     @@NotCLTNVS
			mov     bl,MI@EFXslidetoNote_VolumeSlide
			or      bh,bh
			jnz     @@DoneEFX
			mov     bl,MI@EFXslideToNote    ;Speed0=SlideToNote only
			jmp     @@DoneEFX
			@@NotCLTNVS:
			;CONTINUE VIBRATO + VOLUME SLIDE
			cmp     bl,6
			jne     @@NotCVVS
			mov     bl,MI@EFXvibrato_VolumeSlide
			or      bh,bh
			jnz     @@DoneEFX
			mov     bl,MI@EFXvibrato        ;Speed0=Vibrato only
			jmp     @@DoneEFX
			@@NotCVVS:
			;TREMOLO
			cmp     bl,7
			jne     @@NotTrem
			mov     bl,MI@EFXtremolo
			jmp     @@DoneEFX
			@@NotTrem:
			;SET PANNING
			cmp     bl,8
			jne     @@NotPan
			mov     bl,MI@EFXsetPan
			cmp     bh,128
			jbe     short @@NormalPan
			;ELSE, *ASSUME* IT'S SURROUND.
			mov     bh,254          ;Surround panning! (DMP USES 0A4h)
			@@NormalPan:            ;NOT SUPPORTED YET!
			jmp     @@DoneEFX
			@@NotPan:
			;SET SAMPLE OFFSET
			cmp     bl,9
			jne     @@NotSSO
			mov     bl,MI@EFXsetSampleOffset
			jmp     @@DoneEFX
			@@NotSSO:
			;VOLUME SLIDE
			cmp     bl,0Ah
			jne     @@NotVS
			mov     bl,MI@EFXvolumeSlide
			or      bh,bh
			jz      @@UselessEFX
			jmp     @@DoneEFX
			@@NotVS:
			;POSITION JUMP
			cmp     bl,0Bh
			jne     @@NotPJ
			mov     bl,MI@EFXpatternJump
			jmp     @@DoneEFX
			@@NotPJ:
			;SET VOLUME
			cmp     bl,0Ch
			jne     @@NotSV
			cmp     bh,64
			jbe     short @@VolOK
			mov     bh,64
			@@VolOK:
			mov     bl,255 ;MI@EFXnoEffect
			mov     fs:[di][NoteX.NOTEvolume],bh
			jmp     @@DoneEFX
			@@NotSV:
			;PATTERN BREAK
			cmp     bl,0Dh
			jne     @@NotPB
			;Convert decimal to hexadecimal
			mov     bl,MI@EFXpatternBreak
			mov     al,bh
			shr     al,4
			mov     ah,10
			mul     ah
			and     bh,0Fh
			add     bh,al
			jmp     @@DoneEFX
			@@NotPB:
			;SET SPEED/TEMPO
			cmp     bl,0Fh
			jne     @@NotSS
			mov     bl,MI@EFXsetSpeed
			cmp     bh,01Fh
			jbe     short @@SetSpeed
			mov     bl,MI@EFXsetTempo
			@@SetSpeed:
			jmp     @@DoneEFX
			@@NotSS:
			;MISCELLANEOUS EFFECTS-----------
			cmp     bl,0Eh
			jne     @@NotMISC
			mov     bl,bh
			shr     bl,4
			and     bh,1111b
			  ;SET FILTER
			  cmp     bl,00h
			  jne     @@NotF
			  mov     bl,MI@EFXsetFilter
			  jmp     @@DoneEFX
			  @@NotF:
			  ;FINE SLIDE UP
			  cmp     bl,01h
			  jne     @@NotFSU
			  mov     bl,MI@EFXslideUp
			  or      bh,bh
			  jz      @@UselessEFX
			  or      bh,0F0h
			  jmp     @@DoneEFX
			  @@NotFSU:
			  ;FINE SLIDE DOWN
			  cmp     bl,02h
			  jne     @@NotFSD
			  mov     bl,MI@EFXslideDown
			  or      bh,bh
			  jz      @@UselessEFX
			  or      bh,0F0h
			  jmp     @@DoneEFX
			  @@NotFSD:
			  ;SET GLISSANDO
			  cmp     bl,03h
			  jne     @@NotGliss
			  mov     bl,MI@EFXsetGlissando
			  jmp     @@DoneEFX
			  @@NotGliss:
			  ;SET VIBRATO WAVEFORM
			  cmp     bl,04h
			  jne     @@NotVW
			  mov     bl,MI@EFXsetVibratoWaveform
			  jmp     @@DoneEFX
			  @@NotVW:
			  ;SET FINE TUNE
			  cmp     bl,05h
			  jne     @@NotFT
			  add     bh,8
			  and     bh,0Fh
			  mov     bl,MI@EFXsetFineTune
			  jmp     @@DoneEFX
			  @@NotFT:
			  ;PATTERN LOOP
			  cmp     bl,06h
			  jne     @@NotPL
			  mov     bl,MI@EFXpatternLoop
			  jmp     @@DoneEFX
			  @@NotPL:
			  ;SET TREMOLO WAVEFORM
			  cmp     bl,07h
			  jne     @@NotTW
			  mov     bl,MI@EFXsetTremoloWaveform
			  jmp     @@DoneEFX
			  @@NotTW:
			  ;SET PAN - INACCURATE! SINCE MID = 7!
			  cmp     bl,08h
			  jne     @@NotPan2
			  shl     bh,3
			  mov     bl,MI@EFXsetPan
			  jmp     @@DoneEFX
			  @@NotPan2:
			  ;RETRIGGER
			  cmp     bl,09h
			  jne     @@NotRetrig
			  mov     bl,MI@EFXretrigger
			  or      bh,bh
			  jz      @@UselessEFX
			  jmp     @@DoneEFX
			  @@NotRetrig:
			  ;FINE VOLUME SLIDE UP
			  cmp     bl,0Ah
			  jne     @@NotFVSU
			  mov     bl,MI@EFXvolumeSlide
			  or      bh,bh
			  jz      @@UselessEFX
			  shl     bh,4
			  or      bh,0Fh
			  jmp     @@DoneEFX
			  @@NotFVSU:
			  ;FINE VOLUME SLIDE DOWN
			  cmp     bl,0Bh
			  jne     @@NotFVSD
			  mov     bl,MI@EFXvolumeSlide
			  or      bh,bh
			  jz      @@UselessEFX
			  or      bh,0F0h
			  jmp     @@DoneEFX
			  @@NotFVSD:
			  ;CUT NOTE
			  cmp     bl,0Ch
			  jne     @@NotCut
			  mov     bl,MI@EFXcutNote
			  jmp     @@DoneEFX
			  @@NotCut:
			  ;DELAY NOTE
			  cmp     bl,0Dh
			  jne     @@NotDelay
			  mov     bl,MI@EFXdelayNote
			  jmp     @@DoneEFX
			  @@NotDelay:
			  ;PATTERN DELAY
			  cmp     bl,0Eh
			  jne     @@NotPD
			  mov     bl,MI@EFXpatternDelay
			  jmp     @@DoneEFX
			  @@NotPD:
			  ;INVERT LOOP
			  cmp     bl,0Fh
			  jne     @@NotUnk4
			  mov     bl,MI@EFXinvertLoop
			  jmp     @@DoneEFX
			  @@NotUnk4:

			  ;ELSE, UNKNOWN EFFECT.
			  ;MAKE IT 255 (NO EFX)

			@@UselessEfX:
			  mov     bl,255        ;Useless efx. Remove EFX.
						;(the EFX does NOTHING).
			@@NotMISC:
			@@DoneEFX:
			mov     fs:[di][NoteX.NOTEeffect],bl
			mov     fs:[di][NoteX.NOTEeffectData],bh
			@@DoneEFX2EFX:

			;============================================;
			;;
			;CONVERSION OF MOD PERIODS TO AMM NOTES;
			;CONVERSION OF MOD PERIODS TO AMM NOTES;
			;CONVERSION OF MOD PERIODS TO AMM NOTES;
			;;
			;============================================;
			;==========================================;
			;NOTE C:                                   ;
			;1712*16 ;O0     * EXTENDED S3M            ;
			;1712*08 ;O1     * EXTENDED S3M            ;
			;1712*04 ;O2     --> MOD C0                ;
			;1712*02 ;O3     --> MOD C1                ;
			;1712*01 ;O4     --> MOD C2 - C4 at 8363hz ;
			;1712/02 ;O5     --> MOD C3                ;
			;1712/04 ;O6     --> MOD C4                ;
			;1712/08 ;O7     * EXTENDED S3M            ;
			;1712/16 ;O8     * EXTENDED S3M            ;
			;==========================================;
			mov     ax,es:[si]      ;AX=Period
			xchg    al,ah
			and     ax,0FFFh
			shl     ax,2            ;x4 => convert to AMM periods
			jnz     short @@NotePresent
			mov     cl,255          ;Period0=No note.
			jmp     @@NoteFound
			@@NotePresent:
			mov     TMPhighestDelta,65535
			mov     cl,0    ;2            ;Start from Octave 2
			@@CheckOctave:
			xor     bx,bx
			mov     ch,12           ;12 notes
			@@CheckNote:
			mov     dx,MI_PeriodTable[bx]
			shr     dx,cl
			sub     dx,ax
			jz      short @@FoundMatch
			jns     short @@NotSignedDiff
			neg     dx
			@@NotSignedDiff:
			cmp     dx,TMPhighestDelta      ;Get lowest difference.
			jae     short @@FoundNearMatch  ;If delta starts to deteriorate (getting big),
			mov     TMPhighestDelta,dx      ;we use that previous note.
			inc     bx
			inc     bx
			dec     ch
			jnz     short @@CheckNote
			inc     cl
			cmp     cl,8    ;6            ;MOD: Up to octave 6.
			jbe     short @@CheckOctave
			;--NOTE NOT FOUND. BUT IT WON'T COME HERE AS
			;--I ACTUALLY GET THE CLOSEST MATCH.

push    ax
mov     ax,0eb0h
int     010h
pop     ax

			@@FoundNearMatch:
			sub     bx,2
			jnc     short @@FoundMatch
			mov     bx,2*11
			dec     cl
			@@FoundMatch:
			shr     bx,1
			shl     cl,4
			or      cl,bl
			@@NoteFound:
			mov     fs:[di][NoteX.NOTEnote],cl

			add     si,TMPbytesPerRow
			add     di,SIZE NoteX
			dec     TMProwCount
			jnz     @@ReadRows
		pop     si
		inc     TMPtrackNumber
		add     si,4
		dec     TMPtrackCount
		jnz     @@ReadTracks
	add     TMPpatternOffset,((SIZE NoteX)*64)
	dec     TMPpatternCount
	jnz     @@ReadPatterns

	;DEALLOCATE TEMPORARY BUFFER
	push    TMPbuffer
	push    word ptr 0
	call    _MEMdeallocBase
	doerr   ERR_CannotManageMemory

	;LOAD SAMPLES
	mov     TMPmemPos,0
	mov     bx,2                            ;Start from sample 1...
	mov     cx,Music.MUSnumberSamples
	@@LoadingSamples:
	mov     di,MI_Samples[bx]               ;Set handle and mem pos
	mov     eax,MI_SampleMemHandle
	mov     [cs:SmpX.SMPmemHandle][di],eax
	mov     eax,TMPmemPos
	mov     [cs:SmpX.SMPmemPos][di],eax
	mov     eax,[cs:SmpX.SMPlength][di]
;32-BYTE BOUNDARY LAHHH....
add     eax,31
and     eax,0FFFFFFE0h
	add     TMPmemPos,eax                   ;Increment memory pos
	or      eax,eax
	jz      short @@EmptySample
	push    cs                              ;Load sample...
	push    di
	push    FileHandle
	push    PosInFile
	call    _AMloadSample
	jc      @@Error2
	mov     PosInFile,eax
	@@EmptySample:
	inc     bx
	inc     bx
	loop    @@LoadingSamples

	or      AM.AM_Status,1000000000000b        ;Set LOADED
	quit
	_AMmusicLoadMOD endp




;
;
;
;
;
;
;
;
;
;
;



;IF _TP_ EQ 1


;For Renegade internal use -- upon request by Adrian Chiang, holy Sysop ;-)
;Hahahahaha!

curptr  dd 0            ;Virtual 'file' pointer (linear memory pointer)

;
;Seek a memory address - for use in _AMmusicMemloadMOD                    
;Assumes MoveCode always 0 (from start of mem)                            
;
_MMseekFile PROC FileHandle:WORD,NumBytes:DWORD,MoveCode:WORD
	mov     eax,NumBytes
	;add     eax,curptr
	mov     curptr,eax
	clc
	ret
	ENDP

;
;Reads from memory - for use in _AMmusicMemloadMOD                        
;
_MMreadFile PROC FileHandle:WORD,Buffer:DWORD,NumBytes:WORD
	push    es
	push    ds
	push    si
	push    di
	push    ebx
	push    cx
	cld
	les     di,Buffer
	mov     eax,curptr
	mov     esi,eax
	and     esi,0Fh
	shr     eax,4
	mov     ds,ax
	mov     cx,NumBytes
	shr     cx,1
	rep     movsw
	adc     cl,0
	rep     movsb
	pop     cx
	pop     ebx
	pop     di
	pop     si
	pop     ds
	pop     es
	movzx   eax,NumBytes
	add     curptr,eax
	clc
	ret
	ENDP


;
;_AMmusicMemloadMOD                                                       
;I:  DUMMY:W, SEG:OFF of MOD music in memory                              
;O:  Carry0 = Success, EAX=Pos in file past music                         
;    Carry1 = Error. AX=Error.                                            
;
_AMmusicMemloadMOD proc uses bx cx dx si di es ds fs, FileHandle:WORD,PosInFile:DWORD
LOCAL TMPbuffer:WORD,TMPbytesPerRow:WORD,TMPpatternLength:WORD,TMPpatternCount:WORD,\
TMPtrackNumber:WORD,TMPtrackCount:WORD,TMPpatternOffset:DWORD,TMProwCount:WORD,\
TMPhighestDelta:WORD,TMPtotalSampleSize:DWORD,TMPmemPos:DWORD

	setDS

	;Convert SEG:OFF to linear memory for use in _MMseekFile
	mov     eax,PosInFile
	movzx   ebx,ax
	shr     eax,16-4
	and     eax,0FFFFFFF0h
	add     eax,ebx
	mov     PosInFile,eax
	mov     curptr,0       ;Reset pointer




	;CHECK AM SYSTEM, IF INITIALIZED.
	mov     ErrorCode,ERR_NotPossible
	test    AM.AM_Status,1b
	jz      @@Error

	;CHECK IF A MODULE IS ALREADY LOADED
	test    AM.AM_Status,1000000000000b
	mov     ErrorCode,ERR_AlreadyDone
	jnz     @@Error

	;RESET DATAS
	mov     Music.MUSnativeTrackerVersion,00000h
	mov     Music.MUSextraDataLength,0
	mov     ErrorCode,ERR_CannotManageDisk
	mov     Music.MUSversion,0
	xor     bx,bx                           ;Clear music name
	mov     cx,40
	@@ClearName:
	mov     Music.MUSname[bx],0
	inc     bx
	loop    @@ClearName
	mov     Music.MUSversion,0              ;Version
	mov     ax,MI.MImasterVolume ;AM_MusicMasterVolume         ;Master volume
	mov     Music.MUSmasterVolume,ax
	mov     ax,AM.AM_Amplification         ;Amplification
	mov     Music.MUSamplification,ax
	mov     Music.MUSinitSpeed,6            ;Init speed
	mov     Music.MUSinitTempo,125          ;Init tempo
	mov     eax,000808000h                  ;Pan flags: LRRL format for MOD
	mov     bx,1    ;Start from Track 1 ! xor     bx,bx
	mov     cx,AM@MaxTracks
	@@SetPanFlags:
	mov     Music.MUSinitPan[bx],al
	ror     eax,16
	inc     bx
	loop    @@SetPanFlags

	mov     Music.MUSinfo,10001b            ;AMIGA note limit,stereo.
	mov     Music.MUSsource,2               ;Coverted from MOD

	;DETERMINE NUMBER CHANNELS
	push    Filehandle
	mov     eax,PosInFile
	add     eax,1080
	push    eax
	push    word ptr 0
	call    _MMseekFile
	jc      @@Error
	push    FileHandle                      ;Read 4-byte marker
	push    seg MOD_Marker
	push    offset MOD_Marker
	push    word ptr 4
	call    _MMreadFile
	jc      @@Error
	;***SEARCH FOR CORRECT 4-BYTE MARKER AND GET INFO***
	mov     Music.MUSnumberTracks,4
	mov     Music.MUSnumberSamples,15
	xor     bx,bx
	@@CheckMarker:
	mov     eax,dword ptr MOD_Markers[bx]
	cmp     al,0 ;End of markers list
	je      short @@NoMoreMarkers
	cmp     eax,MOD_Marker
	jne     short @@NextMarker
	mov     al,byte ptr MOD_Markers[bx+4]
	xor     ah,ah
	mov     Music.MUSnumberSamples,ax
	mov     al,byte ptr MOD_Markers[bx+5]
	mov     Music.MUSnumberTracks,ax
	jmp     short @@NoMoreMarkers
	@@NextMarker:
	add     bx,6
	jmp     short @@CheckMarker
	@@NoMoreMarkers:

	;READ MUSIC NAME
	push    Filehandle
	push    PosInFile
	push    word ptr 0
	call    _MMseekFile
	jc      @@Error
	push    FileHandle                      ;Read music name
	push    seg Music.MUSname
	push    offset Music.MUSname
	push    word ptr 20
	call    _MMreadFile
	jc      @@Error
	add     PosInFile,20

	;READ AND DECIPHER SAMPLE INFOS...
	mov     bx,2                            ;From sample number 1...
	mov     TMPtotalSampleSize,0            ;FOR MEMORY ALLOCATION...
	mov     cx,Music.MUSnumberSamples
	@@ReadSample:
	;---READ SAMPLE INFO---
	push    FileHandle
	push    seg MI_Buffer
	push    offset MI_Buffer
	push    word ptr 30
	call    _MMreadFile
	jc      @@Error
	;---RESET AND SETUP SAMPLE STRUCTURE---
	push    bx cx
	mov     di,MI_Samples[bx]
	xor     bx,bx
	mov     cx,22                           ;Sample name
	@@CopySMPName:
	mov     al,byte ptr MI_Buffer[bx]
	mov     [cs:SmpX.SMPname][di][bx],al
	inc     bx
	loop    @@CopySMPName
	mov     cx,28-22
	@@ClearSMPName:
	mov     [cs:SmpX.SMPname][di][bx],0
	inc     bx
	loop    @@ClearSMPName
	xor     eax,eax                         ;Sample length
	mov     ax,word ptr MI_Buffer[22]
	xchg    al,ah
	shl     eax,1
	mov     [cs:SmpX.SMPlength][di],eax
;32-BYTE BOUNDARY LAHHH....
add     eax,31
and     eax,0FFFFFFE0h
add     TMPtotalSampleSize,eax
	xor     eax,eax                         ;Fine tune
	mov     bl,byte ptr MI_Buffer[24]   ;(MidC)
	add     bl,8
	and     bl,1111b
	xor     bh,bh
	shl     bx,1
	mov     ax,MI_FineTuneFrequency[bx]
	mov     [cs:SmpX.SMPmidC][di],eax
	mov     al,byte ptr MI_Buffer[25]   ;Volume
	mov     [cs:SmpX.SMPvolume][di],al
	xor     eax,eax                         ;Loop offset
	mov     ax,word ptr MI_Buffer[26]
	xchg    al,ah
	shl     eax,1
	mov     [cs:SmpX.SMPloopB][di],eax
	xor     eax,eax                         ;Loop past
	mov     ax,word ptr MI_Buffer[28]
	xchg    al,ah
	shl     eax,1
	add     eax,[cs:SmpX.SMPloopB][di]
	mov     [cs:SmpX.SMPloopP][di],eax
	mov     [cs:SmpX.SMPinfo][di],10010b    ;INFO: Signed 8-bit
	mov     eax,[cs:SmpX.SMPloopP][di]
	sub     eax,[cs:SmpX.SMPloopB][di]
	cmp     eax,2
	jbe     short @@NoLooping
	or      [cs:SmpX.SMPinfo][di],1000b     ;INFO: Looped
	@@NoLooping:
	xor     bx,bx
	mov     cx,13
	@@ClearSMPfileName:
	mov     [cs:SmpX.SMPfileName][di][bx],0
	inc     bx
	loop    @@ClearSMPfileName
	pop     cx bx
	add     PosInFile,30
	add     bx,2
	dec     cx
	jnz     @@ReadSample

	;GET SONG LENGTH AND SEQUENCES
	mov     ax,130
	cmp     Music.MUSnumberSamples,15
	je      short @@OldFormat
	add     ax,4 ;With 4-byte marker
	@@OldFormat:
	add     PosInFile,eax
	push    FileHandle
	push    seg MI_Buffer
	push    offset MI_Buffer
	push    ax
	call    _MMreadFile
	jc      @@Error
	mov     al,byte ptr MI_Buffer[0]
	xor     ah,ah
	mov     Music.MUSsongLength,ax
	mov     Music.MUSsongPlayLength,ax      ;FOR MODS (NOT S3M), LENGTH IS REAL.
	xor     bx,bx
	mov     cx,128
	xor     ah,ah
	@@CopySequence:
	mov     al,byte ptr MI_Buffer[bx][2]
	shl     bx,1
	mov     Music.MUSsequence[bx],ax
	shr     bx,1
	inc     bx
	loop    @@CopySequence
	shl     bx,1
	mov     Music.MUSsequence[bx],65535     ;END OF SONG MARKER...
						;NOT REALLY NEEDED.


	;DETERMINE NUMBER OF PATTERNS PRESENT
	;Error would occur if song length = 0, since we would register
	;one pattern as present.
	xor     bx,bx
	xor     ax,ax
	mov     cx,128          ;I've seen NST files using a value
	@@FindNumberPatterns:   ;less 1 for song length! A trick, maybe?
	cmp     Music.MUSsequence[bx],ax
	jbe     short @@NotHighest
	mov     ax,Music.MUSsequence[bx]
	@@NotHighest:
	inc     bx
	inc     bx
	loop    @@FindNumberPatterns
	inc     ax
	mov     Music.MUSnumberPatterns,ax

	;ALLOCATE SAMPLE MEMORY
	mov     eax,TMPtotalSampleSize          ;Allocate one BIG memory chunk
	;add     eax,2048                        ;Add 2k safety pool
	push    eax
	call    _AMallocMem
	doerr   ERR_NotEnoughMemory
	mov     MI_SampleMemHandle,eax

	;ALLOCATE MEMORY FOR TRACKS' PATTERNS & TEMPORARY BUFFER
	mov     bx,2                            ;Alloc track memory
	mov     cx,Music.MUSnumberTracks        ;BX=2 (start from Track1)
	@@AllocateTracks:
	mov     ax,(64*(SIZE NoteX))
	mul     Music.MUSnumberPatterns
	xchg    ax,dx
	shl     eax,16
	mov     ax,dx
	push    eax
	call    _MEMqAlloc
	doerr   ERR_NotEnoughMemory
	mov     di,AM_TrackTable[bx]
	mov     [cs:TrackX.TRKmemHandle][di],eax
	inc     bx
	inc     bx
	loop    @@AllocateTracks
	;---ALLOCATE TEMPORARY BUFFER---        ;Alloc temporary buffer.
	xor     eax,eax                         ;Size is NumberTracks x 256
	mov     ax,Music.MUSnumberTracks        ;bytes.
	shl     ax,8
	push    eax
	call    _MEMallocBase
	doerr   ERR_NotEnoughMemory
	mov     TMPbuffer,dx

	;READ PATTERNS AND SPLIT 'EM UP INTO SEPARATE TRACKS
	mov     ax,Music.MUSnumberTracks
	shl     ax,2
	mov     TMPbytesPerRow,ax
	shl     ax,6
	mov     TMPpatternLength,ax
	mov     ErrorCode,ERR_CannotManageDisk

	mov     TMPpatternOffset,0
	mov     ax,Music.MUSnumberPatterns
	mov     TMPpatternCount,ax
	@@ReadPatterns: ;------------------------------------------------
	push    FileHandle
	push    TMPbuffer
	push    word ptr 0
	push    TMPpatternLength
	call    _MMreadFile
	jc      @@Error
	xor     eax,eax
	mov     ax,TMPpatternLength
	add     PosInFile,eax
		;ES     = SEG of TMPbuffer
		;SI     = OFFSET in TMPbuffer
		;FS:DI  = SEG:OFF of AMM pattern
		mov     TMPtrackNumber,1
		xor     si,si
		mov     ax,Music.MUSnumberTracks
		mov     TMPtrackCount,ax
		@@ReadTracks: ;------------------------------------------
		push    si

		mov     bx,TMPtrackNumber
		shl     bx,1
		mov     di,AM_TrackTable[bx]
		push    [cs:TrackX.TRKmemHandle][di]
		push    TMPpatternOffset
		call    _MEMqGetAddress
		mov     fs,dx
		mov     di,ax
			mov     TMProwCount,64
			@@ReadRows: ;------------------------------------
			mov     es,TMPbuffer
			mov     al,es:[si]
			mov     ah,es:[si+2]
			mov     bl,ah
			shr     ah,4
			and     al,11110000b
			or      al,ah           ;AL=Instrument number
			and     bl,00001111b    ;BL=MOD effect number
			mov     bh,es:[si+3]    ;BH=MOD effect data
			or      al,al
			jnz     short @@SamplePresent
			mov     al,255          ;255=Use previous...
			@@SamplePresent:
			mov     fs:[di][NoteX.NOTEsampleNumber],al

			;================================================;
			;;
			;CONVERSION OF MOD EFFECTS INTO AMM EFFECTS;
			;CONVERSION OF MOD EFFECTS INTO AMM EFFECTS;
			;CONVERSION OF MOD EFFECTS INTO AMM EFFECTS;
			;;
			;================================================;
			mov     fs:[di][NoteX.NOTEvolume],255
			or      bx,bx
			jnz     short @@EffectPresent
			mov     fs:[di][NoteX.NOTEeffect],255
			mov     fs:[di][NoteX.NOTEeffectData],255
			jmp     @@DoneEFX2EFX
			@@EffectPresent:
			;ARPEGGIO
			cmp     bl,0
			jne     @@NotArp
			mov     bl,MI@EFXarpeggio
			or      bh,bh
			jnz     @@DoneEFX
			mov     bl,255          ;No effect. MI@noEffect
			jmp     @@DoneEFX
			@@NotArp:
			;SLIDE UP
			cmp     bl,1
			jne     @@NotSU
			mov     bl,MI@EFXslideUp
			or      bh,bh
			jz      @@UselessEFX
			jmp     @@DoneEFX
			@@NotSU:
			;SLIDE DOWN
			cmp     bl,2
			jne     @@NotSD
			mov     bl,MI@EFXslideDown
			or      bh,bh
			jz      @@UselessEFX
			jmp     @@DoneEFX
			@@NotSD:
			;SLIDE TO NOTE
			cmp     bl,3
			jne     @@NotSTN
			mov     bl,MI@EFXslideToNote
			jmp     @@DoneEFX
			@@NotSTN:
			;VIBRATO
			cmp     bl,4
			jne     @@NotVib
			mov     bl,MI@EFXvibrato
			jmp     @@DoneEFX
			@@NotVib:
			;CONTINUE SLIDE TO NOTE + VOLUME SLIDE
			cmp     bl,5
			jne     @@NotCLTNVS
			mov     bl,MI@EFXslidetoNote_VolumeSlide
			or      bh,bh
			jnz     @@DoneEFX
			mov     bl,MI@EFXslideToNote    ;Speed0=SlideToNote only
			jmp     @@DoneEFX
			@@NotCLTNVS:
			;CONTINUE VIBRATO + VOLUME SLIDE
			cmp     bl,6
			jne     @@NotCVVS
			mov     bl,MI@EFXvibrato_VolumeSlide
			or      bh,bh
			jnz     @@DoneEFX
			mov     bl,MI@EFXvibrato        ;Speed0=Vibrato only
			jmp     @@DoneEFX
			@@NotCVVS:
			;TREMOLO
			cmp     bl,7
			jne     @@NotTrem
			mov     bl,MI@EFXtremolo
			jmp     @@DoneEFX
			@@NotTrem:
			;SET PANNING
			cmp     bl,8
			jne     @@NotPan
			mov     bl,MI@EFXsetPan
			cmp     bh,128
			jbe     short @@NormalPan
			;ELSE, *ASSUME* IT'S SURROUND.
			mov     bh,254          ;Surround panning! (DMP USES 0A4h)
			@@NormalPan:            ;NOT SUPPORTED YET!
			jmp     @@DoneEFX
			@@NotPan:
			;SET SAMPLE OFFSET
			cmp     bl,9
			jne     @@NotSSO
			mov     bl,MI@EFXsetSampleOffset
			jmp     @@DoneEFX
			@@NotSSO:
			;VOLUME SLIDE
			cmp     bl,0Ah
			jne     @@NotVS
			mov     bl,MI@EFXvolumeSlide
			or      bh,bh
			jz      @@UselessEFX
			jmp     @@DoneEFX
			@@NotVS:
			;POSITION JUMP
			cmp     bl,0Bh
			jne     @@NotPJ
			mov     bl,MI@EFXpatternJump
			jmp     @@DoneEFX
			@@NotPJ:
			;SET VOLUME
			cmp     bl,0Ch
			jne     @@NotSV
			cmp     bh,64
			jbe     short @@VolOK
			mov     bh,64
			@@VolOK:
			mov     bl,255 ;MI@EFXnoEffect
			mov     fs:[di][NoteX.NOTEvolume],bh
			jmp     @@DoneEFX
			@@NotSV:
			;PATTERN BREAK
			cmp     bl,0Dh
			jne     @@NotPB
			;Convert decimal to hexadecimal
			mov     bl,MI@EFXpatternBreak
			mov     al,bh
			shr     al,4
			mov     ah,10
			mul     ah
			and     bh,0Fh
			add     bh,al
			jmp     @@DoneEFX
			@@NotPB:
			;SET SPEED/TEMPO
			cmp     bl,0Fh
			jne     @@NotSS
			mov     bl,MI@EFXsetSpeed
			cmp     bh,01Fh
			jbe     short @@SetSpeed
			mov     bl,MI@EFXsetTempo
			@@SetSpeed:
			jmp     @@DoneEFX
			@@NotSS:
			;MISCELLANEOUS EFFECTS-----------
			cmp     bl,0Eh
			jne     @@NotMISC
			mov     bl,bh
			shr     bl,4
			and     bh,1111b
			  ;SET FILTER
			  cmp     bl,00h
			  jne     @@NotF
			  mov     bl,MI@EFXsetFilter
			  jmp     @@DoneEFX
			  @@NotF:
			  ;FINE SLIDE UP
			  cmp     bl,01h
			  jne     @@NotFSU
			  mov     bl,MI@EFXslideUp
			  or      bh,bh
			  jz      @@UselessEFX
			  or      bh,0F0h
			  jmp     @@DoneEFX
			  @@NotFSU:
			  ;FINE SLIDE DOWN
			  cmp     bl,02h
			  jne     @@NotFSD
			  mov     bl,MI@EFXslideDown
			  or      bh,bh
			  jz      @@UselessEFX
			  or      bh,0F0h
			  jmp     @@DoneEFX
			  @@NotFSD:
			  ;SET GLISSANDO
			  cmp     bl,03h
			  jne     @@NotGliss
			  mov     bl,MI@EFXsetGlissando
			  jmp     @@DoneEFX
			  @@NotGliss:
			  ;SET VIBRATO WAVEFORM
			  cmp     bl,04h
			  jne     @@NotVW
			  mov     bl,MI@EFXsetVibratoWaveform
			  jmp     @@DoneEFX
			  @@NotVW:
			  ;SET FINE TUNE
			  cmp     bl,05h
			  jne     @@NotFT
			  add     bh,8
			  and     bh,0Fh
			  mov     bl,MI@EFXsetFineTune
			  jmp     @@DoneEFX
			  @@NotFT:
			  ;PATTERN LOOP
			  cmp     bl,06h
			  jne     @@NotPL
			  mov     bl,MI@EFXpatternLoop
			  jmp     @@DoneEFX
			  @@NotPL:
			  ;SET TREMOLO WAVEFORM
			  cmp     bl,07h
			  jne     @@NotTW
			  mov     bl,MI@EFXsetTremoloWaveform
			  jmp     @@DoneEFX
			  @@NotTW:
			  ;SET PAN - INACCURATE! SINCE MID = 7!
			  cmp     bl,08h
			  jne     @@NotPan2
			  shl     bh,3
			  mov     bl,MI@EFXsetPan
			  jmp     @@DoneEFX
			  @@NotPan2:
			  ;RETRIGGER
			  cmp     bl,09h
			  jne     @@NotRetrig
			  mov     bl,MI@EFXretrigger
			  or      bh,bh
			  jz      @@UselessEFX
			  jmp     @@DoneEFX
			  @@NotRetrig:
			  ;FINE VOLUME SLIDE UP
			  cmp     bl,0Ah
			  jne     @@NotFVSU
			  mov     bl,MI@EFXvolumeSlide
			  or      bh,bh
			  jz      @@UselessEFX
			  shl     bh,4
			  or      bh,0Fh
			  jmp     @@DoneEFX
			  @@NotFVSU:
			  ;FINE VOLUME SLIDE DOWN
			  cmp     bl,0Bh
			  jne     @@NotFVSD
			  mov     bl,MI@EFXvolumeSlide
			  or      bh,bh
			  jz      @@UselessEFX
			  or      bh,0F0h
			  jmp     @@DoneEFX
			  @@NotFVSD:
			  ;CUT NOTE
			  cmp     bl,0Ch
			  jne     @@NotCut
			  mov     bl,MI@EFXcutNote
			  jmp     @@DoneEFX
			  @@NotCut:
			  ;DELAY NOTE
			  cmp     bl,0Dh
			  jne     @@NotDelay
			  mov     bl,MI@EFXdelayNote
			  jmp     @@DoneEFX
			  @@NotDelay:
			  ;PATTERN DELAY
			  cmp     bl,0Eh
			  jne     @@NotPD
			  mov     bl,MI@EFXpatternDelay
			  jmp     @@DoneEFX
			  @@NotPD:
			  ;INVERT LOOP
			  cmp     bl,0Fh
			  jne     @@NotUnk4
			  mov     bl,MI@EFXinvertLoop
			  jmp     @@DoneEFX
			  @@NotUnk4:

			  ;ELSE, UNKNOWN EFFECT.
			  ;MAKE IT 255 (NO EFX)

			@@UselessEfX:
			  mov     bl,255        ;Useless efx. Remove EFX.
						;(the EFX does NOTHING).
			@@NotMISC:
			@@DoneEFX:
			mov     fs:[di][NoteX.NOTEeffect],bl
			mov     fs:[di][NoteX.NOTEeffectData],bh
			@@DoneEFX2EFX:

			;============================================;
			;;
			;CONVERSION OF MOD PERIODS TO AMM NOTES;
			;CONVERSION OF MOD PERIODS TO AMM NOTES;
			;CONVERSION OF MOD PERIODS TO AMM NOTES;
			;;
			;============================================;
			;==========================================;
			;NOTE C:                                   ;
			;1712*16 ;O0     * EXTENDED S3M            ;
			;1712*08 ;O1     * EXTENDED S3M            ;
			;1712*04 ;O2     --> MOD C0                ;
			;1712*02 ;O3     --> MOD C1                ;
			;1712*01 ;O4     --> MOD C2 - C4 at 8363hz ;
			;1712/02 ;O5     --> MOD C3                ;
			;1712/04 ;O6     --> MOD C4                ;
			;1712/08 ;O7     * EXTENDED S3M            ;
			;1712/16 ;O8     * EXTENDED S3M            ;
			;==========================================;
			mov     ax,es:[si]      ;AX=Period
			xchg    al,ah
			and     ax,0FFFh
			shl     ax,2            ;x4 => convert to AMM periods
			jnz     short @@NotePresent
			mov     cl,255          ;Period0=No note.
			jmp     @@NoteFound
			@@NotePresent:
			mov     TMPhighestDelta,65535
			mov     cl,1    ;pigpig 2            ;Start from Octave 2
			@@CheckOctave:
			xor     bx,bx
			mov     ch,12           ;12 notes
			@@CheckNote:
			mov     dx,MI_PeriodTable[bx]
			shr     dx,cl
			sub     dx,ax
			jz      short @@FoundMatch
			jns     short @@NotSignedDiff
			neg     dx
			@@NotSignedDiff:
			cmp     dx,TMPhighestDelta      ;Get lowest difference.
			jae     short @@FoundNearMatch  ;If delta starts to deteriorate (getting big),
			mov     TMPhighestDelta,dx      ;we use that previous note.
			inc     bx
			inc     bx
			dec     ch
			jnz     short @@CheckNote
			inc     cl
			cmp     cl,6            ;MOD: Up to octave 6.
			jbe     short @@CheckOctave
			;--NOTE NOT FOUND. BUT IT WON'T COME HERE AS
			;--I ACTUALLY GET THE CLOSEST MATCH.
			@@FoundNearMatch:
			sub     bx,2
			jnc     short @@FoundMatch
			mov     bx,2*11
			dec     cl
			@@FoundMatch:
			shr     bx,1
			shl     cl,4
			or      cl,bl
			@@NoteFound:
			mov     fs:[di][NoteX.NOTEnote],cl

			add     si,TMPbytesPerRow
			add     di,SIZE NoteX
			dec     TMProwCount
			jnz     @@ReadRows
		pop     si
		inc     TMPtrackNumber
		add     si,4
		dec     TMPtrackCount
		jnz     @@ReadTracks
	add     TMPpatternOffset,((SIZE NoteX)*64)
	dec     TMPpatternCount
	jnz     @@ReadPatterns

	;DEALLOCATE TEMPORARY BUFFER
	push    TMPbuffer
	push    word ptr 0
	call    _MEMdeallocBase
	doerr   ERR_CannotManageMemory

	;LOAD SAMPLES
	mov     TMPmemPos,0
	mov     bx,2                            ;Start from sample 1...
	mov     cx,Music.MUSnumberSamples
	@@LoadingSamples:
	mov     di,MI_Samples[bx]               ;Set handle and mem pos
	mov     eax,MI_SampleMemHandle
	mov     [cs:SmpX.SMPmemHandle][di],eax
	mov     eax,TMPmemPos
	mov     [cs:SmpX.SMPmemPos][di],eax
	mov     eax,[cs:SmpX.SMPlength][di]
;32-BYTE BOUNDARY LAHHH....
add     eax,31
and     eax,0FFFFFFE0h
	add     TMPmemPos,eax                   ;Increment memory pos
	or      eax,eax
	jz      short @@EmptySample
	push    cs                              ;Load sample...
	push    di
	push    FileHandle
	push    PosInFile
	call    _AMmemloadSample                ;Special routine...
	jc      @@Error2
	mov     PosInFile,eax
	@@EmptySample:
	inc     bx
	inc     bx
	loop    @@LoadingSamples

	or      AM.AM_Status,1000000000000b        ;Set LOADED
	quit
	_AMmusicMemloadMOD endp

;ENDIF



.CSEG_ENDS AM

