;[]----------------------------------------------------[]
;| GENERAL MANAGER by Kenneth Foo @ TechnoMaestro. 1994 |
;[]----------------------------------------------------[]
	;includelib e:\GM\GM.LIB         ;GM Library
	include GM_LIB.INC      ;ASSEMBLER-SPECIFIC STUFFS/MODEL/PROCESSOR/ETC
	include MISC.IF         ;Initialization - MUST INCLUDE
	IF _TCM_ EQ 1           ;Timer Chip Manager 2
	include TCM.IF
	ENDIF
	IF _DM_ EQ 1            ;Data Manager
	include DM.IF
	ENDIF
	IF _VID_ EQ 1           ;Video Manager
	include VID.IF
	ENDIF
	IF _AG_ EQ 1            ;Advanced Graphic Manager
	include AG.IF
	ENDIF
	IF _MOUSE_ EQ 1         ;Mouse Manager
	include MOUSE.IF
	ENDIF
	IF _IO_ EQ 1            ;I/O Manager
	include IO.IF
	ENDIF
	IF _SPR_ EQ 1           ;Sprite Manager
	include SPR.IF
	ENDIF
	IF _BKG_ EQ 1           ;Backdrop Manager
	include BKG.IF
	ENDIF
	IF _E3D_ EQ 1           ;E3D Graphics Manager
	include E3D.IF
	ENDIF
	IF _UTIL_ EQ 1          ;Utility Manager
	include UTIL.IF
	ENDIF
	IF _MEM_ EQ 1           ;Memory Manager
	include MEM.IF
	ENDIF
	IF _AM_ EQ 1            ;Audio Manager 3
	include AM.IF
	ENDIF
	IF _MATH_ EQ 1          ;Math Manager
	include MATH.IF
	ENDIF
	IF _GGUI_ EQ 1          ;Graphical User Interface
	include GGUI.INC
	ENDIF
	include DC.INC          ;Dynamic Code macros (SelfModifyingCode)
;
	;global _main:proc
.CSEG
;**NOTE! THIS IS THE FIRST DATA IN THE EXE FILE! COOL EH? WE CAN PUT
;**SECRET MESSAGES HERE!
;------------CODE SEGMENT DATA-------------
DB 10,13,10
DB 'General Manager 1.0 by Kenneth Foo (TechnoMaestro/RDG) 1994.',10,13,01ah
GM_Start DB 'General Manager by Kenneth Foo 1994',10,13
	 DB '       Initializing system...',0,10,13,36
GM_Stack DD 0
GM_ExitFlag     dw      0
;------------------------------------------
Entry:  call    _init        ;Initialize
	call    _main        ;Main routine
	call    _deinit      ;Deinitialization
.CSEG_ENDS
;
;MACROS
;-------------------------------------
; End an ASM source code
;-------------------------------------
END_PROGRAM     MACRO   StackSize
	IFB     <StackSize>
	STACKSEG SEGMENT PARA USE16 STACK 'STACK'
	ASSUME  SS:STACKSEG
	DB 4096 DUP(?)     ;Default size = 4k stack
	STACKSEG ENDS
	ELSE
	STACKSEG SEGMENT PARA USE16 STACK 'STACK'
	ASSUME  SS:STACKSEG
	DB StackSize DUP(?)
	STACKSEG ENDS
	ENDIF
	END Entry
	ENDM
;-------------------------------------
; Initialize General Manager
;-------------------------------------
GMinit  MACRO IntroFlag
	mov     word ptr GM_Stack[0],sp ;;SAVE STACK
	mov     word ptr GM_Stack[2],ss
	IFB     <IntroFlag>             ;;Show text introduction
	push    ax dx ds
	mov     ax,cs
	mov     ds,ax
	mov     dx,offset GM_Start
	mov     ah,9
	int     21h
	pop     ds dx ax
	ENDIF

	IF _TCM_ EQ 1
	    call _TCMinit
	    jc TCMerror
	    ENDIF
	IF _DM_ EQ 1
	    call _DMinit
	    jc DMerror
	    ENDIF
	IF _VID_ EQ 1
	    call _VIDinit
	    jc VIDerror
	    IF      _GGUI_ EQ 1         ;;Graphical introduction
	    IFB     <IntroFlag>
		call    _VIDsetpage,0
		push    word ptr 0
		push    word ptr 0
		push    word ptr 319
		push    word ptr 199
		push    word ptr GREYs+2 ;BLUEs+2 ;GREYs+4
		call    _VIDdrawBox
		;
		;GUIdrawmat
		GUIdrawwin 1,10,1+38,10+3,GREYs+8,GREYs+6 ;CYANs+3,CYANs+1
		GUIprinttxt 1+1,10+1,GM_Start,WHITEhi
	    ENDIF
	    ENDIF
	    ENDIF
	IF _AG_ EQ 1
	    call _AGinit
	    jc AGerror
	    ENDIF
	IF _SPR_ EQ 1
	    call _SPRinit
	    jc SPRerror
	    ENDIF
	IF _BKG_ EQ 1
	    call _BKGinit
	    jc BKGerror
	    ENDIF
	IF _MOUSE_ EQ 1
	    call _MOUSEinit
	    jc MOUSEerror
	    ENDIF
	IF _E3D_ EQ 1
	    call _E3Dinit
	    jc E3Derror
	    ENDIF
	IF _UTIL_ EQ 1
	    call _UTILinit
	    jc UTILerror
	    ENDIF
	IF _MEM_ EQ 1
	    call _MEMinit
	    jc MEMerror
	    ENDIF
	IF _AM_ EQ 1
	    call _AMinit
	    jc AMerror
	    ENDIF
	IF _MATH_ EQ 1
	    call _MATHinit
	    jc MATHerror
	    ENDIF
	ENDM
;-------------------------------------
; Deinitialize General Manager
;-------------------------------------
GMdeinit        MACRO   ExitFlag
	GM_Done LABEL FAR
	lss     sp,GM_Stack             ;;RESTORE STACK
	IFNB <ExitFlag>                 ;;Exit flag
	mov GM_ExitFlag,ExitFlag
	ELSE
	mov GM_ExitFlag,ax
	ENDIF

	IF _MATH_ EQ 1
	    call _MATHdeinit
	    MATHerror:
	    ENDIF
	IF _AM_ EQ 1
	    call _AMdeinit
	    AMerror:
	    ENDIF
	IF _MEM_ EQ 1
	    call _MEMdeinit
	    MEMerror:
	    ENDIF
	IF _UTIL_ EQ 1
	    call _UTILdeinit
	    UTILerror:
	    ENDIF
	IF _E3D_ EQ 1
	    call _E3Ddeinit
	    E3Derror:
	    ENDIF
	IF _MOUSE_ EQ 1
	    call _MOUSEdeinit
	    MOUSEerror:
	    ENDIF
	IF _IO_ EQ 1
	    call _IOdeinit
	    IOerror:
	    ENDIF
	IF _BKG_ EQ 1
	    call _BKGdeinit
	    BKGerror:
	    ENDIF
	IF _SPR_ EQ 1
	    call _SPRdeinit
	    SPRerror:
	    ENDIF
	IF _AG_ EQ 1
	    call _AGdeinit
	    AGerror:
	    ENDIF
	IF _VID_ EQ 1
	    call _VIDdeinit
	    VIDerror:
	    ENDIF
	IF _DM_ EQ 1
	    call _DMdeinit
	    DMerror:
	    ENDIF
	IF _TCM_ EQ 1
	    call _TCMdeinit
	    TCMerror:
	    ENDIF
	mov     ax,GM_ExitFlag
	ENDM
;-------------------------------------
; Anti-debug code. To be inserted anywhere within code.
;-------------------------------------
GMantiDebug     macro
local   @@Target,@@Target2
pushf
push    ax dx
	cli
	;mov     si,ss
	xor     ax,ax
	mov     dx,ax
push    es
	mov     es,dx
	;mov     di,sp                   ;ES,AX,DX=0   SI:DI=SS:SP
	;ANTI-DEBUG MECHANISM 1 - TAKE OVER INT 3 !!
push    bx cx
	mov     ax,0ea90h       ;A NOP and Far JMP
	xchg    es:[03h*4][0],ax                ;Overwrite INT 8 and INT 9..
	mov     cx,offset @@Target
	xchg    es:[03h*4][2],cx
	mov     bx,cs
	xchg    es:[03h*4][4],bx
	;put dummy here...
	;ANTI-DEBUG MECHANISM 2 - PLAY AROUND WITH STACK. DEBUG CAN'T KEEP
	;                         TRACK USING TRACE!
push    bp
	mov     bp,sp
	mov     word ptr [bp-4],03h*4
	mov     [bp-2],dx               ;Seg0:Off03h*4
	mov     dx,1
	mov     ax,ax
	shl     dx,1
	add     dx,dx
	sub     sp,dx
	retf
	;put dummy here...
@@Target:
	;ANTI-DEBUG MECHANISM 3 - PLAY AROUND WITH STACK. DEBUG CAN'T KEEP
	;                         TRACK USING TRACE! WRITE A JMP INSTRUCTION
	;                         ON STACK!!
	mov     dx,cs
	mov     bp,sp
	mov     word ptr [bp-4],offset @@Target2
	;mov     byte ptr [bp-5],0eah    ;FAR JMP INSTRUCTION OP-CODE
	mov     [bp-2],dx               ;Seg:Off 0
	jmp     dword ptr [bp-4]
	;put dummy here...
@@Target2:
pop     bp
	xchg    es:[03h*4][0],ax        ;Restore shit
	xchg    es:[03h*4][2],cx
	xchg    es:[03h*4][4],bx
pop     cx bx es dx ax
popf
endm

