;MUST MODIFY DM - WRITE FULL?
;AND THEN...HANGS IF ERROR OCCURS...
;============================================================================;
; MOD/S3M TO AMM CONVERTER by TechnoMaestro/RDG. 1994                        ;
;----------------------------------------------------------------------------;
; Source code                                                                ;
; USING EXTENDED PACKING (POST-EVENT RLE)                                    ;
;============================================================================;
include GM_init.inc
MODE_FRAME
_DM_            =       1
_UTIL_          =       1
_MEM_           =       1       ;MUST!
_AM_            =       1
start
;
.DSEG
	DB 'CONVERT 2.1. By Kenneth Foo. 1994/95',10,13,01ah
	SMPprevValue    db 0
	EXT_S3M         db '.S3M',0
	EXT_MOD         db '.MOD',0
	EXT_AMM         db '.AMM',0
	SourceFile      db 129 dup(0)
	TargetFile      db 129 dup(0)
	MusicFileHandle dw 0
	TMPsizeOfOneTrack dw 0
	TMPmemPos       dd 0
	TMPbuffer       dw 0
	TMPprevSmp      db 1    ;Previous sample number
	TMPprevEfx      db 255  ;Previous effect number
	TMPprevEfxData  db 255  ;Previous effect number


	;COMMAND LINE PARAMETERS
	FileHandle      dw 0

	TXT_Info        db 'CONVERT 2.1 (MOD/S3M -> AMM) by TechnoMaestro/RDG. 1994',10,13,36
	TXT_Loading     db 'Loading module...',10,13,36
	TXT_Writing     db 'Compressing and writing...',10,13,36
	TXT_Done        db 'Done!',10,13,36

	ERRTXT_NoParam  db 'CONVERT 2.1 (MOD/S3M -> AMM) by TechnoMaestro/RDG. 1994',10,13
			db 'SYNTAX: CONV (source file .MOD/.S3M) (target.AMM)',10,13,36
	ERRTXT_Init     db 'Init error!',10,13,36
	ERRTXT_Deinit   db 'Deinit error!',10,13,36
	ERRTXT_Load     db 'Load error! No file or not enough memory!',10,13,36
	ERRTXT_Write    db 'Write error! Disk full?',10,13,36
	;ERRTXT_DiskFull db 'Error. Disk full!',10,13,36


.DSEG_ENDS
;
.CSEG
;
_main   proc
GMinit  NoIntro
	;SET DEFAULT VALUES
	;GET PARAMETERS
	push    word ptr 1                      ;Source
	call    _UTILgetCmdLineParamNum
	jc      @@NoParam
	xor     di,di
	@@CopySourceFileName:
	mov     al,es:[bx][di]
	mov     SourceFile[di],al
	inc     di
	loop    @@CopySourceFileName
	push    word ptr 2                      ;Target
	call    _UTILgetCmdLineParamNum
	jc      @@NoParam
	xor     di,di
	@@CopyTargetFileName:
	mov     al,es:[bx][di]
	mov     TargetFile[di],al
	inc     di
	loop    @@CopyTargetFileName

	mov     dx,offset TXT_Info
	mov     ah,9
	int     21h

	;PREPARE SYSTEM - Does cumulative errors
	;INIT STAGE
	push    word ptr 0                      ;Init - use NOSOUND
	call    _AMinitSystem
	push    word ptr 22050
	push    word ptr 00b
	call    _AMstart
	call    _AMmusicInit                    ;Initialize music system
	jc      @@InitError                     ; ACCUMULATES ERRORS! 
	;LOADING STAGE
	;OPEN MODULE...
	push    ds
	push    offset SourceFile
	call    _DMopenFile
	mov     MusicFileHandle,ax
	;LOAD MODULE...
	mov     dx,offset TXT_Loading
	mov     ah,9
	int     21h
	;================================================
	;===CRITICAL RECONSTRUCTION!
	;===POINTER THE NOSOUND SDI LOAD/UNLOAD SAMPLE & MEM ALLOC TO POINT TO
	;===DSM'S!
	mov     ax,seg SDIproc_SB
	mov     es,ax
	mov     bx,offset SDIproc_SB
	push    word ptr [es:bx][2*AM@SDI_LoadSample]
	push    word ptr [es:bx][2*AM@SDI_UnloadSample]
	push    word ptr [es:bx][2*AM@SDI_AllocMem]
	push    word ptr [es:bx][2*AM@SDI_DeallocMem]
	mov     ax,seg SDIproc_NS
	mov     es,ax
	mov     bx,offset SDIproc_NS
	pop     word ptr [es:bx][2*AM@SDI_DeallocMem]
	pop     word ptr [es:bx][2*AM@SDI_AllocMem]
	pop     word ptr [es:bx][2*AM@SDI_UnloadSample]
	pop     word ptr [es:bx][2*AM@SDI_LoadSample]
	;================================================

	push    MusicFileHandle                 ;Try as S3M
	push    dword ptr 0
	call    _AMmusicLoadS3M
	jnc     short @@Loaded
	push    MusicFileHandle                 ;Try as MOD
	push    dword ptr 0
	call    _AMmusicLoadMOD
	jnc     short @@Loaded
	;CLOSE MODULE...
	push    MusicFileHandle
	call    _DMcloseFile
	jmp     @@LoadError
      @@Loaded:                                 ;.MOD.
	;CLOSE MODULE...
	push    MusicFileHandle
	call    _DMcloseFile
	;jmp     @@LoadError
	jc      @@LoadError                     ; ACCUMULATES ERRORS! 

;
;WRITE AMM ...
;
push    dword ptr (64*1024)     ;Alloc 64k...should be enuf for now...
call    _MEMallocBase
jc      @@LoadError
mov     TMPbuffer,dx
	mov     dx,offset TXT_Writing
	mov     ah,9
	int     21h
	push    ds                              ;Create
	push    offset TargetFile
	push    word ptr 0
	call    _DMcreateFile
	jc      @@WriteError
	mov     MusicFileHandle,ax
	call    _AMmusicGetInfo                 ;Get Header address...
	mov     es,dx                           ;And write AMM header
	mov     di,ax
	or      [es:di][MusicX.MUSinfo],08000h          ;Set PACKED flag.
	push    MusicFileHandle
	push    dx
	push    ax
	push    word ptr 80
	call    _DMwriteFile
	jc      @@WriteError
	;cmp     ax,80
	;jne     @@DiskFull
	mov     cx,[es:di][MusicX.MUSnumberTracks]      ;Write PAN flags
	mov     ax,di
	add     ax,offset [MusicX.MUSinitPan]
	push    MusicFileHandle
	push    es ax
	push    cx
	call    _DMwriteFile
	jc      @@WriteError
	;cmp     ax,cx
	;jne     @@DiskFull
	mov     cx,[es:di][MusicX.MUSsongLength]        ;Write sequence
	shl     cx,1
	mov     ax,di
	add     ax,offset [MusicX.MUSsequence]
	push    MusicFileHandle
	push    es ax
	push    cx
	call    _DMwriteFile
	jc      @@WriteError
	;cmp     ax,cx
	;jne     @@DiskFull
;                                                ;Write Patterns for each track
;        mov     ax,[es:di][MusicX.MUSnumberPatterns]
;        mov     bx,(SIZE NoteX)*64
;        mul     bx
;        mov     TMPsizeOfOneTrack,ax
	mov     cx,[es:di][MusicX.MUSnumberTracks]
	mov     bx,1 ;Start track 1
	@@WritePatterns:
	push    bx
	call    _AMgetTrackInfo
	mov     fs,dx
	mov     si,ax
	push    [fs:si][TrackX.TRKmemHandle]
	push    dword ptr 0
	call    _MEMqGetAddress

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;COMPRESS AMM PATTERNS
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	push    bx cx si di
	mov     TMPprevSmp,1                            ;DEFAULT PREVIOUS STUFF
	mov     TMPprevEfx,MI@EFXsetSpeed
	mov     TMPprevEfxData,6 ;255
	mov     cx,[es:di][MusicX.MUSnumberPatterns]    ;64 rows per pattern.
	shl     cx,6
;CAUSES PROBLEMS IF THERE ARE NO PATTERNS...
	mov     fs,dx
	mov     si,ax
	mov     gs,TMPbuffer
	mov     di,4                                    ;First 4-bytes
      @@NewEvent:                                       ; = length of compressed
	;===DETERMINE NUMBER REPETITIONS                ; stream...
	push    cx
	mov     al,128                                  ;Get max rows
	or      ch,ch                                   ;128 or if CL less use it.
	jnz     short @@UseAL
	cmp     cl,al
	jbe     short @@UseCL
	@@UseAL:
	mov     cl,al
	@@UseCL:
	call    near ptr GetRLE
	pop     cx
	sub     cl,al                                   ;Decrement row count.
	sbb     ch,0
	shl     ax,8
	jz      short @@EventPresent
	dec     ah
	mov     bx,di
	inc     di
	jmp     short @@WriteEvent

      @@EventPresent:
	mov     ah,10000000b
	;===EVENT PRESENT. MANAGE IT...
	mov     bx,di
	inc     di

	mov     al,[fs:si][NoteX.NOTEnote]              ;Note
	cmp     al,255
	je      short @@NoNote
	or      ah,00000001b
	mov     [gs:di],al
	inc     di
	@@NoNote:

	mov     al,[fs:si][NoteX.NOTEsampleNumber]      ;Sample number
	cmp     al,255
	je      short @@NoSmp
	or      ah,00000010b
	cmp     al,TMPprevSmp ;No change in smp number
	je      short @@NoSmp
	or      ah,00010000b
	mov     [gs:di],al
	mov     TMPprevSmp,al
	inc     di
	@@NoSmp:

	mov     al,[fs:si][NoteX.NOTEvolume]            ;Volume
	cmp     al,255
	je      short @@NoVol
	or      ah,00000100b
	mov     [gs:di],al
	inc     di
	@@NoVol:

	mov     al,[fs:si][NoteX.NOTEeffect]            ;Effect number & data
	cmp     al,255
	jne     short @@EfxPresent
	cmp     [fs:si][NoteX.NOTEeffectData],255
	je      short @@NoEFX
	@@EfxPresent:
	or      ah,00001000b
	;===DIFFERENCE IN EFX NUMBER?===
	cmp     al,TMPprevEFX
	je      short @@NoEFXnumChg
	or      ah,00100000b
	mov     [gs:di],al
	mov     TMPprevEFX,al
	inc     di
	@@NoEFXnumChg:
	;===DIFFERENCE IN EFX DATA?===
	mov     al,[fs:si][NoteX.NOTEeffectData]
	cmp     al,TMPprevEFXdata
	je      short @@NoEFXdataChg
	or      ah,01000000b
	mov     [gs:di],al
	mov     TMPprevEFXdata,al
	inc     di
	@@NoEFXdataChg:
	@@NoEFX:


      comment ~
                 BIT 0 1=Note present
                     1 1=Instrument number present
                     2 1=Volume present
                     3 1=Effect present
                     4 1=Change in instrument number
                     5 1=Change in effect number
                     6 1=Change in effect data
                     7 1=Data present  0=Empty rows RLE encoded .
                         If bit set, then Bit 0-6 = Number of empty rows-1.
                         We do not have a signal for end of pattern because
                         it isn't necessary, as each pattern must be 64-rows
                         and if we reach more than 64 rows, it's time to
                         increment the pattern count.
                         This bit can save up to 128 empty rows with just
                         one byte! :-) Now that's COOL! :-)
      
      ~

	add     si,(SIZE NoteX)
	dec     cx
;        jz      short @@WriteEvent                      ;No post-RLE possible.
;        ;===DETERMINE NUMBER REPETITIONS AFTER NOTE/ETC EVENT.
;        ;===(POST EVENT RLE)
;        push    cx
;        mov     al,3 ;PIGS 7                                    ;Get max rows
;        or      ch,ch                                   ;7 or if CL less use it.
;        jnz     short @@UseAL2
;        cmp     cl,al
;        jbe     short @@UseCL2
;        @@UseAL2:
;        mov     cl,al
;        @@UseCL2:
;        call    near ptr GetRLE
;        pop     cx
;        sub     cl,al                                   ;Decrement row count.
;        sbb     ch,0
;        shl     al,4
;        or      ah,al
;        ;** FALL THROUGH **

      @@WriteEvent:
	;===WRITE EVENT (RLE OR NOTES/ETC...). EVENT FLAG IN AH.
	mov     [gs:bx],ah                              ;Write event flag
	or      cx,cx
	jnz     @@NewEvent
	jmp     short @@DoneRLE

;==============================================================
;INPUT: CL=Number max rows to compress, FS:SI=Note stream
;OUTPUT: AL=Number rows, SI updated, CL uncertain., AH unmodified.
GetRLE LABEL NEAR
	xor     al,al
       @@DoRLE:
	push    cx si
	;=====CHECK ONE ROW======
	mov     cx,SIZE NoteX
	@@CheckRLE:
	cmp     byte ptr [fs:si],255
	jne     short @@RLEsearchEnd
	inc     si
	loop    @@CheckRLE
	;========================
	pop     si cx
	add     si,(SIZE NoteX)
	inc     al
	dec     cl
	jnz     short @@DoRLE
	retn
	@@RLEsearchEnd:
	pop     si cx
	retn
;==============================================================


      @@DoneRLE:
	sub     di,4                                   ;Length
	movzx   eax,di                                  ;Exclude length DWORD
	mov     [gs:0],eax
	add     eax,4
	pop     di si cx bx
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


       ;push    ax
	push    MusicFileHandle
	push    gs
	push    word ptr 0      ;32-bit to 16-bit truncation...
	push    ax      ;TMPsizeOfOneTrack
	call    _DMwriteFile
       ;pop     dx
	jc      @@WriteError
       ;cmp     ax,dx
       ;jne     @@DiskFull
	inc     bx
	loop    @@WritePatterns

						;Write sample headers
	mov     cx,[es:di][MusicX.MUSnumberSamples]
	mov     bx,1    ;Start sample 1
	@@WriteSampleHeaders:
	push    bx
	call    _AMmusicGetSampleInfo

;DELTA-ENCODING
mov     fs,dx
mov     si,ax
or      [fs:si][SmpX.SMPinfo],100000b           ;Delta encode it!
and     [fs:si][SmpX.SMPinfo],NOT (1 SHL 15)    ;Don't set 'loaded' flag.


	push    MusicFileHandle
	push    dx ax
	push    word ptr (SIZE SmpX)
	call    _DMwriteFile
	jc      @@WriteError
       ;cmp     ax,SIZE SmpX
       ;jne     @@DiskFull
	inc     bx
	loop    @@WriteSampleHeaders

						;Write samples
	mov     cx,[es:di][MusicX.MUSnumberSamples]
	mov     bx,1    ;Start sample 1
	@@WriteSamples:
	push    bx
	call    _AMmusicGetSampleInfo
	mov     fs,dx
	mov     si,ax
	mov     eax,[fs:si][SmpX.SMPlength]
	or      eax,eax
	jz      short @@EmptySample
	;---WRITE SAMPLE...----------------------
	mov     eax,[fs:si][SmpX.SMPmemPos]
	mov     TMPmemPos,eax

;DELTA-ENCODING
mov     SMPprevValue,0

      @@WriteSmp:                               ;Write in 16k blocks...
	push    [fs:si][SmpX.SMPmemHandle]
	push    TMPmemPos
	call    _MEMqGetAddress
	jc      @@WriteError

;DELTA-ENCODING
mov     es,dx
mov     di,ax

	push    MusicFileHandle
	push    dx
	push    ax      ;32-bit to 16-bit truncation...
	mov     eax,[fs:si][SmpX.SMPlength]
	or      eax,eax
	jz      short @@DoneWrite
	cmp     eax,16384
	jbe     short @@LengthOK
	mov     eax,16384
	@@LengthOK:

;DELTA-ENCODING
pushad
mov     cx,ax
@@Val2Delta:
mov     al,[es:di]
mov     ah,al
sub     al,SMPprevValue
mov     SMPprevValue,ah
stosb
loop    @@Val2Delta
popad

       ;push ax
	sub     [fs:si][SmpX.SMPlength],eax     ;Modifies SMP header in mem!
	add     TMPmemPos,eax
	push    ax
	call    _DMwriteFile
       ;pop dx
	jc      @@WriteError
       ;cmp     ax,dx
       ;jne     @@DiskFull
	jmp     short @@WriteSmp
      @@DoneWrite:
	;---------------------------------------
	@@EmptySample:
	inc     bx
	loop    @@WriteSamples


	push    MusicFileHandle
	call    _DMcloseFile
	jc      @@WriteError


push    TMPbuffer
push    word ptr 0
call    _MEMdeallocBase
jc      @@LoadError

;

	;DEINIT STAGE
	;UNLOAD MODULE
	call    _AMmusicUnload
	;CLOSE SYSTEM
	call    _AMmusicDeinit
	call    _AMstop
	call    _AMdeinitSystem
	jc      @@DeinitError

	mov     dx,offset TXT_Done
	mov     ah,9
	int     21h

@@Done:
GMdeinit        0
ret
@@NoParam:
	mov     dx,offset ERRTXT_NoParam
	mov     ah,9
	int     21h
	jmp     @@Done
@@InitError:
	mov     dx,offset ERRTXT_Init
	mov     ah,9
	int     21h
	jmp     @@Done
@@LoadError:
	mov     dx,offset ERRTXT_Load
	mov     ah,9
	int     21h
	;CLOSE SYSTEM
	call    _AMmusicDeinit
	call    _AMstop
	call    _AMdeinitSystem
	jmp     @@Done
@@DeinitError:
	mov     dx,offset ERRTXT_Deinit
	mov     ah,9
	int     21h
	jmp     @@Done
@@WriteError:
	mov     dx,offset ERRTXT_Write
	mov     ah,9
	int     21h
	;UNLOAD MODULE
	push    MusicFileHandle
	call    _DMcloseFile
	push    TMPbuffer
	push    word ptr 0
	call    _MEMdeallocBase
	call    _AMmusicUnload
	;CLOSE SYSTEM
	call    _AMmusicDeinit
	call    _AMstop
	call    _AMdeinitSystem
	jmp     @@Done
;@@DiskFull:
;        mov     dx,offset ERRTXT_DiskFull
;        mov     ah,9
;        int     21h
;        ;CLOSE SYSTEM
;        call    _AMmusicDeinit
;        call    _AMstop
;        call    _AMdeinitSystem
;        jmp     @@Done
_main   endp
.CSEG_ENDS
;
END_PROGRAM     512     ;1/2k is enough! 4096



	xor     ah,ah
       @@DoRLE:
	push    cx si
	;=====CHECK ONE ROW======
	mov     cx,SIZE NoteX
	@@CheckRLE:
	cmp     byte ptr [fs:si],255
	jne     short @@RLEsearchEnd
	inc     si
	loop    @@CheckRLE
	;========================
	pop     si cx
	inc     ah
	add     si,(SIZE NoteX)
	dec     cx
	test    ah,10000000b                            ;Up to 128 rows only
	jnz     short @@RLEmaxRows
	or      cx,cx
	jnz     short @@DoRLE
	;** FALL THROUGH **
	;** FINISHED TRACK **
	@@RLEmaxRows: ;===128 ROWS MAX.CONTINUE COMPRESS.
	dec     ah                                      ;-1 count.
	mov     [gs:di],ah                              ;Write event flag (RLE)
	inc     di
	;xor     ah,ah                                   ;Reset count
	or      cx,cx
	jnz     short @@NewEvent ;DoRLE
	jmp     @@DoneRLE
	@@RLEsearchEnd: ;===FOUND AN EVENT. WRITE AND DO EVENT.
	pop     si cx
	or      ah,ah
	jz      short @@DoEventPresent
	dec     ah                                      ;-1 count.
	mov     [gs:di],ah                              ;Write event flag (RLE)
	inc     di
	@@DoEventPresent: ;===FIRST THING WAS AN EVENT, NOT RLE!
	mov     ah,10000000b

