/*-*-c++-*-*/
#ifndef _MODULE_H_
#define _MODULE_H_
#include "types.h"
#include "formats.h"
#include "sample.h"
#include "instrument.h"

typedef struct // data for each note
{
  ubyte InstMode; // 1 bit for instrument mode 
  ubyte number;   // if InstMode set then this is Inst Num else Smp Num 
  ubyte NoteNum;
  ubyte volume;
  ubyte effect;
  ubyte effParam;
} Note;

class  Module
{
public:
  Module(void);
  ~Module(void);
  
  // generic
  int load(const char *filename);
  int save(const char *filename);

  static bool is_module(const char *filename);
  int dump(void);
  
  // specific
  int loadMOD (const char *filename);
  int loadS3M (const char *filename);
  int loadXM  (const char *filename);
  int loadIT  (const char *filename);

  int saveMOD (const char *filename);
  int saveS3M (const char *filename);
  int saveXM  (const char *filename);
  int saveIT  (const char *filename);

  char *error_message;

  //private:
  Note***      PatternData;   // PatternData[pattern][channel][row] 
  Sample**     samples;
  Instrument** in;
  uword*       rows;          // row lengths for each pattern 
  ubyte*       order;         // Pattern Order 
  char*        name;          // NULL terminated string -- hopefully

  uword   SongLength;
  uword   restart;            // Pattern to restart at
  ubyte   NumPatterns;
  ubyte   channels;
  ubyte   NumInst;
  ubyte   NumSamples;
  ubyte   speed;
  ubyte   bpm;
  ubyte   global_volume; // 0 - 64 -- IT uses 0 - 128
  ubyte   linear : 1;
  ubyte   stereo : 1;
  ubyte   period_shift : 3;
  ubyte   flags : 3;
};

// utilities

uword finetune_to_C2SPD(const ubyte finetune);
byte period_to_note(const word period);

byte convert_s3mfx (byte fx, byte* param);
byte convert_xmfx  (byte fx, byte* param);

#endif
