#ifndef _FORMATS_H_
#define _FORMATS_H_
#include "patch.h"

/* FILE FORMATS */

/*****************\
. AU FILE FORMAT .
\*****************/
/* this header follows ".snd" */
typedef struct
{
  udword header_size;
  udword length; /* length in bytes */
  udword format;
  udword sample_rate;
  udword channels;
} AU_HEADER;


/******************************\
 .   THE RIFF WAVE FORMAT     .
\******************************/
enum WAVE 
{
  WAVE_FORMAT_UNKNOWN 		   =(0x0000),
  WAVE_FORMAT_PCM                  =(0x0001),
  WAVE_FORMAT_ADPCM	           =(0x0002),
  WAVE_FORMAT_IBM_CVSD		   =(0x0005),
  WAVE_FORMAT_ALAW		   =(0x0006),
  WAVE_FORMAT_MULAW		   =(0x0007),
  WAVE_FORMAT_OKI_ADPCM		   =(0x0010),
  WAVE_FORMAT_DVI_ADPCM		   =(0x0011),
  WAVE_FORMAT_IMA_ADPCM		   =(WAVE_FORMAT_DVI_ADPCM),
  WAVE_FORMAT_DIGISTD		   =(0x0015),
  WAVE_FORMAT_DIGIFIX		   =(0x0016),
  WAVE_FORMAT_YAMAHA_ADPCM	   =(0x0020),
  WAVE_FORMAT_SONARC		   =(0x0021),
  WAVE_FORMAT_DSPGROUP_TRUESPEECH  =(0x0022),
  WAVE_FORMAT_ECHOSC1		   =(0x0023),
  WAVE_FORAMT_AUDIOFILE_AF18	   =(0x0024),
  WAVE_FORMAT_IBM_MULAW            =(0x0101),
  WAVE_FORMAT_IBM_ALAW             =(0x0102),
  WAVE_FORMAT_IBM_ADPCM            =(0x0103),
  WAVE_FORMAT_CREATIVE_ADPCM	   =(0x0200)
};

/* CHUNK ID's */ 
enum CKID_RIFF 
{
  CKID_RIFF_FMT  =(0x20746d66), /* "fmt " */
  CKID_RIFF_DATA =(0x61746164), /* "data" */
  CKID_RIFF_FACT =(0x74636166), /* "fact" */
  CKID_RIFF_LIST =(0x5453494c), /* "LIST" */
  CKID_RIFF_INFO =(0x4f464e49), /* "INFO" */
  CKID_RIFF_ISFT =(0x54465349), /* "ISFT" */
  CKID_RIFF_ICOP =(0x504F4349), /* "ICOP" */
  CKID_RIFF_IPRD =(0x44525049), /* "IPRD" */
  CKID_RIFF_ICRD =(0x44524349), /* "ICRD" */
  CKID_RIFF_IENG =(0x474e4549), /* "IENG" */
  CKID_RIFF_ICMT =(0x544D4349),
  CKID_RIFF_IGNR =(0x524E4749),
  CKID_RIFF_IKEY =(0x59454B49),
  CKID_RIFF_IMED =(0x44454D49),
  CKID_RIFF_INAM =(0x4D414E49),
  CKID_RIFF_ISRC =(0x43525349),
  CKID_RIFF_ITCH =(0x48435449),
  CKID_RIFF_ISBJ =(0x4A425349),
  CKID_RIFF_ISRF =(0x46525349),
  CKID_RIFF_DISP =(0x50534944)
};
#define CHANNELS (1) /* FOR ADPCMBLOCKHEADER */
/* OTHER CHUNKS */
/* there is a "PAD " and a "JUNK" chunk both contain data to be thrown away
 * Only reason for 2 instead of 1 is because there are two rival companies. 
 */

typedef struct 
{
  char RIFF[4];                 /* magic number "RIFF" */
  udword Size;                  /* length of RIFF chunk */
} RiffHeader;


/* "fmt " */
typedef struct 
{
  uword  FormatTag;              /* format category */
  uword  nChannels;              /* number of channels */
  udword SamplesPerSec;         /* Sampling rate */
  udword AvgBytesPerSec;        /* for buffer estimation */
  uword  BlockAlign;             /* data block size */
  uword  BitsPerSample;
} CommonChunk; 


/* "cue " */
/* before this there is a dword count of the number of cuepoints */
typedef struct
{
  dword Name;
  dword Position;
  char  Chunk[4];                /* "slnt" or "data" */
  dword ChunkStart;
  dword BlockStart;
  dword SampleOffset;
} CuePoints;


/* before this there is a dword count of the number of play lists */
typedef struct
{
  dword Name;
  dword Length;
  dword Loops;
} PlayList;

/* MS ADPCM STRUCTS */ 
typedef struct
{
  sword iCoef1; /* fixed point 8.8 values */
  sword iCoef2;
} ADPCMCOEFSET;

typedef struct
{
  byte  bPredictor[CHANNELS];  /* nChannels is 1 0r 2 */
  sword iDelta[CHANNELS];
  sword iSamp1[CHANNELS];
  sword iSamp2[CHANNELS];
} ADPCMBLOCKHEADER; 

/* IMA ADPCM STRUCTS AND TABLES */

#pragma pack(1)

typedef struct {
  sword Samp0;
  byte StepTableIndex;
  byte Reserved;
} DVI_ADPCMBLOCKHEADER;

#pragma pack()

static const int StepTab[ 89 ]  = {
  7,     8,     9,    10,    11,    12,    13,    14,
  16,    17,    19,    21,    23,    25,    28,    31,
  34,    37,    41,    45,    50,    55,    60,    66,
  73,    80,    88,    97,   107,   118,   130,   143,
  157,   173,   190,   209,   230,   253,   279,   307,
  337,   371,   408,   449,   494,   544,   598,   658,
  724,   796,   876,   963,  1060,  1166,  1282,  1411,
  1552,  1707,  1878,  2066,  2272,  2499,  2749,  3024,
  3327,  3660,  4026,  4428,  4871,  5358,  5894,  6484,
  7132,  7845,  8630,  9493, 10442, 11487, 12635, 13899,
  15289, 16818, 18500, 20350, 22385, 24623, 27086, 29794,
  32767 };

/* 4 bit DVI ADPCM */
static const int IndexTab[ 16 ] = { -1, -1, -1, -1, 2, 4, 6, 8,
                                    -1, -1, -1, -1, 2, 4, 6, 8 };



/*****************************\
 .           IFF             .
\*****************************/
/* CHUNK ID's */
enum CKID_IFF
{
  CKID_IFF_NAME =(0x454d414e),  /* "NAME" */
  CKID_IFF_VHDR =(0x52444856),  /* "VHDR" */
  CKID_IFF_BODY =(0x59444f42),  /* "BODY" */
  CKID_IFF_ANNO =(0x4f4e4e41)  /* "ANNO" */
  /*CKID_IFF_COPY =(0xf        ),*/ /* "(C) " */
  /*CKID_IFF_AUTH =(0x44    41),*/  /* "AUTH" */
};
#pragma pack(1)

typedef struct /* 20 = 0x14 */ 
{
  udword OneShotHi;
  udword RepeatHi;
  udword SmpPerHiCycle;
  uword  SmpPerSec;
  ubyte  NumOctaves;
  ubyte  Cmp;    /* Cmp == 0 for no compression */
  udword  Volume; /* DWORD OR WORD ? */
} Voice8Header;

/*****************************\
 .            XI             .
\*****************************/

typedef struct /* 66 = 0x42 */
{
  char  Magic1[21];         /* "Extended Instrument: " */
  char  Name[22];
  ubyte pad;                /* */
  char  Tracker[20];
  ubyte VMajor;              /* Version Number */
  ubyte VMinor;
} XIFileHeader;

typedef struct
{
  dword size;
  char  name[22];
  byte  type; /* always 0 */
  word  NumSamples;
} XI_XMHeader;

typedef struct /* 210 = 0xd2 */
{
  /*udword Sample_Header_Size;*/
  ubyte Sample_Number[96];  /* sample number for each note */
  uword Vol_Envelope[24]; 
  uword Pan_Envelope[24]; 
  ubyte Num_Vol_Points;
  ubyte Num_Pan_Points;
  ubyte Vol_Sus;
  ubyte Vol_Loop_Start;
  ubyte Vol_Loop_End;
  ubyte Pan_Sus;
  ubyte Pan_Loop_Start;
  ubyte Pan_Loop_End;
  ubyte Vol_Type;          /* Volume type: bit 0: On; 1: Sustain; 2: Loop */
  ubyte Pan_Type;          /* Pan    type: bit 0: On; 1: Sustain; 2: Loop */
  ubyte Vibrato_Type;
  ubyte Vibrato_Sweep;
  ubyte Vibrato_Depth;
  ubyte Vibrato_Rate;
  uword Vol_Fadeout;
  uword Reserved[11]; /* incorrect in xm.txt */
} XIinst; 

/* SMP - Fasttracker samples */
typedef struct /* 40 = 0x28 */
{
  /*00*/ udword Length;
  /*04*/ udword Loop_Start;
  /*08*/ udword Loop_Length;
  /*12*/ ubyte  Volume;
  /*13*/ sbyte  FineTune;
  /*14*/ ubyte  Type;           
  /*15*/ ubyte  Panning;           /* (0-255) */
  /*16*/ sbyte  RelativeNote;
  /*17*/ ubyte  Reserved;
  /*18*/ char   Name[22];
} SMPHeader;
/*****************************************************************************\
  .                             MODULE STRUCTURES                           . 
\*****************************************************************************/
/*****************\
 .     MOD       .
\*****************/

typedef struct
{
  char  Name[22];
  uword Length;        /* A Length of 1 means an empty sample */
  sbyte Finetune;       /* lowest 4 bits represent a signed nibble (-8 .. 7)*/
  ubyte Volume;
  uword LoopStart;     
  uword LoopLength;    /* only loop if LoopLength is greater than 1 */
} ModSampleHeader;
/* period table for finetune 0 ie normal */
/*                        			     
   00 -  11 = c0 - b0 
   12 -  23 = c1 - b1 
   24 -  35 = c2 - b2 
   36 -  47 = c3 - b3 
   48 -  59 = c4 - b4
   60 -  71 = c5 - b5
   72 -  83 = c6 - b6
   84 -  95 = c7 - b7
   96 - 107 = c8 - b8
  108 - 119 = c9 - b9
 */
static const word period_table[] =
{
27392, 25856, 24384, 23040, 21696, 20480,19328,18240,17216,16256,15360,14496,

13696, 12928, 12192, 11520, 10848, 10240, 9664, 9120, 8606, 8128, 7680, 7248,
 6848,  6464,  6096,  5760,  5424,  5120, 4832, 4560, 4304, 4064, 3840, 3624,
 3424,  3232,  3048,  2880,  2712,  2560, 2416, 2280, 2152, 2032, 1920, 1812,
 1712,  1616,  1525,  1440,  1357,  1281, 1209, 1141, 1077, 1017,  961,  907,
  856,   808,   762,   720,   678,   640,  604,  570,  538,  508,  480,  453, 
  428,   404,   381,   360,   339,   320,  302,  285,  269,  254,  240,  226,
  214,   202,   190,   180,   170,   160,  151,  143,  135,  127,  120,  113,
  107,   101,    95,    90,    85,    80,   76,   71,   67,   64,   60,   57,
   54,    51,    48,    45,    42,    40,   38,   36,   34,   32,    30,  28,
   27,    25,    24,    22,    21,    20,   19,   18,   17,   16,    15,  14,

   13,    13,    12,    11,    11,    10,    9,    9
};

static const byte sine_table[] =
{
  0,   24, 49, 74, 97,120,141,161,
  180,197,212,224,235,244,250,253,
  255,253,250,244,235,224,212,197,
  180,161,141,120, 97, 74, 49, 24
};

/*****************\
 .     S3M       .
\*****************/
typedef struct
{
  char Name[28];        /* Null terminated string */
  ubyte Marker;         /* 0x1A */
  ubyte Type;           /* 16 */
  uword Reserved1;
  uword SongLength;
  uword NumInst;
  uword NumPatterns;
  uword Flags;
  uword Version;
  uword Signed;
  char  SCRM[4];        /* "SCRM" */
  ubyte Global_Volume;
  ubyte Speed;
  ubyte BPM;
  ubyte Master_Volume;
  ubyte Click_Removal; /*ignore*/
  ubyte Default_Panning;
  char  Reserved2[8];
  uword Special;
  byte  channels[32];
} S3MHeader;

/* Flags -
   1 - st2vibrato
   2 - st2 tempo
   4 - amiga slides
   8 - ovol omptimisations
  16 - amiga limits
  32 - enable filter
  64 - st3 volume slides
 128 - special data present
 */
typedef struct 
{
  ubyte  type;
  char   filename[12];
  ubyte  memsegh;
  uword  memsegl;
  udword length;
  udword loopstart;
  udword loopend;
  ubyte  volume;
  ubyte  reserved1;
  ubyte  pack;
  ubyte  flags;
  udword c2spd;
  ubyte  reserved2[12];
  char   sampname[28];
  char  scrs[4];
}  S3MSAMPLE;

/* DEFINES FOR EFFECTS */
/* std mod effects */
enum EFFECTS
{
  ARPEGGIO                  =0x00,
  PORT_UP                   =0x01,
  PORT_DOWN                 =0x02,
  PORT_TONE                 =0x03,
  VIBRATO                   =0x04,
  PORT_VOL_SLIDE            =0x05,
  VIBRATO_VOL_SLIDE         =0x06,
  TREMOLO                   =0x07,
  PAN                       =0x08,
  SAMPLE_OFFSET             =0x09,
  VOLUME_SLIDE              =0x0A,
  PATTERN_JUMP              =0x0B,
  VOLUME_SET                =0x0C,
  PATTERN_BREAK             =0x0D,
  SPEED_SET                 =0x0F,
  FILTER_SET                =0xE0,/*not used*/
  FINE_PORT_UP              =0xE1,
  FINE_PORT_DN              =0xE2,
  GLISSANDO                 =0xE3,
  VIBRATO_WAVEFORM          =0xE4,
  FINETUNE_SET              =0xE5,
  PATTERN_LOOP              =0xE6,
  TREMOLO_WAVEFORM          =0xE7,
  RETRIG_NOTE               =0xE9,
  FINE_VOL_SLIDE_UP         =0xEA,
  FINE_VOL_SLIDE_DN         =0xEB,
  NOTE_CUT                  =0xEC,
  NOTE_DELAY                =0xED,
  PATTERN_DELAY             =0xEE,
  FUNK_IT                   =0xEF,/* not used*/
  /* s3m & XM effects */
  TREMOR                    =0x10,
  FINE_VIBRATO              =0x11,
  GLOBAL_VOLUME             =0x12,
  GLOBAL_VOLUME_SLIDE       =0x13,
  STEREO_CONTROL            =0x14,
  XTR_FINE_PORT_DN          =0x15,
  XTR_FINE_PORT_UP          =0x16,
  RETRIG_VOL_SLIDE          =0x17,
  KEY_OFF                   =0x18,
  SET_ENVELOPE_POSITION     =0x19,
  PANNING_SLIDE             =0x1a

};
#define NOTE_OFF             0xfe

/*
  the following effects are present in mods but have been altered by st3
  - set speed          (Axy -> Fxy) 
  - retrig + vol slide (Qxy -> E9x)
  - port   + vol slide (Kxy -> 5xy)
  - volume slide       (Dxy -> Axy)
 */

/* volume column effects */
enum VC_EFFECTS
{
  VC_VOL_SLIDE_DN      =0x6,
  VC_VOL_SLIDE_UP      =0x7,
  VC_FINE_VOL_SLIDE_DN =0x8,
  VC_FINE_VOL_SLIDE_UP =0x9,
  VC_SET_VIBRATO_SPEED =0xa,
  VC_VIBRATO           =0xb,
  VC_SET_PANNING       =0xc,
  VC_PAN_SLIDE_LEFT    =0xd,
  VC_PAN_SLIDE_RIGHT   =0xe,
  VC_PORT_TONE         =0xf
};

/***************\
 .     XM      .
\***************/
typedef struct
{
  char  id[17];      /* "Extended module: " */
  char  name[20];    /* module name padded with zeros */
  char  marker;      /* 0x1A */
  char  tracker[20]; /* Tracker name */
  word  version;
  dword size;        /* header size */
  word  SongLength;
  word  Restart;
  word  Channels;    /* number of channels */
  word  Patterns;    /* number of patterns */
  word  Instruments; /* number of instruments */
  word  flags;       /* bits 0 - 0 = amiga freq, 1 = linear freq */
  word  speed;
  word  bpm;
  byte  order[256];
} XM_HEADER;

typedef struct
{
  byte Note; /* 0 - 71 */
  byte Instrument; /* 0 - 128 */
  byte Volume;
  byte Effect;
  byte EffParam;
} XM_NOTE;

/*
  if bit 7 is set in the Note field then
  bit 0 : Note follows
      1 : Instrument follows
      2 : volume column follows
      3 : effect follows
      4 : effect param follows
  Note: this means you need to process the pattern a byte at time
 */
/***************\
 .     IT      .
\***************/
/* 
   I think IT consists of
   IT_HEADER
   Order
   then come parapointers like s3m 
   instrument  offsets
   sample      offsets
   pattern     offsets
 */
typedef struct
{
  char  IMPM[4]; /* "IMPM" */
  char  name[26]; /* songname null terminated */
  word  pad1;
  word  SongLength;
  word  Instruments;
  word  Samples;
  word  Patterns;
  word  cwtv;    /* created with tracker version */
  word  cmwt;    /* compatible with tracker */
  word  flags;
  word  special;
  byte  Global_Volume;
  byte  Master_Volume;
  byte  speed; /*?*/
  byte  bpm;
  byte  Separation;
  byte  pad2;
  word  msg_length;
  dword msg_offset;
  dword reserved;
  byte  PanMap[64];
  byte  VolMap[64];
} IT_HEADER;

typedef struct
{
  ubyte flags;
  ubyte points;
  ubyte loop_start;
  ubyte loop_end;
  ubyte sustain_start;
  ubyte sustain_end;
  ubyte envelope[75];  
} IT_ENVELOPE;
/* flag bits
 bit 0 - envelope on
 bit 1 - loop on
 bit 2 - susloop on
 */
/* data is stored as 1 byte for y-value, 1 word for tick value */

typedef struct
{
  char id[4]; /* "IMPI" */
  char filename[12];
  char null;
  byte NNA;
  byte DCT;
  byte DCA;
  word fadeout;
  byte PPS;
  byte PPC;
  byte Global_Volume;
  byte Default_Pan;
  byte RV;
  byte RP;
  word version;
  byte Samples;
  byte pad1;
  char name[26];
  word pad2;
  byte midi_channel;
  byte midi_program;
  word midi_bank;
  byte NoteNumber[240];
  /* envelopes */  
  IT_ENVELOPE Volume;
  IT_ENVELOPE Panning;
  IT_ENVELOPE Pitch;
} IT_INST;

typedef struct
{
  char  id[4]; /* "IMPS" */
  char  filename[12];
  char  null;
  byte  Global_Volume;
  byte  flags;
  byte  Volume;
  char  name[26];
  byte  cvt;
  byte  Default_Pan;
  dword length;
  dword loop_start;
  dword loop_end;
  dword C5Speed;
  dword SusLoopStart;
  dword SusLoopEnd;
  dword offset;
  byte  Vibrato_Speed;
  byte  Vibrato_Depth;
  byte  Vibrato_Rate;
  byte  Vibrato_Type;
} IT_SMP;


#if 0
/***************\
 .     MDL      .
\***************/
/* this is similar to RIFF/IFF format */

/* ID = "IN"  - Song Info block */
typedef struct
{
  char name[32];
  char composer[20];
  word song_length;
  word repeat;
  byte main_volume;
  byte speed; /* 1 - 255 */
  byte bpm;   /* 1 - 255 */
  byte channel_info[32]; /*bit 0-6 - pan position, bit 7=1 means chan is off*/
} MDL_IN;
/* 
   MDL_IN Block is followed by 
   snglen bytes of Order
   the names for each channel - length = 8 * number of channels
 */

/* ID = "ME" Song Message block - simply consists of blocklength of message */

/* ID = "PA" Pattern Data block */
/* preceded by "PA", dword - block length, byte - NumPatterns */
/* followed by NumPatterns * MDL_PA */
typedef struct
{
  byte NumChannels;
  byte PatternLength; /* length - 1 */
  char name[16]; /* filled with spaces - 32 */
} MDL_PA;
/* followed by track seqeuncing list - 2 * NumChannels */

/* ID = "TR" track data */

/* ID = "II" Instument block */
/* "II", dword blocklength, byte Number of saved instruments */
typedef struct
{
  byte instrument_number;
  byte NumSamples;
  char name[32];  
} MDL_II_DATA;

/* followed byt NumSamples * MDL_IS_DATA */
/* no id or block length for MDL_IS_DATA */
typedef struct
{
  byte sample_number;
  byte playrange_end; /* last note in the sample */
  byte volume;
  byte volume_flag;
  byte panning;
  byte panning_flag;
  word fadeout;
  byte vibrato_spd;
  byte vibrato_dpth;
  byte vibrato_sweep;
  byte reserved;/* should be 0 */
  byte freq_env_flag;
} MDL_IS_DATA;

/* ID = "VE" volume envelope block */
/* preceded by "VE" , dword block length and byte number of envelopes*/
typedef struct {
  byte envelope_number;
  byte position[30]; /* first x byte, then y byte */ 
  byte flags;     /* bits 0-3 sustain point, bit 4 sustain on, bit 5 loop on */
  byte loop;      /* bits 0-3 loop start, bits 4-7 loop end */
} MDL_VE_DATA;

/* ID = "PE" panning envelope */
/* ID = "FE" frequency envelope */
/* ID = "IS" sample info block */
typedef struct
{
  byte  sample_number;
  char  name[32];
  char  filename[8];
  dword c4spd;
  dword length;
  dword loop_start;
  dword loop_length;
  byte  pad; /* old volume byte */
  byte  info_byte;
} MDL_IS;
/* info byte format
   bit 0    -> 0=8 bit, 1=16 bit
   bit 1    -> 0=forward looping, 1=bidirectional looping
   bits 2,3 -> pack method 0=not packed, 1=8bit packing,2=16bit packing 3=?
   bits 4-7 -> reserved, set to 0
 */
#endif

#pragma pack()

#endif

