// $Id: dsp.cc,v 0.1 1998/06/08 01:22:24 pcburns Exp pcburns $
// $Log: dsp.cc,v $
// Revision 0.1  1998/06/08 01:22:24  pcburns
// initial release
#include <errno.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/soundcard.h>
#include <stdlib.h>
#include <unistd.h>
#ifdef DEBUG
#include <stdio.h>
#endif
#include "dsp.h"

int DSP::play(const byte *&buffer, const int length)
{
  int i = 0;
  if (!length)
    return -1;
  if (!audio_buffer) 
    if ((audio_buffer = (ubyte *)calloc(bufsize, sizeof(ubyte))) == 0)
      return errno;
  
  /* copy sample to audio_buffer and write it */
  if (length > bufsize) 
    for (i = 0; i <= (length - bufsize); i += bufsize) 
      { 
#if 0
	for (int j = 0; j < bufsize; j++)
	  *(audio_buffer + j) = *(buffer + j + i);
#else
	memcpy(audio_buffer,buffer+i,bufsize);
#endif
	
	if (write(fd, audio_buffer, bufsize) == -1) 
	  return errno;
      }
  /* squeeze out the last drop */
#if 0
  for (int j = 0; j < (length % (bufsize+1)); j++)
    *(audio_buffer + j) = *(buffer + j + i);
#else
  memcpy(audio_buffer,buffer+i,length % (bufsize+1));
#endif
  if (write(fd, audio_buffer, (length % (bufsize+1))) == -1)
    return errno;
  return 0;
}


// play a 16 bit buffer as 8 bit unsigned , length in words
int DSP::play16_8(const sword *&buffer, const int length)
{
  int i = 0;
  if (!length)
    return 0;
  if (!audio_buffer) 
    if ((audio_buffer = (ubyte *)calloc(bufsize, sizeof(ubyte))) == 0)
      return errno;
  
  /* copy sample to audio_buffer and write it */
  if (length > bufsize) 
    for (i = 0; i <= (length - bufsize); i += bufsize) 
      { 
	for (int j = 0; j < bufsize; j++)
	  *(audio_buffer + j) = (*(buffer + j + i) >> 8) ^ 0x80;
	
	if (write(fd, audio_buffer, bufsize) == -1) 
	  return errno;
      }
  /* squeeze out the last drop */
  for (int j = 0; j < (length % (bufsize+1)); j++)
    *(audio_buffer + j) = (*(buffer + j + i) >> 8) ^ 0x80;
  if (write(fd, audio_buffer, (length % (bufsize+1))) == -1)
    return errno;
  return 0;
}

// play a 32 bit buffer as 8 bit unsigned, length in dwords
int DSP::play32_8(const sdword *&buffer, const int length)
{
  // convert to 8 bit unsigned and copy to buffer 
  // -- buffer should be big enough for player
  for (int j = (length % (bufsize+1)); j--;)
    {
      sdword t = *(buffer + j) >> 23; 
      // clip to size
      if (t > 0x7f)
	t = 0x7f;
      else if (t < -0x80)
	t = -0x80;      
      // copy to buffer and convert to unsigned
      *(audio_buffer + j) = t ^ 0x80;
    }
  if (write(fd, audio_buffer, (length % (bufsize+1))) == -1)
    return errno;

  return 0;
}

// play a 32 bit buffer as 16 bit signed, length in dwords
int DSP::play32_16(const sdword *&buffer, const int length)
{
  // convert to 16 bit signed and copy to buffer 
  // -- buffer should be big enough for player
  for (int j = (length % (bufsize+1)); j--;)
    {
      sdword t = *(buffer + j) >> 16; 
      // clip to size
      if (t > 0x7fff)
	t = 0x7fff;
      else if (t < -0x8000)
	t = -0x8000;      
      // copy to buffer
      *(audio_buffer + j) = t;
    }
  if (write(fd, audio_buffer, (length % (bufsize+1))) == -1)
    return errno;

  return 0;
}


/*******************************DSP COMMANDS**********************************/

void DSP::reset(void)
{
  ioctl(fd, SNDCTL_DSP_RESET, 0);
}

void DSP::sync(void)
{
  ioctl(fd, SNDCTL_DSP_SYNC, 0);
}

int DSP::get_bits(void)
{
  return bits;
}

int DSP::get_blksize(void)
{
  ioctl(fd, SNDCTL_DSP_GETBLKSIZE, &blksize);
  return blksize;
}

int DSP::get_bufsize(void)
{
  return bufsize;
}

void DSP::set_bufsize(int bufsize)
{
  this->bufsize = bufsize;
  // free the audio buffer so when play is called it is 
  // allocated to the right size -- consider remalloc ?
  free(audio_buffer);
}

int DSP::is_stereo(void)
{
  return stereo;
}

/////////////////////////////////////////////////////////////////////////////
// CONSTRUCTORS & DESTRUCTORS
//
// rate set may not be the same as the rate given 
// stereo - 0=mono, 1=stereo
// bits - number of bits per sample 

DSP::DSP(int rate, int stereo, int bits)
{
  fd = -1;
  audio_buffer = 0;
  this->stereo = stereo;
  this->bits   = bits;
  bufsize = DEFAULT_BUFFER_SIZE;
  this->rate = rate; 
  error = 0;

  //  if (fd == -1) { /* dont open device if it is already open */
  if (access(DEV_DSP, W_OK) != 0) 
    {
      error = -1;/* don't have access to the device */
      //    return;
    } 
  else 
    {
      if ((fd = open(DEV_DSP, O_WRONLY, 0)) == -1) 
	{
	  error = errno;
	  //    return;
	} 
      else 
	{
	  reset();
	  /* is there stereo? */
	  if (ioctl(fd, SNDCTL_DSP_STEREO, &(this->stereo)) == -1) 
	    {
	      error =  errno;
	      //    return;
	    } 
	  else 
	    {
	      /* can I set the dsp to the rate given? */
	      if (ioctl(fd, SNDCTL_DSP_SPEED, &(this->rate)) == -1) 
		{
		  error = errno;
		  //    return;
		} 
	      else
		{
		  /* Can the device play 16bit samples? */
		  if (ioctl(fd,SNDCTL_DSP_SAMPLESIZE,&(this->bits)) == -1)
		    error = -1; // can't set SAMPLESIZE
#ifdef DEBUG
		  if (this->bits == 8)
		    printf("8 bit ");
		  else
		    printf("16 bit ");
		  if (this->stereo)
		    printf("stereo");	  
		  printf("\n");
#endif	  
		  get_blksize();
		  if ((audio_buffer=(ubyte*)calloc(bufsize,sizeof(ubyte)))==0)
		    error = errno;	  
		}
	    }
	}
    }
}

DSP::~DSP()
{
  //  int a = close(fd);
  close(fd);
  fd = -1;
  if (audio_buffer)
    free(audio_buffer);
  // return  a;
}
