unit mxmptmt;

{ cubic (tm) tiny gus xm player 1.5
  extensions for tmt (r) pascal lite compiler. v.0.31 beta
  introduced by __tim/fiction.h }

interface

function xmpinit(
  mxmmem: pointer;    { pointer to the mxm file in the memory }
  mxmdata: pointer;   { pointer to 16k of memory for internal use }
  gusport: dword;     { gus port or zero for no sound }
  maxtimerrate: dword { maximum timer rate between two irq 0 calls }
): dword;             { return value 0: call failed, 1: ok }

procedure xmpplay(
  startord: dword     { order to start playing with }
);

procedure xmpstop;

procedure xmpsetvolume(
  vol: byte           { global volume }
);

function xmpgetsync:
  byte;               { return value: currently set syncvalue }

function xmpgetpos:
  word;               { return value: current position in the song
                        highbyte: current order, lowbyte: current row }

function xmpgettimer:
  dword;              { return value: timer value }

function xmpgetgusport:
  dword;              { gus port from the ultrasnd environment variable
}

implementation

{$l mxmplay.obj}

procedure xmpinit_; external;
procedure xmpplay_; external;
procedure xmpstop_; external;
procedure xmpsetvolume_; external;
procedure xmpgetsync_; external;
procedure xmpgetpos_; external;
procedure xmpgettimer_; external;
procedure xmpgetgusport_; external;

function xmpinit(mxmmem, mxmdata: pointer; gusport, maxtimerrate:
dword): dword;
asm
  pushad
  mov esi, mxmmem
  mov eax, gusport
  mov ebx, mxmdata
  mov ecx, maxtimerrate
  mov edx, 0
  call xmpinit_
  mov result, eax
  popad
end;

procedure xmpplay(startord: dword);
asm
  pushad
  mov eax, startord
  call xmpplay_
  popad
end;

procedure xmpstop;
asm
  pushad
  call xmpstop_
  popad
end;

procedure xmpsetvolume(vol: byte);
asm
  pushad
  mov al, vol
  call xmpsetvolume_
  popad
end;

function xmpgetsync: byte;
asm
  pushad
  call xmpgetsync_
  mov result, al
  popad
end;

function xmpgetpos: word;
asm
  pushad
  call xmpgetpos_
  mov result, ax
  popad
end;

function xmpgettimer: dword;
asm
  pushad
  call xmpgettimer_
  mov result, eax
  popad
end;

function xmpgetgusport: dword;
asm
  pushad
  mov edi, _environ
  call xmpgetgusport_
  mov result, eax
  popad
end;

begin
end.
