#define TRUE 1
#define FALSE 0

typedef unsigned char byte;
typedef unsigned int word;
typedef unsigned long dword;

extern "C" { byte GUSPeek(dword); }
extern "C" { void GUSPoke(dword, byte); }
extern "C" { dword GUSFindMem();
extern "C" { void GUSSetVolume(byte, byte); }
extern "C" { void GUSSetBalance(byte, byte); }
extern "C" { void GUSSetFreq(byte, word); }
extern "C" { void GUSPlayVoice(byte, byte, dword, dword, dword); }
extern "C" { void GUSReset(byte); }
extern "C" { void GUSStopVoice(byte); }
extern dword gusdram;
extern word Base;
extern byte mute[8];
extern char volume[8];		// volume of channel

int     freq[8];            // amiga frequency of each channel
char  panval[8] = { 3,12,12, 3, 3,12,12, 3 };
int  midival[8];            // midi value of channel
char lastins[8];            // instrument # for each channel
int    porto[8];            // note to port to value
byte  portsp[8];            // porta speed
byte  vibspe[8];            // vibrato speed
byte  vibdep[8];            // vibrato depth
byte tremspe[8];            // tremolo speed
byte tremdep[8];            // tremolo depth
byte sinepos[8];            // position in sine wave
byte sineneg[8];            // toggle to add or subtract sine value
byte geffect[8];            // effect played at the time (for interface)

word freqtab[296] = {                   // The sorted amiga table.
	907,900,894,887,881,875,868,862,    // Finetune -8 to -1
	856,850,844,838,832,826,820,814,    // C-1 to finetune +7
	808,802,796,791,785,779,774,768,    // C#1 to finetune +7
	762,757,752,746,741,736,730,725,    // D-1 to finetune +7
	720,715,709,704,699,694,689,684,    // D#1 to finetune +7
	678,675,670,665,660,655,651,646,    // E-1 to finetune +7
	640,636,632,628,623,619,614,610,    // F-1 to finetune +7
	604,601,597,592,588,584,580,575,    // F#1 to finetune +7
	570,567,563,559,555,551,547,543,    // G-1 to finetune +7
	538,535,532,528,524,520,516,513,    // G#1 to finetune +7
	508,505,502,498,494,491,487,484,    // A-1 to finetune +7
	480,477,474,470,467,463,460,457,    // A#1 to finetune +7
	453,450,447,444,441,437,434,431,    // B-1 to finetune +7
	428,425,422,419,416,413,410,407,    // C-2 to finetune +7
	404,401,398,395,392,390,387,384,    // C#2 to finetune +7
	381,379,376,373,370,368,365,363,    // D-2 to finetune +7
	360,357,355,352,350,347,345,342,    // D#2 to finetune +7
	339,337,335,332,330,328,325,323,    // E-2 to finetune +7
	320,318,316,314,312,309,307,305,    // F-2 to finetune +7
	302,300,298,296,294,292,290,288,    // F#2 to finetune +7
	285,284,282,280,278,276,274,272,    // G-2 to finetune +7
	269,268,266,264,262,260,258,256,    // G#2 to finetune +7
	254,253,251,249,247,245,244,242,    // A-2 to finetune +7
	240,238,237,235,233,232,230,228,    // A#2 to finetune +7
	226,225,223,222,220,219,217,216,    // B-2 to finetune +7
	214,212,211,209,208,206,205,203,    // C-3 to finetune +7
	202,200,199,198,196,195,193,192,    // C#3 to finetune +7
	190,189,188,187,185,184,183,181,    // D-3 to finetune +7
	180,179,177,176,175,174,172,171,    // D#3 to finetune +7
	170,169,167,166,165,164,163,161,    // E-3 to finetune +7
	160,159,158,157,156,155,154,152,    // F-3 to finetune +7
	151,150,149,148,147,146,145,144,    // F#3 to finetune +7
	143,142,141,140,139,138,137,136,    // G-3 to finetune +7
	135,134,133,132,131,130,129,128,    // G#3 to finetune +7
	127,126,125,125,123,123,122,121,    // A-3 to finetune +7
	120,119,118,118,117,116,115,114,    // A#3 to finetune +7
	113,113,112,111,110,109,109,108,    // B-3 to finetune +7
};


// This table is for the interface to display the notes.
char *notetab[37] = {
	"   ","C-1","C#1","D-1","D#1","E-1","F-1","F#1","G-1","G#1","A-1","A#1","B-1",
	"C-2","C#2","D-2","D#2","E-2","F-2","F#2","G-2","G#2","A-2","A#2","B-2",
	"C-3","C#3","D-3","D#3","E-3","F-3","F#3","G-3","G#3","A-3","A#3","B-3"
};


// This table is for vibrato and contains half a sine wave.
byte sintab[32] = {
	   0, 24, 49, 74, 97,120,141,161,
	 180,197,212,224,235,244,250,253,
	 255,253,250,244,235,224,212,197,
	 180,161,141,120, 97, 74, 49, 24
};

byte speed, bpm, channels;  // speed, bpm, channels, figure it out.
byte patdelay=0;            // variable storing number of times to delay patn
byte patlooprow=0, patloopno=0; // pattern loop variables.
char row, mastervol=64;     // same here, current row, and master volume
int  ord;                   // current order being played
float clock=0;              // a floating point value for our home made clock
							// take all references to this out, its just for
							// the interface and I think it slows things down
long filelen;               // size of file, again for the interface

// SAMPLE STRUCT
typedef struct {
	char name[23];			// instrument name
	word length;            // sample length
	char finetune;          // sample finetune value
	byte volume;            // sample default volume
	word loopstart;         // sample loop start
	word loopend;           // sample loop length
	dword offset;           // offset of sample in dram
} Sample;

// SONG STRUCT
struct {
	char name[20];          // song name
	Sample inst[31];        // instrument headers
	byte songLength;        // song length
	byte numpats;           // number of physical patterns
	byte order[128];        // pattern playing orders
} MOD;

// SINGLE NOTE STRUCT
struct Note {
	byte number:5;          // sample being played              5 bits
	int period:11;          // frequency being played at     + 11 bits = 16.
	byte effect;            // effect number                 +  8
	byte eparm;             // effect parameter              +  8 = 4 bytes!
} *current;

char huge *patbuff;         // buffer that holds our pattern data
dword offset;               // offset of note in pattern data buffer.

// PROTOTYPES
void interrupt ( *oldmodhandler)(...);   // old vector for timer int
void interrupt ( *oldkeyhandler)(...);   // old vector for keyboard int

void waitvrt(void) {
	asm  mov dx,0x3da         // move status port address # to dx
VRT:
	asm {
		in   al,dx          // get value from port and put in al
		test al,8           // test al with bit 3 (8h)
		jnz  VRT            // wait until Verticle Retrace starts
	}
NVRT:
	asm {
		in   al,dx          // get value from port and put in al
		test al,8           // test al with bit 3 (8h)
		jz   NVRT           // wait until Verticle Retrace Ends
	}
}


void textsquare(int left, int top, int right, int bottom, int type)
{
	int count=0;

	gotoxy(left,top);
	if (type==1) putch(218);
	if (type==2) putch(201);
	for (count=left+1; count < right; count++) {
		gotoxy(count,top);
		if (type==1) putch(196);
		if (type==2) putch(205);
	}
	gotoxy(right,top);
	if (type==1) putch(191);
	if (type==2) putch(187);
	for (count=top+1; count < bottom; count++) {
		gotoxy(left,count);
		if (type==1) putch(179);
		if (type==2) putch(186);
		gotoxy(right,count);
		if (type==1) putch(179);
		if (type==2) putch(186);
	}
	gotoxy(left,bottom);
	if (type==1) putch(192);
	if (type==2) putch(200);
	for (count=left+1; count < right; count++) {
		gotoxy(count,bottom);
		if (type==1) putch(196);
		if (type==2) putch(205);
	}
	gotoxy(right,bottom);
	if (type==1) putch(217);
	if (type==2) putch(188);
}


void textbox(byte x, byte y, byte x2, byte y2, byte type, char *heading) {
	int count, count2;
	char *buff = (char *)MK_FP(0xb800, 0);
	textbackground(7);
	textcolor(15);
	textsquare(x,y,x2,y2,type);
	for (count2=y; count2<y2-1; count2++) {
		for (count=x; count<x2-1; count++) {
			buff[(count2*160)+(count*2)+1] = 7*16;
		}
	}
	gotoxy(((x+x2)/2)-(strlen(heading)/2),y);
	cprintf("%s", heading);
	gotoxy(x+1,y2+1);
	textcolor(1);
	for (count=x; count<=x2; count++) putch(219);
	for (count=y+1; count<y2+1; count++) {gotoxy(x2+1,count); putch(219);}
}


void setrgbpalette(byte col, byte r, byte g, byte b) {
	asm {
		mov dx, 0x3c8
		mov al, col
		out dx, al
		inc dx
		mov al, r
		out dx, al
		mov al, g
		out dx, al
		mov al, b
		out dx, al
	}
}

void eputch(char *buff, byte val, byte x, byte y, byte colour, byte bgcolor) {
	x--;
	y--;
	buff[(y*160)+(x*2)] = val;
	buff[(y*160)+(x*2)+1] = (bgcolor * 16) + colour;
}