// Panard-Vision
// 3D real time engine
// (C) 1997, Olivier Brunet
// Email: bruneto@efrei.fr
//
// Panard-Motion : Animation library
//
// Before using this library consult the LICENSE file

#ifndef __PMOTION_H__
#define __PMOTION_H__
#include "pvision.h"

extern char *PMOTION_DATE;
extern char *PMOTION_TIME;
extern char *PMOTION_VERSION;

typedef enum _PMOBJTYPE {UNKNOW=0,LIGHT_POS,LIGHT_TARGET,CAM_POS,CAM_TARGET,MESH} PMObjType;

typedef struct _PMRKey
{
    float Time;
    Quat q;
    float easeto,easefrom;
    float bias,cont,tens;
}PMRKey;

typedef struct _PMPKey
{
    float Time;
    float x,y,z;
    float easeto,easefrom;
    float bias,cont,tens;
}PMPKey;

typedef struct _PMRollKey
{
    float Time;
    float Roll;
    float easeto,easefrom;
    float bias,cont,tens;
}PMRollKey;

typedef struct _PosKeys
{
    unsigned NbKeys;
    PMPKey *Keys;
}PosKeys;

typedef struct _RotKeys
{
    unsigned NbKeys;
    PMRKey *Keys;
}RotKeys;

typedef struct _RollKeys
{
    unsigned NbKeys;
    PMRollKey *Keys;
}RollKeys;

typedef struct _PMNode
{
    PMObjType Type;
    int ID;
    void *Object;

    PosKeys Pos;
    RotKeys Rot;
    RollKeys Roll;

    struct _PMNode *Child,*Next,*Father;
} PMNode;

typedef struct _PMotion
{
    float CurrentTime,MaxTime;
    PMNode *RootObj;
} PMotion;

#ifdef __cplusplus
extern "C" {
#endif

PMotion * PVAPI PM_CreateTree(void);
void PVAPI PM_KillTree(PMotion *m);
void PVAPI PM_SetCurrentTime(PMotion *m,float t);

/////////////////////////////////////////////////

PMNode *  PVAPI PM_CreateNode(int ID);
void PVAPI PM_KillNode(PMNode *o);
void PVAPI PM_AddChild(PMNode *father,PMNode *newnode);
PMNode * PVAPI PM_GetNodePtrByID(PMNode *m,int id);

void PVAPI PM_ComputeCurrentTime(PMotion *m);

#ifdef __cplusplus
}
#endif

///////////////////////////// Error codes
#define OBJ_ID_NOT_FOUND        50

#endif
